/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.common;

import com.sun.ctmgx.common.Log;
import com.sun.ctmgx.common.LogWatcherRegex;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class LogWatcher {
    protected String configFileName = "/tmp/.ctmgx.LogWatcher";
    protected File configFile;
    protected int port;
    protected String enterprise = "ENTERPRISE = 1.3.6.1.4.1.42";
    protected String objectId = "OBJECTID = 1.3.6.1.4.1.860";
    protected String mdlogdCommand = "/usr/sbin/mdlogd";
    protected Process mdlogd;
    LogWatcherRegex[] regexs;

    public LogWatcher(LogWatcherRegex[] logWatcherRegexArray, int n) {
        this.regexs = logWatcherRegexArray;
        this.port = n;
    }

    public LogWatcher(String[] stringArray, int[] nArray, int n) {
        this.regexs = new LogWatcherRegex[stringArray.length];
        int n2 = 0;
        while (n2 < this.regexs.length) {
            this.regexs[n2] = new LogWatcherRegex(stringArray[n2], nArray[n2]);
            ++n2;
        }
        this.port = n;
    }

    void createConfigFile() {
        this.configFile = new File(this.configFileName);
        this.configFile.deleteOnExit();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.configFile);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            printWriter.println(this.enterprise);
            printWriter.println(this.objectId);
            int n = 0;
            while (n < this.regexs.length) {
                printWriter.println("\"" + this.regexs[n].regex + "\" \"localhost:" + this.port + ":udp\" 6 " + this.regexs[n].code);
                ++n;
            }
            printWriter.close();
        }
        catch (Exception exception) {
            Log.error(this, "unable to create the LogWatcher config file, " + this.configFileName + ".");
            Log.error(this, exception.toString());
        }
    }

    public void start() {
        this.createConfigFile();
        String[] stringArray = new String[]{this.mdlogdCommand, "-d", "-c", this.configFileName};
        try {
            this.mdlogd = Runtime.getRuntime().exec(stringArray);
        }
        catch (Exception exception) {}
    }

    public void stop() {
        this.mdlogd.destroy();
        try {
            this.mdlogd.getInputStream().close();
            this.mdlogd.getOutputStream().close();
            this.mdlogd.getErrorStream().close();
        }
        catch (IOException iOException) {}
        this.configFile.delete();
    }
}

