/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.common;

import com.sun.ctmgx.common.DsmAutoMonitor;
import com.sun.ctmgx.common.PackageInfo;
import com.sun.ctmgx.common.PackageInfoList;
import com.sun.ctmgx.common.ProcessInfo;
import com.sun.ctmgx.common.ProcessInfoList;
import com.sun.ctmgx.common.SyslogEvent;
import com.sun.ctmgx.common.SyslogListener;

public class Dsm
implements SyslogListener {
    private PackageInfoList packageInfoList;
    private ProcessInfoList processInfoList;
    private PackageInfo bdmInfo;
    private PackageInfo bdmrInfo;
    private static final ProcessInfo dsmaddDefaultInfo = new ProcessInfo("dsmadd.sh", 0, "/opt/SUNWbdm/scripts/dsmadd.sh", "", "application", "running");
    private static final ProcessInfo dsmrmDefaultInfo = new ProcessInfo("dsmrm.sh", 0, "/opt/SUNWbdm/scripts/dsmrm.sh", "", "application", "running");
    private static final ProcessInfo dsmaddautoDefaultInfo = new ProcessInfo("dsmaddauto.sh", 0, "/opt/SUNWbdm/scripts/dsmaddauto.sh", "", "application", "running");
    private static final ProcessInfo dsmrmaddDefaultInfo = new ProcessInfo("dsmrmadd.sh", 0, "/opt/SUNWbdm/scripts/dsmrmadd.sh", "", "application", "running");
    private static final ProcessInfo dsmrmautoDefaultInfo = new ProcessInfo("dsmrmauto.sh", 0, "/opt/SUNWbdm/scripts/dsmrmauto.sh", "", "application", "running");
    private static final ProcessInfo dsmcfgDefaultInfo = new ProcessInfo("dsmcfg.sh", 0, "/opt/SUNWbdm/scripts/dsmcfg.sh", "", "application", "running");
    private static final ProcessInfo NULL_INFO = new ProcessInfo(null, 0, null, null, null, null);
    private ProcessInfo dsmrm;
    private ProcessInfo dsmadd;
    private ProcessInfo dsmauto;
    private ProcessInfo dsmaddauto;
    private ProcessInfo dsmrmadd;
    private ProcessInfo dsmrmauto;
    private ProcessInfo dsmcfg;
    private DsmAutoMonitor dsmautoMonitor;

    public Dsm(PackageInfoList packageInfoList, ProcessInfoList processInfoList) {
        this.packageInfoList = packageInfoList;
        this.processInfoList = processInfoList;
        this.addDsmPackages();
        this.initInfos();
        this.dsmautoMonitor = new DsmAutoMonitor(processInfoList, 2000L);
    }

    protected void addDsmPackages() {
        this.bdmInfo = PackageInfo.create("SUNWbdm");
        if (this.bdmInfo != null) {
            this.packageInfoList.add(this.bdmInfo);
        }
        this.bdmrInfo = PackageInfo.create("SUNWbdmr");
        if (this.bdmrInfo != null) {
            this.packageInfoList.add(this.bdmrInfo);
        }
    }

    private void addProcessInfo(ProcessInfo processInfo, ProcessInfo processInfo2, String string) {
        ProcessInfo processInfo3;
        if (processInfo.getName() != null) {
            this.processInfoList.remove(processInfo);
        }
        if ((processInfo3 = ProcessInfo.create(processInfo2.getName(), true)) == null) {
            processInfo.update(processInfo2);
        } else {
            processInfo.update(processInfo3);
        }
        this.processInfoList.add(processInfo, string);
    }

    protected void addSdsPackages() {
    }

    private void initInfos() {
        try {
            this.dsmrm = (ProcessInfo)NULL_INFO.clone();
            this.dsmadd = (ProcessInfo)NULL_INFO.clone();
            this.dsmaddauto = (ProcessInfo)NULL_INFO.clone();
            this.dsmrmadd = (ProcessInfo)NULL_INFO.clone();
            this.dsmrmauto = (ProcessInfo)NULL_INFO.clone();
            this.dsmcfg = (ProcessInfo)NULL_INFO.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
    }

    public void processEvent(SyslogEvent syslogEvent) {
        int n = syslogEvent.code;
        String string = syslogEvent.getMessage();
        if (n == SyslogEvent.Constants.DSMRM_COMPENSATING_ACTIONS_STARTED.code) {
            this.addProcessInfo(this.dsmrm, dsmrmDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMRM_COMPENSATING_ACTIONS_FINISHED.code) {
            this.removeProcessInfo(this.dsmrm, dsmrmDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMADD_REINTEGRATING_ACTIONS_STARTED.code) {
            this.addProcessInfo(this.dsmadd, dsmaddDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMADD_REINTEGRATING_ACTIONS_FINISHED.code) {
            this.removeProcessInfo(this.dsmadd, dsmaddDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMADD_BAD_NEW_DISK.code) {
            this.removeProcessInfo(this.dsmadd, dsmaddDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMADD_NO_DELETED_METADEVICES_FILE.code) {
            this.removeProcessInfo(this.dsmadd, dsmaddDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMADD_RUN_DSMRM.code) {
            this.removeProcessInfo(this.dsmadd, dsmaddDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMADD_CREATE_FAILURE.code) {
            this.removeProcessInfo(this.dsmadd, dsmaddDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMADD_BAD_CONFIG_FILES.code) {
            this.removeProcessInfo(this.dsmadd, dsmaddDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMADD_DISK_FAILURE.code) {
            this.removeProcessInfo(this.dsmadd, dsmaddDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMRM_DOUBLE_FAULT.code) {
            this.removeProcessInfo(this.dsmrm, dsmrmDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMRM_DOUBLE_FAULT_OVERRIDE.code) {
            this.removeProcessInfo(this.dsmrm, dsmrmDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMRM_BAD_CONFIG_FILES.code) {
            this.removeProcessInfo(this.dsmrm, dsmrmDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMRM_USAGE_ERROR.code) {
            this.removeProcessInfo(this.dsmrm, dsmrmDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMRM_INVALID_DISK.code) {
            this.removeProcessInfo(this.dsmrm, dsmrmDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMRM_NO_FAILURE.code) {
            this.removeProcessInfo(this.dsmrm, dsmrmDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMRM_DELETE_FAILURE.code) {
            this.removeProcessInfo(this.dsmrm, dsmrmDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMADDAUTO_NO_DELETED_METADEVICES_FILE.code) {
            this.removeProcessInfo(this.dsmaddauto, dsmaddautoDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMADDAUTO_USAGE_ERROR.code) {
            this.removeProcessInfo(this.dsmaddauto, dsmaddautoDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMADDAUTO_INVALID_SUBMIRROR.code) {
            this.removeProcessInfo(this.dsmaddauto, dsmaddautoDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMADDAUTO_INVALID_DISK.code) {
            this.removeProcessInfo(this.dsmaddauto, dsmaddautoDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMADDAUTO_COMPENSATING_ACTIONS_FAILURE.code) {
            this.removeProcessInfo(this.dsmaddauto, dsmaddautoDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMADDAUTO_BAD_CONFIG_FILES.code) {
            this.removeProcessInfo(this.dsmaddauto, dsmaddautoDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMRMADD_BAD_CONFIG_FILES.code) {
            this.removeProcessInfo(this.dsmrmadd, dsmrmaddDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMRMADD_COMPENSATING_ACTIONS_FAILURE.code) {
            this.removeProcessInfo(this.dsmrmadd, dsmrmaddDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMRMADD_REINTEGRATING_ACTIONS_FAILURE.code) {
            this.removeProcessInfo(this.dsmrmadd, dsmrmaddDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMRMADD_USAGE_ERROR.code) {
            this.removeProcessInfo(this.dsmrmadd, dsmrmaddDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMCFG_BAD_DSMDISK_INF.code) {
            this.removeProcessInfo(this.dsmcfg, dsmcfgDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMCFG_BAD_BOOT_DEVICE_LIST.code) {
            this.removeProcessInfo(this.dsmcfg, dsmcfgDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMRMAUTO_DOUBLE_FAULT.code) {
            this.removeProcessInfo(this.dsmrmauto, dsmrmautoDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMRMAUTO_USAGE_ERROR.code) {
            this.removeProcessInfo(this.dsmrmauto, dsmrmautoDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMRMAUTO_BAD_CONFIG_FILES.code) {
            this.removeProcessInfo(this.dsmrmauto, dsmrmautoDefaultInfo, string);
        } else if (n == SyslogEvent.Constants.DSMAUTO_BAD_CONFIG_FILES.code) {
            this.dsmautoMonitor.setRunning("");
            this.dsmautoMonitor.setNotRunning(string);
        } else if (n == SyslogEvent.Constants.DSMAUTO_NO_DELETED_METADEVICES_FILE.code) {
            this.dsmautoMonitor.setRunning("");
            this.dsmautoMonitor.setNotRunning(string);
        } else if (n == SyslogEvent.Constants.DSMAUTO_USAGE_ERROR.code) {
            this.dsmautoMonitor.setRunning("");
            this.dsmautoMonitor.setNotRunning(string);
        }
    }

    private void removeProcessInfo(ProcessInfo processInfo, ProcessInfo processInfo2, String string) {
        if (processInfo.getName() == null) {
            processInfo.update(processInfo2);
            this.processInfoList.add(processInfo, "");
        }
        this.processInfoList.remove(processInfo, string);
        processInfo.update(NULL_INFO);
    }
}

