/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.common;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class Debug {
    public static final int EMERG_LEVEL = 0;
    public static final int ALERT_LEVEL = 1;
    public static final int CRIT_LEVEL = 2;
    public static final int ERR_LEVEL = 3;
    public static final int WARN_LEVEL = 4;
    public static final int NOTICE_LEVEL = 5;
    public static final int INFO_LEVEL = 6;
    public static final int DEBUG_LEVEL = 7;
    public static final int DEFAULT_DBG_THRESHOLD = 5;
    private static int debugThreshold = 5;
    private boolean syslogEnabled = false;
    private static PrintWriter out;
    private static FileOutputStream outStream;
    private static SimpleDateFormat dateFormat;

    static {
        System.loadLibrary("Debug");
    }

    public Debug() {
        this(null, debugThreshold);
    }

    public Debug(String string) {
        this(string, debugThreshold);
    }

    public Debug(String string, int n) {
        debugThreshold = n;
        Calendar calendar = Calendar.getInstance();
        dateFormat = new SimpleDateFormat("HH:mm:ss");
        dateFormat.setCalendar(calendar);
        if (out == null) {
            this.openDebugFile(string);
        }
    }

    native void debugSyslogClose();

    native void debugSyslogOpen();

    native void debugSyslogSetMask(int var1);

    native void debugSyslogWrite(int var1, String var2);

    public void disableSyslog() {
        this.debugSyslogClose();
        this.syslogEnabled = false;
    }

    public void enableSyslog() {
        this.debugSyslogOpen();
        this.syslogEnabled = true;
    }

    String listToString(String[] stringArray) {
        String string = new String("\n");
        if (stringArray == null) {
            return "";
        }
        int n = 0;
        while (n < stringArray.length) {
            string = string.concat(String.valueOf(stringArray[n]) + "\n");
            ++n;
        }
        return string;
    }

    void openDebugFile(String string) {
        block3: {
            if (string == null) break block3;
            try {
                outStream = new FileOutputStream(string);
                out = new PrintWriter(outStream, true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
        }
    }

    public final void setDebugFile(String string) {
        try {
            if (outStream != null) {
                outStream.close();
                out.close();
                outStream = null;
                out = null;
            }
            this.openDebugFile(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static final void setDebugThreshold(int n) {
        debugThreshold = n;
    }

    public void setSyslogMask(int n) {
        if (this.syslogEnabled) {
            this.debugSyslogSetMask(n);
        }
    }

    public final void write(int n, String string) {
        this.write(null, n, string);
    }

    public final void write(int n, String[] stringArray) {
        this.write(null, n, stringArray);
    }

    public final void write(Object object, int n, String string) {
        if (n <= debugThreshold && n > 0) {
            String string2;
            Date date = new Date();
            String string3 = String.valueOf(dateFormat.format(date)) + ": ";
            String string4 = string2 = object == null ? String.valueOf(string3) + string : String.valueOf(string3) + "[" + object.getClass().getName() + "] " + string;
            if (out == null) {
                System.err.println(string2);
            } else {
                out.println(string2);
            }
            if (this.syslogEnabled) {
                this.debugSyslogWrite(n, string2);
            }
        }
    }

    public final void write(Object object, int n, String[] stringArray) {
        if (n <= debugThreshold && n > 0) {
            String string;
            Date date = new Date();
            String string2 = String.valueOf(dateFormat.format(date)) + ": ";
            String string3 = string = object == null ? this.listToString(stringArray) : "[" + object.getClass().getName() + "] " + this.listToString(stringArray);
            if (out == null) {
                System.err.println(string);
            } else {
                out.println(string);
            }
            if (this.syslogEnabled) {
                this.debugSyslogWrite(n, string);
            }
        }
    }

    public final void write(Object object, String string) {
        this.write(object, debugThreshold, string);
    }

    public final void write(Object object, String[] stringArray) {
        this.write(object, debugThreshold, stringArray);
    }

    public final void write(String string) {
        this.write(null, debugThreshold, string);
    }

    public final void write(String[] stringArray) {
        this.write(null, debugThreshold, stringArray);
    }
}

