/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.common;

import com.sun.ctmgx.common.CpciSlotInfo;
import com.sun.ctmgx.common.CpciSlotInfoException;
import com.sun.ctmgx.common.Cpu;
import com.sun.ctmgx.common.CpuCardInfo;
import com.sun.ctmgx.common.CpuInfo;
import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.Device;
import com.sun.ctmgx.common.FRUInfo;
import com.sun.ctmgx.common.HmePort;
import com.sun.ctmgx.common.HmePortInfo;
import com.sun.ctmgx.common.MgmtDevInfoException;
import com.sun.ctmgx.common.Midplane;
import com.sun.ctmgx.common.PlugInUnitImpl;
import com.sun.ctmgx.common.ScsiContainer;
import com.sun.ctmgx.common.ScsiSlot;
import com.sun.ctmgx.common.ScsiSlotInfo;
import com.sun.ctmgx.common.SerialPort;
import com.sun.ctmgx.common.SerialPortInfo;
import com.sun.ctmgx.common.TempInfo;
import com.sun.ctmgx.common.TerminationIf;

public class CpuCard
extends PlugInUnitImpl
implements ScsiContainer {
    Device[] hmeList;
    Device[] scsiList;
    FRUInfo fruInfo;
    CpuCardInfo cpuCardInfo;
    HmePortInfo hmePortInfo;
    CpuInfo cpuInfo;
    TempInfo tempInfo;
    HmePort[] hmePort;
    ScsiSlot[] scsiSlots;
    Cpu cpu;
    Debug debug;

    public CpuCard(FRUInfo fRUInfo, CpuCardInfo cpuCardInfo) {
        super(new String("cpu_card"), new String("cpu_card"), 9, 12, fRUInfo.getUnit());
        this.fruInfo = fRUInfo;
        this.cpuCardInfo = cpuCardInfo;
        this.debug = new Debug();
        this.hmeList = cpuCardInfo.getHmeList();
        this.scsiList = cpuCardInfo.getScsiList();
        this.cpuInfo = new CpuInfo(0);
        this.tempInfo = new TempInfo(0);
        this.cpu = new Cpu(this.cpuInfo, this.tempInfo);
        Cpu[] cpuArray = new Cpu[]{this.cpu};
        this.plugInEquipments = cpuArray;
        HmePort[] hmePortArray = new HmePort[this.hmeList.length];
        int n = 0;
        while (n < this.hmeList.length) {
            this.hmePortInfo = new HmePortInfo(this.hmeList[n].getDriverInstance());
            hmePortArray[n] = new HmePort(this.hmePortInfo, n + 1);
            ++n;
        }
        this.hmePort = hmePortArray;
        this.scsiSlots = new ScsiSlot[1];
        ScsiSlotInfo scsiSlotInfo = new ScsiSlotInfo(this.scsiList);
        this.scsiSlots[0] = new ScsiSlot(scsiSlotInfo, this);
        int n2 = SerialPortInfo.getInstanceNo();
        SerialPortInfo serialPortInfo = new SerialPortInfo("com_port", n2);
        SerialPort serialPort = new SerialPort(serialPortInfo, 1);
        if (Midplane.crtmPresent) {
            this.plugInTerminations = new TerminationIf[1];
        } else {
            this.plugInTerminations = new TerminationIf[2];
            int n3 = 0;
            while (n3 < this.hmePort.length) {
                String string = this.hmePort[n3].getIfDescr();
                if ("hme0".equals(string)) {
                    this.plugInTerminations[1] = this.hmePort[n3];
                    break;
                }
                ++n3;
            }
        }
        this.plugInTerminations[0] = serialPort;
    }

    public Cpu[] getCpus() {
        Cpu[] cpuArray = new Cpu[]{this.cpu};
        return cpuArray;
    }

    int getHmeDeviceInstance(Device device) {
        String string = device.getDevicePath();
        int n = string.indexOf("/network@");
        int n2 = string.indexOf(",", n + 9);
        int n3 = Integer.parseInt(string.substring(n + 9, n2));
        this.debug.write((Object)this, 7, "port instance = " + n3);
        return n3;
    }

    HmePort[] getHmePort() {
        return this.hmePort;
    }

    public Device[] getScsiDevices(int n) {
        CpciSlotInfo cpciSlotInfo = new CpciSlotInfo(Midplane.getMidplaneId(), this.fruInfo.getUnit());
        Device[] deviceArray = new Device[]{};
        try {
            deviceArray = cpciSlotInfo.getSlotInfo();
        }
        catch (MgmtDevInfoException mgmtDevInfoException) {
            mgmtDevInfoException.printStackTrace();
        }
        catch (CpciSlotInfoException cpciSlotInfoException) {
            cpciSlotInfoException.printStackTrace();
        }
        this.cpuCardInfo = new CpuCardInfo(deviceArray);
        this.scsiList = this.cpuCardInfo.getScsiList();
        return this.scsiList;
    }
}

