/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.common;

import com.sun.ctmgx.common.Alarm;
import com.sun.ctmgx.common.CpuInfo;
import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.EquipmentImpl;
import com.sun.ctmgx.common.TempAlarmControl;
import com.sun.ctmgx.common.TempInfo;
import com.sun.ctmgx.common.TempListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class Cpu
extends EquipmentImpl {
    int clockSpeed;
    String type;
    String state;
    int currentTemperature;
    int warningThreshold;
    int shutdownThreshold;
    private Debug debug;
    CpuInfo cpuInfo;
    TempInfo tempInfo;
    TempPropertyChangeListener tempListener;

    public Cpu(CpuInfo cpuInfo, TempInfo tempInfo) {
        super(new String("cpu"), new String("cpu"), 2, 12, cpuInfo.getInstance());
        this.cpuInfo = cpuInfo;
        this.tempInfo = tempInfo;
        this.debug = new Debug();
        this.currentTemperature = tempInfo.getCurrentTemperature();
        this.warningThreshold = tempInfo.getWarningThreshold();
        this.shutdownThreshold = tempInfo.getShutdownThreshold();
        this.clockSpeed = cpuInfo.getClockSpeed();
        this.type = cpuInfo.getType();
        this.state = cpuInfo.getState();
        TempAlarm tempAlarm = new TempAlarm("warningTempAlarm");
        TempAlarm tempAlarm2 = new TempAlarm("shutdownTempAlarm");
        TempAlarmControl tempAlarmControl = new TempAlarmControl(tempAlarm, tempAlarm2);
        this.tempListener = new TempPropertyChangeListener(tempAlarmControl);
        tempInfo.addPropertyChangeListener(this.tempListener);
    }

    public int getCurrentTemperature() {
        return this.currentTemperature;
    }

    public int getShutdownThreshold() {
        return this.shutdownThreshold;
    }

    public int getWarningThreshold() {
        return this.warningThreshold;
    }

    class TempPropertyChangeListener
    implements PropertyChangeListener {
        private TempListener listener;

        TempPropertyChangeListener(TempListener tempListener) {
            this.listener = tempListener;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Cpu.this.debug.write((Object)this, 7, "In propChange");
            if ("temperatureChange".equals(string)) {
                int n = Cpu.this.tempInfo.getCurrentTemperature();
                int n2 = Cpu.this.tempInfo.getWarningThreshold();
                int n3 = Cpu.this.tempInfo.getShutdownThreshold();
                if (n < n2) {
                    this.listener.normalTemp();
                } else if (n < n3) {
                    this.listener.warningTemp();
                } else {
                    this.listener.shutdownTemp();
                }
            }
        }
    }

    class TempAlarm
    implements Alarm {
        private final String name;
        private boolean state;

        TempAlarm(String string) {
            this.name = string;
        }

        public void clear() {
            boolean bl = this.state;
            this.state = false;
            Cpu.this.propChangeSupport.firePropertyChange(this.name, bl, this.state);
        }

        public boolean get() {
            return this.state;
        }

        public void set() {
            boolean bl = this.state;
            this.state = true;
            Cpu.this.propChangeSupport.firePropertyChange(this.name, bl, this.state);
        }
    }
}

