/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.common;

import com.sun.ctmgx.common.CoyoteDisk;
import com.sun.ctmgx.common.CoyoteDiskInfo;
import com.sun.ctmgx.common.CoyoteInfo;
import com.sun.ctmgx.common.CoyotePropChangeEvent;
import com.sun.ctmgx.common.D130Disk;
import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.PlugInUnitImpl;
import com.sun.ctmgx.common.ScsiSlot;
import com.sun.ctmgx.common.ScsiSlotInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class Coyote
extends PlugInUnitImpl
implements PropertyChangeListener {
    CoyoteInfo coyoteInfo;
    CoyoteDisk[] coyoteDisks;
    ScsiSlot scsiSlot;
    private Debug debug = new Debug();

    Coyote(CoyoteInfo coyoteInfo) {
        super("coyote", coyoteInfo.getName(), 9, 12, coyoteInfo.getId());
        this.coyoteInfo = coyoteInfo;
        D130Disk[] d130DiskArray = coyoteInfo.getDisks();
        int n = d130DiskArray.length;
        this.coyoteDisks = new CoyoteDisk[n];
        int n2 = 0;
        while (n2 < n) {
            CoyoteDiskInfo coyoteDiskInfo = new CoyoteDiskInfo(d130DiskArray[n2]);
            this.coyoteDisks[n2] = new CoyoteDisk(coyoteDiskInfo);
            ++n2;
        }
        ScsiSlotInfo scsiSlotInfo = new ScsiSlotInfo(coyoteInfo.getConnectedD130s());
        this.scsiSlot = new ScsiSlot(scsiSlotInfo, null);
        ScsiSlot[] scsiSlotArray = new ScsiSlot[]{this.scsiSlot};
        this.plugInHolders = scsiSlotArray;
        this.plugInEquipments = this.coyoteDisks;
        this.plugInOperStatus = this.formOperStatus();
        coyoteInfo.addD130Listener(this);
    }

    int formOperStatus() {
        boolean bl = this.coyoteInfo.isOnline();
        if (bl) {
            return 1;
        }
        return 2;
    }

    public CoyoteDisk[] getCoyoteDisks() {
        return this.coyoteDisks;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.debug.write((Object)this, 6, "In propChange");
        String string = propertyChangeEvent.getPropertyName();
        boolean bl = (Boolean)propertyChangeEvent.getNewValue();
        int n = this.plugInOperStatus;
        String string2 = "";
        if ("online".equals(string)) {
            if (!bl) {
                this.plugInOperStatus = 2;
                string2 = "Coyote unit offline";
            } else {
                this.plugInOperStatus = 1;
                string2 = "Coyote unit online";
            }
        } else if ("monitored".equals(string)) {
            int n2;
            if (!bl) {
                this.plugInOperStatus = 3;
                string2 = "SSM monitoring stopped";
                n2 = 0;
                while (n2 < this.coyoteDisks.length) {
                    this.coyoteDisks[n2].coyoteDiskInfo.onConnection(false);
                    ++n2;
                }
            } else {
                this.plugInOperStatus = this.formOperStatus();
                string2 = "SSM monitoring started";
                n2 = 0;
                while (n2 < this.coyoteDisks.length) {
                    this.coyoteDisks[n2].coyoteDiskInfo.onConnection(true);
                    ++n2;
                }
            }
        }
        CoyotePropChangeEvent coyotePropChangeEvent = new CoyotePropChangeEvent(new Integer(this.plugInOperStatus), string2);
        CoyotePropChangeEvent coyotePropChangeEvent2 = new CoyotePropChangeEvent(new Integer(n), string2);
        this.debug.write((Object)this, 6, "Firing propChange");
        this.propertyChangeSupport.firePropertyChange("operStatus", coyotePropChangeEvent2, coyotePropChangeEvent);
    }

    public void stopMonitoring() {
        super.stopMonitoring();
        this.coyoteInfo.stopMonitoring();
    }
}

