/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.snmp;

import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.snmp.NetraCtAlarmFilter;
import com.sun.ctmgx.snmp.TrapDestination;
import com.sun.ctmgx.snmp.TrapInfo;
import com.sun.jdmk.comm.SnmpAdaptorServer;
import java.io.IOException;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;

public class TrapManager {
    SnmpAdaptorServer snmpAdaptor;
    NetraCtAlarmFilter filter;
    Debug debug;

    TrapManager(SnmpAdaptorServer snmpAdaptorServer, NetraCtAlarmFilter netraCtAlarmFilter) {
        this.snmpAdaptor = snmpAdaptorServer;
        this.filter = netraCtAlarmFilter;
        this.debug = new Debug();
        this.debug.enableSyslog();
    }

    void sendThisV2Trap(TrapInfo trapInfo) {
        String string = "public";
        SnmpOid snmpOid = trapInfo.getTrapObject();
        SnmpOid snmpOid2 = trapInfo.getTrapOid();
        int n = trapInfo.getAlarmSeverityIndex();
        int n2 = this.filter.getSeverity(n, snmpOid2);
        TrapDestination[] trapDestinationArray = this.filter.getTrapDestinations(snmpOid2, snmpOid, n2);
        int n3 = 0;
        while (n3 < trapDestinationArray.length) {
            String[] stringArray;
            try {
                String string2 = "sending " + trapInfo.getTrapOid() + " to " + trapDestinationArray[n3].getInetAddress() + ":" + trapDestinationArray[n3].getPort();
                this.debug.write((Object)this, 6, string2);
                this.snmpAdaptor.setTrapPort(trapDestinationArray[n3].getPort());
                this.snmpAdaptor.sendV2Trap(trapDestinationArray[n3].getInetAddress(), string, trapInfo.getTrapOid(), trapInfo.getTrapVarBind());
            }
            catch (SnmpStatusException snmpStatusException) {
                stringArray = new String[]{"Exception occurred while sending " + trapInfo + " to " + trapDestinationArray[n3].getInetAddress(), snmpStatusException.toString()};
                this.debug.write((Object)this, 3, stringArray);
            }
            catch (IOException iOException) {
                stringArray = new String[]{"Exception occurred while sending " + trapInfo + " to " + trapDestinationArray[n3].getInetAddress(), iOException.toString()};
                this.debug.write((Object)this, 3, stringArray);
            }
            ++n3;
        }
    }
}

