/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.snmp;

import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.EquipmentIf;
import com.sun.ctmgx.common.Log;
import com.sun.ctmgx.common.Midplane;
import com.sun.ctmgx.common.PackageInfoList;
import com.sun.ctmgx.common.ProcessInfoList;
import com.sun.ctmgx.common.SystemView;
import com.sun.ctmgx.snmp.ENTITY_MIB;
import com.sun.ctmgx.snmp.EntityPhysicalImpl;
import com.sun.ctmgx.snmp.HOST_RESOURCES_MIB;
import com.sun.ctmgx.snmp.HrSWRunImpl;
import com.sun.ctmgx.snmp.IF_MIB;
import com.sun.ctmgx.snmp.InterfacesImpl;
import com.sun.ctmgx.snmp.LogFilter;
import com.sun.ctmgx.snmp.LogManager;
import com.sun.ctmgx.snmp.NetraCtAlarmFilter;
import com.sun.ctmgx.snmp.NetraCtEquipEntryImpl;
import com.sun.ctmgx.snmp.NetraCtMIBObjectsImpl;
import com.sun.ctmgx.snmp.RFC1213_MIB;
import com.sun.ctmgx.snmp.SUN_SNMP_NETRA_CT_MIB;
import com.sun.ctmgx.snmp.TableNetraCtHwInstalledSwTable;
import com.sun.ctmgx.snmp.TableNetraCtHwRunningSwTable;
import com.sun.ctmgx.snmp.TrapManager;
import com.sun.jdmk.comm.SnmpAdaptorServer;
import com.sun.jdmk.snmp.agent.SnmpMib;
import com.sun.jdmk.snmp.agent.SnmpMibHandler;
import java.io.IOException;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;

public class SnmpMM {
    NetraCtMIBObjectsImpl netraCtMibObjects;
    SnmpAdaptorServer snmpAdaptor;
    TrapManager trapManager;
    LogManager logManager;
    LogFilter logFilter;
    NetraCtAlarmFilter netraCtAlarmFilter;
    MBeanServer server;
    SystemView sysView;
    ObjectName snmpName;
    int snmpPort;
    Debug debug;
    boolean register;

    public SnmpMM(MBeanServer mBeanServer, SnmpAdaptorServer snmpAdaptorServer, ObjectName objectName, int n, SystemView systemView, boolean bl) {
        this.server = mBeanServer;
        this.sysView = systemView;
        this.snmpAdaptor = snmpAdaptorServer;
        this.snmpName = objectName;
        this.snmpPort = n;
        this.register = bl;
        this.debug = new Debug();
        this.initialize();
    }

    private void initMib(SnmpMib snmpMib, String string) {
        if (this.register) {
            ObjectName objectName = null;
            try {
                objectName = new ObjectName("snmp:class=" + string);
                this.server.registerMBean(snmpMib, objectName);
            }
            catch (Exception exception) {
                String[] stringArray = new String[]{"exception occurred while registering " + string + ".", exception.toString()};
                Log.error((Object)snmpMib, (String)("exception occurred while registering " + string + ". " + exception.toString()));
            }
        } else {
            try {
                snmpMib.init();
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.error((Object)snmpMib, (String)("Illegal access" + illegalAccessException.toString()));
            }
        }
    }

    private void initialize() {
        RFC1213_MIB rFC1213_MIB = new RFC1213_MIB();
        this.initMib(rFC1213_MIB, "RFC_1213");
        SUN_SNMP_NETRA_CT_MIB sUN_SNMP_NETRA_CT_MIB = new SUN_SNMP_NETRA_CT_MIB();
        this.initMib(sUN_SNMP_NETRA_CT_MIB, "SUN_SNMP_NETRA_CT_MIB");
        IF_MIB iF_MIB = new IF_MIB();
        this.initMib(iF_MIB, "IF_MIB");
        ENTITY_MIB eNTITY_MIB = new ENTITY_MIB();
        this.initMib(eNTITY_MIB, "ENTITY_MIB");
        sUN_SNMP_NETRA_CT_MIB.setSnmpAdaptor((SnmpMibHandler)this.snmpAdaptor);
        iF_MIB.setSnmpAdaptor((SnmpMibHandler)this.snmpAdaptor);
        eNTITY_MIB.setSnmpAdaptor((SnmpMibHandler)this.snmpAdaptor);
        rFC1213_MIB.setSnmpAdaptor((SnmpMibHandler)this.snmpAdaptor);
        this.netraCtMibObjects = sUN_SNMP_NETRA_CT_MIB.getNetraCtMIBObjectsImpl();
        this.netraCtAlarmFilter = new NetraCtAlarmFilter(this.netraCtMibObjects.getAlarmSevTableImpl(), this.netraCtMibObjects.getTrapForwardingTable(), this.netraCtMibObjects);
        this.trapManager = new TrapManager(this.snmpAdaptor, this.netraCtAlarmFilter);
        EntityPhysicalImpl entityPhysicalImpl = eNTITY_MIB.getEntityPhysicalImpl();
        InterfacesImpl interfacesImpl = iF_MIB.getInterfacesImpl();
        this.logManager = new LogManager(sUN_SNMP_NETRA_CT_MIB, this.netraCtMibObjects.getTrapLogTable(), this.netraCtMibObjects.getLoggedTrapTable(), this.netraCtMibObjects.getLoggedAlarmTable());
        this.logFilter = new LogFilter(sUN_SNMP_NETRA_CT_MIB, this.netraCtMibObjects.getTrapLogTable());
        this.netraCtMibObjects.setEntityPhysicalImpl(entityPhysicalImpl);
        this.netraCtMibObjects.setInterfacesImpl(interfacesImpl);
        this.netraCtMibObjects.setTrapManager(this.trapManager);
        this.netraCtMibObjects.setLogManager(this.logManager);
        this.netraCtMibObjects.setLogFilter(this.logFilter);
        this.netraCtMibObjects.setAlarmFilter(this.netraCtAlarmFilter);
        interfacesImpl.setTrapManager(this.trapManager);
        interfacesImpl.setLogManager(this.logManager);
        interfacesImpl.setLogFilter(this.logFilter);
        PackageInfoList packageInfoList = this.sysView.getPackageInfoList();
        ProcessInfoList processInfoList = this.sysView.getProcessInfoList();
        TableNetraCtHwInstalledSwTable tableNetraCtHwInstalledSwTable = this.netraCtMibObjects.NetraCtHwInstalledSwTable;
        TableNetraCtHwRunningSwTable tableNetraCtHwRunningSwTable = this.netraCtMibObjects.NetraCtHwRunningSwTable;
        HOST_RESOURCES_MIB hOST_RESOURCES_MIB = new HOST_RESOURCES_MIB(processInfoList, tableNetraCtHwRunningSwTable, packageInfoList, tableNetraCtHwInstalledSwTable, entityPhysicalImpl.EntPhysicalTable);
        this.initMib(hOST_RESOURCES_MIB, "HOST_RESOURCES_MIB");
        hOST_RESOURCES_MIB.setSnmpAdaptor((SnmpMibHandler)this.snmpAdaptor);
        HrSWRunImpl hrSWRunImpl = hOST_RESOURCES_MIB.getHrSWRunImpl();
        hrSWRunImpl.setTrapManager(this.trapManager);
        hrSWRunImpl.setLogManager(this.logManager);
        hrSWRunImpl.setLogFilter(this.logFilter);
        Midplane midplane = this.sysView.getMidplane();
        boolean bl = false;
        NetraCtEquipEntryImpl netraCtEquipEntryImpl = new NetraCtEquipEntryImpl(sUN_SNMP_NETRA_CT_MIB, this.netraCtMibObjects, (EquipmentIf)midplane, 0);
        entityPhysicalImpl.addEntPhysicalEntry(netraCtEquipEntryImpl.getEntity());
        this.netraCtMibObjects.addEquipTableEntry(netraCtEquipEntryImpl);
        netraCtEquipEntryImpl.init();
        netraCtEquipEntryImpl.startListener();
        boolean bl2 = true;
        this.debug.write(7, "midplane done");
        this.debug.write(6, "Sending coldStart trap");
        this.snmpAdaptor.setTrapPort(new Integer(this.snmpPort + 1));
        try {
            this.snmpAdaptor.sendV2Trap(new SnmpOid("1.3.6.1.6.3.1.1.5.1"), new Vector());
        }
        catch (SnmpStatusException snmpStatusException) {
            this.debug.write(3, "Error trying to send cold start trap " + snmpStatusException.getMessage());
            snmpStatusException.printStackTrace();
        }
        catch (IOException iOException) {
            this.debug.write(3, "Error trying to send cold start trap " + iOException.getMessage());
            iOException.printStackTrace();
        }
        this.debug.write(6, "SnmpMM Done.");
    }
}

