/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.snmp;

import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.EquipmentIf;
import com.sun.ctmgx.common.FRUInfo;
import com.sun.ctmgx.common.SystemView;
import com.sun.ctmgx.common.TerminationIf;
import com.sun.ctmgx.snmp.DateAndTime;
import com.sun.ctmgx.snmp.EntPhysicalEntry;
import com.sun.ctmgx.snmp.EntPhysicalEntryImpl;
import com.sun.ctmgx.snmp.EntityPhysicalImpl;
import com.sun.ctmgx.snmp.EnumEntPhysicalClass;
import com.sun.ctmgx.snmp.EnumNetraCtAlarmSevDefault;
import com.sun.ctmgx.snmp.EnumNetraCtNeSuppressZeroStats;
import com.sun.ctmgx.snmp.FilterEntryNotFoundException;
import com.sun.ctmgx.snmp.IfEntryImpl;
import com.sun.ctmgx.snmp.InterfacesImpl;
import com.sun.ctmgx.snmp.LogFilter;
import com.sun.ctmgx.snmp.LogManager;
import com.sun.ctmgx.snmp.NetraCtAlarmFilter;
import com.sun.ctmgx.snmp.NetraCtEquipEntry;
import com.sun.ctmgx.snmp.NetraCtEquipHolderEntry;
import com.sun.ctmgx.snmp.NetraCtMIBObjects;
import com.sun.ctmgx.snmp.NetraCtPhysPathTpEntry;
import com.sun.ctmgx.snmp.NetraCtPlugInUnitEntry;
import com.sun.ctmgx.snmp.NetraCtTrapLogEntryImpl;
import com.sun.ctmgx.snmp.TableEntPhysicalTableImpl;
import com.sun.ctmgx.snmp.TableNetraCtAlarmSevProfileTable;
import com.sun.ctmgx.snmp.TableNetraCtAlarmSevTableImpl;
import com.sun.ctmgx.snmp.TableNetraCtEquipHolderTable;
import com.sun.ctmgx.snmp.TableNetraCtEquipTable;
import com.sun.ctmgx.snmp.TableNetraCtHwInstalledSwTable;
import com.sun.ctmgx.snmp.TableNetraCtHwRunningSwTable;
import com.sun.ctmgx.snmp.TableNetraCtLoggedAlarmTable;
import com.sun.ctmgx.snmp.TableNetraCtLoggedTrapTable;
import com.sun.ctmgx.snmp.TableNetraCtPhysPathTpTable;
import com.sun.ctmgx.snmp.TableNetraCtPlugInUnitTable;
import com.sun.ctmgx.snmp.TableNetraCtTrapForwardingTable;
import com.sun.ctmgx.snmp.TableNetraCtTrapLogTable;
import com.sun.ctmgx.snmp.TrapInfo;
import com.sun.ctmgx.snmp.TrapManager;
import com.sun.jdmk.comm.SnmpAdaptorServer;
import com.sun.jdmk.snmp.agent.SnmpIndex;
import com.sun.jdmk.snmp.agent.SnmpMib;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.snmp.SnmpInt;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;

public class NetraCtMIBObjectsImpl
extends NetraCtMIBObjects {
    SnmpMib mib;
    EntityPhysicalImpl entityPhysical;
    TableEntPhysicalTableImpl entPhysicalTable;
    InterfacesImpl interfaces;
    SnmpAdaptorServer snmpAdaptor = null;
    TrapManager trapManager = null;
    LogManager logManager = null;
    LogFilter logFilter = null;
    NetraCtAlarmFilter alarmFilter = null;
    TableNetraCtAlarmSevTableImpl netraCtAlarmSevTableImpl;
    private Debug debug;
    MBeanServer server;

    public NetraCtMIBObjectsImpl(SnmpMib snmpMib) {
        this.mib = snmpMib;
        this.snmpAdaptor = this.snmpAdaptor;
        this.initialize();
    }

    public NetraCtMIBObjectsImpl(SnmpMib snmpMib, MBeanServer mBeanServer) {
        this.mib = snmpMib;
        this.snmpAdaptor = this.snmpAdaptor;
        this.server = mBeanServer;
        this.initialize();
    }

    void addEntityEntry(EntPhysicalEntryImpl entPhysicalEntryImpl) {
        this.entityPhysical.addEntPhysicalEntry(entPhysicalEntryImpl);
    }

    void addEquipHolderTableAsListener(FRUInfo fRUInfo) {
    }

    void addEquipHolderTableEntry(NetraCtEquipHolderEntry netraCtEquipHolderEntry) {
        try {
            this.NetraCtEquipHolderTable.addEntry(netraCtEquipHolderEntry);
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
        }
    }

    void addEquipTableAsListener(EquipmentIf equipmentIf) {
    }

    void addEquipTableEntry(NetraCtEquipEntry netraCtEquipEntry) {
        try {
            this.NetraCtEquipTable.addEntry(netraCtEquipEntry);
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
        }
    }

    void addIfEntry(IfEntryImpl ifEntryImpl) {
        this.interfaces.addIfEntry(ifEntryImpl);
    }

    void addPhysPathTpTableAsListener(FRUInfo fRUInfo) {
    }

    void addPhysPathTpTableEntry(NetraCtPhysPathTpEntry netraCtPhysPathTpEntry) {
        try {
            this.NetraCtPhysPathTpTable.addEntry(netraCtPhysPathTpEntry);
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
        }
    }

    void addPlugInUnitTableAsListener(FRUInfo fRUInfo) {
    }

    void addPlugInUnitTableEntry(NetraCtPlugInUnitEntry netraCtPlugInUnitEntry) {
        try {
            this.NetraCtPlugInUnitTable.addEntry(netraCtPlugInUnitEntry);
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
        }
    }

    EntPhysicalEntryImpl createEntityEntry(String string, Integer n, EnumEntPhysicalClass enumEntPhysicalClass, String string2, Integer n2, Integer n3) {
        return new EntPhysicalEntryImpl(this.entityPhysical.getMib(), string, n, enumEntPhysicalClass, string2, n2, n3);
    }

    IfEntryImpl createIfEntry(TerminationIf terminationIf, int n) {
        return new IfEntryImpl(this.interfaces.getMib(), this.interfaces, n, terminationIf.getIfDescr(), terminationIf.getIfType(), terminationIf.getIfSpeed(), terminationIf.getIfOperStatus(), terminationIf.getIfInUcastPkts(), terminationIf.getIfInNUcastPkts(), terminationIf.getIfOutOctets(), terminationIf.getIfOutUcastPkts(), terminationIf.getIfOutNUcastPkts());
    }

    void deleteEntityEntry(EntPhysicalEntry entPhysicalEntry) {
        this.entPhysicalTable.removeEntry(entPhysicalEntry);
    }

    void deleteEquipHolderTableEntry(NetraCtEquipHolderEntry netraCtEquipHolderEntry) {
        this.NetraCtEquipHolderTable.removeEntry(netraCtEquipHolderEntry);
    }

    void deleteEquipTableEntry(NetraCtEquipEntry netraCtEquipEntry) {
        this.NetraCtEquipTable.removeEntry(netraCtEquipEntry);
    }

    void deleteIfEntry(IfEntryImpl ifEntryImpl) {
        this.interfaces.removeIfEntry(ifEntryImpl);
    }

    void deletePhysPathTpTableEntry(NetraCtPhysPathTpEntry netraCtPhysPathTpEntry) {
        this.NetraCtPhysPathTpTable.removeEntry(netraCtPhysPathTpEntry);
    }

    void deletePlugInUnitTableEntry(NetraCtPlugInUnitEntry netraCtPlugInUnitEntry) {
        this.NetraCtPlugInUnitTable.removeEntry(netraCtPlugInUnitEntry);
    }

    NetraCtAlarmFilter getAlarmFilter() {
        return this.alarmFilter;
    }

    TableNetraCtAlarmSevTableImpl getAlarmSevTableImpl() {
        return this.netraCtAlarmSevTableImpl;
    }

    EntPhysicalEntry getEntityEntry(Integer n) {
        if (this.entPhysicalTable == null) {
            return null;
        }
        try {
            SnmpIndex snmpIndex = this.entPhysicalTable.getSnmpIndex(n);
            return this.entPhysicalTable.getEntPhysicalEntry(snmpIndex);
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
            return null;
        }
    }

    TableNetraCtLoggedAlarmTable getLoggedAlarmTable() {
        return this.NetraCtLoggedAlarmTable;
    }

    TableNetraCtLoggedTrapTable getLoggedTrapTable() {
        return this.NetraCtLoggedTrapTable;
    }

    String getNeType() {
        String string;
        int n = SystemView.getSystemType();
        if (n == 0) {
            this.debug.write((Object)this, 7, "This is a monte carlo");
            string = "1.3.6.1.4.1.42.2.65.1.1.2.1";
        } else if (n == 3) {
            this.debug.write((Object)this, 7, "This is a tonga without disk");
            string = "1.3.6.1.4.1.42.2.65.1.1.2.2";
        } else {
            this.debug.write((Object)this, 7, "This is a tonga with disk");
            string = "1.3.6.1.4.1.42.2.65.1.1.2.3";
        }
        return string;
    }

    public Integer getNetraCtAlarmSevProfileIndexNext() throws SnmpStatusException {
        this.NetraCtAlarmSevProfileIndexNext = this.NetraCtAlarmSevProfileIndexNext >= Integer.MAX_VALUE ? new Integer(-1) : new Integer(this.NetraCtAlarmSevProfileIndexNext + 1);
        return this.NetraCtAlarmSevProfileIndexNext;
    }

    TableNetraCtTrapForwardingTable getTrapForwardingTable() {
        return this.NetraCtTrapForwardingTable;
    }

    TableNetraCtTrapLogTable getTrapLogTable() {
        return this.NetraCtTrapLogTable;
    }

    Vector getVBList(EntPhysicalEntry entPhysicalEntry) throws SnmpStatusException {
        return this.getVBList(entPhysicalEntry.getEntPhysicalIndex(), entPhysicalEntry.getEntPhysicalContainedIn(), entPhysicalEntry.getEntPhysicalParentRelPos(), new Integer(entPhysicalEntry.getEntPhysicalClass().intValue()));
    }

    Vector getVBList(Integer n, Integer n2, Integer n3, Integer n4) throws SnmpStatusException {
        SnmpInt snmpInt = new SnmpInt(n2);
        SnmpInt snmpInt2 = new SnmpInt(n3);
        SnmpInt snmpInt3 = new SnmpInt(n4);
        SnmpOid snmpOid = new SnmpOid("1.3.6.1.2.1.47.1.1.1.1.4");
        SnmpOid snmpOid2 = new SnmpOid("1.3.6.1.2.1.47.1.1.1.1.6");
        SnmpOid snmpOid3 = new SnmpOid("1.3.6.1.2.1.47.1.1.1.1.5");
        snmpOid.append((long)n.intValue());
        snmpOid2.append((long)n.intValue());
        snmpOid3.append((long)n.intValue());
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[]{new SnmpVarBind(snmpOid, (SnmpValue)snmpInt), new SnmpVarBind(snmpOid2, (SnmpValue)snmpInt2), new SnmpVarBind(snmpOid3, (SnmpValue)snmpInt3)};
        Vector<SnmpVarBind> vector = new Vector<SnmpVarBind>();
        vector.add(snmpVarBindArray[0]);
        vector.add(snmpVarBindArray[1]);
        vector.add(snmpVarBindArray[2]);
        return vector;
    }

    void initialize() {
        this.debug = new Debug();
        this.NetraCtEquipHolderTable = new TableNetraCtEquipHolderTable(this.mib, this.server);
        this.registerMBean(this.NetraCtEquipHolderTable, "TableNetraCtEquipHolderTable");
        this.NetraCtEquipTable = new TableNetraCtEquipTable(this.mib, this.server);
        this.registerMBean(this.NetraCtEquipTable, "TableNetraCtEquipTable");
        this.NetraCtPhysPathTpTable = new TableNetraCtPhysPathTpTable(this.mib, this.server);
        this.registerMBean(this.NetraCtPhysPathTpTable, "TableNetraCtPhysPathTpTable");
        this.NetraCtPlugInUnitTable = new TableNetraCtPlugInUnitTable(this.mib, this.server);
        this.registerMBean(this.NetraCtPlugInUnitTable, "TableNetraCtPlugInUnitTable");
        this.NetraCtLoggedAlarmTable = new TableNetraCtLoggedAlarmTable(this.mib);
        this.registerMBean(this.NetraCtLoggedAlarmTable, "TableNetraCtLoggedAlarmTable");
        this.NetraCtLoggedTrapTable = new TableNetraCtLoggedTrapTable(this.mib, this.server);
        this.registerMBean(this.NetraCtLoggedTrapTable, "TableNetraCtLoggedTrapTable");
        this.NetraCtTrapLogTable = new TableNetraCtTrapLogTable(this.mib, this.server);
        this.registerMBean(this.NetraCtTrapLogTable, "TableNetraCtTrapLogTable");
        this.NetraCtTrapForwardingTable = new TableNetraCtTrapForwardingTable(this.mib, this.server);
        this.registerMBean(this.NetraCtTrapForwardingTable, "TableNetraCtTrapForwardingTable");
        this.netraCtAlarmSevTableImpl = new TableNetraCtAlarmSevTableImpl(this.mib, this, this.server);
        this.registerMBean(this.netraCtAlarmSevTableImpl, "TableNetraCtAlarmSevTable");
        this.NetraCtAlarmSevTable = this.netraCtAlarmSevTableImpl;
        this.NetraCtAlarmSevProfileTable = new TableNetraCtAlarmSevProfileTable(this.mib, this.server, this.netraCtAlarmSevTableImpl);
        this.registerMBean(this.NetraCtAlarmSevProfileTable, "TableNetraCtAlarmSevProfileTable");
        this.NetraCtHwInstalledSwTable = new TableNetraCtHwInstalledSwTable(this.mib, this.server);
        this.registerMBean(this.NetraCtHwInstalledSwTable, "TableNetraCtHwInstalledSwTable");
        this.NetraCtHwRunningSwTable = new TableNetraCtHwRunningSwTable(this.mib, this.server);
        this.registerMBean(this.NetraCtHwRunningSwTable, "TableNetraCtHwRunningSwTable");
        this.NetraCtNeVendor = "Sun Microsystems Inc.";
        this.NetraCtNeVersion = this.getNeType();
        this.NetraCtNeAlarmSeverityIndex = new Integer(0);
        this.NetraCtNeStartTime = DateAndTime.getTimeInBytes();
        this.NetraCtNeSuppressZeroStats = new EnumNetraCtNeSuppressZeroStats("true");
        this.NetraCtAlarmSevDefault = new EnumNetraCtAlarmSevDefault("minor");
        this.NetraCtAlarmSevProfileIndexNext = new Integer(-1);
        this.NetraCtTrapAlarmBUObject = new String("0.0");
        this.NetraCtTrapAlarmSpecificProb = "No specific information";
        this.NetraCtTrapAlarmRepairAct = "Repair action(s) unknown";
    }

    protected void registerMBean(Object object, String string) {
        block2: {
            if (this.server == null) break block2;
            try {
                ObjectName objectName = new ObjectName("NetraCtMIBObjects:name=" + string);
                this.server.registerMBean(object, objectName);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void sendThisV2Trap(TrapInfo trapInfo) {
        this.trapManager.sendThisV2Trap(trapInfo);
        try {
            NetraCtTrapLogEntryImpl netraCtTrapLogEntryImpl = this.logFilter.getFilterEntry(trapInfo);
            this.logManager.logThisTrap(netraCtTrapLogEntryImpl, trapInfo);
        }
        catch (FilterEntryNotFoundException filterEntryNotFoundException) {
            this.debug.write((Object)this, 7, "Filter not set for this trap");
        }
    }

    void setAlarmFilter(NetraCtAlarmFilter netraCtAlarmFilter) {
        this.alarmFilter = netraCtAlarmFilter;
    }

    void setEntityPhysicalImpl(EntityPhysicalImpl entityPhysicalImpl) {
        this.entityPhysical = entityPhysicalImpl;
        try {
            this.entPhysicalTable = (TableEntPhysicalTableImpl)this.entityPhysical.accessEntPhysicalTable();
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
        }
    }

    void setInterfacesImpl(InterfacesImpl interfacesImpl) {
        this.interfaces = interfacesImpl;
    }

    void setLogFilter(LogFilter logFilter) {
        this.logFilter = logFilter;
    }

    void setLogManager(LogManager logManager) {
        this.logManager = logManager;
    }

    void setTrapManager(TrapManager trapManager) {
        this.trapManager = trapManager;
    }
}

