/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.snmp;

import com.sun.ctmgx.snmp.InterfacesMBean;
import com.sun.ctmgx.snmp.TableIfTable;
import com.sun.jdmk.snmp.agent.SnmpMib;
import com.sun.jdmk.snmp.agent.SnmpMibGroup;
import com.sun.jdmk.snmp.agent.SnmpMibNode;
import java.io.Serializable;
import javax.management.snmp.SnmpInt;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;

public class InterfacesMeta
extends SnmpMibGroup
implements Serializable {
    private InterfacesMBean node;

    public InterfacesMeta(SnmpMib snmpMib) {
        try {
            this.registerVariable(2L);
            this.registerVariable(1L);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getMessage());
        }
    }

    public void check(SnmpValue snmpValue, long[] lArray, int n) throws SnmpStatusException {
        boolean bl = true;
        int n2 = lArray.length;
        if (n >= n2) {
            throw new SnmpStatusException(6);
        }
        if (n + 2 == n2) {
            bl = lArray[n2 - 1] == 0L;
        }
        switch ((int)lArray[n]) {
            case 2: {
                TableIfTable tableIfTable = this.node.accessIfTable();
                tableIfTable.check(snmpValue, lArray, n + 1);
                return;
            }
            case 1: {
                if (!bl) {
                    throw new SnmpStatusException(2);
                }
                throw new SnmpStatusException(4);
            }
        }
        super.check(snmpValue, lArray, n);
    }

    public SnmpValue get(long[] lArray, int n) throws SnmpStatusException {
        boolean bl = false;
        int n2 = lArray.length;
        if (n >= n2) {
            throw new SnmpStatusException(6);
        }
        if (n + 2 == n2) {
            bl = lArray[n2 - 1] == 0L;
        }
        switch ((int)lArray[n]) {
            case 2: {
                TableIfTable tableIfTable = this.node.accessIfTable();
                return tableIfTable.get(lArray, n + 1);
            }
            case 1: {
                if (!bl) break;
                return new SnmpInt(this.node.getIfNumber());
            }
            default: {
                return super.get(lArray, n);
            }
        }
        throw new SnmpStatusException(2);
    }

    public SnmpVarBind getNext(long[] lArray, int n) throws SnmpStatusException {
        if (lArray.length <= n) {
            lArray = new long[1];
            n = 0;
            lArray[0] = -1L;
            return this.getNext(lArray, n);
        }
        int n2 = (int)lArray[n];
        SnmpVarBind snmpVarBind = null;
        try {
            switch (n2) {
                case 2: {
                    TableIfTable tableIfTable = this.node.accessIfTable();
                    snmpVarBind = tableIfTable.getNext(lArray, n + 1);
                    snmpVarBind.insertInOid(2);
                    return snmpVarBind;
                }
            }
            if (this.isSubArc(n2)) {
                return super.getNext(lArray, n);
            }
            long[] lArray2 = new long[]{n + 1 == lArray.length ? (long)n2 : (long)SnmpMibNode.getNextIdentifier((int[])((SnmpMibNode)this).varList, (long)lArray[n]), 0L};
            SnmpValue snmpValue = this.get(lArray2, 0);
            return new SnmpVarBind(new SnmpOid(lArray2), snmpValue);
        }
        catch (SnmpStatusException snmpStatusException) {
            long[] lArray3 = new long[]{SnmpMibNode.getNextIdentifier((int[])((SnmpMibNode)this).varList, (long)lArray[n])};
            return this.getNext(lArray3, 0);
        }
    }

    public SnmpValue set(SnmpValue snmpValue, long[] lArray, int n) throws SnmpStatusException {
        boolean bl = true;
        int n2 = lArray.length;
        if (n >= n2) {
            throw new SnmpStatusException(6);
        }
        if (n == n2 - 2) {
            bl = lArray[n2 - 1] == 0L;
        }
        switch ((int)lArray[n]) {
            case 2: {
                TableIfTable tableIfTable = this.node.accessIfTable();
                return tableIfTable.set(snmpValue, lArray, n + 1);
            }
            case 1: {
                if (!bl) break;
                throw new SnmpStatusException(4);
            }
            default: {
                return super.set(snmpValue, lArray, n);
            }
        }
        throw new SnmpStatusException(2);
    }

    protected void setInstance(InterfacesMBean interfacesMBean) {
        this.node = interfacesMBean;
    }
}

