/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.snmp;

import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.SystemView;
import com.sun.ctmgx.snmp.DateAndTime;
import com.sun.ctmgx.snmp.EnumIfAdminStatus;
import com.sun.ctmgx.snmp.EnumIfOperStatus;
import com.sun.ctmgx.snmp.EnumIfType;
import com.sun.ctmgx.snmp.IF_MIBOidTable;
import com.sun.ctmgx.snmp.IfEntry;
import com.sun.ctmgx.snmp.IfEntryMBean;
import com.sun.ctmgx.snmp.InterfacesImpl;
import com.sun.ctmgx.snmp.LinkDownTrap;
import com.sun.ctmgx.snmp.LinkUpTrap;
import com.sun.jdmk.snmp.agent.SnmpIndex;
import com.sun.jdmk.snmp.agent.SnmpMib;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.management.snmp.SnmpInt;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpOidRecord;
import javax.management.snmp.SnmpStatusException;

public class IfEntryImpl
extends IfEntry
implements Serializable {
    InterfacesImpl group;
    Debug debug;
    IF_MIBOidTable oidTable;

    public IfEntryImpl(SnmpMib snmpMib, InterfacesImpl interfacesImpl, int n, String string, int n2, long l, int n3, long l2, long l3, long l4, long l5, long l6) {
        super(snmpMib);
        this.group = interfacesImpl;
        this.debug = new Debug();
        this.oidTable = new IF_MIBOidTable();
        this.IfIndex = new Integer(n);
        this.IfDescr = string;
        this.IfType = new EnumIfType(n2);
        this.IfSpeed = new Long(l);
        this.IfInUcastPkts = new Long(l2);
        this.IfInNUcastPkts = new Long(l3);
        this.IfOutOctets = new Long(l4);
        this.IfOutUcastPkts = new Long(l5);
        this.IfOutNUcastPkts = new Long(l6);
        this.IfMtu = new Integer(0);
        this.IfOperStatus = new EnumIfOperStatus(n3);
        this.IfAdminStatus = new EnumIfAdminStatus("up");
        Byte by = new Byte(0);
        Byte[] byteArray = new Byte[]{by, by, by, by, by, by};
        this.IfLastChange = new Long(0L);
        this.IfPhysAddress = byteArray;
        this.IfInOctets = new Long(0L);
        this.IfInDiscards = new Long(0L);
        this.IfInErrors = new Long(0L);
        this.IfInUnknownProtos = new Long(0L);
        this.IfOutDiscards = new Long(0L);
        this.IfOutErrors = new Long(0L);
        this.IfOutQLen = new Long(0L);
    }

    protected SnmpOid buildOidFromIndex(SnmpIndex snmpIndex) throws SnmpStatusException {
        SnmpOid snmpOid = new SnmpOid();
        if (snmpIndex.getNbComponents() != 1) {
            throw new SnmpStatusException(2);
        }
        try {
            Vector vector = snmpIndex.getComponents();
            SnmpInt.appendToOid((SnmpOid)((SnmpOid)vector.elementAt(0)), (SnmpOid)snmpOid);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
        return snmpOid;
    }

    public SnmpIndex buildSnmpIndex(IfEntryMBean ifEntryMBean) throws SnmpStatusException {
        SnmpOid[] snmpOidArray = new SnmpOid[1];
        SnmpInt snmpInt = null;
        snmpInt = new SnmpInt(ifEntryMBean.getIfIndex());
        snmpOidArray[0] = snmpInt.toOid();
        return new SnmpIndex(snmpOidArray);
    }

    SnmpOid getTrapObject() {
        String string = "0.0";
        try {
            SnmpOidRecord snmpOidRecord = this.oidTable.resolveVarName("ifIndex");
            String string2 = snmpOidRecord.getOid();
            SnmpIndex snmpIndex = this.buildSnmpIndex(this);
            SnmpOid snmpOid = this.buildOidFromIndex(snmpIndex);
            string = String.valueOf(string2) + snmpOid.toString();
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
        }
        return new SnmpOid(string);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        this.debug.write((Object)this, 7, "Inside propertyChange handler for property = " + string);
        int n = (Integer)propertyChangeEvent.getOldValue();
        int n2 = (Integer)propertyChangeEvent.getNewValue();
        EnumIfOperStatus enumIfOperStatus = new EnumIfOperStatus("up");
        EnumIfOperStatus enumIfOperStatus2 = new EnumIfOperStatus("down");
        EnumIfOperStatus enumIfOperStatus3 = new EnumIfOperStatus("unknown");
        if ("operStatus".equals(string) && n != n2) {
            this.debug.write((Object)this, 6, "property=operStatus");
            Vector vector = new Vector();
            this.IfOperStatus = n2 == enumIfOperStatus.intValue() ? enumIfOperStatus : enumIfOperStatus2;
            try {
                vector = this.group.getVBList(this);
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpStatusException.printStackTrace();
            }
            if (n2 == enumIfOperStatus.intValue()) {
                Byte[] byteArray = DateAndTime.getTimeInBytes();
                SnmpOid snmpOid = this.getTrapObject();
                LinkUpTrap linkUpTrap = new LinkUpTrap(SystemView.getSysIpAddress(), byteArray, snmpOid, vector, new Integer(0));
                this.debug.write((Object)this, 6, "sending LinkUp trap");
                this.group.sendThisV2Trap(linkUpTrap);
            } else if (n2 == enumIfOperStatus2.intValue()) {
                Byte[] byteArray = DateAndTime.getTimeInBytes();
                SnmpOid snmpOid = this.getTrapObject();
                LinkDownTrap linkDownTrap = new LinkDownTrap(SystemView.getSysIpAddress(), byteArray, snmpOid, vector, new Integer(0));
                this.debug.write((Object)this, 6, "sending LinkDownTrap trap");
                this.group.sendThisV2Trap(linkDownTrap);
            }
        }
    }
}

