/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.snmp;

import com.sun.ctmgx.common.PackageInfo;
import com.sun.ctmgx.common.PackageInfoList;
import com.sun.ctmgx.common.PackageInfoListEvent;
import com.sun.ctmgx.common.PackageInfoListListener;
import com.sun.ctmgx.common.SystemView;
import com.sun.ctmgx.snmp.DateAndTime;
import com.sun.ctmgx.snmp.EnumHrSWInstalledType;
import com.sun.ctmgx.snmp.HOST_RESOURCES_MIBOidTable;
import com.sun.ctmgx.snmp.HrSWInstalled;
import com.sun.ctmgx.snmp.HrSWInstalledEntry;
import com.sun.ctmgx.snmp.InstalledSwDeletedTrap;
import com.sun.ctmgx.snmp.NetraCtHwInstalledSwEntryImpl;
import com.sun.ctmgx.snmp.SUN_SNMP_NETRA_CT_MIBOidTable;
import com.sun.ctmgx.snmp.TableEntPhysicalTable;
import com.sun.ctmgx.snmp.TableNetraCtHwInstalledSwTable;
import com.sun.ctmgx.snmp.TrapInfo;
import com.sun.ctmgx.snmp.TrapManager;
import com.sun.jdmk.snmp.SnmpOidTableSupport;
import com.sun.jdmk.snmp.agent.SnmpMib;
import com.sun.jdmk.snmp.agent.SnmpMibHandler;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.snmp.SnmpInt;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpString;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;

public class HrSWInstalledImpl
extends HrSWInstalled
implements PackageInfoListListener {
    protected static final String PKGINST_PROP = "PKGINST";
    protected static final String INSTDATE_PROP = "INSTDATE";
    protected static String defaultDate = "";
    private PackageInfoList packageInfoList;
    private TableNetraCtHwInstalledSwTable netraCtHwInstalledSwTable;
    private TableEntPhysicalTable entPhysicalTable;
    private SnmpMib mib;
    private HashMap map;
    TrapManager trapManager;
    private int index;
    private static final String ENTRY_NAME_PREFIX = "TableHrSWInstalledTable:name=com.sun.ctmgx.snmp.HrSWInstalledEntry,HrSWInstalledIndex=";
    private static SnmpOid HrSwInstalledIndexOid;
    private static SnmpOid HrSwInstalledNameOid;
    private static SnmpOid NetraCtHwInstalledSwSwIndexOid;
    private static SnmpOid NetraCtTrapAlarmSpecificProbOid;

    public HrSWInstalledImpl(SnmpMib snmpMib, PackageInfoList packageInfoList, TableNetraCtHwInstalledSwTable tableNetraCtHwInstalledSwTable, TableEntPhysicalTable tableEntPhysicalTable) {
        this(snmpMib, null, packageInfoList, tableNetraCtHwInstalledSwTable, tableEntPhysicalTable);
    }

    public HrSWInstalledImpl(SnmpMib snmpMib, MBeanServer mBeanServer, PackageInfoList packageInfoList, TableNetraCtHwInstalledSwTable tableNetraCtHwInstalledSwTable, TableEntPhysicalTable tableEntPhysicalTable) {
        super(snmpMib, mBeanServer);
        this.init(snmpMib, packageInfoList, tableNetraCtHwInstalledSwTable, tableEntPhysicalTable);
    }

    private EntryPair addEntry(PackageInfo packageInfo) {
        HrSWInstalledEntry hrSWInstalledEntry = this.createHrSWInstalledEntry(packageInfo);
        NetraCtHwInstalledSwEntryImpl netraCtHwInstalledSwEntryImpl = this.createNetraCtHwInstalledSwEntry(hrSWInstalledEntry);
        EntryPair entryPair = new EntryPair(hrSWInstalledEntry, netraCtHwInstalledSwEntryImpl);
        this.map.put(packageInfo, entryPair);
        try {
            this.HrSWInstalledTable.addEntry(hrSWInstalledEntry);
            this.netraCtHwInstalledSwTable.addEntry(netraCtHwInstalledSwEntryImpl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return entryPair;
    }

    private Byte[] createByteArray(byte[] byArray) {
        Byte[] byteArray = new Byte[byArray.length - 2];
        int n = 0;
        while (n < byteArray.length) {
            byteArray[n] = new Byte(byArray[n + 1]);
            ++n;
        }
        return byteArray;
    }

    private HrSWInstalledEntry createHrSWInstalledEntry(PackageInfo packageInfo) {
        HrSWInstalledEntry hrSWInstalledEntry = new HrSWInstalledEntry(this.mib);
        hrSWInstalledEntry.HrSWInstalledIndex = new Integer(this.index++);
        hrSWInstalledEntry.HrSWInstalledDate = this.getByteArray(packageInfo.getInstalledDate());
        hrSWInstalledEntry.HrSWInstalledName = this.getByteArray(packageInfo.getName());
        hrSWInstalledEntry.HrSWInstalledID = "0.0";
        hrSWInstalledEntry.HrSWInstalledType = new EnumHrSWInstalledType(4);
        return hrSWInstalledEntry;
    }

    protected HrSWInstalledEntry createHrSWInstalledEntry(SnmpMib snmpMib, Properties properties, int n) {
        HrSWInstalledEntry hrSWInstalledEntry = new HrSWInstalledEntry(snmpMib);
        hrSWInstalledEntry.HrSWInstalledIndex = new Integer(n);
        hrSWInstalledEntry.HrSWInstalledDate = this.createByteArray(properties.getProperty(INSTDATE_PROP, defaultDate).getBytes());
        hrSWInstalledEntry.HrSWInstalledName = this.createByteArray(properties.getProperty(PKGINST_PROP, defaultDate).getBytes());
        hrSWInstalledEntry.HrSWInstalledID = "0.0";
        hrSWInstalledEntry.HrSWInstalledType = new EnumHrSWInstalledType(1);
        return hrSWInstalledEntry;
    }

    private NetraCtHwInstalledSwEntryImpl createNetraCtHwInstalledSwEntry(HrSWInstalledEntry hrSWInstalledEntry) {
        NetraCtHwInstalledSwEntryImpl netraCtHwInstalledSwEntryImpl = new NetraCtHwInstalledSwEntryImpl(this.mib);
        netraCtHwInstalledSwEntryImpl.NetraCtHwSwAlarmSeverityIndex = new Integer(0);
        netraCtHwInstalledSwEntryImpl.NetraCtHwInstalledSwSwIndex = hrSWInstalledEntry.HrSWInstalledIndex;
        netraCtHwInstalledSwEntryImpl.NetraCtHwInstalledSwIndex = hrSWInstalledEntry.HrSWInstalledIndex;
        netraCtHwInstalledSwEntryImpl.NetraCtHwInstalledSwHwIndex = new Integer(1);
        return netraCtHwInstalledSwEntryImpl;
    }

    private Vector createVarBind(HrSWInstalledEntry hrSWInstalledEntry, NetraCtHwInstalledSwEntryImpl netraCtHwInstalledSwEntryImpl, PackageInfoListEvent packageInfoListEvent) {
        Vector<SnmpVarBind> vector = new Vector<SnmpVarBind>(3);
        try {
            vector.add(new SnmpVarBind(NetraCtHwInstalledSwSwIndexOid, (SnmpValue)new SnmpInt(netraCtHwInstalledSwEntryImpl.getNetraCtHwInstalledSwSwIndex())));
            vector.add(new SnmpVarBind(HrSwInstalledIndexOid, (SnmpValue)new SnmpInt(hrSWInstalledEntry.getHrSWInstalledIndex())));
            vector.add(new SnmpVarBind(HrSwInstalledNameOid, (SnmpValue)new SnmpString(hrSWInstalledEntry.getHrSWInstalledName())));
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
        }
        return vector;
    }

    private Byte[] getByteArray(String string) {
        byte[] byArray = string.getBytes();
        Byte[] byteArray = new Byte[byArray.length];
        int n = 0;
        while (n < byteArray.length) {
            byteArray[n] = new Byte(byArray[n]);
            ++n;
        }
        return byteArray;
    }

    protected Properties getPackageProperties(String string) {
        Properties properties = new Properties();
        try {
            String[] stringArray = new String[]{"/usr/bin/pkgparam", "-v", string, INSTDATE_PROP, PKGINST_PROP};
            Process process = Runtime.getRuntime().exec(stringArray);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
            properties.load(bufferedInputStream);
            int n = process.waitFor();
            if (n != 0) {
                throw new Exception("pkgparam failed.");
            }
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return properties;
    }

    private ArrayList getPackages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String[] stringArray = new String[]{"pkginfo", ">", "pkginfo_out"};
            Process process = Runtime.getRuntime().exec("/usr/bin/pkginfo");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (stringTokenizer.countTokens() < 2) continue;
                stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                arrayList.add(string2);
            }
            int n = process.waitFor();
            if (n != 0) {
                throw new Exception("pkginfo failed");
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private void init(SnmpMib snmpMib, PackageInfoList packageInfoList, TableNetraCtHwInstalledSwTable tableNetraCtHwInstalledSwTable, TableEntPhysicalTable tableEntPhysicalTable) {
        this.mib = snmpMib;
        this.packageInfoList = packageInfoList;
        this.netraCtHwInstalledSwTable = tableNetraCtHwInstalledSwTable;
        this.entPhysicalTable = tableEntPhysicalTable;
        this.map = new HashMap();
        this.initOids();
        packageInfoList.addPackageInfoListListener((PackageInfoListListener)this);
        PackageInfo[] packageInfoArray = packageInfoList.toArray();
        int n = 0;
        while (n < packageInfoArray.length) {
            this.addEntry(packageInfoArray[n]);
            ++n;
        }
    }

    private void initOids() {
        SnmpOidTableSupport snmpOidTableSupport = new HOST_RESOURCES_MIBOidTable();
        try {
            HrSwInstalledIndexOid = new SnmpOid(snmpOidTableSupport.resolveVarName("hrSWInstalledIndex").getOid());
            HrSwInstalledNameOid = new SnmpOid(snmpOidTableSupport.resolveVarName("hrSWInstalledName").getOid());
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
        }
        snmpOidTableSupport = new SUN_SNMP_NETRA_CT_MIBOidTable();
        try {
            NetraCtHwInstalledSwSwIndexOid = new SnmpOid(snmpOidTableSupport.resolveVarName("netraCtHwInstalledSwSwIndex").getOid());
            NetraCtTrapAlarmSpecificProbOid = new SnmpOid(snmpOidTableSupport.resolveVarName("netraCtTrapAlarmSpecificProb").getOid());
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
        }
    }

    public void packageInfoAdded(PackageInfoListEvent packageInfoListEvent) {
    }

    public void packageInfoRemoved(PackageInfoListEvent packageInfoListEvent) {
        PackageInfo packageInfo = packageInfoListEvent.getPackageInfo();
        EntryPair entryPair = this.addEntry(packageInfo);
        Vector vector = this.createVarBind(entryPair.hrSWInstalledEntry, entryPair.netraCtHwInstalledSwEntry, packageInfoListEvent);
        Byte[] byteArray = DateAndTime.getTimeInBytes();
        SnmpOid snmpOid = entryPair.netraCtHwInstalledSwEntry.getTrapObject();
        InstalledSwDeletedTrap installedSwDeletedTrap = new InstalledSwDeletedTrap(SystemView.getSysIpAddress(), byteArray, snmpOid, vector, new Integer(0));
        this.sendTrap(installedSwDeletedTrap);
    }

    private void sendTrap(TrapInfo trapInfo) {
        block3: {
            SnmpMibHandler snmpMibHandler = this.mib.getSnmpAdaptor();
            if (snmpMibHandler == null) break block3;
            try {
                snmpMibHandler.sendV2Trap(trapInfo.getTrapOid(), trapInfo.getTrapVarBind());
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpStatusException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    void setTrapManager(TrapManager trapManager) {
        this.trapManager = trapManager;
    }

    static class EntryPair {
        HrSWInstalledEntry hrSWInstalledEntry;
        NetraCtHwInstalledSwEntryImpl netraCtHwInstalledSwEntry;

        EntryPair(HrSWInstalledEntry hrSWInstalledEntry, NetraCtHwInstalledSwEntryImpl netraCtHwInstalledSwEntryImpl) {
            this.hrSWInstalledEntry = hrSWInstalledEntry;
            this.netraCtHwInstalledSwEntry = this.netraCtHwInstalledSwEntry;
        }
    }
}

