/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.snmp;

import com.sun.ctmgx.common.Cpu;
import com.sun.ctmgx.common.EquipmentIf;
import com.sun.ctmgx.common.SystemView;
import com.sun.ctmgx.snmp.DateAndTime;
import com.sun.ctmgx.snmp.EntPhysicalEntryImpl;
import com.sun.ctmgx.snmp.EnumNetraCtLoggedAlarmBackedUp;
import com.sun.ctmgx.snmp.EnumNetraCtLoggedAlarmSeverity;
import com.sun.ctmgx.snmp.HighTempAlarm;
import com.sun.ctmgx.snmp.NetraCtAlarmFilter;
import com.sun.ctmgx.snmp.NetraCtEquipEntryImpl;
import com.sun.ctmgx.snmp.NetraCtMIBObjectsImpl;
import com.sun.jdmk.snmp.agent.SnmpMib;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.management.snmp.SnmpInt;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpString;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;

public class CpuEquipment
extends NetraCtEquipEntryImpl
implements Serializable,
PropertyChangeListener {
    Cpu cpu;
    NetraCtAlarmFilter alarmFilter;

    public CpuEquipment(SnmpMib snmpMib, NetraCtMIBObjectsImpl netraCtMIBObjectsImpl, Cpu cpu, int n) {
        super(snmpMib, netraCtMIBObjectsImpl, (EquipmentIf)cpu, n);
        this.cpu = cpu;
        this.alarmFilter = netraCtMIBObjectsImpl.getAlarmFilter();
    }

    protected void alarmChange(Boolean bl, String string) {
        if (bl.booleanValue()) {
            this.setHighTempAlarm(string);
        } else {
            this.clearHighTempAlarm(string);
        }
    }

    protected void clearHighTempAlarm(String string) {
        this.sendHighTempAlarm(this.entity, string, new EnumNetraCtLoggedAlarmSeverity(-1), this.NetraCtEquipAlarmSeverityIndex);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.debug.write((Object)this, 7, "In propChange");
        String string = propertyChangeEvent.getPropertyName();
        if ("warningTempAlarm".equals(string)) {
            this.alarmChange((Boolean)propertyChangeEvent.getNewValue(), "Warning threshold exceeded");
        } else if ("shutdownTempAlarm".equals(string)) {
            this.alarmChange((Boolean)propertyChangeEvent.getNewValue(), "Shutdown threshold exceeded");
        }
    }

    protected void sendHighTempAlarm(EntPhysicalEntryImpl entPhysicalEntryImpl, String string, EnumNetraCtLoggedAlarmSeverity enumNetraCtLoggedAlarmSeverity, Integer n) {
        SnmpVarBind[] snmpVarBindArray;
        SnmpOid snmpOid;
        SnmpOid snmpOid2;
        Vector vector = new Vector();
        this.debug.write((Object)this, 6, "sending high temp alarm");
        try {
            vector = this.group.getVBList(entPhysicalEntryImpl);
            snmpOid2 = new SnmpOid("1.3.6.1.4.1.42.2.65.1.1.1.1.21");
            snmpOid = new SnmpOid("1.3.6.1.4.1.42.2.65.1.1.1.1.24");
            SnmpInt snmpInt = new SnmpInt(enumNetraCtLoggedAlarmSeverity.intValue());
            SnmpString snmpString = new SnmpString(string);
            snmpVarBindArray = new SnmpVarBind[]{new SnmpVarBind(snmpOid2, (SnmpValue)snmpInt), new SnmpVarBind(snmpOid, (SnmpValue)snmpString)};
            vector.add(snmpVarBindArray[0]);
            vector.add(snmpVarBindArray[1]);
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
        }
        snmpOid2 = DateAndTime.getTimeInBytes();
        snmpOid = this.getTrapObject();
        snmpVarBindArray = new EnumNetraCtLoggedAlarmBackedUp("false");
        HighTempAlarm highTempAlarm = new HighTempAlarm(SystemView.getSysIpAddress(), (Byte[])snmpOid2, snmpOid, vector, enumNetraCtLoggedAlarmSeverity, (EnumNetraCtLoggedAlarmBackedUp)snmpVarBindArray, new SnmpOid("0.0"), string, "no repair action defined", n);
        this.group.sendThisV2Trap(highTempAlarm);
    }

    protected void sendHighTempAlarm(EntPhysicalEntryImpl entPhysicalEntryImpl, String string, Integer n) {
        EnumNetraCtLoggedAlarmSeverity enumNetraCtLoggedAlarmSeverity = new EnumNetraCtLoggedAlarmSeverity(this.alarmFilter.getSeverity(n, HighTempAlarm.getOid()));
        this.sendHighTempAlarm(entPhysicalEntryImpl, string, enumNetraCtLoggedAlarmSeverity, n);
    }

    protected void setHighTempAlarm(String string) {
        this.sendHighTempAlarm(this.entity, string, this.NetraCtEquipAlarmSeverityIndex);
    }
}

