/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.snmp;

import com.sun.ctmgx.common.CoyoteDisk;
import com.sun.ctmgx.common.CoyotePropChangeEvent;
import com.sun.ctmgx.common.EquipmentIf;
import com.sun.ctmgx.common.SystemView;
import com.sun.ctmgx.snmp.DateAndTime;
import com.sun.ctmgx.snmp.EntPhysicalEntryImpl;
import com.sun.ctmgx.snmp.EnumNetraCtEquipOperStatus;
import com.sun.ctmgx.snmp.EnumNetraCtLoggedAlarmBackedUp;
import com.sun.ctmgx.snmp.EnumNetraCtLoggedAlarmSeverity;
import com.sun.ctmgx.snmp.HighTempAlarm;
import com.sun.ctmgx.snmp.HwUnitDownTrap;
import com.sun.ctmgx.snmp.HwUnitUpTrap;
import com.sun.ctmgx.snmp.NetraCtEquipEntryImpl;
import com.sun.ctmgx.snmp.NetraCtMIBObjectsImpl;
import com.sun.jdmk.snmp.agent.SnmpMib;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.management.snmp.SnmpInt;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpString;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;

public class CoyoteDiskEquipment
extends NetraCtEquipEntryImpl
implements Serializable,
PropertyChangeListener {
    CoyoteDisk coyoteDisk;

    public CoyoteDiskEquipment(SnmpMib snmpMib, NetraCtMIBObjectsImpl netraCtMIBObjectsImpl, CoyoteDisk coyoteDisk, int n) {
        super(snmpMib, netraCtMIBObjectsImpl, (EquipmentIf)coyoteDisk, n);
        this.coyoteDisk = coyoteDisk;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.debug.write((Object)this, 7, "In propChange");
        String string = propertyChangeEvent.getPropertyName();
        CoyotePropChangeEvent coyotePropChangeEvent = (CoyotePropChangeEvent)propertyChangeEvent.getNewValue();
        int n = coyotePropChangeEvent.getValue();
        int n2 = this.NetraCtEquipOperStatus.intValue();
        String string2 = coyotePropChangeEvent.getSpecificProbString();
        EnumNetraCtEquipOperStatus enumNetraCtEquipOperStatus = new EnumNetraCtEquipOperStatus("up");
        EnumNetraCtEquipOperStatus enumNetraCtEquipOperStatus2 = new EnumNetraCtEquipOperStatus("down");
        EnumNetraCtEquipOperStatus enumNetraCtEquipOperStatus3 = new EnumNetraCtEquipOperStatus("unknown");
        if ("operStatus".equals(string)) {
            SnmpVarBind[] snmpVarBindArray;
            SnmpOid snmpOid;
            if (n == enumNetraCtEquipOperStatus3.intValue()) {
                this.NetraCtEquipOperStatus = enumNetraCtEquipOperStatus3;
                return;
            }
            Vector vector = new Vector();
            try {
                vector = this.group.getVBList(this.entity);
                SnmpString snmpString = new SnmpString(string2);
                snmpOid = new SnmpOid("1.3.6.1.4.1.42.2.65.1.1.1.1.24");
                snmpVarBindArray = new SnmpVarBind[]{new SnmpVarBind(snmpOid, (SnmpValue)snmpString)};
                vector.add(snmpVarBindArray[0]);
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpStatusException.printStackTrace();
            }
            snmpOid = DateAndTime.getTimeInBytes();
            snmpVarBindArray = this.getTrapObject();
            if (n == enumNetraCtEquipOperStatus.intValue()) {
                this.NetraCtEquipOperStatus = enumNetraCtEquipOperStatus;
                HwUnitUpTrap hwUnitUpTrap = new HwUnitUpTrap(SystemView.getSysIpAddress(), (Byte[])snmpOid, (SnmpOid)snmpVarBindArray, vector, this.NetraCtEquipAlarmSeverityIndex);
                this.debug.write((Object)this, 6, "sending HeUnitUp trap");
                this.group.sendThisV2Trap(hwUnitUpTrap);
            } else {
                this.NetraCtEquipOperStatus = enumNetraCtEquipOperStatus2;
                HwUnitDownTrap hwUnitDownTrap = new HwUnitDownTrap(SystemView.getSysIpAddress(), (Byte[])snmpOid, (SnmpOid)snmpVarBindArray, vector, this.NetraCtEquipAlarmSeverityIndex);
                this.debug.write((Object)this, 6, "sending HwUnitDown trap");
                this.group.sendThisV2Trap(hwUnitDownTrap);
            }
        }
    }

    public void sendHighTempAlarm(EntPhysicalEntryImpl entPhysicalEntryImpl, String string, Integer n) {
        SnmpVarBind[] snmpVarBindArray;
        SnmpOid snmpOid;
        SnmpOid snmpOid2;
        Vector vector = new Vector();
        this.debug.write((Object)this, 6, "sending high temp alarm");
        try {
            vector = this.group.getVBList(entPhysicalEntryImpl);
            snmpOid2 = new SnmpOid("1.3.6.1.4.1.42.2.65.1.1.1.1.21");
            snmpOid = new SnmpOid("1.3.6.1.4.1.42.2.65.1.1.1.1.24");
            SnmpInt snmpInt = new SnmpInt(3);
            SnmpString snmpString = new SnmpString(string);
            snmpVarBindArray = new SnmpVarBind[]{new SnmpVarBind(snmpOid2, (SnmpValue)snmpInt), new SnmpVarBind(snmpOid, (SnmpValue)snmpString)};
            vector.add(snmpVarBindArray[0]);
            vector.add(snmpVarBindArray[1]);
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
        }
        snmpOid2 = DateAndTime.getTimeInBytes();
        snmpOid = this.getTrapObject();
        snmpVarBindArray = new EnumNetraCtLoggedAlarmSeverity(n);
        EnumNetraCtLoggedAlarmBackedUp enumNetraCtLoggedAlarmBackedUp = new EnumNetraCtLoggedAlarmBackedUp("false");
        HighTempAlarm highTempAlarm = new HighTempAlarm(SystemView.getSysIpAddress(), (Byte[])snmpOid2, snmpOid, vector, (EnumNetraCtLoggedAlarmSeverity)snmpVarBindArray, enumNetraCtLoggedAlarmBackedUp, new SnmpOid("0.0"), string, "no repair action defined", n);
        this.group.sendThisV2Trap(highTempAlarm);
    }
}

