/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.moh;

import com.sun.ctmgx.common.ProcessInfo;
import com.sun.ctmgx.common.ProcessInfoList;
import com.sun.ctmgx.common.ProcessInfoListEvent;
import com.sun.ctmgx.common.ProcessInfoListListener;
import com.sun.ctmgx.common.SystemView;
import com.sun.ctmgx.moh.ContainmentTree;
import com.sun.ctmgx.moh.NetraCtDefs;
import com.sun.ctmgx.moh.ObjectCreationNotification;
import com.sun.ctmgx.moh.ObjectDeletionNotification;
import com.sun.ctmgx.moh.Software;
import com.sun.ctmgx.moh.SoftwareRunning;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;

class SwRunning
implements ProcessInfoListListener {
    private MBeanServer server;
    private SystemView sysView;
    private ContainmentTree ct;
    private ProcessInfoList processInfoList;
    private HashMap swInstanceMap = new HashMap();
    private HashMap swObjectNameMap = new HashMap();
    private String relId;
    private transient long id = 0L;

    public SwRunning(MBeanServer mBeanServer, ProcessInfoList processInfoList, ContainmentTree containmentTree) {
        this.server = mBeanServer;
        this.processInfoList = processInfoList;
        this.ct = containmentTree;
    }

    private synchronized void addEntry(ProcessInfo processInfo) {
        this.createEntry(processInfo);
        this.removeRelation(this.relId);
        this.createRelation();
        Software software = (Software)this.swInstanceMap.get(processInfo);
        ObjectName objectName = (ObjectName)this.swObjectNameMap.get(processInfo);
        ObjectCreationNotification objectCreationNotification = new ObjectCreationNotification("netract.moh.object.creation", software, objectName, software.getSequenceNumber(), "Software has been created", objectName, NetraCtDefs.OBJECT_NAME_NE);
        software.sendNotification(objectCreationNotification);
    }

    private void createEntry(ProcessInfo processInfo) {
        SoftwareRunning softwareRunning = new SoftwareRunning(processInfo);
        ObjectName objectName = null;
        try {
            long l = this.id++;
            objectName = new ObjectName("NetraCt:dn=" + NetraCtDefs.OBJECT_NAME_NE.getKeyProperty("dn") + "/" + processInfo.getName() + "_" + l + ",name=" + processInfo.getName() + ",id=" + l);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            malformedObjectNameException.printStackTrace();
        }
        this.swInstanceMap.put(processInfo, softwareRunning);
        this.swObjectNameMap.put(processInfo, objectName);
        try {
            this.server.registerMBean(softwareRunning, objectName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void createRelation() {
        Collection collection = this.swObjectNameMap.values();
        if (!collection.isEmpty()) {
            ObjectName[] objectNameArray = new ObjectName[]{};
            ObjectName[] objectNameArray2 = collection.toArray(objectNameArray);
            this.relId = this.ct.createMohRelation("NE-Software", NetraCtDefs.OBJECT_NAME_NE, objectNameArray2);
        }
    }

    void init() {
        this.processInfoList.addProcessInfoListListener((ProcessInfoListListener)this);
        ProcessInfo[] processInfoArray = this.processInfoList.toArray();
        int n = 0;
        while (n < processInfoArray.length) {
            this.createEntry(processInfoArray[n]);
            ++n;
        }
        this.createRelation();
        int n2 = 0;
        while (n2 < processInfoArray.length) {
            Software software = (Software)this.swInstanceMap.get(processInfoArray[n2]);
            ObjectName objectName = (ObjectName)this.swObjectNameMap.get(processInfoArray[n2]);
            ObjectCreationNotification objectCreationNotification = new ObjectCreationNotification("netract.moh.object.creation", software, objectName, software.getSequenceNumber(), "Software has been created", objectName, NetraCtDefs.OBJECT_NAME_NE);
            software.sendNotification(objectCreationNotification);
            ++n2;
        }
    }

    public void processInfoAdded(ProcessInfoListEvent processInfoListEvent) {
        ProcessInfo processInfo = processInfoListEvent.getProcessInfo();
        this.addEntry(processInfo);
    }

    public void processInfoRemoved(ProcessInfoListEvent processInfoListEvent) {
        ProcessInfo processInfo = processInfoListEvent.getProcessInfo();
        this.removeEntry(processInfo);
    }

    private synchronized void removeEntry(ProcessInfo processInfo) {
        Software software = (Software)this.swInstanceMap.remove(processInfo);
        ObjectName objectName = (ObjectName)this.swObjectNameMap.remove(processInfo);
        Serializable serializable = software;
        synchronized (serializable) {
            software.remote_deletion = false;
            try {
                try {
                    this.server.unregisterMBean(objectName);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Object var7_6 = null;
                software.remote_deletion = true;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                software.remote_deletion = true;
                throw throwable;
            }
        }
        serializable = new ObjectDeletionNotification("netract.moh.object.deletion", software, objectName, software.getSequenceNumber(), "Software has been deleted", objectName, NetraCtDefs.OBJECT_NAME_NE);
        software.sendNotification((Notification)serializable);
    }

    private void removeRelation(String string) {
        this.ct.removeMohRelation(string);
    }
}

