/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.moh;

import com.sun.ctmgx.common.CoyoteDisk;
import com.sun.ctmgx.common.Cpu;
import com.sun.ctmgx.common.EquipmentIf;
import com.sun.ctmgx.common.HolderIf;
import com.sun.ctmgx.common.PlugInUnitIf;
import com.sun.ctmgx.common.TerminationIf;
import com.sun.ctmgx.moh.AdministrativeState;
import com.sun.ctmgx.moh.AttributeChangeNotification;
import com.sun.ctmgx.moh.AvailabilityStatus;
import com.sun.ctmgx.moh.ContainmentTree;
import com.sun.ctmgx.moh.Equipment;
import com.sun.ctmgx.moh.EquipmentCoyoteDisk;
import com.sun.ctmgx.moh.EquipmentCpu;
import com.sun.ctmgx.moh.EquipmentHolder;
import com.sun.ctmgx.moh.NetraCtDefs;
import com.sun.ctmgx.moh.ObjectCreationNotification;
import com.sun.ctmgx.moh.ObjectDeletionNotification;
import com.sun.ctmgx.moh.OperationalState;
import com.sun.ctmgx.moh.PlugInUnitMBean;
import com.sun.ctmgx.moh.Slot;
import com.sun.ctmgx.moh.StateChangeNotification;
import com.sun.ctmgx.moh.TerminationPoint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.management.JMRuntimeException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;

public class PlugInUnit
extends NotificationBroadcasterSupport
implements PlugInUnitMBean,
MBeanRegistration,
Serializable {
    static long pluginId = 0L;
    boolean remote_deletion = true;
    MBeanServer server;
    ObjectName name;
    PlugInUnitIf plugin;
    ContainmentTree ct;
    HolderIf[] tempHolders;
    EquipmentIf[] tempEquips;
    TerminationIf[] tempTps;
    Slot[] holders;
    Equipment[] equips;
    TerminationPoint[] tps;
    ObjectName[] on_holders;
    ObjectName[] on_equips;
    ObjectName[] on_tps;
    PropChangeListener listener;
    AdministrativeState admin_state = AdministrativeState.UNLOCKED;
    OperationalState oper_state;
    AvailabilityStatus avail_status;
    String vendor_name = "";
    String version = "0.0";
    ObjectName asp = NetraCtDefs.OBJECT_NAME_ASP;
    transient long sequenceNumber = 0L;

    public PlugInUnit() {
        throw new JMRuntimeException("Remote creation of instances of this MBean is not allowed.");
    }

    PlugInUnit(PlugInUnitIf plugInUnitIf, ContainmentTree containmentTree) {
        this.plugin = plugInUnitIf;
        this.ct = containmentTree;
        this.listener = new PropChangeListener(this);
        this.oper_state = OperationalState.getState(plugInUnitIf.getOperStatus());
        if (this.oper_state == OperationalState.ENABLED) {
            this.avail_status = AvailabilityStatus.AVAILABLE;
        } else if (this.oper_state == OperationalState.DISABLED) {
            this.avail_status = AvailabilityStatus.FAILED;
        }
        int n = 0;
        this.tempHolders = plugInUnitIf.getHolders();
        this.tempEquips = plugInUnitIf.getEquipments();
        this.tempTps = plugInUnitIf.getTerminations();
        if (this.tempEquips != null) {
            this.equips = new Equipment[this.tempEquips.length];
            this.on_equips = new ObjectName[this.tempEquips.length];
        } else {
            this.equips = new Equipment[0];
            this.on_equips = new ObjectName[0];
        }
        if (this.tempHolders != null) {
            this.holders = new Slot[this.tempHolders.length];
            this.on_holders = new ObjectName[this.tempHolders.length];
        } else {
            this.holders = new Slot[0];
            this.on_holders = new ObjectName[0];
        }
        if (this.tempTps != null) {
            this.tps = new TerminationPoint[this.tempTps.length];
            this.on_tps = new ObjectName[this.tempTps.length];
        } else {
            this.tps = new TerminationPoint[0];
            this.on_tps = new ObjectName[0];
        }
        n = 0;
        while (n < this.equips.length) {
            this.equips[n] = "cpu".equals(this.tempEquips[n].getEntityName()) ? new EquipmentCpu((EquipmentIf)((Cpu)this.tempEquips[n]), containmentTree) : ("coyote_disk".equals(this.tempEquips[n].getEntityName()) ? new EquipmentCoyoteDisk((EquipmentIf)((CoyoteDisk)this.tempEquips[n]), containmentTree) : new Equipment(this.tempEquips[n], containmentTree));
            ++n;
        }
        n = 0;
        while (n < this.holders.length) {
            this.holders[n] = new Slot(this.tempHolders[n], containmentTree);
            ++n;
        }
        n = 0;
        while (n < this.tps.length) {
            this.tps[n] = new TerminationPoint(this.tempTps[n]);
            ++n;
        }
    }

    public AdministrativeState getAdministrativeState() {
        return this.admin_state;
    }

    public ObjectName getAlarmSeverityProfilePointer() {
        return this.asp;
    }

    public AvailabilityStatus getAvailabilityStatus() {
        return this.avail_status;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"netract.moh.object.creation"}, "com.sun.ctmgx.moh.ObjectCreationNotification", "Sent when an object is created."), new MBeanNotificationInfo(new String[]{"netract.moh.object.deletion"}, "com.sun.ctmgx.moh.ObjectDeletionNotification", "Sent when an object is deleted."), new MBeanNotificationInfo(new String[]{"netract.moh.attribute.change"}, "com.sun.ctmgx.moh.AttributeChangeNotification", "Sent when an attribute changes its value."), new MBeanNotificationInfo(new String[]{"netract.moh.state.change"}, "com.sun.ctmgx.moh.StateChangeNotification", "Sent when an state attribute changes its value.")};
        return mBeanNotificationInfoArray;
    }

    public OperationalState getOperationalState() {
        return this.oper_state;
    }

    static synchronized long getPlugInUnitId() {
        return pluginId++;
    }

    public String getPlugInUnitType() {
        return this.plugin.getEntityName();
    }

    synchronized long getSequenceNumber() {
        return this.sequenceNumber++;
    }

    public String getVendorName() {
        return this.vendor_name;
    }

    public String getVersion() {
        return this.version;
    }

    void init() {
        int n = 0;
        n = 0;
        while (n < this.equips.length) {
            try {
                Equipment cfr_ignored_0 = this.equips[n];
                this.on_equips[n] = new ObjectName("NetraCt:dn=" + this.name.getKeyProperty("dn") + "/" + this.tempEquips[n].getEntityName() + "_" + this.tempEquips[n].getEntityParentRelPos() + ",name=" + this.tempEquips[n].getEntityName() + ",id=" + Equipment.getEquipmentId());
                this.server.registerMBean(this.equips[n], this.on_equips[n]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.equips[n].init();
            ++n;
        }
        if (this.equips.length > 0) {
            this.ct.createMohRelation("PlugInUnit-Equipment", this.name, this.on_equips);
        }
        n = 0;
        while (n < this.holders.length) {
            try {
                String string = this.tempHolders[n].getEntityName();
                if (!string.endsWith("_slot")) {
                    string = String.valueOf(string) + "_slot";
                }
                Slot cfr_ignored_1 = this.holders[n];
                this.on_holders[n] = new ObjectName("NetraCt:dn=" + this.name.getKeyProperty("dn") + "/" + string + "_" + this.tempHolders[n].getEntityParentRelPos() + ",name=" + string + ",id=" + EquipmentHolder.getEquipmentHolderId());
                this.server.registerMBean(this.holders[n], this.on_holders[n]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.holders[n].init();
            ++n;
        }
        if (this.holders.length > 0) {
            this.ct.createMohRelation("PlugInUnit-EquipmentHolder", this.name, this.on_holders);
        }
        n = 0;
        while (n < this.tps.length) {
            try {
                long l;
                String string = this.tempTps[n].getIfDescr();
                boolean bl = false;
                int n2 = string.length();
                while (n2 > 0) {
                    if (!Character.isDigit(string.charAt(--n2))) break;
                }
                String string2 = null;
                if (n2 > 0) {
                    l = Long.parseLong(string.substring(n2 + 1));
                    string2 = string.substring(0, n2 + 1);
                } else {
                    TerminationPoint cfr_ignored_2 = this.tps[n];
                    l = TerminationPoint.getTerminationPointId();
                    string2 = string;
                }
                this.on_tps[n] = new ObjectName("NetraCt:dn=" + this.name.getKeyProperty("dn") + "/" + string2 + "_" + l + ",name=" + string2 + ",id=" + l);
                this.server.registerMBean(this.tps[n], this.on_tps[n]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.tps[n].init();
            ++n;
        }
        if (this.tps.length > 0) {
            this.ct.createMohRelation("PlugInUnit-TerminationPoint", this.name, this.on_tps);
        }
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
        if (this.remote_deletion) {
            throw new JMRuntimeException("Remote deletion of instances of this MBean is not allowed.");
        }
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.server = mBeanServer;
        this.name = objectName;
        return objectName;
    }

    public void setAdministrativeState(AdministrativeState administrativeState) throws IllegalArgumentException {
        if (administrativeState == null) {
            throw new IllegalArgumentException("null value not allowed");
        }
        if (!this.admin_state.equals(administrativeState)) {
            AdministrativeState administrativeState2 = this.admin_state;
            this.admin_state = administrativeState;
            StateChangeNotification stateChangeNotification = new StateChangeNotification("netract.moh.state.change", this, this.name, this.getSequenceNumber(), "Administrative State value has changed", "AdministrativeState", "AdministrativeState", administrativeState2, this.admin_state);
            this.sendNotification(stateChangeNotification);
        }
    }

    public void setAlarmSeverityProfilePointer(ObjectName objectName) {
        ObjectName objectName2 = this.asp;
        ObjectName objectName3 = objectName;
        if (objectName != null) {
            boolean bl;
            try {
                bl = this.server.isInstanceOf(objectName, "com.sun.ctmgx.moh.AlarmSeverityProfile");
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("MBean " + exception.getMessage() + " not registered.");
            }
            if (!bl) {
                throw new IllegalArgumentException("The given ObjectName does not correspond to an MBean of class com.sun.ctmgx.moh.AlarmSeverityProfile");
            }
            this.asp = objectName;
        } else {
            this.asp = NetraCtDefs.OBJECT_NAME_ASP;
        }
        if (!objectName2.equals(objectName3)) {
            AttributeChangeNotification attributeChangeNotification = new AttributeChangeNotification("netract.moh.attribute.change", this, this.name, this.getSequenceNumber(), "Alarm Severity Profile Pointer has changed", "AlarmSeverityProfilePointer", "ObjectName", objectName2, objectName3);
            this.sendNotification(attributeChangeNotification);
        }
    }

    void start() {
        ObjectCreationNotification objectCreationNotification;
        int n = 0;
        this.plugin.addPropertyChangeListener((PropertyChangeListener)this.listener);
        n = 0;
        while (n < this.equips.length) {
            objectCreationNotification = new ObjectCreationNotification("netract.moh.object.creation", this.equips[n], this.on_equips[n], this.equips[n].getSequenceNumber(), "Equipment has been created", this.on_equips[n], this.name);
            this.equips[n].sendNotification(objectCreationNotification);
            this.equips[n].start();
            ++n;
        }
        n = 0;
        while (n < this.holders.length) {
            objectCreationNotification = new ObjectCreationNotification("netract.moh.object.creation", this.holders[n], this.on_holders[n], this.holders[n].getSequenceNumber(), "Equipment Holder has been created", this.on_holders[n], this.name);
            this.holders[n].sendNotification(objectCreationNotification);
            this.holders[n].start();
            ++n;
        }
        n = 0;
        while (n < this.tps.length) {
            objectCreationNotification = new ObjectCreationNotification("netract.moh.object.creation", this.tps[n], this.on_tps[n], this.tps[n].getSequenceNumber(), "Termination Point has been created", this.on_tps[n], this.name);
            this.tps[n].sendNotification(objectCreationNotification);
            this.tps[n].start();
            ++n;
        }
    }

    void stop() {
        Object var5_3;
        Serializable serializable;
        int n = 0;
        n = 0;
        while (n < this.equips.length) {
            this.equips[n].stop();
            ++n;
        }
        n = 0;
        while (n < this.holders.length) {
            this.holders[n].stop();
            ++n;
        }
        n = 0;
        while (n < this.tps.length) {
            this.tps[n].stop();
            ++n;
        }
        this.plugin.removePropertyChangeListener((PropertyChangeListener)this.listener);
        n = 0;
        while (n < this.equips.length) {
            serializable = this.equips[n];
            synchronized (serializable) {
                this.equips[n].remote_deletion = false;
                try {
                    try {
                        this.server.unregisterMBean(this.on_equips[n]);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    var5_3 = null;
                    this.equips[n].remote_deletion = true;
                }
                catch (Throwable throwable) {
                    var5_3 = null;
                    this.equips[n].remote_deletion = true;
                    throw throwable;
                }
            }
            ++n;
        }
        n = 0;
        while (n < this.holders.length) {
            serializable = this.holders[n];
            synchronized (serializable) {
                this.holders[n].remote_deletion = false;
                try {
                    try {
                        this.server.unregisterMBean(this.on_holders[n]);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    var5_3 = null;
                    this.holders[n].remote_deletion = true;
                }
                catch (Throwable throwable) {
                    var5_3 = null;
                    this.holders[n].remote_deletion = true;
                    throw throwable;
                }
            }
            ++n;
        }
        n = 0;
        while (n < this.tps.length) {
            serializable = this.tps[n];
            synchronized (serializable) {
                this.tps[n].remote_deletion = false;
                try {
                    try {
                        this.server.unregisterMBean(this.on_tps[n]);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    var5_3 = null;
                    this.tps[n].remote_deletion = true;
                }
                catch (Throwable throwable) {
                    var5_3 = null;
                    this.tps[n].remote_deletion = true;
                    throw throwable;
                }
            }
            ++n;
        }
        n = 0;
        while (n < this.equips.length) {
            serializable = new ObjectDeletionNotification("netract.moh.object.deletion", this.equips[n], this.on_equips[n], this.equips[n].getSequenceNumber(), "Equipment has been deleted", this.on_equips[n], this.name);
            this.equips[n].sendNotification((Notification)serializable);
            ++n;
        }
        n = 0;
        while (n < this.holders.length) {
            serializable = new ObjectDeletionNotification("netract.moh.object.deletion", this.holders[n], this.on_holders[n], this.holders[n].getSequenceNumber(), "Equipment Holder has been deleted", this.on_holders[n], this.name);
            this.holders[n].sendNotification((Notification)serializable);
            ++n;
        }
        n = 0;
        while (n < this.tps.length) {
            serializable = new ObjectDeletionNotification("netract.moh.object.deletion", this.tps[n], this.on_tps[n], this.tps[n].getSequenceNumber(), "Termination Point has been deleted", this.on_tps[n], this.name);
            this.tps[n].sendNotification((Notification)serializable);
            ++n;
        }
    }

    class PropChangeListener
    implements PropertyChangeListener {
        PlugInUnit pi;

        public PropChangeListener(PlugInUnit plugInUnit2) {
            this.pi = plugInUnit2;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            int n = (Integer)propertyChangeEvent.getOldValue();
            int n2 = (Integer)propertyChangeEvent.getNewValue();
            if ("operStatus".equals(string) && n != n2) {
                PlugInUnit.this.oper_state = OperationalState.getState(n2);
                StateChangeNotification stateChangeNotification = new StateChangeNotification("netract.moh.state.change", this.pi, PlugInUnit.this.name, PlugInUnit.this.getSequenceNumber(), "Operational State value has changed", "OperationalState", "OperationalState", OperationalState.getState(n), OperationalState.getState(n2));
                PlugInUnit.this.sendNotification(stateChangeNotification);
            }
        }
    }
}

