/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.moh;

import com.sun.ctmgx.common.Cpu;
import com.sun.ctmgx.common.EquipmentIf;
import com.sun.ctmgx.moh.AlarmNotification;
import com.sun.ctmgx.moh.AlarmSeverity;
import com.sun.ctmgx.moh.ContainmentTree;
import com.sun.ctmgx.moh.Equipment;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;

public class EquipmentCpu
extends Equipment {
    Cpu cpu;
    int currentTemperature;
    int warningThreshold;
    int shutdownThreshold;

    public EquipmentCpu() {
    }

    EquipmentCpu(EquipmentIf equipmentIf, ContainmentTree containmentTree) {
        super(equipmentIf, containmentTree);
        this.cpu = (Cpu)equipmentIf;
        this.listener = new PropChangeListenerCpu((Equipment)this);
        this.currentTemperature = this.cpu.getCurrentTemperature();
        this.warningThreshold = this.cpu.getWarningThreshold();
        this.shutdownThreshold = this.cpu.getShutdownThreshold();
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] mBeanNotificationInfoArray = super.getNotificationInfo();
        ArrayList<MBeanNotificationInfo> arrayList = new ArrayList<MBeanNotificationInfo>();
        int n = 0;
        while (n < mBeanNotificationInfoArray.length) {
            arrayList.add(mBeanNotificationInfoArray[n]);
            ++n;
        }
        MBeanNotificationInfo mBeanNotificationInfo = new MBeanNotificationInfo(new String[]{"netract.moh.alarm.high.temperature"}, "com.sun.ctmgx.moh.AlarmNotification", "Sent when a problem occurs and an alarm is to be sent.");
        arrayList.add(mBeanNotificationInfo);
        return arrayList.toArray(mBeanNotificationInfoArray);
    }

    class PropChangeListenerCpu
    extends Equipment.PropChangeListener {
        public PropChangeListenerCpu(Equipment equipment) {
            super(equipment);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            int n = (Integer)propertyChangeEvent.getOldValue();
            int n2 = (Integer)propertyChangeEvent.getNewValue();
            if ("currentTemperature".equals(string)) {
                EquipmentCpu.this.currentTemperature = n2;
                if (EquipmentCpu.this.currentTemperature > EquipmentCpu.this.shutdownThreshold) {
                    this.sendHighTempAlarm("Shutdown threshold exceeded");
                } else if (EquipmentCpu.this.currentTemperature > EquipmentCpu.this.warningThreshold) {
                    this.sendHighTempAlarm("Warning threshold exceeded");
                }
            } else if ("warningThreshold".equals(string)) {
                EquipmentCpu.this.warningThreshold = n2;
            } else if ("shutdownThreshold".equals(string)) {
                EquipmentCpu.this.shutdownThreshold = n2;
            }
        }

        void sendHighTempAlarm(String string) {
            Object object;
            AlarmSeverity alarmSeverity = AlarmSeverity.INDETERMINATE;
            try {
                object = new Object[]{"netract.moh.alarm.high.temperature"};
                String[] stringArray = new String[]{"java.lang.String"};
                AlarmSeverity alarmSeverity2 = (AlarmSeverity)EquipmentCpu.this.server.invoke(EquipmentCpu.this.asp, "getAlarmSeverity", (Object[])object, stringArray);
                if (alarmSeverity2 == null) {
                    alarmSeverity = AlarmSeverity.INDETERMINATE;
                }
            }
            catch (Exception exception) {
                alarmSeverity = AlarmSeverity.INDETERMINATE;
            }
            object = new AlarmNotification("netract.moh.alarm.high.temperature", this.equip, EquipmentCpu.this.name, EquipmentCpu.this.getSequenceNumber(), "High Temperature Alarm Notification", alarmSeverity, string, false, null, "no repair action defined", null);
            EquipmentCpu.this.sendNotification((Notification)object);
        }
    }
}

