/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.moh;

import com.sun.ctmgx.moh.AlarmSeverity;
import com.sun.ctmgx.moh.AlarmSeverityProfileMBean;
import com.sun.ctmgx.moh.AttributeChangeNotification;
import com.sun.ctmgx.moh.NetraCtDefs;
import java.io.Serializable;
import java.util.Map;
import javax.management.JMRuntimeException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;

public class AlarmSeverityProfile
extends NotificationBroadcasterSupport
implements AlarmSeverityProfileMBean,
MBeanRegistration,
Serializable {
    private MBeanServer server;
    private ObjectName name;
    private Map list;
    private transient long sequenceNumber = 0L;

    public AlarmSeverityProfile() {
    }

    public AlarmSeverityProfile(Map map) {
        this.list = map;
    }

    public AlarmSeverity getAlarmSeverity(String string) {
        AlarmSeverity alarmSeverity = (AlarmSeverity)this.list.get(string);
        if (alarmSeverity == null) {
            throw new IllegalArgumentException("No severity associated with the specified alarm type");
        }
        return alarmSeverity;
    }

    public Map getAlarmSeverityList() {
        return this.list;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"netract.moh.attribute.change"}, "com.sun.ctmgx.moh.AttributeChangeNotification", "Sent when an attribute changes its value.")};
        return mBeanNotificationInfoArray;
    }

    private synchronized long getSequenceNumber() {
        return this.sequenceNumber++;
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
        if (this.name.equals(NetraCtDefs.OBJECT_NAME_ASP)) {
            throw new JMRuntimeException("Remote deletion of instances of this MBean is not allowed.");
        }
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.server = mBeanServer;
        this.name = objectName;
        return objectName;
    }

    public synchronized void setAlarmSeverity(String string, AlarmSeverity alarmSeverity) throws IllegalArgumentException {
        if (string == null || alarmSeverity == null) {
            throw new IllegalArgumentException("null values are not allowed");
        }
        AlarmSeverity alarmSeverity2 = (AlarmSeverity)this.list.get(string);
        if (!alarmSeverity.equals(alarmSeverity2)) {
            this.list.put(string, alarmSeverity);
            AttributeChangeNotification attributeChangeNotification = new AttributeChangeNotification("netract.moh.attribute.change", this, this.name, this.getSequenceNumber(), "Alarm Severity List has changed", "AlarmSeverityList", "Map", this.list, this.list);
            this.sendNotification(attributeChangeNotification);
        }
    }

    public synchronized void setAlarmSeverityList(Map map) {
        this.list = map;
        AttributeChangeNotification attributeChangeNotification = new AttributeChangeNotification("netract.moh.attribute.change", this, this.name, this.getSequenceNumber(), "Alarm Severity List has changed", "AlarmSeverityList", "Map", map, map);
        this.sendNotification(attributeChangeNotification);
    }
}

