/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.snmp;

import com.sun.ctmgx.snmp.SystemMBean;
import com.sun.jdmk.snmp.agent.SnmpMib;
import com.sun.jdmk.snmp.agent.SnmpMibGroup;
import com.sun.jdmk.snmp.agent.SnmpMibNode;
import java.io.Serializable;
import javax.management.snmp.SnmpInt;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpString;
import javax.management.snmp.SnmpTimeticks;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;

public class SystemMeta
extends SnmpMibGroup
implements Serializable {
    private SystemMBean node;

    public SystemMeta(SnmpMib snmpMib) {
        try {
            this.registerVariable(7L);
            this.registerVariable(6L);
            this.registerVariable(5L);
            this.registerVariable(4L);
            this.registerVariable(3L);
            this.registerVariable(2L);
            this.registerVariable(1L);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getMessage());
        }
    }

    public void check(SnmpValue snmpValue, long[] lArray, int n) throws SnmpStatusException {
        boolean bl = true;
        int n2 = lArray.length;
        if (n >= n2) {
            throw new SnmpStatusException(6);
        }
        if (n + 2 == n2) {
            bl = lArray[n2 - 1] == 0L;
        }
        switch ((int)lArray[n]) {
            case 7: {
                if (!bl) {
                    throw new SnmpStatusException(2);
                }
                throw new SnmpStatusException(4);
            }
            case 6: {
                if (!bl) {
                    throw new SnmpStatusException(2);
                }
                if (snmpValue instanceof SnmpString) {
                    this.node.checkSysLocation(((SnmpString)snmpValue).toString());
                    break;
                }
                throw new SnmpStatusException(3);
            }
            case 5: {
                if (!bl) {
                    throw new SnmpStatusException(2);
                }
                if (snmpValue instanceof SnmpString) {
                    this.node.checkSysName(((SnmpString)snmpValue).toString());
                    break;
                }
                throw new SnmpStatusException(3);
            }
            case 4: {
                if (!bl) {
                    throw new SnmpStatusException(2);
                }
                if (snmpValue instanceof SnmpString) {
                    this.node.checkSysContact(((SnmpString)snmpValue).toString());
                    break;
                }
                throw new SnmpStatusException(3);
            }
            case 3: {
                if (!bl) {
                    throw new SnmpStatusException(2);
                }
                throw new SnmpStatusException(4);
            }
            case 2: {
                if (!bl) {
                    throw new SnmpStatusException(2);
                }
                throw new SnmpStatusException(4);
            }
            case 1: {
                if (!bl) {
                    throw new SnmpStatusException(2);
                }
                throw new SnmpStatusException(4);
            }
            default: {
                super.check(snmpValue, lArray, n);
                return;
            }
        }
    }

    public SnmpValue get(long[] lArray, int n) throws SnmpStatusException {
        boolean bl = false;
        int n2 = lArray.length;
        if (n >= n2) {
            throw new SnmpStatusException(6);
        }
        if (n + 2 == n2) {
            bl = lArray[n2 - 1] == 0L;
        }
        switch ((int)lArray[n]) {
            case 7: {
                if (!bl) break;
                return new SnmpInt(this.node.getSysServices());
            }
            case 6: {
                if (!bl) break;
                return new SnmpString(this.node.getSysLocation());
            }
            case 5: {
                if (!bl) break;
                return new SnmpString(this.node.getSysName());
            }
            case 4: {
                if (!bl) break;
                return new SnmpString(this.node.getSysContact());
            }
            case 3: {
                if (!bl) break;
                return new SnmpTimeticks(this.node.getSysUpTime());
            }
            case 2: {
                if (!bl) break;
                return new SnmpOid(this.node.getSysObjectID());
            }
            case 1: {
                if (!bl) break;
                return new SnmpString(this.node.getSysDescr());
            }
            default: {
                return super.get(lArray, n);
            }
        }
        throw new SnmpStatusException(2);
    }

    public SnmpVarBind getNext(long[] lArray, int n) throws SnmpStatusException {
        if (lArray.length <= n) {
            lArray = new long[1];
            n = 0;
            lArray[0] = -1L;
            return this.getNext(lArray, n);
        }
        int n2 = (int)lArray[n];
        Object var4_4 = null;
        try {
            switch (n2) {
                default: 
            }
            if (this.isSubArc(n2)) {
                return super.getNext(lArray, n);
            }
            long[] lArray2 = new long[]{n + 1 == lArray.length ? (long)n2 : (long)SnmpMibNode.getNextIdentifier((int[])((SnmpMibNode)this).varList, (long)lArray[n]), 0L};
            SnmpValue snmpValue = this.get(lArray2, 0);
            return new SnmpVarBind(new SnmpOid(lArray2), snmpValue);
        }
        catch (SnmpStatusException snmpStatusException) {
            long[] lArray3 = new long[]{SnmpMibNode.getNextIdentifier((int[])((SnmpMibNode)this).varList, (long)lArray[n])};
            return this.getNext(lArray3, 0);
        }
    }

    public SnmpValue set(SnmpValue snmpValue, long[] lArray, int n) throws SnmpStatusException {
        boolean bl = true;
        int n2 = lArray.length;
        if (n >= n2) {
            throw new SnmpStatusException(6);
        }
        if (n == n2 - 2) {
            bl = lArray[n2 - 1] == 0L;
        }
        switch ((int)lArray[n]) {
            case 7: {
                if (!bl) break;
                throw new SnmpStatusException(4);
            }
            case 6: {
                if (!bl) break;
                if (snmpValue instanceof SnmpString) {
                    this.node.setSysLocation(((SnmpString)snmpValue).toString());
                    return new SnmpString(this.node.getSysLocation());
                }
                throw new SnmpStatusException(3);
            }
            case 5: {
                if (!bl) break;
                if (snmpValue instanceof SnmpString) {
                    this.node.setSysName(((SnmpString)snmpValue).toString());
                    return new SnmpString(this.node.getSysName());
                }
                throw new SnmpStatusException(3);
            }
            case 4: {
                if (!bl) break;
                if (snmpValue instanceof SnmpString) {
                    this.node.setSysContact(((SnmpString)snmpValue).toString());
                    return new SnmpString(this.node.getSysContact());
                }
                throw new SnmpStatusException(3);
            }
            case 3: {
                if (!bl) break;
                throw new SnmpStatusException(4);
            }
            case 2: {
                if (!bl) break;
                throw new SnmpStatusException(4);
            }
            case 1: {
                if (!bl) break;
                throw new SnmpStatusException(4);
            }
            default: {
                return super.set(snmpValue, lArray, n);
            }
        }
        throw new SnmpStatusException(2);
    }

    protected void setInstance(SystemMBean systemMBean) {
        this.node = systemMBean;
    }
}

