/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.snmp;

import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.EquipmentIf;
import com.sun.ctmgx.common.HolderIf;
import com.sun.ctmgx.common.IDGenerator;
import com.sun.ctmgx.common.SystemView;
import com.sun.ctmgx.snmp.DateAndTime;
import com.sun.ctmgx.snmp.EntPhysicalEntryImpl;
import com.sun.ctmgx.snmp.EnumEntPhysicalClass;
import com.sun.ctmgx.snmp.EnumNetraCtEquipAdminStatus;
import com.sun.ctmgx.snmp.EnumNetraCtEquipOperStatus;
import com.sun.ctmgx.snmp.HwUnitDownTrap;
import com.sun.ctmgx.snmp.HwUnitUpTrap;
import com.sun.ctmgx.snmp.NetraCtEquipEntry;
import com.sun.ctmgx.snmp.NetraCtEquipEntryMBean;
import com.sun.ctmgx.snmp.NetraCtEquipHolderEntryImpl;
import com.sun.ctmgx.snmp.NetraCtMIBObjectsImpl;
import com.sun.ctmgx.snmp.ObjCreationTrap;
import com.sun.ctmgx.snmp.ObjDeletionTrap;
import com.sun.ctmgx.snmp.SUN_SNMP_NETRA_CT_MIBOidTable;
import com.sun.jdmk.snmp.agent.SnmpIndex;
import com.sun.jdmk.snmp.agent.SnmpMib;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.management.snmp.SnmpInt;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpOidRecord;
import javax.management.snmp.SnmpStatusException;

public class NetraCtEquipEntryImpl
extends NetraCtEquipEntry
implements PropertyChangeListener,
Serializable {
    Debug debug = new Debug();
    EquipmentIf equip = null;
    NetraCtMIBObjectsImpl group = null;
    SnmpMib mib = null;
    NetraCtEquipHolderEntryImpl[] holders = null;
    NetraCtEquipEntryImpl[] equips = null;
    EntPhysicalEntryImpl entity = null;
    SUN_SNMP_NETRA_CT_MIBOidTable oidTable;

    public NetraCtEquipEntryImpl(SnmpMib snmpMib, NetraCtMIBObjectsImpl netraCtMIBObjectsImpl, EquipmentIf equipmentIf, int n) {
        super(snmpMib);
        Integer n2;
        this.mib = snmpMib;
        this.group = netraCtMIBObjectsImpl;
        this.equip = equipmentIf;
        int n3 = 0;
        this.oidTable = new SUN_SNMP_NETRA_CT_MIBOidTable();
        this.NetraCtEquipAdminStatus = new EnumNetraCtEquipAdminStatus("up");
        this.NetraCtEquipLocation = new String("Netra ct chassis");
        this.NetraCtEquipVendor = "";
        this.NetraCtEquipVersion = new String("0.0");
        this.NetraCtEquipUserLabel = "";
        this.NetraCtEquipOperStatus = new EnumNetraCtEquipOperStatus(equipmentIf.getOperStatus());
        this.NetraCtEquipAlarmSeverityIndex = new Integer(0);
        String string = equipmentIf.getEntityName();
        Integer n4 = new Integer(equipmentIf.getEntityParentRelPos());
        EnumEntPhysicalClass enumEntPhysicalClass = new EnumEntPhysicalClass(equipmentIf.getEntityClass());
        String string2 = equipmentIf.getEntityDescr();
        Integer n5 = new Integer(n);
        String string3 = new String("0.0");
        this.EntPhysicalIndex = n2 = new Integer(IDGenerator.getNewEntIndex());
        this.entity = this.group.createEntityEntry(string, n4, enumEntPhysicalClass, string2, n5, n2);
        this.debug.write((Object)this, 6, String.valueOf(string2) + "'s operStatus = " + this.NetraCtEquipOperStatus);
        HolderIf[] holderIfArray = equipmentIf.getHolders();
        EquipmentIf[] equipmentIfArray = equipmentIf.getEquipments();
        this.equips = equipmentIfArray != null ? new NetraCtEquipEntryImpl[equipmentIfArray.length] : new NetraCtEquipEntryImpl[0];
        this.holders = holderIfArray != null ? new NetraCtEquipHolderEntryImpl[holderIfArray.length] : new NetraCtEquipHolderEntryImpl[0];
        if (this.equips != null) {
            n3 = 0;
            while (n3 < this.equips.length) {
                this.equips[n3] = new NetraCtEquipEntryImpl(snmpMib, netraCtMIBObjectsImpl, equipmentIfArray[n3], this.EntPhysicalIndex);
                ++n3;
            }
        }
        if (this.holders != null) {
            n3 = 0;
            while (n3 < this.holders.length) {
                this.holders[n3] = new NetraCtEquipHolderEntryImpl(snmpMib, netraCtMIBObjectsImpl, holderIfArray[n3], this.EntPhysicalIndex);
                ++n3;
            }
        }
    }

    protected SnmpOid buildOidFromIndex(SnmpIndex snmpIndex) throws SnmpStatusException {
        SnmpOid snmpOid = new SnmpOid();
        if (snmpIndex.getNbComponents() != 1) {
            throw new SnmpStatusException(2);
        }
        try {
            Vector vector = snmpIndex.getComponents();
            SnmpInt.appendToOid((SnmpOid)((SnmpOid)vector.elementAt(0)), (SnmpOid)snmpOid);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
        return snmpOid;
    }

    public SnmpIndex buildSnmpIndex(NetraCtEquipEntryMBean netraCtEquipEntryMBean) throws SnmpStatusException {
        SnmpOid[] snmpOidArray = new SnmpOid[1];
        SnmpInt snmpInt = null;
        snmpInt = new SnmpInt(netraCtEquipEntryMBean.getEntPhysicalIndex());
        snmpOidArray[0] = snmpInt.toOid();
        return new SnmpIndex(snmpOidArray);
    }

    void fini() {
        int n = 0;
        Integer n2 = new Integer(0);
        n = 0;
        while (n < this.equips.length) {
            try {
                n2 = this.equips[n].getNetraCtEquipAlarmSeverityIndex();
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpStatusException.printStackTrace();
            }
            this.equips[n].fini();
            this.sendDeleteTrap(this.equips[n].getEntity(), n2);
            ++n;
        }
        n = 0;
        while (n < this.holders.length) {
            this.holders[n].fini();
            this.sendDeleteTrap(this.holders[n].getEntity(), n2);
            ++n;
        }
    }

    EntPhysicalEntryImpl getEntity() {
        return this.entity;
    }

    SnmpOid getTrapObject() {
        String string = "0.0";
        try {
            SnmpOidRecord snmpOidRecord = this.oidTable.resolveVarName("netraCtEquipAdminStatus");
            String string2 = snmpOidRecord.getOid();
            SnmpIndex snmpIndex = this.buildSnmpIndex(this);
            SnmpOid snmpOid = this.buildOidFromIndex(snmpIndex);
            string = String.valueOf(string2) + snmpOid.toString();
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
        }
        return new SnmpOid(string);
    }

    void init() {
        int n = 0;
        n = 0;
        while (n < this.equips.length) {
            this.group.addEntityEntry(this.equips[n].getEntity());
            this.group.addEquipTableEntry(this.equips[n]);
            this.equips[n].init();
            ++n;
        }
        n = 0;
        while (n < this.holders.length) {
            this.group.addEntityEntry(this.holders[n].getEntity());
            this.group.addEquipHolderTableEntry(this.holders[n]);
            this.holders[n].init();
            ++n;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        int n = (Integer)propertyChangeEvent.getOldValue();
        int n2 = (Integer)propertyChangeEvent.getNewValue();
        EnumNetraCtEquipOperStatus enumNetraCtEquipOperStatus = new EnumNetraCtEquipOperStatus("up");
        EnumNetraCtEquipOperStatus enumNetraCtEquipOperStatus2 = new EnumNetraCtEquipOperStatus("down");
        if ("operStatus".equals(string) && n != n2) {
            this.debug.write((Object)this, 6, "property=operStatus");
            Vector vector = new Vector();
            try {
                vector = this.group.getVBList(this.entity);
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpStatusException.printStackTrace();
            }
            Byte[] byteArray = DateAndTime.getTimeInBytes();
            SnmpOid snmpOid = this.getTrapObject();
            if (n2 == enumNetraCtEquipOperStatus.intValue()) {
                this.NetraCtEquipOperStatus = enumNetraCtEquipOperStatus;
                HwUnitUpTrap hwUnitUpTrap = new HwUnitUpTrap(SystemView.getSysIpAddress(), byteArray, snmpOid, vector, this.NetraCtEquipAlarmSeverityIndex);
                this.debug.write((Object)this, 6, "sending HeUnitUp trap");
                this.group.sendThisV2Trap(hwUnitUpTrap);
            } else {
                this.NetraCtEquipOperStatus = enumNetraCtEquipOperStatus2;
                HwUnitDownTrap hwUnitDownTrap = new HwUnitDownTrap(SystemView.getSysIpAddress(), byteArray, snmpOid, vector, this.NetraCtEquipAlarmSeverityIndex);
                this.debug.write((Object)this, 6, "sending HwUnitDown trap");
                this.group.sendThisV2Trap(hwUnitDownTrap);
            }
        }
    }

    public void sendCreateTrap(EntPhysicalEntryImpl entPhysicalEntryImpl, Integer n) {
        Vector vector = new Vector();
        this.debug.write((Object)this, 6, "sending objCreation trap");
        try {
            vector = this.group.getVBList(entPhysicalEntryImpl);
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
        }
        Byte[] byteArray = DateAndTime.getTimeInBytes();
        SnmpOid snmpOid = this.getTrapObject();
        ObjCreationTrap objCreationTrap = new ObjCreationTrap(SystemView.getSysIpAddress(), byteArray, snmpOid, vector, n);
        this.group.sendThisV2Trap(objCreationTrap);
    }

    public void sendDeleteTrap(EntPhysicalEntryImpl entPhysicalEntryImpl, Integer n) {
        Vector vector = new Vector();
        this.debug.write((Object)this, 6, "sending objCreation trap");
        try {
            vector = this.group.getVBList(entPhysicalEntryImpl);
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
        }
        Byte[] byteArray = DateAndTime.getTimeInBytes();
        SnmpOid snmpOid = this.getTrapObject();
        ObjDeletionTrap objDeletionTrap = new ObjDeletionTrap(SystemView.getSysIpAddress(), byteArray, snmpOid, vector, n);
        this.group.sendThisV2Trap(objDeletionTrap);
    }

    void start() {
        int n = 0;
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        this.equip.addPropertyChangeListener((PropertyChangeListener)this);
        n = 0;
        while (n < this.equips.length) {
            try {
                n2 = this.equips[n].getNetraCtEquipAlarmSeverityIndex();
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpStatusException.printStackTrace();
            }
            this.sendCreateTrap(this.equips[n].getEntity(), n2);
            this.equips[n].start();
            ++n;
        }
        n = 0;
        while (n < this.holders.length) {
            this.sendCreateTrap(this.holders[n].getEntity(), n3);
            this.holders[n].start();
            ++n;
        }
    }

    void startListener() {
        int n = 0;
        this.equip.addPropertyChangeListener((PropertyChangeListener)this);
        n = 0;
        while (n < this.equips.length) {
            this.equips[n].startListener();
            ++n;
        }
        n = 0;
        while (n < this.holders.length) {
            this.holders[n].startListener();
            ++n;
        }
    }

    void stop() {
        int n = 0;
        n = 0;
        while (n < this.equips.length) {
            this.equips[n].stop();
            ++n;
        }
        n = 0;
        while (n < this.holders.length) {
            this.holders[n].stop();
            ++n;
        }
        this.equip.removePropertyChangeListener((PropertyChangeListener)this);
        n = 0;
        while (n < this.equips.length) {
            this.group.deleteEntityEntry(this.equips[n].getEntity());
            this.group.deleteEquipTableEntry(this.equips[n]);
            ++n;
        }
        n = 0;
        while (n < this.holders.length) {
            this.group.deleteEntityEntry(this.holders[n].getEntity());
            this.group.deleteEquipHolderTableEntry(this.holders[n]);
            ++n;
        }
    }
}

