/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.snmp;

import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.IDGenerator;
import com.sun.ctmgx.snmp.AlarmInfo;
import com.sun.ctmgx.snmp.EnumNetraCtTrapLogAdminStatus;
import com.sun.ctmgx.snmp.EnumNetraCtTrapLogFullAction;
import com.sun.ctmgx.snmp.EnumNetraCtTrapLogType;
import com.sun.ctmgx.snmp.NetraCtLoggedAlarmEntryImpl;
import com.sun.ctmgx.snmp.NetraCtLoggedTrapEntryImpl;
import com.sun.ctmgx.snmp.NetraCtLoggedTrapEntryMBean;
import com.sun.ctmgx.snmp.NetraCtTrapLogEntryImpl;
import com.sun.ctmgx.snmp.TableNetraCtLoggedAlarmTable;
import com.sun.ctmgx.snmp.TableNetraCtLoggedTrapTable;
import com.sun.ctmgx.snmp.TableNetraCtTrapLogTable;
import com.sun.ctmgx.snmp.TrapInfo;
import com.sun.jdmk.Enumerated;
import com.sun.jdmk.snmp.agent.SnmpMib;
import com.sun.jdmk.snmp.agent.SnmpTableEntryNotification;
import java.util.Hashtable;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.snmp.SnmpStatusException;

public class LogManager {
    static final int LOGGED_TRAP_TABLE_SIZE = 5000;
    int loggedTrapTableSize;
    TableNetraCtTrapLogTable trapLogTable;
    TableNetraCtLoggedTrapTable loggedTrapTable;
    TableNetraCtLoggedAlarmTable loggedAlarmTable;
    Hashtable trapAlarmMap = new Hashtable();
    Hashtable trapInfoMap = new Hashtable();
    SnmpMib mib;
    LogTableListener logTableListener;
    private Debug debug = new Debug();
    private EnumNetraCtTrapLogType alarmType;
    private EnumNetraCtTrapLogFullAction haltAction;
    private EnumNetraCtTrapLogFullAction wrapAction;

    public LogManager(SnmpMib snmpMib, TableNetraCtTrapLogTable tableNetraCtTrapLogTable, TableNetraCtLoggedTrapTable tableNetraCtLoggedTrapTable, TableNetraCtLoggedAlarmTable tableNetraCtLoggedAlarmTable) {
        this(snmpMib, tableNetraCtTrapLogTable, tableNetraCtLoggedTrapTable, tableNetraCtLoggedAlarmTable, 5000);
    }

    public LogManager(SnmpMib snmpMib, TableNetraCtTrapLogTable tableNetraCtTrapLogTable, TableNetraCtLoggedTrapTable tableNetraCtLoggedTrapTable, TableNetraCtLoggedAlarmTable tableNetraCtLoggedAlarmTable, int n) {
        this.mib = snmpMib;
        this.trapLogTable = tableNetraCtTrapLogTable;
        this.loggedTrapTable = tableNetraCtLoggedTrapTable;
        this.loggedAlarmTable = tableNetraCtLoggedAlarmTable;
        this.loggedTrapTableSize = n;
        this.logTableListener = new LogTableListener();
        tableNetraCtLoggedTrapTable.addNotificationListener(this.logTableListener, null, null);
        this.alarmType = new EnumNetraCtTrapLogType("alarm");
        this.haltAction = new EnumNetraCtTrapLogFullAction("halt");
        this.wrapAction = new EnumNetraCtTrapLogFullAction("wrap");
    }

    int compareDates(Byte[] byteArray, Byte[] byteArray2) {
        int n = byteArray.length;
        if (byteArray2.length < n) {
            n = byteArray2.length;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byteArray[n2].intValue() < byteArray2[n2].intValue()) {
                return -1;
            }
            if (byteArray[n2].intValue() > byteArray2[n2].intValue()) {
                return 1;
            }
            ++n2;
        }
        return 0;
    }

    NetraCtLoggedTrapEntryImpl getOldestLogEntry() {
        int n = 0;
        NetraCtLoggedTrapEntryMBean[] netraCtLoggedTrapEntryMBeanArray = this.loggedTrapTable.getEntries();
        this.debug.write((Object)this, 7, "Got basic entries");
        if (netraCtLoggedTrapEntryMBeanArray.length <= 0) {
            this.debug.write((Object)this, 7, "No entries in loggedTrapTable");
            return null;
        }
        NetraCtLoggedTrapEntryMBean netraCtLoggedTrapEntryMBean = netraCtLoggedTrapEntryMBeanArray[0];
        try {
            Byte[] byteArray = netraCtLoggedTrapEntryMBean.getNetraCtLoggedTrapTime();
            n = 1;
            while (n < netraCtLoggedTrapEntryMBeanArray.length) {
                NetraCtLoggedTrapEntryMBean netraCtLoggedTrapEntryMBean2 = netraCtLoggedTrapEntryMBeanArray[n];
                Byte[] byteArray2 = netraCtLoggedTrapEntryMBean2.getNetraCtLoggedTrapTime();
                if (this.compareDates(byteArray, byteArray2) > 0) {
                    netraCtLoggedTrapEntryMBean = netraCtLoggedTrapEntryMBean2;
                    byteArray = byteArray2;
                }
                ++n;
            }
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
        }
        return (NetraCtLoggedTrapEntryImpl)netraCtLoggedTrapEntryMBean;
    }

    void logThisTrap(NetraCtTrapLogEntryImpl netraCtTrapLogEntryImpl, TrapInfo trapInfo) {
        block11: {
            Enumerated enumerated;
            EnumNetraCtTrapLogAdminStatus enumNetraCtTrapLogAdminStatus = new EnumNetraCtTrapLogAdminStatus("down");
            try {
                enumerated = netraCtTrapLogEntryImpl.getNetraCtTrapLogAdminStatus();
                if (enumerated.equals(enumNetraCtTrapLogAdminStatus)) {
                    return;
                }
            }
            catch (SnmpStatusException snmpStatusException) {}
            enumerated = null;
            NetraCtLoggedTrapEntryImpl netraCtLoggedTrapEntryImpl = null;
            enumerated = new EnumNetraCtTrapLogFullAction("wrap");
            this.debug.write((Object)this, 7, "tableSize = " + this.loggedTrapTable.getSize());
            if (this.loggedTrapTable.getSize() >= this.loggedTrapTableSize) {
                try {
                    enumerated = netraCtTrapLogEntryImpl.getNetraCtTrapLogFullAction();
                }
                catch (SnmpStatusException snmpStatusException) {
                    snmpStatusException.printStackTrace();
                }
                if (this.haltAction.equals(enumerated)) {
                    this.debug.write((Object)this, 7, "halt set, returning");
                    return;
                }
                this.debug.write((Object)this, 7, "wrap set, wrapping");
                netraCtLoggedTrapEntryImpl = this.getOldestLogEntry();
                this.loggedTrapTable.removeEntry(netraCtLoggedTrapEntryImpl);
            }
            int n = IDGenerator.getNewTrapIndex();
            NetraCtLoggedTrapEntryImpl netraCtLoggedTrapEntryImpl2 = new NetraCtLoggedTrapEntryImpl(this.mib, this.loggedTrapTable, trapInfo.getTrapObject().toString(), trapInfo.getTrapId(), trapInfo.getTrapTime(), n, trapInfo.getLogSource(), trapInfo.getLogType());
            netraCtTrapLogEntryImpl.addListener(netraCtLoggedTrapEntryImpl2);
            try {
                this.loggedTrapTable.addEntry(netraCtLoggedTrapEntryImpl2);
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpStatusException.printStackTrace();
            }
            if (!this.alarmType.equals(trapInfo.getLogType())) break block11;
            AlarmInfo alarmInfo = (AlarmInfo)trapInfo;
            NetraCtLoggedAlarmEntryImpl netraCtLoggedAlarmEntryImpl = new NetraCtLoggedAlarmEntryImpl(this.mib, alarmInfo.getLogSource(), alarmInfo.getLogType(), new Long(n), alarmInfo.getLoggedAlarmSeverity(), alarmInfo.getLoggedAlarmBackedUp(), alarmInfo.getLoggedAlarmBUObject(), alarmInfo.getLoggedAlarmSpecificProb(), alarmInfo.getLoggedAlarmRepairAct());
            try {
                this.loggedAlarmTable.addEntry(netraCtLoggedAlarmEntryImpl);
                this.trapAlarmMap.put(netraCtLoggedTrapEntryImpl2, netraCtLoggedAlarmEntryImpl);
                this.trapInfoMap.put(netraCtLoggedTrapEntryImpl2, trapInfo);
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpStatusException.printStackTrace();
            }
        }
    }

    class LogTableListener
    implements NotificationListener {
        LogTableListener() {
        }

        public void handleNotification(Notification notification, Object object) {
            block3: {
                LogManager.this.debug.write((Object)this, 7, "In handleNotification");
                SnmpTableEntryNotification snmpTableEntryNotification = (SnmpTableEntryNotification)notification;
                String string = snmpTableEntryNotification.getType();
                NetraCtLoggedTrapEntryImpl netraCtLoggedTrapEntryImpl = (NetraCtLoggedTrapEntryImpl)snmpTableEntryNotification.getEntry();
                if (!string.equals(SnmpTableEntryNotification.SNMP_ENTRY_REMOVED)) break block3;
                try {
                    if (LogManager.this.alarmType.equals(netraCtLoggedTrapEntryImpl.getNetraCtTrapLogType())) {
                        LogManager.this.debug.write((Object)this, 7, "trap type: alarm, removing entry from alarmTable");
                        LogManager.this.loggedAlarmTable.removeEntry((NetraCtLoggedAlarmEntryImpl)LogManager.this.trapAlarmMap.get(netraCtLoggedTrapEntryImpl));
                        LogManager.this.trapAlarmMap.remove(netraCtLoggedTrapEntryImpl);
                        LogManager.this.debug.write((Object)this, 7, "done removing entry from alarmTable");
                    }
                }
                catch (SnmpStatusException snmpStatusException) {
                    snmpStatusException.printStackTrace();
                }
            }
        }
    }
}

