/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.snmp;

import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.snmp.EnumIfAdminStatus;
import com.sun.ctmgx.snmp.EnumIfOperStatus;
import com.sun.ctmgx.snmp.FilterEntryNotFoundException;
import com.sun.ctmgx.snmp.IfEntryImpl;
import com.sun.ctmgx.snmp.Interfaces;
import com.sun.ctmgx.snmp.LogFilter;
import com.sun.ctmgx.snmp.LogManager;
import com.sun.ctmgx.snmp.NetraCtTrapLogEntryImpl;
import com.sun.ctmgx.snmp.TrapInfo;
import com.sun.ctmgx.snmp.TrapManager;
import com.sun.jdmk.Enumerated;
import com.sun.jdmk.snmp.agent.SnmpMib;
import java.io.Serializable;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.snmp.SnmpInt;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;

public class InterfacesImpl
extends Interfaces
implements Serializable {
    SnmpMib mib;
    TrapManager trapManager = null;
    LogManager logManager = null;
    LogFilter logFilter = null;
    private Debug debug = new Debug();

    public InterfacesImpl(SnmpMib snmpMib) {
        super(snmpMib);
        this.mib = snmpMib;
        this.IfNumber = new Integer(0);
    }

    public InterfacesImpl(SnmpMib snmpMib, MBeanServer mBeanServer) {
        super(snmpMib, mBeanServer);
        this.mib = snmpMib;
        this.IfNumber = new Integer(0);
    }

    void addIfEntry(IfEntryImpl ifEntryImpl) {
        this.debug.write((Object)this, 7, "\tadding ifEntry");
        try {
            this.IfTable.addEntry(ifEntryImpl);
            this.IfNumber = new Integer(this.IfNumber + 1);
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
        }
    }

    public SnmpMib getMib() {
        return this.mib;
    }

    Vector getVBList(IfEntryImpl ifEntryImpl) throws SnmpStatusException {
        return this.getVBList(ifEntryImpl.getIfIndex(), ifEntryImpl.getIfAdminStatus(), ifEntryImpl.getIfOperStatus());
    }

    Vector getVBList(Integer n, EnumIfAdminStatus enumIfAdminStatus, EnumIfOperStatus enumIfOperStatus) throws SnmpStatusException {
        SnmpInt snmpInt = new SnmpInt(n);
        SnmpInt snmpInt2 = new SnmpInt((Enumerated)enumIfAdminStatus);
        SnmpInt snmpInt3 = new SnmpInt((Enumerated)enumIfOperStatus);
        SnmpOid snmpOid = new SnmpOid("1.3.6.1.2.1.2.2.1.1");
        SnmpOid snmpOid2 = new SnmpOid("1.3.6.1.2.1.2.2.1.7");
        SnmpOid snmpOid3 = new SnmpOid("1.3.6.1.2.1.2.2.1.8");
        snmpOid2.append((long)snmpInt.intValue());
        snmpOid3.append((long)snmpInt.intValue());
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[]{new SnmpVarBind(snmpOid, (SnmpValue)snmpInt), new SnmpVarBind(snmpOid2, (SnmpValue)snmpInt2), new SnmpVarBind(snmpOid3, (SnmpValue)snmpInt3)};
        Vector<SnmpVarBind> vector = new Vector<SnmpVarBind>();
        vector.add(snmpVarBindArray[0]);
        vector.add(snmpVarBindArray[1]);
        vector.add(snmpVarBindArray[2]);
        return vector;
    }

    void removeIfEntry(IfEntryImpl ifEntryImpl) {
        this.debug.write((Object)this, 7, "\tremoving ifEntry");
        this.IfTable.removeEntry(ifEntryImpl);
        this.IfNumber = new Integer(this.IfNumber - 1);
    }

    void sendThisV2Trap(TrapInfo trapInfo) {
        this.trapManager.sendThisV2Trap(trapInfo);
        try {
            NetraCtTrapLogEntryImpl netraCtTrapLogEntryImpl = this.logFilter.getFilterEntry(trapInfo);
            this.logManager.logThisTrap(netraCtTrapLogEntryImpl, trapInfo);
        }
        catch (FilterEntryNotFoundException filterEntryNotFoundException) {
            this.debug.write((Object)this, 7, "Filter not set for this trap");
        }
    }

    void setLogFilter(LogFilter logFilter) {
        this.logFilter = logFilter;
    }

    void setLogManager(LogManager logManager) {
        this.logManager = logManager;
    }

    void setTrapManager(TrapManager trapManager) {
        this.trapManager = trapManager;
    }
}

