/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.snmp;

import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.ProcessInfo;
import com.sun.ctmgx.common.ProcessInfoList;
import com.sun.ctmgx.common.ProcessInfoListEvent;
import com.sun.ctmgx.common.ProcessInfoListListener;
import com.sun.ctmgx.common.SystemView;
import com.sun.ctmgx.snmp.DateAndTime;
import com.sun.ctmgx.snmp.EnumHrSWRunStatus;
import com.sun.ctmgx.snmp.EnumHrSWRunType;
import com.sun.ctmgx.snmp.FilterEntryNotFoundException;
import com.sun.ctmgx.snmp.HOST_RESOURCES_MIBOidTable;
import com.sun.ctmgx.snmp.HrSWRun;
import com.sun.ctmgx.snmp.HrSWRunEntry;
import com.sun.ctmgx.snmp.LogFilter;
import com.sun.ctmgx.snmp.LogManager;
import com.sun.ctmgx.snmp.NetraCtHwRunningSwEntryImpl;
import com.sun.ctmgx.snmp.NetraCtTrapLogEntryImpl;
import com.sun.ctmgx.snmp.RunningSwCreatedTrap;
import com.sun.ctmgx.snmp.RunningSwDeletedTrap;
import com.sun.ctmgx.snmp.SUN_SNMP_NETRA_CT_MIBOidTable;
import com.sun.ctmgx.snmp.TableEntPhysicalTable;
import com.sun.ctmgx.snmp.TableNetraCtHwRunningSwTable;
import com.sun.ctmgx.snmp.TrapInfo;
import com.sun.ctmgx.snmp.TrapManager;
import com.sun.jdmk.snmp.SnmpOidTableSupport;
import com.sun.jdmk.snmp.agent.SnmpMib;
import java.util.HashMap;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.snmp.SnmpInt;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpString;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;

public class HrSWRunImpl
extends HrSWRun
implements ProcessInfoListListener {
    ProcessInfoList processInfoList;
    TableNetraCtHwRunningSwTable netraCtHwRunningSwTable;
    TableEntPhysicalTable entPhysicalTable;
    SnmpMib mib;
    HashMap map;
    TrapManager trapManager;
    LogManager logManager = null;
    LogFilter logFilter = null;
    private Debug debug = new Debug();
    private static SnmpOid HrSwRunIndexOid;
    private static SnmpOid HrSwRunNameOid;
    private static SnmpOid NetraCtHwRunningSwSwIndexOid;
    private static SnmpOid NetraCtTrapAlarmSpecificProbOid;
    private static final String ENTRY_NAME_PREFIX = "TableHrSWRunTable:name=com.sun.ctmgx.snmp.HrSWRunEntry,HrSWRunIndex=";

    public HrSWRunImpl(SnmpMib snmpMib, ProcessInfoList processInfoList, TableNetraCtHwRunningSwTable tableNetraCtHwRunningSwTable, TableEntPhysicalTable tableEntPhysicalTable) {
        this(snmpMib, null, processInfoList, tableNetraCtHwRunningSwTable, tableEntPhysicalTable);
    }

    public HrSWRunImpl(SnmpMib snmpMib, MBeanServer mBeanServer, ProcessInfoList processInfoList, TableNetraCtHwRunningSwTable tableNetraCtHwRunningSwTable, TableEntPhysicalTable tableEntPhysicalTable) {
        super(snmpMib, mBeanServer);
        this.processInfoList = processInfoList;
        this.netraCtHwRunningSwTable = tableNetraCtHwRunningSwTable;
        this.entPhysicalTable = tableEntPhysicalTable;
        this.mib = snmpMib;
        this.initOids();
        this.init();
        this.HrSWOSIndex = new Integer(0);
    }

    protected EntryPair addEntry(ProcessInfo processInfo) {
        HrSWRunEntry hrSWRunEntry = this.createEntry(processInfo);
        NetraCtHwRunningSwEntryImpl netraCtHwRunningSwEntryImpl = this.createNetraCtHwRunningSwEntry(hrSWRunEntry);
        EntryPair entryPair = new EntryPair(hrSWRunEntry, netraCtHwRunningSwEntryImpl);
        this.map.put(processInfo, entryPair);
        try {
            this.HrSWRunTable.addEntry(hrSWRunEntry);
            this.netraCtHwRunningSwTable.addEntry(netraCtHwRunningSwEntryImpl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return entryPair;
    }

    protected HrSWRunEntry createEntry(ProcessInfo processInfo) {
        HrSWRunEntry hrSWRunEntry = new HrSWRunEntry(this.mib);
        hrSWRunEntry.HrSWRunIndex = new Integer(processInfo.getPid());
        hrSWRunEntry.HrSWRunStatus = new EnumHrSWRunStatus(1);
        hrSWRunEntry.HrSWRunPath = this.getByteArray(processInfo.getPath());
        hrSWRunEntry.HrSWRunName = this.getByteArray(processInfo.getName());
        hrSWRunEntry.HrSWRunParameters = this.getByteArray(processInfo.getParameters());
        hrSWRunEntry.HrSWRunID = "0.0";
        hrSWRunEntry.HrSWRunType = new EnumHrSWRunType(4);
        return hrSWRunEntry;
    }

    protected NetraCtHwRunningSwEntryImpl createNetraCtHwRunningSwEntry(HrSWRunEntry hrSWRunEntry) {
        NetraCtHwRunningSwEntryImpl netraCtHwRunningSwEntryImpl = new NetraCtHwRunningSwEntryImpl(this.mib);
        netraCtHwRunningSwEntryImpl.NetraCtHwRunningSwSwIndex = hrSWRunEntry.HrSWRunIndex;
        netraCtHwRunningSwEntryImpl.NetraCtHwRunningSwIndex = hrSWRunEntry.HrSWRunIndex;
        netraCtHwRunningSwEntryImpl.NetraCtHwRunningSwHwIndex = new Integer(1);
        return netraCtHwRunningSwEntryImpl;
    }

    private Vector createVarBind(HrSWRunEntry hrSWRunEntry, NetraCtHwRunningSwEntryImpl netraCtHwRunningSwEntryImpl, ProcessInfoListEvent processInfoListEvent) {
        Vector<SnmpVarBind> vector = new Vector<SnmpVarBind>(4);
        try {
            vector.add(new SnmpVarBind(NetraCtHwRunningSwSwIndexOid, (SnmpValue)new SnmpInt(netraCtHwRunningSwEntryImpl.getNetraCtHwRunningSwSwIndex())));
            vector.add(new SnmpVarBind(HrSwRunIndexOid, (SnmpValue)new SnmpInt(hrSWRunEntry.getHrSWRunIndex())));
            vector.add(new SnmpVarBind(HrSwRunNameOid, (SnmpValue)new SnmpString(hrSWRunEntry.getHrSWRunName())));
            vector.add(new SnmpVarBind(NetraCtTrapAlarmSpecificProbOid, (SnmpValue)new SnmpString(processInfoListEvent.getMessage())));
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
        }
        return vector;
    }

    protected Byte[] getByteArray(String string) {
        byte[] byArray = string.getBytes();
        Byte[] byteArray = new Byte[byArray.length];
        int n = 0;
        while (n < byteArray.length) {
            byteArray[n] = new Byte(byArray[n]);
            ++n;
        }
        return byteArray;
    }

    protected void init() {
        this.map = new HashMap();
        this.processInfoList.addProcessInfoListListener((ProcessInfoListListener)this);
        ProcessInfo[] processInfoArray = this.processInfoList.toArray();
        int n = 0;
        while (n < processInfoArray.length) {
            this.addEntry(processInfoArray[n]);
            ++n;
        }
    }

    private void initOids() {
        SnmpOidTableSupport snmpOidTableSupport = new HOST_RESOURCES_MIBOidTable();
        try {
            HrSwRunIndexOid = new SnmpOid(snmpOidTableSupport.resolveVarName("hrSWRunIndex").getOid());
            HrSwRunNameOid = new SnmpOid(snmpOidTableSupport.resolveVarName("hrSWRunName").getOid());
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
        }
        snmpOidTableSupport = new SUN_SNMP_NETRA_CT_MIBOidTable();
        try {
            NetraCtHwRunningSwSwIndexOid = new SnmpOid(snmpOidTableSupport.resolveVarName("netraCtHwRunningSwSwIndex").getOid());
            NetraCtTrapAlarmSpecificProbOid = new SnmpOid(snmpOidTableSupport.resolveVarName("netraCtTrapAlarmSpecificProb").getOid());
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
        }
    }

    public void processInfoAdded(ProcessInfoListEvent processInfoListEvent) {
        ProcessInfo processInfo = processInfoListEvent.getProcessInfo();
        EntryPair entryPair = this.addEntry(processInfo);
        HrSWRunEntry hrSWRunEntry = entryPair.hrSWRunEntry;
        NetraCtHwRunningSwEntryImpl netraCtHwRunningSwEntryImpl = entryPair.netraCtHwRunningSwEntry;
        Vector<SnmpVarBind> vector = new Vector<SnmpVarBind>(4);
        try {
            vector.add(new SnmpVarBind(NetraCtHwRunningSwSwIndexOid, (SnmpValue)new SnmpInt(netraCtHwRunningSwEntryImpl.getNetraCtHwRunningSwSwIndex())));
            vector.add(new SnmpVarBind(HrSwRunIndexOid, (SnmpValue)new SnmpInt(hrSWRunEntry.getHrSWRunIndex())));
            vector.add(new SnmpVarBind(HrSwRunNameOid, (SnmpValue)new SnmpString(hrSWRunEntry.getHrSWRunName())));
            vector.add(new SnmpVarBind(NetraCtTrapAlarmSpecificProbOid, (SnmpValue)new SnmpString(processInfoListEvent.getMessage())));
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpStatusException.printStackTrace();
        }
        Byte[] byteArray = DateAndTime.getTimeInBytes();
        SnmpOid snmpOid = netraCtHwRunningSwEntryImpl.getTrapObject();
        RunningSwCreatedTrap runningSwCreatedTrap = new RunningSwCreatedTrap(SystemView.getSysIpAddress(), byteArray, snmpOid, vector, new Integer(0));
        this.sendTrap(runningSwCreatedTrap);
    }

    public void processInfoRemoved(ProcessInfoListEvent processInfoListEvent) {
        ProcessInfo processInfo = processInfoListEvent.getProcessInfo();
        EntryPair entryPair = this.removeEntry(processInfo);
        Vector vector = this.createVarBind(entryPair.hrSWRunEntry, entryPair.netraCtHwRunningSwEntry, processInfoListEvent);
        Byte[] byteArray = DateAndTime.getTimeInBytes();
        SnmpOid snmpOid = entryPair.netraCtHwRunningSwEntry.getTrapObject();
        RunningSwDeletedTrap runningSwDeletedTrap = new RunningSwDeletedTrap(SystemView.getSysIpAddress(), byteArray, snmpOid, vector, new Integer(0));
        this.sendTrap(runningSwDeletedTrap);
    }

    public EntryPair removeEntry(ProcessInfo processInfo) {
        EntryPair entryPair = (EntryPair)this.map.remove(processInfo);
        HrSWRunEntry hrSWRunEntry = entryPair.hrSWRunEntry;
        NetraCtHwRunningSwEntryImpl netraCtHwRunningSwEntryImpl = entryPair.netraCtHwRunningSwEntry;
        this.netraCtHwRunningSwTable.removeEntry(netraCtHwRunningSwEntryImpl);
        this.HrSWRunTable.removeEntry(hrSWRunEntry);
        return entryPair;
    }

    protected void sendTrap(TrapInfo trapInfo) {
        this.trapManager.sendThisV2Trap(trapInfo);
        try {
            NetraCtTrapLogEntryImpl netraCtTrapLogEntryImpl = this.logFilter.getFilterEntry(trapInfo);
            this.logManager.logThisTrap(netraCtTrapLogEntryImpl, trapInfo);
        }
        catch (FilterEntryNotFoundException filterEntryNotFoundException) {
            this.debug.write((Object)this, 7, "Filter not set for this trap");
        }
    }

    void setLogFilter(LogFilter logFilter) {
        this.logFilter = logFilter;
    }

    void setLogManager(LogManager logManager) {
        this.logManager = logManager;
    }

    void setTrapManager(TrapManager trapManager) {
        this.trapManager = trapManager;
    }

    static class EntryPair {
        HrSWRunEntry hrSWRunEntry;
        NetraCtHwRunningSwEntryImpl netraCtHwRunningSwEntry;

        EntryPair(HrSWRunEntry hrSWRunEntry, NetraCtHwRunningSwEntryImpl netraCtHwRunningSwEntryImpl) {
            this.hrSWRunEntry = hrSWRunEntry;
            this.netraCtHwRunningSwEntry = netraCtHwRunningSwEntryImpl;
        }
    }
}

