/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.common;

import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.Dsm;
import com.sun.ctmgx.common.EquipmentIf;
import com.sun.ctmgx.common.HolderIf;
import com.sun.ctmgx.common.Midplane;
import com.sun.ctmgx.common.MonitorFactory;
import com.sun.ctmgx.common.PackageInfoList;
import com.sun.ctmgx.common.PollMonitor;
import com.sun.ctmgx.common.ProcessInfoList;
import com.sun.ctmgx.common.ScsbInfo;
import com.sun.ctmgx.common.SsmdMonitor;
import com.sun.ctmgx.common.SyslogMonitor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class SystemView {
    static int systemType;
    ScsbInfo sysInfo;
    Vector holderVector;
    Vector equipVector;
    Midplane midplane;
    PackageInfoList packageInfoList;
    ProcessInfoList processInfoList;
    static String sysIpAddress;
    static String sysHostname;
    private Debug debug;

    public SystemView() {
        boolean bl = false;
        this.debug = new Debug();
        this.holderVector = new Vector();
        this.equipVector = new Vector();
        MonitorFactory monitorFactory = new MonitorFactory();
        try {
            sysIpAddress = InetAddress.getLocalHost().getHostAddress();
            sysHostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            sysIpAddress = "127.0.0.1";
            sysHostname = "localhost";
        }
        SsmdMonitor ssmdMonitor = new SsmdMonitor();
        Thread thread = new Thread(ssmdMonitor);
        monitorFactory.setSsmdMonitor(ssmdMonitor);
        PollMonitor pollMonitor = new PollMonitor();
        Thread thread2 = new Thread(pollMonitor);
        monitorFactory.setPollMonitor(pollMonitor);
        SyslogMonitor syslogMonitor = new SyslogMonitor();
        monitorFactory.setSyslogMonitor(syslogMonitor);
        this.sysInfo = new ScsbInfo();
        this.midplane = new Midplane(this.sysInfo);
        systemType = this.midplane.getMidplaneType();
        this.equipVector.add(this.midplane);
        thread.start();
        thread2.start();
        this.packageInfoList = new PackageInfoList();
        this.processInfoList = new ProcessInfoList();
        Dsm dsm = new Dsm(this.packageInfoList, this.processInfoList);
        syslogMonitor.addSyslogListener(dsm);
    }

    public EquipmentIf[] getEquipments() {
        int n = this.equipVector.size();
        EquipmentIf[] equipmentIfArray = new EquipmentIf[n];
        int n2 = 0;
        Enumeration enumeration = this.equipVector.elements();
        while (enumeration.hasMoreElements()) {
            equipmentIfArray[n2] = (EquipmentIf)enumeration.nextElement();
            ++n2;
        }
        return equipmentIfArray;
    }

    public HolderIf[] getHolders() {
        int n = this.holderVector.size();
        HolderIf[] holderIfArray = new HolderIf[n];
        int n2 = 0;
        Enumeration enumeration = this.holderVector.elements();
        while (enumeration.hasMoreElements()) {
            holderIfArray[n2] = (HolderIf)enumeration.nextElement();
            ++n2;
        }
        return holderIfArray;
    }

    public Midplane getMidplane() {
        return this.midplane;
    }

    public PackageInfoList getPackageInfoList() {
        return this.packageInfoList;
    }

    public ProcessInfoList getProcessInfoList() {
        return this.processInfoList;
    }

    public static String getSysHostname() {
        return sysHostname;
    }

    public static String getSysIpAddress() {
        return sysIpAddress;
    }

    public static int getSystemType() {
        return systemType;
    }
}

