/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.common;

import com.sun.ctmgx.common.D130;
import com.sun.ctmgx.common.D130Disk;
import com.sun.ctmgx.common.D130DiskEventListener;
import com.sun.ctmgx.common.D130EventListener;
import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.SsmEvent;
import com.sun.ctmgx.common.SsmdMonitorException;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class SsmdMonitor
implements Runnable {
    D130[] d130s = new D130[0];
    Hashtable d130Table = new Hashtable();
    Hashtable d130EventListenerTable = new Hashtable();
    Hashtable d130DiskEventListenerTable = new Hashtable();
    private Debug debug = new Debug();
    private static boolean isSsmInstalled = true;
    private static boolean isSsmDaemonRunning = true;

    static {
        try {
            System.loadLibrary("ssmrpc");
            System.loadLibrary("SsmdMonitor");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            isSsmInstalled = false;
            System.out.println(String.valueOf(unsatisfiedLinkError.getMessage()) + "\n" + "\tcannot find ssm library. SSM sw" + " may not be installed, \n\twill not monitor D130s on the" + " system");
        }
    }

    SsmdMonitor() {
        if (!isSsmInstalled) {
            return;
        }
        try {
            this.initSsmd();
        }
        catch (SsmdMonitorException ssmdMonitorException) {
            isSsmDaemonRunning = false;
            return;
        }
        try {
            this.d130s = this.getD130s();
        }
        catch (SsmdMonitorException ssmdMonitorException) {
            this.debug.write((Object)this, 4, "ssmond (SSM daemon) not responding, will not monitor D130s.");
            return;
        }
        if (this.d130s != null) {
            int n = 0;
            while (n < this.d130s.length) {
                D130 d130 = this.d130s[n];
                this.debug.write((Object)this, 7, "Coyote name = " + d130.getName() + "\n" + "\tid = " + d130.getId() + "\n" + "\tonline = " + (d130.isOnline() ? "yes" : "no"));
                D130Disk[] d130DiskArray = d130.getDisks();
                int n2 = 0;
                while (n2 < d130DiskArray.length) {
                    D130Disk d130Disk = d130DiskArray[n2];
                    this.d130Table.put(d130Disk.getDevPath(), d130);
                    this.debug.write((Object)this, 7, " Disk name = " + d130Disk.getName() + "\n" + "\t     id = " + d130Disk.getId() + "\n" + "\t     devname = " + d130Disk.getDevName() + "\n" + "\t     devpath = " + d130Disk.getDevPath() + "\n" + "\t     vendor = " + d130Disk.getVendor() + "\n" + "\t     serial = " + d130Disk.getSerial() + "\n" + "\t     model = " + d130Disk.getModel() + "\n" + "\t     online = " + (d130Disk.isOnline() ? "yes" : "no") + "\n" + "\t     good = " + (d130Disk.isGood() ? "yes" : "no"));
                    ++n2;
                }
                ++n;
            }
        }
    }

    public void addD130DiskListener(D130DiskEventListener d130DiskEventListener) {
        this.d130DiskEventListenerTable.put(d130DiskEventListener.getD130DiskPath(), d130DiskEventListener);
    }

    public void addD130Listener(D130EventListener d130EventListener) {
        this.d130EventListenerTable.put(d130EventListener.getD130Name(), d130EventListener);
    }

    D130 getD130(String string) {
        return (D130)this.d130Table.get(string);
    }

    D130[] getD130List() {
        int n = 0;
        D130[] d130Array = new D130[this.d130Table.size()];
        Enumeration enumeration = this.d130Table.elements();
        while (enumeration.hasMoreElements()) {
            d130Array[n] = (D130)enumeration.nextElement();
            ++n;
        }
        return d130Array;
    }

    protected native D130[] getD130s() throws SsmdMonitorException;

    private void handleSsmEvent(SsmEvent[] ssmEventArray) {
        int n = 0;
        this.debug.write((Object)this, 7, "In handleSsmEvent");
        n = 0;
        while (n < ssmEventArray.length) {
            SsmEvent ssmEvent = ssmEventArray[n];
            switch (ssmEvent.getEvent()) {
                case 1: 
                case 2: {
                    this.debug.write((Object)this, 7, "UNIT_* for " + ssmEvent.getCName());
                    D130EventListener d130EventListener = (D130EventListener)this.d130EventListenerTable.get(ssmEvent.getCName());
                    d130EventListener.handleEvent(ssmEvent);
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    String string = new String();
                    try {
                        File file = new File(ssmEvent.getDName());
                        string = file.getCanonicalPath();
                        int n2 = string.indexOf(":");
                        if (n2 >= 0) {
                            string = string.substring(0, n2);
                        }
                        if (string.startsWith("/devices")) {
                            string = string.substring(8);
                        }
                        this.debug.write((Object)this, 7, "DISK_* for " + ssmEvent.getDName() + ", " + string);
                        D130DiskEventListener d130DiskEventListener = (D130DiskEventListener)this.d130DiskEventListenerTable.get(string);
                        d130DiskEventListener.handleEvent(ssmEvent);
                    }
                    catch (IOException iOException) {
                        this.debug.write((Object)this, 6, String.valueOf(ssmEvent.getDName()) + " path not found, cannot forward DISK* event");
                        iOException.printStackTrace();
                    }
                    break;
                }
            }
            ++n;
        }
    }

    protected native void initSsmd() throws SsmdMonitorException;

    public void printTable() {
        D130[] d130Array = this.getD130List();
        if (d130Array != null) {
            int n = 0;
            while (n < d130Array.length) {
                D130 d130 = d130Array[n];
                this.debug.write((Object)this, 7, "Coyote name = " + d130.getName() + " of " + d130Array.length);
                D130Disk[] d130DiskArray = d130.getDisks();
                int n2 = 0;
                while (n2 < d130DiskArray.length) {
                    D130Disk d130Disk = d130DiskArray[n2];
                    this.debug.write((Object)this, 7, " Disk name = " + d130Disk.getName() + "\n" + " Disk path = " + d130Disk.getDevPath());
                    ++n2;
                }
                ++n;
            }
        }
    }

    protected native void registerForEvents();

    public void run() {
        if (isSsmInstalled && isSsmDaemonRunning) {
            this.registerForEvents();
        }
    }
}

