/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.common;

import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.FRUInfo;
import com.sun.ctmgx.common.KStat;
import com.sun.ctmgx.common.MonitorFactory;
import com.sun.ctmgx.common.PollEventListener;
import com.sun.ctmgx.common.PollMonitor;
import com.sun.ctmgx.common.ScsbException;
import java.beans.PropertyChangeSupport;

public class ScsbInfo
implements PollEventListener {
    private FRUInfo midPlane;
    private int[] maxUnits;
    private FRUInfo[] ps;
    private FRUInfo[] pdu;
    private FRUInfo[] slots;
    private FRUInfo[] disks;
    private FRUInfo[] fans;
    private FRUInfo[] scb;
    private FRUInfo[] ssb;
    private FRUInfo[] alarmCard;
    private FRUInfo[] cftm;
    private FRUInfo[] crtm;
    private FRUInfo[] prtm;
    private byte[] curr;
    int deviceInstance = 2;
    String deviceType = "02";
    private PollMonitor pollMonitor;
    private KStat ks;
    private PropertyChangeSupport propChangeSupport;
    private Debug debug;

    static {
        System.loadLibrary("ScsbInfo");
        try {
            ScsbInfo.initIDs();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (ScsbException scsbException) {
            scsbException.printStackTrace();
        }
    }

    public ScsbInfo() {
        this("scsb", 0, "env_topology");
    }

    ScsbInfo(int n) {
        this("scsb", n, "env_topology");
    }

    public ScsbInfo(String string, int n, String string2) {
        this.ks = new KStat(string, n, string2);
        byte[] byArray = this.ks.read();
        this.create(byArray);
        this.debug = new Debug();
        this.propChangeSupport = new PropertyChangeSupport(this);
        this.pollMonitor = MonitorFactory.getPollMonitor();
        this.pollMonitor.addPollEventListener(this);
    }

    protected void create(byte[] byArray) {
        if (byArray.length <= 0) {
            this.debug.write((Object)this, 4, "Failed to get current systemimage from scsb driver");
        } else {
            this.curr = byArray;
            try {
                this.init(byArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (ScsbException scsbException) {
                scsbException.printStackTrace();
            }
        }
    }

    private String fruInfoArrayToString(String string, FRUInfo[] fRUInfoArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < fRUInfoArray.length) {
            stringBuffer.append(String.valueOf(string) + "[" + n + "]\n");
            stringBuffer.append(fRUInfoArray[n].toString());
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public FRUInfo[] getAlarm() {
        return this.alarmCard;
    }

    public FRUInfo[] getCFTM() {
        return this.cftm;
    }

    public FRUInfo[] getCRTM() {
        return this.crtm;
    }

    public int getDeviceInstance() {
        return this.deviceInstance;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public FRUInfo[] getDisk() {
        return this.disks;
    }

    public FRUInfo[] getFans() {
        return this.fans;
    }

    public int[] getMaxUnits() {
        return this.maxUnits;
    }

    public FRUInfo getMidPlane() {
        return this.midPlane;
    }

    public FRUInfo[] getPDU() {
        return this.pdu;
    }

    public FRUInfo[] getPRTM() {
        return this.prtm;
    }

    public FRUInfo[] getPS() {
        return this.ps;
    }

    public FRUInfo[] getSCB() {
        return this.scb;
    }

    public FRUInfo[] getSSB() {
        return this.ssb;
    }

    public FRUInfo[] getSlots() {
        return this.slots;
    }

    public void handleEvent() {
        this.debug.write((Object)this, 7, "In handleEvent");
        byte[] byArray = this.ks.read();
        if (byArray.length <= 0) {
            this.debug.write((Object)this, 4, "scsb lookup failed");
        } else {
            this.set(byArray);
        }
    }

    protected native void init(byte[] var1) throws ClassNotFoundException, ScsbException;

    private static native void initIDs() throws ClassNotFoundException, ScsbException;

    protected void set(byte[] byArray) {
        if (this.curr.length <= 0) {
            this.create(byArray);
        } else {
            this.update(this.curr, byArray);
            this.curr = byArray;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.fruInfoArrayToString("slots", this.slots));
        stringBuffer.append(this.fruInfoArrayToString("pdu", this.pdu));
        stringBuffer.append(this.fruInfoArrayToString("ps", this.ps));
        stringBuffer.append(this.fruInfoArrayToString("disks", this.disks));
        stringBuffer.append(this.fruInfoArrayToString("fans", this.fans));
        stringBuffer.append(this.fruInfoArrayToString("alarmCard", this.alarmCard));
        stringBuffer.append(this.fruInfoArrayToString("scb", this.scb));
        stringBuffer.append(this.fruInfoArrayToString("ssb", this.ssb));
        stringBuffer.append(this.fruInfoArrayToString("cftm", this.cftm));
        stringBuffer.append(this.fruInfoArrayToString("crtm", this.crtm));
        stringBuffer.append(this.fruInfoArrayToString("prtm", this.prtm));
        stringBuffer.append(String.valueOf(String.valueOf(this.midPlane)) + "\n");
        return stringBuffer.toString();
    }

    protected native void update(byte[] var1, byte[] var2);
}

