/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.common;

import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.EnvmondEvent;
import com.sun.ctmgx.common.EnvmondEventListener;
import com.sun.ctmgx.common.KStat;
import com.sun.ctmgx.common.MonitorFactory;
import com.sun.ctmgx.common.PollMonitor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class FanInfo
implements EnvmondEventListener {
    boolean present;
    boolean ok;
    boolean speed;
    int version;
    int deviceInstance;
    String deviceType = "05";
    private Debug debug = new Debug();
    PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    PollMonitor pollMonitor;
    private KStat ks;

    static {
        System.loadLibrary("FanInfo");
    }

    FanInfo(int n) {
        this("gpio", n, 0, "gpio_fantray" + n);
    }

    public FanInfo(String string, int n, int n2, String string2) {
        this.deviceInstance = n;
        this.ks = new KStat(string, n2, string2);
        byte[] byArray = this.ks.read();
        this.create(byArray);
        this.pollMonitor = MonitorFactory.getPollMonitor();
        this.pollMonitor.addPollEventListener(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    protected void create(byte[] byArray) {
        try {
            this.set(byArray);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
        }
    }

    public int getDeviceInstance() {
        return this.deviceInstance;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public boolean getSpeed() {
        return this.speed;
    }

    public int getVersion() {
        return this.version;
    }

    public void handleEvent() {
        this.handleEvent(new EnvmondEvent(new Object()));
    }

    public void handleEvent(EnvmondEvent envmondEvent) {
        this.debug.write((Object)this, 7, "In fan handleEvent");
        byte[] byArray = this.ks.read();
        try {
            this.set(byArray);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
        }
    }

    public boolean isOk() {
        return this.ok;
    }

    public boolean isPresent() {
        return this.present;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void set(boolean bl, boolean bl2, boolean bl3, int n) {
        this.setPresent(bl);
        this.setOk(bl2);
        this.setSpeed(bl3);
        this.setVersion(n);
    }

    protected native void set(byte[] var1);

    private void setOk(boolean bl) {
        boolean bl2 = this.ok;
        this.ok = bl;
        this.propChangeSupport.firePropertyChange("ok", bl2, this.ok);
    }

    private void setPresent(boolean bl) {
        boolean bl2 = this.present;
        this.present = bl;
        this.propChangeSupport.firePropertyChange("present", bl2, this.present);
    }

    private void setSpeed(boolean bl) {
        boolean bl2 = this.speed;
        this.speed = bl;
        this.propChangeSupport.firePropertyChange("speed", bl2, this.speed);
    }

    private void setVersion(int n) {
        int n2 = this.version;
        this.version = n;
        this.propChangeSupport.firePropertyChange("version", n2, this.version);
    }

    void stopMonitoring() {
        this.pollMonitor.removePollEventListener(this);
    }
}

