/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.common;

import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.KStat;
import com.sun.ctmgx.common.MonitorFactory;
import com.sun.ctmgx.common.Ndd;
import com.sun.ctmgx.common.PollEventListener;
import com.sun.ctmgx.common.PollMonitor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class EtherPortInfo
implements PollEventListener {
    KStat ks;
    Ndd ndd;
    int ifType = 6;
    String ifDescr;
    int ifOperStatus;
    PollMonitor pollMonitor;
    Debug debug = new Debug();
    PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    String driverName;
    String kstatName;
    int instance;

    public EtherPortInfo(String string, int n, String string2) {
        this.driverName = string;
        this.kstatName = string2;
        this.instance = n;
        this.ifDescr = String.valueOf(string) + n;
        this.ks = new KStat(string, n, string2);
        this.ndd = new Ndd("/dev/" + string, n);
        this.ifOperStatus = this.getIfOperStatus();
        this.pollMonitor = MonitorFactory.getPollMonitor();
        this.pollMonitor.addPollEventListener(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    String getIfDescr() {
        return this.ifDescr;
    }

    long getIfInNUcastPkts() {
        return this.ks.getLongValue("multircv") + this.ks.getLongValue("brdcstrcv");
    }

    long getIfInUcastPkts() {
        return this.ks.getLongValue("ipackets");
    }

    int getIfOperStatus() {
        int n = this.ndd.ioctlGetLinkStatus();
        this.debug.write((Object)this, 7, "linkStatus = " + n);
        int n2 = n == 0 ? 2 : (n == 1 ? 1 : 4);
        return n2;
    }

    long getIfOutNUcastPkts() {
        return this.ks.getLongValue("multixmt") + this.ks.getLongValue("brdcstxmt");
    }

    long getIfOutOctets() {
        return this.ks.getLongValue("obytes");
    }

    long getIfOutUcastPkts() {
        return this.ks.getLongValue("opackets");
    }

    long getIfSpeed() {
        return this.ks.getLongValue("ifspeed");
    }

    int getIfType() {
        return this.ifType;
    }

    public void handleEvent() {
        this.debug.write((Object)this, 7, "In handleEvent");
        int n = this.getIfOperStatus();
        if (n != this.ifOperStatus) {
            int n2 = this.ifOperStatus;
            this.ifOperStatus = n;
            this.propChangeSupport.firePropertyChange("operStatus", n2, n);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void stopMonitoring() {
        this.pollMonitor.removePollEventListener(this);
    }
}

