/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.common;

import com.sun.ctmgx.common.CpuInfo;
import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.EquipmentImpl;
import com.sun.ctmgx.common.TempInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class Cpu
extends EquipmentImpl {
    int clockSpeed;
    String type;
    String state;
    int currentTemperature;
    int warningThreshold;
    int shutdownThreshold;
    private Debug debug;
    CpuInfo cpuInfo;
    TempInfo tempInfo;
    TempPropertyChangeListener tempListener;

    public Cpu(CpuInfo cpuInfo, TempInfo tempInfo) {
        super(new String("cpu"), new String("cpu"), 2, 12, cpuInfo.getInstance());
        this.cpuInfo = cpuInfo;
        this.tempInfo = tempInfo;
        this.debug = new Debug();
        this.currentTemperature = tempInfo.getCurrentTemperature();
        this.warningThreshold = tempInfo.getWarningThreshold();
        this.shutdownThreshold = tempInfo.getShutdownThreshold();
        this.clockSpeed = cpuInfo.getClockSpeed();
        this.type = cpuInfo.getType();
        this.state = cpuInfo.getState();
        this.tempListener = new TempPropertyChangeListener();
        tempInfo.addPropertyChangeListener(this.tempListener);
    }

    public int getCurrentTemperature() {
        return this.currentTemperature;
    }

    public int getShutdownThreshold() {
        return this.shutdownThreshold;
    }

    public int getWarningThreshold() {
        return this.warningThreshold;
    }

    class TempPropertyChangeListener
    implements PropertyChangeListener {
        TempPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Cpu.this.debug.write((Object)this, 7, "In propChange");
            String string = propertyChangeEvent.getPropertyName();
            int n = (Integer)propertyChangeEvent.getOldValue();
            int n2 = (Integer)propertyChangeEvent.getNewValue();
            boolean bl = false;
            if ("currentTemperature".equals(string)) {
                int n3 = Cpu.this.currentTemperature;
                Cpu.this.currentTemperature = n2;
                Cpu.this.debug.write((Object)this, 7, "Firing propChange, currTemp = " + Cpu.this.currentTemperature + ", warnThresh = " + Cpu.this.warningThreshold + ", shutThresh = " + Cpu.this.shutdownThreshold);
                Cpu.this.propChangeSupport.firePropertyChange("currentTemperature", new Integer(n3), new Integer(Cpu.this.currentTemperature));
            } else if ("warningThreshold".equals(string)) {
                int n4 = Cpu.this.warningThreshold;
                Cpu.this.warningThreshold = n2;
                Cpu.this.debug.write((Object)this, 7, "Firing propChange");
                Cpu.this.propChangeSupport.firePropertyChange("warningThreshold", new Integer(n4), new Integer(Cpu.this.warningThreshold));
            } else if ("shutdownThreshold".equals(string)) {
                int n5 = Cpu.this.shutdownThreshold;
                Cpu.this.shutdownThreshold = n2;
                Cpu.this.debug.write((Object)this, 7, "Firing propChange");
                Cpu.this.propChangeSupport.firePropertyChange("shutdownThreshold", new Integer(n5), new Integer(Cpu.this.shutdownThreshold));
            }
        }
    }
}

