/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ctmgx.common;

import com.sun.ctmgx.common.D130Disk;
import com.sun.ctmgx.common.D130DiskEventListener;
import com.sun.ctmgx.common.Debug;
import com.sun.ctmgx.common.MonitorFactory;
import com.sun.ctmgx.common.SsmEvent;
import com.sun.ctmgx.common.SsmdMonitor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;

public class CoyoteDiskInfo
implements D130DiskEventListener {
    int id;
    String name;
    String devPath;
    String vendor;
    String serial;
    String model;
    boolean online;
    boolean good;
    SsmdMonitor ssmdMonitor;
    Debug debug = new Debug();
    PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);

    CoyoteDiskInfo(D130Disk d130Disk) {
        this.id = d130Disk.getId();
        this.name = d130Disk.getName();
        this.devPath = d130Disk.getDevPath();
        this.vendor = d130Disk.getVendor();
        this.serial = d130Disk.getSerial();
        this.model = d130Disk.getModel();
        this.online = d130Disk.isOnline();
        this.good = d130Disk.isGood();
        this.ssmdMonitor = MonitorFactory.getSsmdMonitor();
        this.ssmdMonitor.addD130DiskListener(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public String getD130DiskPath() {
        return this.getDevPath();
    }

    String getDevPath() {
        return this.devPath;
    }

    int getId() {
        return this.id;
    }

    String getModel() {
        return this.model;
    }

    String getName() {
        return this.name;
    }

    String getSerial() {
        return this.serial;
    }

    String getVendor() {
        return this.vendor;
    }

    public void handleEvent(SsmEvent ssmEvent) {
        this.debug.write((Object)this, 7, "In handleEvent, event = " + ssmEvent.getEvent());
        String string = new String();
        try {
            File file = new File(ssmEvent.getDName());
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            this.debug.write((Object)this, 4, String.valueOf(ssmEvent.getDName()) + " path not found, cannot forward DISK* event");
            iOException.printStackTrace();
        }
        this.debug.write((Object)this, 7, "devpath = " + this.devPath + ", " + "tempDevPath = " + string);
        switch (ssmEvent.getEvent()) {
            case 3: 
            case 4: {
                this.debug.write((Object)this, 7, "Setting online");
                this.setOnline(ssmEvent.getEvent());
                break;
            }
            case 6: 
            case 7: {
                this.debug.write((Object)this, 7, "Setting good");
                this.setGood(ssmEvent.getEvent());
                break;
            }
        }
    }

    boolean isGood() {
        return this.good;
    }

    boolean isOnline() {
        return this.online;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    void setGood(int n) {
        boolean bl;
        if (n == 6) {
            bl = true;
        } else if (n == 7) {
            bl = false;
        } else {
            return;
        }
        boolean bl2 = this.good;
        if (bl != this.online) {
            this.good = bl;
            this.propChangeSupport.firePropertyChange("good", bl2, bl);
        }
    }

    void setOnline(int n) {
        boolean bl;
        if (n == 3) {
            bl = false;
        } else if (n == 4) {
            bl = true;
        } else {
            return;
        }
        this.debug.write((Object)this, 7, "oldonline = " + this.online + " newonline = " + bl);
        boolean bl2 = this.online;
        if (bl != this.online) {
            this.online = bl;
            this.debug.write((Object)this, 7, "Firing propChange");
            this.propChangeSupport.firePropertyChange("online", bl2, bl);
        }
    }
}

