/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client;

import com.sun.admin.fsmgr.client.FsMgr;
import com.sun.admin.fsmgr.client.FsMgrResourceStrings;
import com.sun.admin.fsmgr.client.apps.AppData;
import com.sun.admin.fsmgr.client.apps.AppsCache;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FsMgrTree
extends JTree {
    public static String FSMGR_RSRC = new String("FileSystemManager");
    public static String MOUNT_RSRC = new String("MountAdministration");
    public static String SHARE_RSRC = new String("ShareAdministration");
    public static String USAGE_RSRC = new String("FileSystemUsage");
    public static String FSMGR = FsMgrResourceStrings.getString(FSMGR_RSRC);
    public static String MOUNT = FsMgrResourceStrings.getString(MOUNT_RSRC);
    public static String SHARE = FsMgrResourceStrings.getString(SHARE_RSRC);
    public static String USAGE = FsMgrResourceStrings.getString(USAGE_RSRC);
    private AppsCache appsCache;
    final TreeCellRenderer oldRenderer = this.getCellRenderer();

    public FsMgrTree(AppsCache appsCache) {
        super((TreeModel)null);
        this.appsCache = appsCache;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(appsCache.getAppsRoot());
        int n = 0;
        while (n < appsCache.size()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode((AppData)appsCache.elementAt(n)));
            ++n;
        }
        FsMgrTreeModel fsMgrTreeModel = new FsMgrTreeModel(defaultMutableTreeNode);
        this.setModel(fsMgrTreeModel);
        FsMgrTreeCellRenderer fsMgrTreeCellRenderer = new FsMgrTreeCellRenderer();
        this.setCellRenderer(fsMgrTreeCellRenderer);
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        this.setSelectionModel(defaultTreeSelectionModel);
        this.addTreeSelectionListener(new FsMgrTreeSelectionHandler());
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.collapseRow(0);
    }

    public void setSelectedNode(String string) {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null) {
            String string2 = treePath.getLastPathComponent().toString();
            if (string.equals(string2)) {
                return;
            }
        } else {
            this.setSelectionRow(0);
        }
        this.expandRow(0);
        int n = 0;
        while (n < this.getRowCount()) {
            treePath = this.getPathForRow(n);
            if (string.equals(treePath.getLastPathComponent().toString())) {
                this.setSelectionPath(treePath);
                return;
            }
            ++n;
        }
    }

    public void setPanel(String string) {
        FsMgr fsMgr = FsMgr.getFsMgr();
        if (string.equals(MOUNT)) {
            fsMgr.setCurrentPanel(MOUNT);
            fsMgr.addToHelpPanel("fs_ctx_main_mount");
            return;
        }
        if (string.equals(SHARE)) {
            fsMgr.setCurrentPanel(SHARE);
            fsMgr.addToHelpPanel("fs_ctx_main_share");
            return;
        }
        if (string.equals(USAGE)) {
            fsMgr.setCurrentPanel(USAGE);
            fsMgr.addToHelpPanel("fs_ctx_main_usage");
            return;
        }
        fsMgr.setCurrentPanel(FSMGR);
        fsMgr.addToHelpPanel("fs_ctx_main");
    }

    protected class FsMgrTreeSelectionHandler
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            FsMgrTree fsMgrTree = (FsMgrTree)treeSelectionEvent.getSource();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
            String string = defaultMutableTreeNode.toString();
            if (treeSelectionEvent.isAddedPath()) {
                if (defaultMutableTreeNode != null) {
                    FsMgr.getFsMgr().getClientComm().setAppFocus(FsMgr.getFsMgr());
                }
                fsMgrTree.setPanel(string);
            }
        }

        protected FsMgrTreeSelectionHandler() {
            FsMgrTree.this = FsMgrTree.this;
        }
    }

    class FsMgrTreeCellRenderer
    implements TreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = FsMgrTree.this.oldRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                if (object2 instanceof AppData) {
                    AppData appData = (AppData)object2;
                    if (appData.getPreferredSize() == null) {
                        Dimension dimension = jLabel.getMinimumSize();
                        dimension.height += 4;
                        appData.setPreferredSize(dimension);
                    }
                    jLabel.setIcon(appData.getAppIconSmall());
                    jLabel.setPreferredSize(appData.getPreferredSize());
                    jLabel.setMaximumSize(appData.getPreferredSize());
                }
            }
            return component;
        }

        FsMgrTreeCellRenderer() {
            FsMgrTree.this = FsMgrTree.this;
        }
    }

    class FsMgrTreeModel
    extends DefaultTreeModel {
        public FsMgrTreeModel(TreeNode treeNode) {
            super(treeNode);
            FsMgrTree.this = FsMgrTree.this;
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            String string = (String)object;
            AppData appData = FsMgrTree.this.appsCache.getAppByName(string);
            if (appData != null) {
                defaultMutableTreeNode.setUserObject(appData);
            } else {
                defaultMutableTreeNode.setUserObject(string);
            }
            this.nodeChanged(defaultMutableTreeNode);
        }
    }
}

