/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.server;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.server.AdminServerException;
import com.sun.admin.usermgr.common.UserObj;
import com.sun.admin.usermgr.server.SolarisGroupTable;

public class AdminServerLibrary {
    public static final String ADMIN_SERVER_LIBRARY = "admsvr";
    private static boolean library_loaded;

    public static String getEncryptedPassword(String string) throws AdminException {
        String string2 = null;
        if (library_loaded) {
            string2 = AdminServerLibrary.getPassword(string);
            if (string2 == null || string2.trim().length() == 0) {
                string2 = null;
            }
        } else {
            throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
        }
        return string2;
    }

    public static String getDomainName() throws AdminException {
        String string = null;
        if (library_loaded) {
            string = AdminServerLibrary.getDomain();
            if (string == null || string.trim().length() == 0) {
                string = null;
            }
        } else {
            throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
        }
        return string;
    }

    public static String ypLookup(String string, String string2, String string3) throws AdminException {
        String string4 = null;
        if (library_loaded) {
            int n = string3.length();
            string4 = AdminServerLibrary.ypMatch(string, string2, string3, n);
            if (string4 == null || string4.trim().length() == 0) {
                string4 = null;
            }
        } else {
            throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
        }
        return string4;
    }

    public static void writeToSyslog(String string, String string2, int n) throws AdminException {
        if (library_loaded) {
            AdminServerLibrary.doSyslog(string, string2, n);
            return;
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    public static int doStat(String string) throws AdminException {
        if (library_loaded) {
            return AdminServerLibrary.runStat(string);
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    public static int isConsole(String string) throws AdminException {
        if (library_loaded) {
            return AdminServerLibrary.isPortConsole(string);
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    public static int eepromSet(String string) throws AdminException {
        if (library_loaded) {
            return AdminServerLibrary.doEEprom(string);
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    public static String getArchitecture() throws AdminException {
        if (library_loaded) {
            return AdminServerLibrary.getArch();
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    public static int checkTTYLabel(String string, String string2) throws AdminException {
        if (library_loaded) {
            return AdminServerLibrary.checkLabel(string, string2);
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    public static synchronized int auditUserCreate(UserObj userObj, int n, String string, String string2, long l) throws AdminException {
        if (library_loaded) {
            if (userObj != null) {
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                String string8 = "";
                String string9 = "";
                String string10 = "";
                String string11 = "";
                String string12 = "";
                if (userObj.getSolGroupAttr() != null) {
                    string3 = userObj.getSolGroupAttr().getPrimaryGroup();
                    if (string3 == null) {
                        string3 = "";
                    }
                    if (userObj.getSolGroupAttr().getSecondaryGroups() != null) {
                        string4 = SolarisGroupTable.formatMembersIntoString(userObj.getSolGroupAttr().getSecondaryGroups());
                    }
                    if (string4 == null) {
                        string4 = "";
                    }
                }
                if (userObj.getSolServicesAttr() != null && (string5 = userObj.getSolServicesAttr().getInitialShell()) == null) {
                    string5 = "";
                }
                if (userObj.getSolPasswordAttr() != null) {
                    string6 = userObj.getSolPasswordAttr().getCannotChangeDays();
                    if (string6 == null) {
                        string6 = "";
                    }
                    if ((string7 = userObj.getSolPasswordAttr().getAlertChangeDays()) == null) {
                        string7 = "";
                    }
                    if ((string8 = userObj.getSolPasswordAttr().getInactiveDays()) == null) {
                        string8 = "";
                    }
                }
                if (userObj.getSolAccountAttr() != null && (string9 = userObj.getSolAccountAttr().getAccountExpires()) == null) {
                    string9 = "";
                }
                if (userObj.getSolHomedirAttr() != null) {
                    string10 = userObj.getSolHomedirAttr().getPathname();
                    if (string10 == null) {
                        string10 = "";
                    }
                    if ((string11 = userObj.getSolHomedirAttr().getServer()) == null) {
                        string11 = "";
                    }
                    if (userObj.getSolHomedirAttr().getPerms() != null) {
                        string12 = userObj.getSolHomedirAttr().getPerms().getPermissions();
                    }
                    if (string12 == null) {
                        string12 = "";
                    }
                }
                int n2 = 3;
                int n3 = 0;
                if (userObj.getSolAccountAttr() != null && userObj.getSolAccountAttr().isAccountLocked()) {
                    n2 = 2;
                    n3 = 1;
                } else {
                    n2 = userObj.getSolPasswordAttr() != null && userObj.getSolPasswordAttr().isThereAPassword() ? 1 : 0;
                }
                return AdminServerLibrary.auditUserCreateEvent(userObj.getUserID(), userObj.getUserName(), string3, string4, string5, string6, string7, string8, string9, string7, string10, string11, string12, n2, n3, n, string, string2, l);
            }
            return -1;
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    public static synchronized int auditUserModify(UserObj userObj, int n, String string, String string2, long l) throws AdminException {
        if (library_loaded) {
            if (userObj != null) {
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                String string8 = "";
                String string9 = "";
                String string10 = "";
                String string11 = "";
                if (userObj.getSolGroupAttr() != null) {
                    string3 = userObj.getSolGroupAttr().getPrimaryGroup();
                    if (string3 == null) {
                        string3 = "";
                    }
                    if (userObj.getSolGroupAttr().getSecondaryGroups() != null) {
                        string4 = SolarisGroupTable.formatMembersIntoString(userObj.getSolGroupAttr().getSecondaryGroups());
                    }
                    if (string4 == null) {
                        string4 = "";
                    }
                }
                if (userObj.getSolServicesAttr() != null && (string5 = userObj.getSolServicesAttr().getInitialShell()) == null) {
                    string5 = "";
                }
                if (userObj.getSolPasswordAttr() != null) {
                    string6 = userObj.getSolPasswordAttr().getCannotChangeDays();
                    if (string6 == null) {
                        string6 = "";
                    }
                    if ((string7 = userObj.getSolPasswordAttr().getAlertChangeDays()) == null) {
                        string7 = "";
                    }
                    if ((string8 = userObj.getSolPasswordAttr().getInactiveDays()) == null) {
                        string8 = "";
                    }
                }
                if (userObj.getSolAccountAttr() != null && (string9 = userObj.getSolAccountAttr().getAccountExpires()) == null) {
                    string9 = "";
                }
                if (userObj.getSolHomedirAttr() != null) {
                    string10 = userObj.getSolHomedirAttr().getPathname();
                    if (string10 == null) {
                        string10 = "";
                    }
                    if ((string11 = userObj.getSolHomedirAttr().getServer()) == null) {
                        string11 = "";
                    }
                }
                int n2 = 3;
                int n3 = 0;
                if (userObj.getSolAccountAttr() != null && userObj.getSolAccountAttr().isAccountLocked()) {
                    n2 = 2;
                    n3 = 1;
                } else {
                    n2 = userObj.getSolPasswordAttr() != null && userObj.getSolPasswordAttr().isThereAPassword() ? 1 : 0;
                }
                return AdminServerLibrary.auditUserModifyEvent(userObj.getUserID(), userObj.getUserName(), string3, string4, string5, string6, string7, string8, string9, string7, string10, string11, n2, n3, n, string, string2, l);
            }
            return -1;
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    public static synchronized int auditUserDelete(String string, String string2, int n, String string3, String string4, long l) throws AdminException {
        if (string == null || string2 == null) {
            return -1;
        }
        if (library_loaded) {
            if (n >= 0) {
                return AdminServerLibrary.auditDeleteUserSuccess(string, string2, string3, string4, l);
            }
            return AdminServerLibrary.auditDeleteUserFailure(string, string2, string3, string4, l);
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    public static synchronized int auditMount(String string, String string2, int n, String string3, String string4, long l) throws AdminException {
        return 0;
    }

    public static synchronized int auditUMount(String string, String string2, String string3, String string4, long l) throws AdminException {
        return 0;
    }

    public static boolean auditOn() throws AdminException {
        if (library_loaded) {
            int n = AdminServerLibrary.isAuditOn();
            return n != 0;
        }
        throw new AdminServerException("EXM_NNL", ADMIN_SERVER_LIBRARY);
    }

    private static native String getPassword(String var0);

    private static native String getDomain();

    private static native String ypMatch(String var0, String var1, String var2, int var3);

    private static native void doSyslog(String var0, String var1, int var2);

    private static native int runStat(String var0);

    private static native int isPortConsole(String var0);

    private static native int doEEprom(String var0);

    private static native String getArch();

    private static native int checkLabel(String var0, String var1);

    private static native int auditUserCreateEvent(String var0, String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, int var13, int var14, int var15, String var16, String var17, long var18);

    private static native int auditUserModifyEvent(String var0, String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, int var12, int var13, int var14, String var15, String var16, long var17);

    private static native int auditDeleteUserSuccess(String var0, String var1, String var2, String var3, long var4);

    private static native int auditDeleteUserFailure(String var0, String var1, String var2, String var3, long var4);

    private static native int auditMountEvent(String var0, String var1, int var2, String var3, String var4, long var5);

    private static native int auditUMountEvent(String var0, String var1, String var2, String var3, long var4);

    private static native int isAuditOn();

    static {
        try {
            System.loadLibrary(ADMIN_SERVER_LIBRARY);
            library_loaded = true;
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("Server daemon: Unable to load libadmsvr shared library: " + exception.getMessage());
        }
    }
}

