/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.usermgr.client.AdminMainPanel;
import com.sun.admin.usermgr.client.AdminViews;
import com.sun.admin.usermgr.client.RightsProps;
import com.sun.admin.usermgr.client.SolGenProps;
import com.sun.admin.usermgr.client.SolGrpProps;
import com.sun.admin.usermgr.client.SolHdirProps;
import com.sun.admin.usermgr.client.SolMailProps;
import com.sun.admin.usermgr.client.SolPassOpProps;
import com.sun.admin.usermgr.client.SolPassProps;
import com.sun.admin.usermgr.client.UMgrPropsPanel;
import com.sun.admin.usermgr.client.UserMgrClient;
import com.sun.admin.usermgr.common.PartialSuccessObject;
import com.sun.admin.usermgr.common.SolServerPartialSuccessException;
import com.sun.admin.usermgr.common.UMgrResourceStrings;
import com.sun.admin.usermgr.common.UserMgrNameAlreadyInUseException;
import com.sun.admin.usermgr.common.UserObj;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AdminUserTabs
extends JTabbedPane {
    UserObj userObj;
    JDialog parent;
    GenInfoPanel infoPanel;
    AdminUserTabs adminUserTabs;
    private UserMgrClient userMgrClient;
    SolGenProps solGenProps;
    SolGrpProps solGrpProps;
    SolPassProps solPassProps;
    SolPassOpProps solPassOpProps;
    SolHdirProps solHdirProps;
    SolMailProps solMailProps;
    RightsProps rightsProps;
    boolean isGenVisited;
    boolean isPassVisited;
    boolean isPassOpVisited;
    boolean isGrpVisited;
    boolean isHdirVisited;
    boolean isMailVisited;
    boolean isRightsVisited;
    boolean showPasswdTab;
    int SelectedPane;
    URL genUrl;
    URL passUrl;
    URL homeUrl;
    URL groupUrl;
    public static final Border emptyBorder5 = new EmptyBorder(5, 5, 5, 5);

    public AdminUserTabs(UserObj userObj, GenInfoPanel genInfoPanel, JDialog jDialog, boolean bl) {
        this.userObj = userObj;
        this.parent = jDialog;
        this.infoPanel = genInfoPanel;
        this.isGenVisited = true;
        this.isPassVisited = false;
        this.isPassOpVisited = false;
        this.isGrpVisited = false;
        this.isHdirVisited = false;
        this.isMailVisited = false;
        this.isRightsVisited = false;
        this.showPasswdTab = bl;
        this.AdminUserTabsInit();
    }

    void AdminUserTabsInit() {
        this.adminUserTabs = this;
        AdminUserTabsListener adminUserTabsListener = new AdminUserTabsListener();
        this.addChangeListener(adminUserTabsListener);
        this.addFocusListener(new TabPaneFocusListener(adminUserTabsListener));
        this.setupSolTabs(this.userObj);
    }

    void setupSolTabs(UserObj userObj) {
        this.solGenProps = new SolGenProps(userObj, this.infoPanel, this.showPasswdTab);
        this.adminUserTabs.addTab(UMgrResourceStrings.getString("au_tabs_general"), null, this.solGenProps);
        this.solGrpProps = new SolGrpProps(userObj, this.infoPanel);
        this.adminUserTabs.addTab(UMgrResourceStrings.getString("au_tabs_grp"), null, this.solGrpProps);
        this.solHdirProps = new SolHdirProps(userObj, this.infoPanel);
        this.adminUserTabs.addTab(UMgrResourceStrings.getString("au_tabs_hdir"), null, this.solHdirProps);
        if (this.showPasswdTab) {
            this.solPassProps = new SolPassProps(userObj, this.infoPanel);
            this.adminUserTabs.addTab(UMgrResourceStrings.getString("au_tabs_passwd"), null, this.solPassProps);
            this.solPassOpProps = new SolPassOpProps(userObj, this.infoPanel);
            this.adminUserTabs.addTab(UMgrResourceStrings.getString("au_tabs_passwd_op"), null, this.solPassOpProps);
        }
        this.solMailProps = new SolMailProps(userObj, this.infoPanel);
        this.adminUserTabs.addTab(UMgrResourceStrings.getString("au_tabs_mail"), null, this.solMailProps);
        try {
            this.rightsProps = new RightsProps(userObj, this.infoPanel);
            this.adminUserTabs.addTab(UMgrResourceStrings.getString("au_tabs_rights"), null, this.rightsProps);
            return;
        }
        catch (AdminException adminException) {
            new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, adminException.getLocalizedMessage());
            return;
        }
    }

    public boolean isUpdatePropsOK(UserObj userObj) {
        this.userMgrClient = UserMgrClient.instance();
        UserObj userObj2 = userObj;
        UserObj userObj3 = (UserObj)userObj.clone();
        boolean bl = false;
        if (this.isGenVisited) {
            if (this.solGenProps.isUserNameSyntaxOK() && this.solGenProps.isDescriptionSyntaxOK() && this.solGenProps.isExpireDateSyntaxOK()) {
                bl = true;
                userObj3 = this.solGenProps.updateGenProps(userObj3);
            } else {
                return false;
            }
        }
        if (this.isGrpVisited) {
            if (this.solGrpProps.checkNumberSecondaryGroups()) {
                bl = true;
                userObj3 = this.solGrpProps.updateGrpProps(userObj3);
            } else {
                return false;
            }
        }
        if (this.isPassVisited) {
            if (this.solPassProps.isPasswdSyntaxOK()) {
                bl = true;
                userObj3 = this.solPassProps.updateSolPassProps(userObj3);
                if (!this.solPassProps.getPasswordGood()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.isPassOpVisited) {
            if (this.solPassOpProps.isPasswdSyntaxOK()) {
                bl = true;
                userObj3 = this.solPassOpProps.updateSolPassOpProps(userObj3);
            } else {
                return false;
            }
        }
        if (this.isHdirVisited) {
            if (this.solHdirProps.isHdirSyntaxOK()) {
                bl = true;
                userObj3 = this.solHdirProps.updateSolHdirProps(userObj3);
            } else {
                return false;
            }
        }
        if (this.isMailVisited) {
            if (this.solMailProps.isMailSyntaxOK()) {
                bl = true;
                userObj3 = this.solMailProps.updateSolMailProps(userObj3);
            } else {
                return false;
            }
        }
        if (this.isRightsVisited) {
            bl = true;
            userObj3 = this.rightsProps.updateRightsProps(userObj3);
        }
        userObj3.debugPrint();
        userObj2.debugPrint();
        if (bl) {
            block36: {
                try {
                    if (userObj3.requireModify() || !userObj3.equals(userObj2)) {
                        UserObj userObj4 = this.userMgrClient.modifyUser(userObj3, userObj2);
                        AdminViews.instance().modifyUserObjInViews(userObj2, userObj4);
                        if (!userObj2.getUserName().equals(userObj4.getUserName())) {
                            AdminViews.instance().refreshUserViews();
                            AdminViews.instance().setCurrentViewWithoutProgress(AdminViews.instance().getAncestorViewName(), AdminViews.instance().getCurrentViewName());
                        }
                    }
                }
                catch (SolServerPartialSuccessException solServerPartialSuccessException) {
                    PartialSuccessObject partialSuccessObject = solServerPartialSuccessException.getPartialSuccessObject();
                    if (partialSuccessObject != null) {
                        if (partialSuccessObject.getHomedirFailed()) {
                            Exception exception = partialSuccessObject.getHomedirException();
                            if (exception != null) {
                                new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_information"), exception.getLocalizedMessage(), true);
                            }
                        } else if (partialSuccessObject.getMailboxFailed()) {
                            Exception exception = partialSuccessObject.getMailboxException();
                            if (exception != null) {
                                new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_information"), exception.getLocalizedMessage(), true);
                            }
                        } else {
                            String string = solServerPartialSuccessException.getLocalizedMessage();
                            if (string != null && !string.equals("")) {
                                new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_information"), string, true);
                            }
                        }
                    }
                    AdminViews.instance().modifyUserObjInViews(userObj2, userObj3);
                    if (!userObj2.getUserName().equals(userObj3.getUserName())) {
                        AdminViews.instance().refreshUserViews();
                        AdminViews.instance().setCurrentViewWithoutProgress(AdminViews.instance().getAncestorViewName(), AdminViews.instance().getCurrentViewName());
                    }
                }
                catch (UserMgrNameAlreadyInUseException userMgrNameAlreadyInUseException) {
                    new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, userMgrNameAlreadyInUseException.getLocalizedMessage());
                    return false;
                }
                catch (Exception exception) {
                    String string = exception.getLocalizedMessage();
                    if (string == null || string.equals("")) break block36;
                    new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, string);
                }
            }
            return true;
        }
        return false;
    }

    public int ReturnIndex() {
        return this.SelectedPane;
    }

    class AdminUserTabsListener
    implements ChangeListener {
        private AdminMainPanel am = AdminMainPanel.sharedInstance();
        private String um = "usermgr";

        public void stateChanged(ChangeEvent changeEvent) {
            FocusListener focusListener;
            try {
                if (AdminUserTabs.this.adminUserTabs.getSelectedComponent() == AdminUserTabs.this.solGenProps) {
                    AdminUserTabs.this.solGenProps.requestFocus();
                    AdminUserTabs.this.isGenVisited = true;
                } else if (AdminUserTabs.this.adminUserTabs.getSelectedComponent() == AdminUserTabs.this.solPassProps) {
                    AdminUserTabs.this.solPassProps.requestFocus();
                    AdminUserTabs.this.isPassVisited = true;
                } else if (AdminUserTabs.this.adminUserTabs.getSelectedComponent() == AdminUserTabs.this.solPassOpProps) {
                    AdminUserTabs.this.solPassOpProps.requestFocus();
                    AdminUserTabs.this.isPassOpVisited = true;
                } else if (AdminUserTabs.this.adminUserTabs.getSelectedComponent() == AdminUserTabs.this.solGrpProps) {
                    AdminUserTabs.this.solGrpProps.requestFocus();
                    AdminUserTabs.this.isGrpVisited = true;
                } else if (AdminUserTabs.this.adminUserTabs.getSelectedComponent() == AdminUserTabs.this.solHdirProps) {
                    AdminUserTabs.this.solHdirProps.requestFocus();
                    AdminUserTabs.this.isHdirVisited = true;
                } else if (AdminUserTabs.this.adminUserTabs.getSelectedComponent() == AdminUserTabs.this.solMailProps) {
                    AdminUserTabs.this.solMailProps.requestFocus();
                    AdminUserTabs.this.isMailVisited = true;
                } else if (AdminUserTabs.this.adminUserTabs.getSelectedComponent() == AdminUserTabs.this.rightsProps) {
                    AdminUserTabs.this.rightsProps.requestFocus();
                    AdminUserTabs.this.isRightsVisited = true;
                }
            }
            catch (Exception exception) {
                new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, exception.getLocalizedMessage());
            }
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            UMgrPropsPanel uMgrPropsPanel = (UMgrPropsPanel)jTabbedPane.getSelectedComponent();
            if (uMgrPropsPanel != null && (focusListener = uMgrPropsPanel.getFocusListener()) != null) {
                focusListener.focusGained(new FocusEvent(jTabbedPane, 1004));
            }
        }

        AdminUserTabsListener() {
            AdminUserTabs.this = AdminUserTabs.this;
        }
    }

    class TabPaneFocusListener
    implements FocusListener {
        AdminUserTabsListener cl;

        public TabPaneFocusListener(AdminUserTabsListener adminUserTabsListener) {
            AdminUserTabs.this = AdminUserTabs.this;
            this.cl = adminUserTabsListener;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.cl.stateChanged(new ChangeEvent(focusEvent.getComponent()));
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

