/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.serialmgr.server;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.server.AdminFactoryImpl;
import com.sun.admin.cis.server.AdminServerImpl;
import com.sun.admin.cis.server.AdminServerLibrary;
import com.sun.admin.cis.service.logging.LogRecord;
import com.sun.admin.cis.service.logging.LogServiceFactoryImpl;
import com.sun.admin.cis.service.security.SecurityToken;
import com.sun.admin.serialmgr.common.SerialPortData;
import com.sun.admin.serialmgr.common.SerialPortException;
import com.sun.admin.serialmgr.server.SerialPortMgr;
import com.sun.admin.serialmgr.server.TokenString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Vector;

public class SerialPortMgrImpl
extends AdminFactoryImpl
implements SerialPortMgr {
    public static final String SERIALPORTMGR_APPNAME = "Serial Port Manager";
    public static final String DEFAULT_PMADM_PATH = "/usr/sbin/pmadm";
    public static final String DEFAULT_SACADM_PATH = "/usr/sbin/sacadm";
    public static final String DEFAULT_TTYADM_PATH = "/usr/sbin/ttyadm";
    public static final String DEFAULT_DEVTERM_DIR = "/dev/term";
    public static final String DEFAULT_ARCHITECTURE = "sparc";
    public static final String DEFAULT_TTYDEFS_FILE = "/etc/ttydefs";
    private static final int PM_NOTEXIST = 0;
    private static final int PM_ENABLED = 1;
    private static final int PM_DISABLED = 2;
    private static final int PM_STARTING = 3;
    private static final int PM_FAILED = 4;
    private AdminServerImpl admin_server;
    private Vector dataObjectVector;
    private Hashtable allPortData = new Hashtable();
    private LogServiceFactoryImpl logsvc;
    private SecurityToken security_token;
    private String pmadm_path;
    private String sacadm_path;
    private String ttyadm_path;
    private String devterm_dir;
    private String alternate_device_dirs;
    private String architecture;
    private String ttydefs_file;
    private boolean init_has_run = false;
    private static final String[] rights = new String[]{"solaris.admin.serialmgr.modify", "solaris.admin.serialmgr.delete"};

    public SerialPortMgrImpl() throws RemoteException, AdminException {
        super((AdminServerImpl)null);
    }

    public SerialPortMgrImpl(AdminServerImpl adminServerImpl) throws RemoteException, AdminException {
        super(adminServerImpl);
        super.setAppName(SERIALPORTMGR_APPNAME);
        super.setSingleton();
        this.admin_server = adminServerImpl;
        try {
            this.logsvc = (LogServiceFactoryImpl)adminServerImpl.getServiceImpl("com.sun.admin.cis.service.logging.LogServiceFactoryImpl");
        }
        catch (AdminException adminException) {}
        try {
            this.pmadm_path = adminServerImpl.getServerProperty("admin.server.serialmgr.pmadm.path");
            if (this.pmadm_path == null) {
                this.pmadm_path = DEFAULT_PMADM_PATH;
            }
        }
        catch (AdminException adminException) {
            this.pmadm_path = DEFAULT_PMADM_PATH;
        }
        try {
            this.sacadm_path = adminServerImpl.getServerProperty("admin.server.serialmgr.sacadm.path");
            if (this.sacadm_path == null) {
                this.sacadm_path = DEFAULT_SACADM_PATH;
            }
        }
        catch (AdminException adminException) {
            this.sacadm_path = DEFAULT_SACADM_PATH;
        }
        try {
            this.ttyadm_path = adminServerImpl.getServerProperty("admin.server.serialmgr.ttyadm.path");
            if (this.ttyadm_path == null) {
                this.ttyadm_path = DEFAULT_TTYADM_PATH;
            }
        }
        catch (AdminException adminException) {
            this.ttyadm_path = DEFAULT_TTYADM_PATH;
        }
        try {
            this.devterm_dir = adminServerImpl.getServerProperty("admin.server.serialmgr.devterm.dir");
            if (this.devterm_dir == null) {
                this.devterm_dir = DEFAULT_DEVTERM_DIR;
            }
        }
        catch (AdminException adminException) {
            this.devterm_dir = DEFAULT_DEVTERM_DIR;
        }
        try {
            this.alternate_device_dirs = adminServerImpl.getServerProperty("admin.server.serialmgr.alternate_dev.dir");
        }
        catch (AdminException adminException) {}
        try {
            this.architecture = AdminServerLibrary.getArchitecture();
            if (this.architecture == null) {
                this.architecture = DEFAULT_ARCHITECTURE;
            }
        }
        catch (AdminException adminException) {
            this.architecture = DEFAULT_ARCHITECTURE;
        }
        try {
            this.ttydefs_file = adminServerImpl.getServerProperty("admin.server.serialmgr.ttydefs_file");
            if (this.ttydefs_file == null) {
                this.ttydefs_file = DEFAULT_TTYDEFS_FILE;
            }
        }
        catch (AdminException adminException) {
            this.ttydefs_file = DEFAULT_TTYDEFS_FILE;
        }
        this.dataObjectVector = new Vector();
    }

    public Vector getSerialPorts(SecurityToken securityToken) throws RemoteException, SerialPortException {
        this.security_token = securityToken;
        try {
            this.admin_server.checkVerifier(securityToken, null);
        }
        catch (AdminException adminException) {
            throw new SerialPortException("EXM_VERF");
        }
        return this.synchronizedGetSerialPorts();
    }

    public SerialPortData getPortInfo(SecurityToken securityToken, String string) throws RemoteException, SerialPortException {
        this.security_token = securityToken;
        try {
            this.admin_server.checkVerifier(securityToken, null);
        }
        catch (AdminException adminException) {
            throw new SerialPortException("EXM_VERF");
        }
        return this.synchronizedGetPortInfo(string);
    }

    public void setPortInfo(SecurityToken securityToken, String string, SerialPortData serialPortData, boolean bl) throws RemoteException, SerialPortException {
        LogRecord logRecord;
        String[] stringArray;
        boolean bl2;
        block11: {
            this.security_token = securityToken;
            try {
                Object[] objectArray = new Object[]{string, serialPortData, new Boolean(bl)};
                this.admin_server.checkVerifier(securityToken, objectArray);
            }
            catch (AdminException adminException) {
                throw new SerialPortException("EXM_VERF");
            }
            bl2 = false;
            try {
                if (this.admin_server.checkRights(securityToken, "solaris.admin.serialmgr.modify")) break block11;
                try {
                    stringArray = new String[]{string};
                    logRecord = this.createLogRecord(1, "LM_5021", "LM_5027", stringArray);
                    this.writeLog(logRecord, false);
                }
                catch (AdminException adminException) {}
                bl2 = true;
            }
            catch (AdminException adminException) {
                try {
                    String[] stringArray2 = new String[]{string};
                    LogRecord logRecord2 = this.createLogRecord(1, "LM_5021", "LM_5027", stringArray2);
                    logRecord2.addExceptionToLog(adminException);
                    this.writeLog(logRecord2, false);
                }
                catch (AdminException adminException2) {}
                throw new SerialPortException("EXM_AUTHFAIL_SRV");
            }
        }
        if (bl2) {
            try {
                stringArray = new String[]{string};
                logRecord = this.createLogRecord(1, "LM_5021", "LM_5027", stringArray);
                this.writeLog(logRecord, false);
            }
            catch (AdminException adminException) {}
            throw new SerialPortException("EXM_MODAUTH_SRV", string);
        }
        this.synchronizedSetPortInfo(string, serialPortData, bl);
    }

    public Vector deletePort(SecurityToken securityToken, String string) throws RemoteException, SerialPortException {
        LogRecord logRecord;
        String[] stringArray;
        boolean bl;
        block11: {
            this.security_token = securityToken;
            try {
                Object[] objectArray = new Object[]{string};
                this.admin_server.checkVerifier(securityToken, objectArray);
            }
            catch (AdminException adminException) {
                throw new SerialPortException("EXM_VERF");
            }
            bl = false;
            try {
                if (this.admin_server.checkRights(securityToken, "solaris.admin.serialmgr.delete")) break block11;
                try {
                    stringArray = new String[]{string};
                    logRecord = this.createLogRecord(1, "LM_5021", "LM_5022", stringArray);
                    this.writeLog(logRecord, false);
                }
                catch (AdminException adminException) {}
                bl = true;
            }
            catch (AdminException adminException) {
                try {
                    String[] stringArray2 = new String[]{string};
                    LogRecord logRecord2 = this.createLogRecord(1, "LM_5021", "LM_5022", stringArray2);
                    logRecord2.addExceptionToLog(adminException);
                    this.writeLog(logRecord2, false);
                }
                catch (AdminException adminException2) {}
                throw new SerialPortException("EXM_AUTHFAIL_SRV");
            }
        }
        if (bl) {
            try {
                stringArray = new String[]{string};
                logRecord = this.createLogRecord(1, "LM_5021", "LM_5022", stringArray);
                this.writeLog(logRecord, false);
            }
            catch (AdminException adminException) {}
            throw new SerialPortException("EXM_DELAUTH_SRV", string);
        }
        return this.synchronizedDeletePort(string);
    }

    private synchronized Vector synchronizedGetSerialPorts() throws SerialPortException {
        if (!this.init_has_run) {
            this.initData();
        }
        return this.dataObjectVector;
    }

    private synchronized SerialPortData synchronizedGetPortInfo(String string) throws SerialPortException {
        SerialPortData serialPortData;
        if (!this.init_has_run) {
            this.initData();
        }
        if ((serialPortData = (SerialPortData)this.allPortData.get(string)) == null) {
            String[] stringArray = new String[]{string};
            try {
                this.writeLog(this.createLogRecord(0, "LM_5000", "LM_5001", stringArray), false);
            }
            catch (AdminException adminException) {}
            throw new SerialPortException("EXM_INV_SRV", string);
        }
        return serialPortData;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private synchronized void synchronizedSetPortInfo(String var1_1, SerialPortData var2_2, boolean var3_3) throws SerialPortException {
        block70: {
            block69: {
                if (var2_2 == null) {
                    throw new SerialPortException("EXM_NULL_DATA_SRV");
                }
                var4_4 = false;
                var5_5 = "";
                var6_6 = var2_2.getDeviceName();
                try {
                    if (AdminServerLibrary.isConsole(var6_6) <= 0) break block69;
                    var7_7 = new String[]{var6_6};
                    try {
                        this.writeLog(this.createLogRecord(1, "LM_5028", "LM_5029", var7_7), false);
                    }
                    catch (AdminException v0) {}
                    throw new SerialPortException("EXM_CONSOLE_SRV", var6_6);
                }
                catch (AdminException v1) {}
            }
            if (!var2_2.isEnableSet() && !var3_3) {
                var7_8 = new String[6];
                var8_11 = String.valueOf(this.pmadm_path) + " -d -p " + var2_2.getPortMonTag() + "  -s " + var2_2.getServiceTag();
                var7_8[0] = this.pmadm_path;
                var7_8[1] = "-d";
                var7_8[2] = "-p";
                var7_8[3] = var2_2.getPortMonTag();
                var7_8[4] = "-s";
                var7_8[5] = var2_2.getServiceTag();
                var9_13 = null;
                try {
                    var9_13 = this.runCommand(var7_8);
                }
                catch (Exception v2) {
                    try {
                        var10_15 = new String[]{var2_2.getPortName()};
                        var11_19 = this.createLogRecord(2, "LM_5056", "LM_5057", var10_15);
                        var11_19.addData("LM_LABEL_SERIAL_SEC_CMD", var8_11);
                        this.writeLog(var11_19, true);
                    }
                    catch (AdminException v3) {}
                    throw new SerialPortException("EXM_CMD_FAIL_SRV");
                }
                if (var9_13 != null && var9_13.size() > 0) {
                    var10_16 = (String)var9_13.elementAt(0);
                    if (var10_16.compareTo("Error") == 0) {
                        var11_20 = new String[]{var2_2.getPortName()};
                        try {
                            var12_27 = this.createLogRecord(2, "LM_5056", "LM_5057", var11_20);
                            var12_27.addData("LM_LABEL_SERIAL_SEC_CMD", var8_11);
                            var13_33 = 1;
                            while (var13_33 < var9_13.size()) {
                                var12_27.addData("  ", (String)var9_13.elementAt(var13_33));
                                ++var13_33;
                            }
                            this.writeLog(var12_27, true);
                        }
                        catch (AdminException v4) {}
                        throw new SerialPortException("EXM_CMD_FAIL_SRV");
                    }
                    var11_21 = new String[]{var2_2.getPortName()};
                    try {
                        var12_28 = this.createLogRecord(0, "LM_5058", "LM_5059", var11_21);
                        var12_28.addData("LM_LABEL_SERIAL_SEC_CMD", var8_11);
                        this.writeLog(var12_28, false);
                    }
                    catch (AdminException v5) {}
                } else {
                    var10_17 = new String[]{var2_2.getPortName()};
                    try {
                        var11_22 = this.createLogRecord(2, "LM_5056", "LM_5057", var10_17);
                        var11_22.addData("LM_LABEL_SERIAL_SEC_CMD", var8_11);
                        this.writeLog(var11_22, true);
                    }
                    catch (AdminException v6) {}
                    throw new SerialPortException("EXM_CMD_FAIL_SRV");
                }
                this.init_has_run = false;
                return;
            }
            try {
                switch (this.checkForPortmon(var2_2.getPortMonTag())) {
                    case -1: {
                        var7_9 /* !! */  = "1";
                        try {
                            var8_12 = new String[]{this.ttyadm_path, "-V"};
                            var9_14 = this.runCommand(var8_12);
                            if (var9_14 != null && var9_14.size() > 0 && (var10_18 = (String)var9_14.elementAt(0)).compareTo("Success") == 0) {
                                var11_23 = 1;
                                while (var11_23 < var9_14.size()) {
                                    var7_9 /* !! */  = (String)var9_14.elementAt(var11_23);
                                    ++var11_23;
                                }
                            }
                        }
                        catch (AdminException v7) {}
                        var8_12 = String.valueOf(this.sacadm_path) + " -a -n 2 -p " + var2_2.getPortMonTag() + "  -t ttymon -c /usr/lib/saf/ttymon -v " + (String)var7_9 /* !! */  + " -y \"Serial Ports\"";
                        try {
                            var9_14 = new String[]{this.sacadm_path, "-a", "-n", "2", "-p", var2_2.getPortMonTag(), "-t", "ttymon", "-c", "/usr/lib/saf/ttymon", "-v", var7_9 /* !! */ , "-y", "\"Serial Ports\""};
                            var10_18 = this.runCommand((String[])var9_14);
                            if (var10_18 == null || var10_18.size() <= 0) break;
                            var11_24 = (String)var10_18.elementAt(0);
                            if (var11_24.compareTo("Error") != 0) ** GOTO lbl109
                            var12_29 = new String[]{var1_1};
                            try {
                                var13_34 = this.createLogRecord(2, "LM_5030", "LM_5031", var12_29);
                                var13_34.addData("LM_LABEL_SERIAL_SEC_CMD", (String)var8_12);
                                var14_39 = 1;
                                while (var14_39 < var10_18.size()) {
                                    var13_34.addData("  ", (String)var10_18.elementAt(var14_39));
                                    ++var14_39;
                                }
                                this.writeLog(var13_34, true);
                            }
                            catch (AdminException v8) {}
                            var4_4 = true;
                            var5_5 = var8_12;
                            break;
lbl109:
                            // 1 sources

                            var12_30 = new String[]{var1_1};
                            try {
                                var13_35 = this.createLogRecord(0, "LM_5032", "LM_5033", var12_30);
                                var13_35.addData("LM_LABEL_SERIAL_SEC_CMD", (String)var8_12);
                                var14_40 = 1;
                                while (var14_40 < var10_18.size()) {
                                    var13_35.addData("  ", (String)var10_18.elementAt(var14_40));
                                    ++var14_40;
                                }
                                this.writeLog(var13_35, false);
                            }
                            catch (AdminException v9) {
                            }
                        }
                        catch (SerialPortException v10) {
                            var4_4 = true;
                            var5_5 = var8_12;
                        }
                        break;
                    }
                    case 2: {
                        var9_14 = String.valueOf(this.sacadm_path) + " -e -p " + var2_2.getPortMonTag();
                        try {
                            var10_18 = new String[]{this.sacadm_path, "-e", "-p", var2_2.getPortMonTag()};
                            var11_25 = this.runCommand((String[])var10_18);
                            if (var11_25 == null || var11_25.size() <= 0) break;
                            var12_31 = (String)var11_25.elementAt(0);
                            if (var12_31.compareTo("Error") != 0) ** GOTO lbl148
                            var13_36 = new String[]{var1_1};
                            try {
                                var14_41 = this.createLogRecord(2, "LM_5034", "LM_5035", var13_36);
                                var14_41.addData("LM_LABEL_SERIAL_SEC_CMD", (String)var9_14);
                                var15_45 = 1;
                                while (var15_45 < var11_25.size()) {
                                    var14_41.addData("  ", (String)var11_25.elementAt(var15_45));
                                    ++var15_45;
                                }
                                this.writeLog(var14_41, true);
                            }
                            catch (AdminException v11) {}
                            var4_4 = true;
                            break;
lbl148:
                            // 1 sources

                            var13_37 = new String[]{var1_1};
                            try {
                                var14_42 = this.createLogRecord(0, "LM_5036", "LM_5037", var13_37);
                                var14_42.addData("LM_LABEL_SERIAL_SEC_CMD", (String)var9_14);
                                var15_46 = 1;
                                while (var15_46 < var11_25.size()) {
                                    var14_42.addData("  ", (String)var11_25.elementAt(var15_46));
                                    ++var15_46;
                                }
                                this.writeLog(var14_42, false);
                            }
                            catch (AdminException v12) {
                            }
                        }
                        catch (SerialPortException v13) {
                            var4_4 = true;
                            var5_5 = var9_14;
                        }
                        break;
                    }
                    case 4: {
                        var10_18 = String.valueOf(this.sacadm_path) + " -s -p " + var2_2.getPortMonTag();
                        try {
                            var11_26 = new String[]{this.sacadm_path, "-s", "-p", var2_2.getPortMonTag()};
                            var12_32 = this.runCommand(var11_26);
                            if (var12_32 == null || var12_32.size() <= 0) break;
                            var13_38 = (String)var12_32.elementAt(0);
                            if (var13_38.compareTo("Error") != 0) ** GOTO lbl187
                            var14_43 = new String[]{var1_1};
                            try {
                                var15_47 = this.createLogRecord(2, "LM_5038", "LM_5039", var14_43);
                                var15_47.addData("LM_LABEL_SERIAL_SEC_CMD", (String)var10_18);
                                var16_49 = 1;
                                while (var16_49 < var12_32.size()) {
                                    var15_47.addData("  ", (String)var12_32.elementAt(var16_49));
                                    ++var16_49;
                                }
                                this.writeLog(var15_47, true);
                            }
                            catch (AdminException v14) {}
                            var4_4 = true;
                            break;
lbl187:
                            // 1 sources

                            var14_44 = new String[]{var1_1};
                            try {
                                var15_48 = this.createLogRecord(0, "LM_5040", "LM_5041", var14_44);
                                var15_48.addData("LM_LABEL_SERIAL_SEC_CMD", (String)var10_18);
                                var16_50 = 1;
                                while (var16_50 < var12_32.size()) {
                                    var15_48.addData("  ", (String)var12_32.elementAt(var16_50));
                                    ++var16_50;
                                }
                                this.writeLog(var15_48, false);
                            }
                            catch (AdminException v15) {
                            }
                        }
                        catch (SerialPortException v16) {
                            var4_4 = true;
                            var5_5 = var10_18;
                        }
                        break;
                    }
                    default: {
                        if (!var4_4) break block70;
                    }
                }
            }
            catch (SerialPortException v17) {
                var7_9 /* !! */  = new String[]{var1_1};
                try {
                    this.writeLog(this.createLogRecord(2, "LM_5042", "LM_5043", var7_9 /* !! */ ), true);
                }
                catch (AdminException v18) {}
            }
            if (!var4_4) break block70;
            throw new SerialPortException("EXM_SACADM_ERR_SRV", (Object)var5_5);
        }
        this.turn_on_port(var2_2, var3_3);
        var7_10 = -1;
        try {
            var7_10 = AdminServerLibrary.eepromSet(var6_6);
        }
        catch (AdminException v19) {
            try {
                var8_12 = new String[]{var2_2.getDeviceName()};
                this.writeLog(this.createLogRecord(2, "LM_5060", "LM_5061", var8_12), false);
            }
            catch (AdminException v20) {}
            throw new SerialPortException("EXM_EEPROM_SRV");
        }
        if (var7_10 < 0) {
            try {
                var8_12 = new String[]{var2_2.getDeviceName()};
                this.writeLog(this.createLogRecord(2, "LM_5060", "LM_5061", var8_12), false);
            }
            catch (AdminException v21) {}
            throw new SerialPortException("EXM_EEPROM_SRV");
        }
        try {
            var8_12 = new String[]{var1_1};
            var9_14 = this.createLogRecord(0, "LM_5062", "LM_5063", var8_12);
            var10_18 = (SerialPortData)this.allPortData.get(var1_1);
            var9_14.addData("LM_LABEL_SERIAL_OLD_DATA", var10_18.toString());
            this.writeLog((LogRecord)var9_14, false);
        }
        catch (AdminException v22) {}
        this.init_has_run = false;
    }

    private synchronized Vector synchronizedDeletePort(String string) throws SerialPortException {
        SerialPortData serialPortData = (SerialPortData)this.allPortData.get(string);
        String string2 = serialPortData.getPortMonTag();
        String string3 = serialPortData.getServiceTag();
        Vector vector = null;
        if (string2 != null && string3 != null) {
            Serializable serializable;
            Object object;
            String[] stringArray;
            String string4 = String.valueOf(this.pmadm_path) + " -r -p " + string2 + " -s " + string3;
            try {
                stringArray = new String[]{this.pmadm_path, "-r", "-p", string2, "-s", string3};
                vector = this.runCommand(stringArray);
            }
            catch (Exception exception) {
                try {
                    String[] stringArray2 = new String[]{string};
                    LogRecord logRecord = this.createLogRecord(2, "LM_5015", "LM_5016", stringArray2);
                    logRecord.addData("LM_LABEL_SERIAL_SEC_CMD", string4);
                    this.writeLog(logRecord, false);
                    throw new SerialPortException("EXM_DEL_SRV", string);
                }
                catch (AdminException adminException) {
                    throw new SerialPortException("EXM_DEL_SRV", string);
                }
            }
            if (vector != null && vector.size() > 1) {
                try {
                    stringArray = new String[]{string, (String)vector.elementAt(1)};
                    LogRecord logRecord = this.createLogRecord(2, "LM_5015", "LM_5017", stringArray);
                    logRecord.addData("LM_LABEL_SERIAL_SEC_CMD", string4);
                    this.writeLog(logRecord, false);
                }
                catch (AdminException adminException) {}
                throw new SerialPortException("EXM_DEL_SRV", string);
            }
            serialPortData.setDefaults(string);
            int n = 0;
            while (n < this.dataObjectVector.size()) {
                object = null;
                serializable = (SerialPortData)this.dataObjectVector.elementAt(n);
                object = ((SerialPortData)serializable).getPortName();
                if (object != null && ((String)object).compareTo(string) == 0) {
                    ((SerialPortData)serializable).setDefaults(string);
                    ((SerialPortData)serializable).setDeviceName(serialPortData.getDeviceName());
                    ((SerialPortData)serializable).setNoService();
                    ((SerialPortData)serializable).setDeleted();
                    this.dataObjectVector.setElementAt(serializable, n);
                    this.allPortData.put(string, serializable);
                    break;
                }
                ++n;
            }
            this.init_has_run = false;
            try {
                object = new String[]{string};
                serializable = this.createLogRecord(0, "LM_5019", "LM_5020", (String[])object);
                ((LogRecord)serializable).addData("LM_LABEL_SERIAL_PORTMONTAG", string2);
                ((LogRecord)serializable).addData("LM_LABEL_SERIAL_SERVICETAG", string3);
                this.writeLog((LogRecord)serializable, false);
            }
            catch (AdminException adminException) {}
            return this.dataObjectVector;
        }
        try {
            LogRecord logRecord = this.createLogRecord(2, "LM_5015", "LM_5018", null);
            this.writeLog(logRecord, false);
        }
        catch (AdminException adminException) {}
        throw new SerialPortException("EXM_DELNODATA_SRV", string);
    }

    private int checkForPortmon(String string) throws SerialPortException {
        Vector vector = null;
        String[] stringArray = new String[4];
        try {
            stringArray[0] = this.sacadm_path;
            stringArray[1] = "-l";
            stringArray[2] = "-t";
            stringArray[3] = "ttymon";
            vector = this.runCommand(stringArray);
        }
        catch (Exception exception) {
            try {
                String string2 = String.valueOf(stringArray[0]) + " " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3];
                String[] stringArray2 = new String[]{string2, "ttymon"};
                this.writeLog(this.createLogRecord(2, "LM_5064", "LM_5065", stringArray2), false);
            }
            catch (Exception exception2) {}
            throw new SerialPortException("EXM_PORTMONERR_SRV");
        }
        if (vector == null || vector.size() == 0) {
            return -1;
        }
        String string3 = (String)vector.elementAt(0);
        if (string3.compareTo("Error") == 0) {
            return -1;
        }
        int n = 1;
        while (n < vector.size()) {
            String string4 = (String)vector.elementAt(n);
            int n2 = string4.indexOf(string);
            if (n2 >= 0) {
                n2 = string4.indexOf("ENABLED");
                if (n2 > 0) {
                    return 1;
                }
                n2 = string4.indexOf("DISABLED");
                if (n2 > 0) {
                    return 2;
                }
                n2 = string4.indexOf("STARTING");
                if (n2 > 0) {
                    return 3;
                }
                n2 = string4.indexOf("FAILED");
                if (n2 > 0) {
                    return 4;
                }
                return -1;
            }
            ++n;
        }
        return -1;
    }

    private void turn_on_port(SerialPortData serialPortData, boolean bl) throws SerialPortException {
        String[] stringArray;
        Object object;
        Object object2;
        String string;
        String string2;
        if (serialPortData.isEnableSet() && !bl) {
            Object object3;
            String string3 = String.valueOf(this.pmadm_path) + "  -e -p " + serialPortData.getPortMonTag() + " -s " + serialPortData.getServiceTag();
            Vector vector = null;
            try {
                object3 = new String[]{this.pmadm_path, "-e", "-p", serialPortData.getPortMonTag(), "-s", serialPortData.getServiceTag()};
                vector = this.runCommand((String[])object3);
            }
            catch (Exception exception) {
                try {
                    String[] stringArray2 = new String[]{serialPortData.getPortName()};
                    LogRecord logRecord = this.createLogRecord(2, "LM_5044", "LM_5045", stringArray2);
                    logRecord.addData("LM_LABEL_SERIAL_SEC_CMD", string3);
                    this.writeLog(logRecord, true);
                }
                catch (AdminException adminException) {}
                throw new SerialPortException("EXM_CMD_FAIL_SRV");
            }
            if (vector != null && vector.size() > 0) {
                object3 = (String)vector.elementAt(0);
                if (((String)object3).compareTo("Error") == 0) {
                    String[] stringArray3 = new String[]{serialPortData.getPortName()};
                    try {
                        LogRecord logRecord = this.createLogRecord(2, "LM_5044", "LM_5045", stringArray3);
                        logRecord.addData("LM_LABEL_SERIAL_SEC_CMD", string3);
                        int n = 1;
                        while (n < vector.size()) {
                            logRecord.addData("  ", (String)vector.elementAt(n));
                            ++n;
                        }
                        this.writeLog(logRecord, true);
                    }
                    catch (AdminException adminException) {}
                    throw new SerialPortException("EXM_CMD_FAIL_SRV");
                }
                String[] stringArray4 = new String[]{serialPortData.getPortName()};
                try {
                    LogRecord logRecord = this.createLogRecord(0, "LM_5046", "LM_5047", stringArray4);
                    logRecord.addData("LM_LABEL_SERIAL_SEC_CMD", string3);
                    this.writeLog(logRecord, false);
                    return;
                }
                catch (AdminException adminException) {
                    return;
                }
            }
            object3 = new String[]{serialPortData.getPortName()};
            try {
                LogRecord logRecord = this.createLogRecord(2, "LM_5044", "LM_5045", (String[])object3);
                logRecord.addData("LM_LABEL_SERIAL_SEC_CMD", string3);
                this.writeLog(logRecord, true);
            }
            catch (AdminException adminException) {}
            throw new SerialPortException("EXM_CMD_FAIL_SRV");
        }
        if (serialPortData.isEnableSet() && bl) {
            serialPortData.tweakPortFlags();
        }
        if (!serialPortData.isEnableSet() && bl) {
            serialPortData.setDisableFlag();
        }
        int n = -1;
        try {
            n = AdminServerLibrary.checkTTYLabel(serialPortData.getTTYLabel(), this.ttydefs_file);
        }
        catch (AdminException adminException) {
            try {
                String[] stringArray5 = new String[]{serialPortData.getPortName(), serialPortData.getTTYLabel(), this.ttydefs_file};
                this.writeLog(this.createLogRecord(2, "LM_5048", "LM_5049", stringArray5), true);
            }
            catch (AdminException adminException2) {}
            throw new SerialPortException("EXM_TTYDEFS_SRV", (Object)this.ttydefs_file, serialPortData.getTTYLabel());
        }
        if (n < 0) {
            try {
                String[] stringArray6 = new String[]{serialPortData.getPortName(), serialPortData.getTTYLabel(), this.ttydefs_file};
                this.writeLog(this.createLogRecord(0, "LM_5050", "LM_5051", stringArray6), false);
            }
            catch (AdminException adminException) {}
            throw new SerialPortException("EXM_TTYDEFS_SRV", (Object)this.ttydefs_file, serialPortData.getTTYLabel());
        }
        String string4 = String.valueOf(this.ttyadm_path) + " -d " + serialPortData.getDeviceName() + " -l " + serialPortData.getTTYLabel() + " -s " + serialPortData.getServiceCmdLine();
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(this.ttyadm_path);
        vector.addElement("-d");
        vector.addElement(serialPortData.getDeviceName());
        vector.addElement("-l");
        vector.addElement(serialPortData.getTTYLabel());
        vector.addElement("-s");
        vector.addElement(serialPortData.getServiceCmdLine());
        String string5 = serialPortData.getTTYFlags();
        if (string5 != null && string5.length() > 0) {
            if (string5.indexOf("b") >= 0) {
                string4 = String.valueOf(string4) + " -b ";
                vector.addElement("-b");
            }
            if (string5.indexOf("c") >= 0) {
                string4 = String.valueOf(string4) + " -c ";
                vector.addElement("-c");
            }
            if (string5.indexOf("I") >= 0) {
                string4 = String.valueOf(string4) + " -I ";
                vector.addElement("-I");
            }
        }
        if ((string2 = serialPortData.getModules()) != null && string2.length() > 0) {
            string4 = String.valueOf(string4) + " -m " + string2;
            vector.addElement("-m");
            vector.addElement(string2);
        }
        if ((string2 = serialPortData.getPrompt()) != null && string2.length() > 0) {
            string4 = String.valueOf(string4) + " -p " + string2;
            vector.addElement("-p");
            vector.addElement(string2);
        }
        if ((string2 = serialPortData.getTimeoutVal()) != null && string2.length() > 0) {
            string4 = String.valueOf(string4) + " -t " + string2;
            vector.addElement("-t");
            vector.addElement(string2);
        }
        if ((string2 = serialPortData.getSoftwareCarrier()) != null && string2.length() > 0) {
            string4 = String.valueOf(string4) + " -S " + string2;
            vector.addElement("-S");
            vector.addElement(string2);
        }
        if ((string2 = serialPortData.getTerminalType()) != null && string2.length() > 0) {
            string4 = String.valueOf(string4) + " -T " + string2;
            vector.addElement("-T");
            vector.addElement(string2);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Vector vector2 = null;
        String string6 = "";
        try {
            vector2 = this.runCommand((String[])objectArray);
        }
        catch (SerialPortException serialPortException) {
            try {
                String[] stringArray7 = new String[]{serialPortData.getPortName()};
                LogRecord logRecord = this.createLogRecord(2, "LM_5052", "LM_5053", stringArray7);
                logRecord.addData("LM_LABEL_SERIAL_SEC_CMD", string4);
                this.writeLog(logRecord, true);
            }
            catch (AdminException adminException) {}
            throw new SerialPortException("EXM_SACADM_ERR_SRV", string4);
        }
        if (vector2 != null && vector2.size() > 0) {
            string = (String)vector2.elementAt(0);
            if (string.compareTo("Error") == 0) {
                try {
                    String[] stringArray8 = new String[]{serialPortData.getPortName()};
                    LogRecord logRecord = this.createLogRecord(2, "LM_5052", "LM_5053", stringArray8);
                    logRecord.addData("LM_LABEL_SERIAL_SEC_CMD", string4);
                    int n2 = 1;
                    while (n2 < vector2.size()) {
                        logRecord.addData("  ", (String)vector2.elementAt(n2));
                        ++n2;
                    }
                    this.writeLog(logRecord, true);
                }
                catch (AdminException adminException) {}
                throw new SerialPortException("EXM_SACADM_ERR_SRV", string4);
            }
            if (vector2.size() > 1) {
                string6 = (String)vector2.elementAt(1);
            }
        } else {
            try {
                String[] stringArray9 = new String[]{serialPortData.getPortName()};
                LogRecord logRecord = this.createLogRecord(2, "LM_5052", "LM_5053", stringArray9);
                logRecord.addData("LM_LABEL_SERIAL_SEC_CMD", string4);
                this.writeLog(logRecord, true);
            }
            catch (AdminException adminException) {}
            throw new SerialPortException("EXM_SACADM_ERR_SRV", string4);
        }
        string2 = serialPortData.getOldPortMonTag();
        if (string2 != null && string2.length() > 0 && (string = serialPortData.getOldServiceTag()) != null && string.length() > 0) {
            try {
                object2 = new String[]{this.pmadm_path, "-r", "-p", string2, "-s", string};
                this.runCommand((String[])object2);
            }
            catch (AdminException adminException) {}
        }
        string = String.valueOf(this.pmadm_path) + " -a " + " -p " + serialPortData.getPortMonTag() + " -s " + serialPortData.getServiceTag() + " -i " + serialPortData.getIdentity();
        vector = new Vector();
        vector.addElement(this.pmadm_path);
        vector.addElement("-a");
        vector.addElement("-p");
        vector.addElement(serialPortData.getPortMonTag());
        vector.addElement("-s");
        vector.addElement(serialPortData.getServiceTag());
        vector.addElement("-i");
        vector.addElement(serialPortData.getIdentity());
        object2 = "1";
        try {
            object = new String[]{this.ttyadm_path, "-V"};
            vector2 = this.runCommand((String[])object);
            if (vector2 != null && vector2.size() > 0 && (stringArray = (String)vector2.elementAt(0)).compareTo("Success") == 0) {
                int n3 = 1;
                while (n3 < vector2.size()) {
                    object2 = (String)vector2.elementAt(n3);
                    ++n3;
                }
            }
        }
        catch (AdminException adminException) {}
        string = String.valueOf(string) + " -v " + (String)object2;
        vector.addElement("-v");
        vector.addElement(object2);
        string2 = serialPortData.getPortFlags();
        if (string2 != null && string2.length() > 0) {
            string = String.valueOf(string) + " -f " + string2;
            vector.addElement("-f");
            vector.addElement(string2);
        }
        string = String.valueOf(string) + " -m \"" + string6 + "\"";
        vector.addElement("-m");
        vector.addElement(string6);
        string2 = serialPortData.getComment();
        if (string2 != null && string2.length() > 0) {
            string = String.valueOf(string) + " -y " + string2;
            vector.addElement("-y");
            vector.addElement(string2);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        try {
            vector2 = this.runCommand((String[])objectArray);
        }
        catch (AdminException adminException) {
            try {
                object = new String[]{serialPortData.getPortName()};
                stringArray = this.createLogRecord(2, "LM_5054", "LM_5055", (String[])object);
                stringArray.addData("LM_LABEL_SERIAL_SEC_CMD", string);
                this.writeLog((LogRecord)stringArray, true);
            }
            catch (AdminException adminException3) {}
            throw new SerialPortException("EXM_SACADM_ERR_SRV", string);
        }
        if (vector2 != null && vector2.size() > 0) {
            object = (String)vector2.elementAt(0);
            if (object.compareTo("Error") == 0) {
                try {
                    stringArray = new String[]{serialPortData.getPortName()};
                    LogRecord logRecord = this.createLogRecord(2, "LM_5054", "LM_5055", stringArray);
                    logRecord.addData("LM_LABEL_SERIAL_SEC_CMD", string);
                    int n4 = 1;
                    while (n4 < vector2.size()) {
                        logRecord.addData("  ", (String)vector2.elementAt(n4));
                        ++n4;
                    }
                    this.writeLog(logRecord, true);
                }
                catch (AdminException adminException) {}
                throw new SerialPortException("EXM_SACADM_ERR_SRV", string);
            }
        } else {
            try {
                object = new String[]{serialPortData.getPortName()};
                stringArray = this.createLogRecord(2, "LM_5054", "LM_5055", (String[])object);
                stringArray.addData("LM_LABEL_SERIAL_SEC_CMD", string);
                this.writeLog((LogRecord)stringArray, true);
            }
            catch (AdminException adminException) {}
            throw new SerialPortException("EXM_SACADM_ERR_SRV", string);
        }
    }

    private Vector runCommand(String[] stringArray) throws SerialPortException {
        String string;
        Vector<String> vector = new Vector<String>();
        Process process = null;
        Runtime runtime = null;
        InputStream inputStream = null;
        runtime = Runtime.getRuntime();
        try {
            process = runtime.exec(stringArray);
        }
        catch (IOException iOException) {
            throw new SerialPortException("");
        }
        catch (SecurityException securityException) {
            throw new SerialPortException("EXM_SEC_SRV");
        }
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            inputStream = process.getInputStream();
            while ((n = inputStream.read()) > 0) {
                stringBuffer.append((char)n);
                ++n2;
            }
        }
        catch (IOException iOException) {}
        if (n2 == 0) {
            String string2;
            InputStream inputStream2 = null;
            StringBuffer stringBuffer2 = new StringBuffer();
            try {
                inputStream2 = process.getErrorStream();
                while ((n = inputStream2.read()) > 0) {
                    stringBuffer2.append((char)n);
                    ++n2;
                }
            }
            catch (IOException iOException) {
                throw new SerialPortException("");
            }
            if (n2 == 0) {
                vector.addElement("Success");
                return vector;
            }
            String string3 = new String(stringBuffer2);
            n2 = string3.indexOf("\n");
            int n3 = 0;
            int n4 = 0;
            vector.addElement("Error");
            while (n2 != -1) {
                n4 = n2;
                string2 = string3.substring(n3, n4);
                if (string2.length() > 0) {
                    vector.addElement(string2);
                }
                if ((n3 = n4 + 1) >= string3.length()) break;
                n2 = string3.indexOf("\n", n3);
            }
            if (n3 < string3.length() && (string2 = string3.substring(n3)).length() > 0) {
                vector.addElement(string2);
            }
            return vector;
        }
        String string4 = new String(stringBuffer);
        vector.addElement("Success");
        n2 = string4.indexOf("\n");
        int n5 = 0;
        int n6 = 0;
        while (n2 != -1) {
            n6 = n2;
            string = string4.substring(n5, n6);
            if (string.length() > 0) {
                vector.addElement(string);
            }
            if ((n5 = n6 + 1) >= string4.length()) break;
            n2 = string4.indexOf("\n", n5);
        }
        if (n5 < string4.length() && (string = string4.substring(n5)).length() > 0) {
            vector.addElement(string);
        }
        return vector;
    }

    private void initData() throws SerialPortException {
        Vector vector = null;
        Vector vector2 = null;
        if (this.dataObjectVector.size() > 0) {
            this.dataObjectVector.removeAllElements();
        }
        if (!this.allPortData.isEmpty()) {
            this.allPortData.clear();
        }
        if ((vector = this.readDirs()) == null) {
            try {
                LogRecord logRecord = this.createLogRecord(1, "LM_5002", "LM_5003", null);
                logRecord.addData("LM_LABEL_SERIAL_DEV_DIR", this.devterm_dir);
                logRecord.addData("LM_LABEL_SERIAL_ALT_DEV_DIR", this.alternate_device_dirs);
                this.writeLog(logRecord, true);
            }
            catch (AdminException adminException) {}
            throw new SerialPortException("EXM_NODEV_SRV");
        }
        vector2 = this.listSerialDevices();
        this.constructData(vector, vector2);
        this.init_has_run = false;
    }

    private void constructData(Vector vector, Vector vector2) {
        String string = null;
        File file = null;
        int n = 0;
        while (n < vector.size()) {
            int n2 = 0;
            String string2 = (String)vector.elementAt(n);
            if (string2 != null && string2.length() > 0) {
                String[] stringArray;
                int n3 = 0;
                while (vector2 != null && n3 < vector2.size()) {
                    String string3 = (String)vector2.elementAt(n3);
                    if (string3 != null && string3.length() > 0) {
                        block15: {
                            try {
                                file = new File(string2);
                            }
                            catch (Exception exception) {
                                stringArray = new String[]{string2};
                                try {
                                    this.writeLog(this.createLogRecord(1, "LM_5004", "LM_5005", stringArray), false);
                                }
                                catch (AdminException adminException) {}
                                n2 = -1;
                                break;
                            }
                            try {
                                if (file != null && file.exists()) break block15;
                                stringArray = new String[]{string2};
                                try {
                                    this.writeLog(this.createLogRecord(1, "LM_5004", "LM_5005", stringArray), false);
                                }
                                catch (AdminException adminException) {}
                                n2 = -1;
                            }
                            catch (Exception exception) {
                                stringArray = new String[]{string2};
                                try {
                                    this.writeLog(this.createLogRecord(1, "LM_5004", "LM_5005", stringArray), false);
                                }
                                catch (AdminException adminException) {}
                                n2 = -1;
                            }
                            break;
                        }
                        n2 = this.parseAdmString(string2, string3);
                        if (n2 > 0) break;
                    }
                    ++n3;
                }
                if (n2 != -1 && n2 == 0) {
                    int n4 = string2.lastIndexOf("/");
                    string = n4 >= 0 ? string2.substring(n4 + 1) : string2;
                    stringArray = new SerialPortData(string);
                    stringArray.setDefaults(string);
                    stringArray.setDeleted();
                    stringArray.setDeviceName(string2);
                    this.dataObjectVector.addElement(stringArray);
                    this.allPortData.put(string, stringArray);
                }
            }
            ++n;
        }
    }

    private int parseAdmString(String string, String string2) {
        String string3;
        String string4;
        String[] stringArray;
        block12: {
            if (string2.indexOf(String.valueOf(string) + ":") < 0) {
                return 0;
            }
            stringArray = new String[20];
            int n = 0;
            while (n < 20) {
                stringArray[n] = "";
                ++n;
            }
            int n2 = string.lastIndexOf("/");
            string4 = n2 >= 0 ? string.substring(n2 + 1) : string;
            int n3 = 0;
            String string5 = TokenString.getToken(string2, ":");
            while (string5 != null && n3 < 20) {
                int n4;
                stringArray[n3] = string5;
                string5 = TokenString.getToken(null, ":");
                if (string5 != null && (n4 = stringArray[n3].lastIndexOf("\\")) > 0 && n4 == stringArray[n3].length() - 1) {
                    String string6 = stringArray[n3].substring(0, n4);
                    stringArray[n3] = string6 = string6.concat(":");
                    int n5 = n3;
                    stringArray[n5] = String.valueOf(stringArray[n5]) + string5;
                    string5 = TokenString.getToken(null, ":");
                }
                ++n3;
            }
            if (string5 != null && n3 >= 20) {
                String[] stringArray2 = new String[]{string2};
                try {
                    this.writeLog(this.createLogRecord(2, "LM_5054", "LM_5014", stringArray2), true);
                }
                catch (AdminException adminException) {}
                return 0;
            }
            if (stringArray[8] != null && stringArray[8].length() != 0) {
                try {
                    if (AdminServerLibrary.doStat(stringArray[8]) >= 0) break block12;
                    String[] stringArray3 = new String[]{stringArray[8]};
                    try {
                        this.writeLog(this.createLogRecord(2, "LM_5013", "LM_5014", stringArray3), true);
                    }
                    catch (AdminException adminException) {}
                    return 0;
                }
                catch (AdminException adminException) {}
            }
        }
        stringArray[19] = stringArray[19] != null && stringArray[19].length() > 1 ? (string3 = stringArray[19].substring(1)) : "";
        SerialPortData serialPortData = new SerialPortData(string4);
        serialPortData.fillData(stringArray);
        this.dataObjectVector.addElement(serialPortData);
        this.allPortData.put(string4, serialPortData);
        return 1;
    }

    private Vector listSerialDevices() throws SerialPortException {
        String string;
        String string2 = String.valueOf(this.pmadm_path) + " -L -t ttymon";
        Vector<String> vector = new Vector<String>();
        Process process = null;
        Runtime runtime = null;
        InputStream inputStream = null;
        runtime = Runtime.getRuntime();
        try {
            process = runtime.exec(string2);
        }
        catch (IOException iOException) {
            try {
                LogRecord logRecord = this.createLogRecord(2, "LM_5023", "LM_5024", null);
                logRecord.addData("LM_LABEL_SERIAL_SEC_CMD", string2);
                this.writeLog(logRecord, false);
            }
            catch (AdminException adminException) {}
            throw new SerialPortException("EXM_IO_SRV");
        }
        catch (SecurityException securityException) {
            try {
                LogRecord logRecord = this.createLogRecord(1, "LM_5006", "LM_5007", null);
                logRecord.addData("LM_LABEL_SERIAL_SEC_CMD", string2);
                this.writeLog(logRecord, false);
            }
            catch (AdminException adminException) {}
            throw new SerialPortException("EXM_SEC_SRV");
        }
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            inputStream = process.getInputStream();
            while ((n = inputStream.read()) > 0) {
                stringBuffer.append((char)n);
                ++n2;
            }
        }
        catch (IOException iOException) {}
        if (n2 == 0) {
            InputStream inputStream2 = null;
            StringBuffer stringBuffer2 = new StringBuffer();
            try {
                inputStream2 = process.getErrorStream();
                while ((n = inputStream.read()) > 0) {
                    stringBuffer2.append((char)n);
                    ++n2;
                }
            }
            catch (IOException iOException) {}
            if (n2 == 0) {
                try {
                    this.writeLog(this.createLogRecord(0, "LM_5008", "LM_5009", null), false);
                }
                catch (AdminException adminException) {}
                return null;
            }
            String string3 = new String(stringBuffer2);
            String[] stringArray = new String[]{string3};
            try {
                LogRecord logRecord = this.createLogRecord(2, "LM_5010", "LM_5011", stringArray);
                logRecord.addData("LM_LABEL_SERIAL_SEC_CMD", string2);
                this.writeLog(logRecord, false);
            }
            catch (AdminException adminException) {}
            return null;
        }
        String string4 = new String(stringBuffer);
        n2 = string4.indexOf("\n");
        int n3 = 0;
        int n4 = 0;
        while (n2 != -1) {
            n4 = n2;
            string = string4.substring(n3, n4);
            if (string.length() > 0) {
                vector.addElement(string);
            }
            if ((n3 = n4 + 1) >= string4.length()) break;
            n2 = string4.indexOf("\n", n3);
        }
        if (n3 < string4.length() && (string = string4.substring(n3)).length() > 0) {
            vector.addElement(string);
        }
        return vector;
    }

    private Vector readDirs() throws SerialPortException {
        Object object;
        String[] stringArray;
        int n = 0;
        Vector vector = this.parseDirString(this.alternate_device_dirs);
        Vector<Object> vector2 = new Vector<Object>();
        boolean bl = false;
        File file = null;
        try {
            file = new File(this.devterm_dir);
        }
        catch (SecurityException securityException) {
            stringArray = new String[]{this.devterm_dir};
            try {
                this.writeLog(this.createLogRecord(1, "LM_5006", "LM_5012", stringArray), false);
            }
            catch (AdminException adminException) {}
            bl = true;
        }
        try {
            if (file.exists() && file.isDirectory() && (stringArray = file.list()) != null && stringArray.length > 0) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    object = String.valueOf(this.devterm_dir) + File.separator + stringArray[n2];
                    vector2.addElement(object);
                    ++n;
                    ++n2;
                }
            }
        }
        catch (SecurityException securityException) {
            stringArray = new String[]{this.devterm_dir};
            try {
                this.writeLog(this.createLogRecord(1, "LM_5006", "LM_5012", stringArray), false);
            }
            catch (AdminException adminException) {}
            bl = true;
        }
        if (vector != null && vector.size() > 0) {
            int n3 = 0;
            while (n3 < vector.size()) {
                String[] stringArray2;
                try {
                    String[] stringArray3;
                    stringArray2 = (String[])vector.elementAt(n3);
                    object = new File((String)stringArray2);
                    if (((File)object).exists() && ((File)object).isDirectory() && (stringArray3 = ((File)object).list()) != null && stringArray3.length > 0) {
                        int n4 = 0;
                        while (n4 < stringArray3.length) {
                            String string = String.valueOf(stringArray2) + File.separator + stringArray3[n3];
                            vector2.addElement(string);
                            ++n;
                            ++n4;
                        }
                    }
                }
                catch (SecurityException securityException) {
                    stringArray2 = new String[]{(String)vector.elementAt(n3)};
                    try {
                        this.writeLog(this.createLogRecord(1, "LM_5006", "LM_5012", stringArray2), false);
                    }
                    catch (AdminException adminException) {}
                    bl = true;
                }
                ++n3;
            }
        }
        if (n == 0 && bl) {
            throw new SerialPortException("EXM_SEC_SRV");
        }
        if (n == 0) {
            return null;
        }
        return vector2;
    }

    private Vector parseDirString(String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        int n = 0;
        if (string == null || string.length() == 0) {
            return null;
        }
        string2 = TokenString.getToken(string, ":");
        while (string2 != null) {
            vector.addElement(string2);
            ++n;
            string2 = TokenString.getToken(null, ":");
        }
        if (n == 0) {
            return null;
        }
        return vector;
    }

    private LogRecord createLogRecord(int n, String string, String string2, String[] stringArray) throws AdminException {
        LogRecord logRecord = new LogRecord();
        logRecord.setBasicLogInfo("LM_SERIAL_APP_NAME", 0, n, this.admin_server.getUserName(this.security_token), this.admin_server.getClientHost(this.security_token), this.admin_server.getHostName(), string, this.admin_server.getMgmtScope(this.security_token));
        logRecord.setDetailedMesgId(string2);
        if (stringArray != null && stringArray.length > 0) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                logRecord.addSubstArg(stringArray[n2]);
                ++n2;
            }
        }
        return logRecord;
    }

    private void writeLog(LogRecord logRecord, boolean bl) {
        if (this.logsvc == null) {
            try {
                this.logsvc = (LogServiceFactoryImpl)this.admin_server.getServiceImpl("com.sun.admin.cis.service.logging.LogServiceFactoryImpl");
            }
            catch (AdminException adminException) {
                return;
            }
        }
        try {
            this.logsvc.writeRecord(logRecord, bl);
            return;
        }
        catch (AdminException adminException) {
            return;
        }
    }

    protected String[] myAuthRights() {
        return rights;
    }
}

