/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.hostmgr.client.ListViewEvent;
import com.sun.admin.hostmgr.client.ListViewListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public abstract class ListView
extends JScrollPane {
    public static final int ICON_VIEW = 1;
    public static final int TABLE_VIEW = 2;
    public static final int ASCEND_SORT = 3;
    public static final int DESCEND_SORT = 4;
    public static final int NO_SORT = 5;
    public static final String HOST_COLUMN_HOSTNAME = "hostListComputerName";
    public static final String HOST_COLUMN_IPADDRESS = "hostListIPAddress";
    public static final String HOST_COLUMN_COMMENT = "hostListComment";
    public static final String HOST_COLUMN_ALIASES = "hostListAliases";
    public static final String HOST_COLUMN_ENETADDRESS = "hostListEnetAddress";
    public static final String NETWORK_COLUMN_NETWORKNAME = "networkListNetworkName";
    public static final String NETWORK_COLUMN_IPADDRESS = "networkListIPAddress";
    public static final String NETWORK_COLUMN_ALIASES = "networkListAliases";
    public static final String NETWORK_COLUMN_COMMENT = "networkListComment";
    public static final String NETWORK_COLUMN_NETMASK = "networkListNetmask";
    private Vector listeners = new Vector();

    protected abstract int getViewType();

    protected abstract int getSortOrder();

    protected abstract String getSortAttribute();

    protected abstract Vector getAvailableSortAttributes();

    protected abstract void populate();

    protected abstract void append(Vector var1);

    protected abstract void clear();

    protected abstract void setDataCache(Vector var1);

    protected abstract void selectAll();

    protected abstract void sortAscending();

    protected abstract void sortDescending();

    protected abstract void sortByAttribute(String var1);

    protected abstract void find(String var1);

    protected abstract void find(Object var1);

    protected abstract void clearSelection();

    protected abstract Vector getSelected();

    protected abstract void setSelected(Vector var1);

    protected abstract int getNumSelections();

    public ListView() {
        this.addMouseListener(new ViewMouseListener());
    }

    protected void fireItemPressed(int n) {
        ListViewEvent listViewEvent = new ListViewEvent(this, n, this.getViewType(), this.getSortOrder(), this.getSortAttribute(), this.getAvailableSortAttributes(), null);
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            ListViewListener listViewListener = (ListViewListener)this.listeners.elementAt(n2);
            listViewListener.itemPressed(listViewEvent);
            ++n2;
        }
    }

    public void fireViewChanged() {
        ListViewEvent listViewEvent = new ListViewEvent(this, 0, this.getViewType(), this.getSortOrder(), this.getSortAttribute(), this.getAvailableSortAttributes(), null);
        int n = 0;
        while (n < this.listeners.size()) {
            ListViewListener listViewListener = (ListViewListener)this.listeners.elementAt(n);
            listViewListener.viewChanged(listViewEvent);
            ++n;
        }
    }

    protected void fireSortChanged() {
        ListViewEvent listViewEvent = new ListViewEvent(this, 0, this.getViewType(), this.getSortOrder(), this.getSortAttribute(), this.getAvailableSortAttributes(), null);
        int n = 0;
        while (n < this.listeners.size()) {
            ListViewListener listViewListener = (ListViewListener)this.listeners.elementAt(n);
            listViewListener.sortChanged(listViewEvent);
            ++n;
        }
    }

    protected void firePopupTriggered(MouseEvent mouseEvent) {
        ListViewEvent listViewEvent = new ListViewEvent(this, 0, this.getViewType(), this.getSortOrder(), this.getSortAttribute(), this.getAvailableSortAttributes(), mouseEvent.getPoint());
        int n = 0;
        while (n < this.listeners.size()) {
            ListViewListener listViewListener = (ListViewListener)this.listeners.elementAt(n);
            listViewListener.popupTriggered(listViewEvent);
            ++n;
        }
    }

    public void configureHeader() {
    }

    public void openSelected() {
    }

    public synchronized void addListViewListener(ListViewListener listViewListener) {
        this.listeners.addElement(listViewListener);
    }

    public synchronized void removeListViewListener(ListViewListener listViewListener) {
        this.listeners.removeElement(listViewListener);
    }

    class ViewMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (!mouseEvent.isControlDown()) {
                    ListView.this.clearSelection();
                }
                ListView.this.firePopupTriggered(mouseEvent);
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                ListView.this.clearSelection();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (!mouseEvent.isControlDown()) {
                    ListView.this.clearSelection();
                }
                ListView.this.firePopupTriggered(mouseEvent);
                return;
            }
        }

        ViewMouseListener() {
            ListView.this = ListView.this;
        }
    }
}

