/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.client.ContentPanel;
import com.sun.admin.hostmgr.client.HostActionsListener;
import com.sun.admin.hostmgr.client.HostContentPanel;
import com.sun.admin.hostmgr.client.HostIconView;
import com.sun.admin.hostmgr.client.HostMgrTree;
import com.sun.admin.hostmgr.client.HostMgrTreeEvent;
import com.sun.admin.hostmgr.client.HostMgrTreeListener;
import com.sun.admin.hostmgr.client.HostTableView;
import com.sun.admin.hostmgr.client.ListView;
import com.sun.admin.hostmgr.client.ListViewEvent;
import com.sun.admin.hostmgr.client.ListViewListener;
import com.sun.admin.hostmgr.client.Main;
import com.sun.admin.hostmgr.client.NetworkContentPanel;
import com.sun.admin.hostmgr.client.NetworkIconView;
import com.sun.admin.hostmgr.client.NetworkTableView;
import com.sun.admin.hostmgr.client.TreeNodeData;
import com.sun.admin.hostmgr.common.HostData;
import com.sun.admin.hostmgr.common.NetworkData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class HostMgrTree
extends JTree {
    private DefaultTreeModel treeModel;
    private ContentPanel currentContentPanel;
    private ListViewListener listViewListener;
    private ImageIcon programIcon;
    private ImageIcon staticNetworkIcon;
    private ImageIcon staticSubnetIcon;
    private ImageIcon dynamicNetworkIcon;
    private ImageIcon dynamicSubnetIcon;
    private ImageIcon allHostsIcon;
    private final TreeCellRenderer oldRenderer = this.getCellRenderer();
    private Vector listeners = new Vector();

    public HostMgrTree() {
        ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
        this.programIcon = Main.getApp().loadImageIcon(ResourceStrings.getString(resourceBundle, "SmallProgramGif"), "");
        this.staticNetworkIcon = Main.getApp().loadImageIcon(ResourceStrings.getString(resourceBundle, "SmallStaticNetworkGif"), "");
        this.staticSubnetIcon = Main.getApp().loadImageIcon(ResourceStrings.getString(resourceBundle, "SmallStaticSubnetworkGif"), "");
        this.dynamicNetworkIcon = Main.getApp().loadImageIcon(ResourceStrings.getString(resourceBundle, "SmallDynamicNetworkGif"), "");
        this.dynamicSubnetIcon = Main.getApp().loadImageIcon(ResourceStrings.getString(resourceBundle, "SmallDynamicSubnetworkGif"), "");
        this.allHostsIcon = Main.getApp().loadImageIcon(ResourceStrings.getString(resourceBundle, "SmallAllHostsGif"), "");
        NetworkContentPanel networkContentPanel = new NetworkContentPanel();
        networkContentPanel.addView(new NetworkIconView());
        networkContentPanel.addView(new NetworkTableView());
        String string = ResourceStrings.getString(resourceBundle, "toolname");
        TreeNodeData treeNodeData = new TreeNodeData(string, networkContentPanel, null, this.programIcon, "main");
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(treeNodeData);
        networkContentPanel.setTreeNode(defaultMutableTreeNode);
        this.currentContentPanel = networkContentPanel;
        this.setModel(new HostMgrTreeModel(defaultMutableTreeNode));
        this.setCellRenderer(new HostMgrTreeCellRenderer());
        TreeSelectionModel treeSelectionModel = this.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.collapseRow(0);
        this.listViewListener = new 1();
        this.currentContentPanel.addListViewListener(this.listViewListener);
        this.addTreeSelectionListener(new 2());
        this.registerKeyboardAction(new HostActionsListener(), "Delete", KeyStroke.getKeyStroke(127, 0, true), 1);
    }

    private void onTreeSelection(TreeSelectionEvent treeSelectionEvent) {
        Serializable serializable;
        Object object;
        if (this.isSelectionEmpty()) {
            return;
        }
        Main.getApp().getClientComm().waitOn();
        Main.getApp().getClientComm().setAppFocus(Main.getApp());
        this.currentContentPanel.removeListViewListener(this.listViewListener);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
        TreeNodeData treeNodeData = (TreeNodeData)defaultMutableTreeNode.getUserObject();
        this.currentContentPanel = treeNodeData.getContentPanel();
        this.fireContentPanelChanged();
        this.currentContentPanel.repaintView();
        Main.getApp().setContentPanel(this.currentContentPanel);
        Main.getApp().setHelp(treeNodeData.getHelpName());
        this.currentContentPanel.addListViewListener(this.listViewListener);
        Main.getApp().getClientComm().waitOff();
        if (this.currentContentPanel instanceof HostContentPanel && ((TreeNodeData)(object = (TreeNodeData)(serializable = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject())).getNetworkData() == null) {
            if (!this.currentContentPanel.isRefreshed()) {
                ActionEvent actionEvent = new ActionEvent(Main.getApp().getTree(), 1001, "FilterInitialView");
                HostActionsListener hostActionsListener = new HostActionsListener(false);
                hostActionsListener.actionPerformed(actionEvent);
            }
            return;
        }
        if (!this.currentContentPanel.isRefreshed()) {
            serializable = new ActionEvent(Main.getApp().getTree(), 1001, "Refresh");
            object = new HostActionsListener(false);
            ((HostActionsListener)object).actionPerformed((ActionEvent)serializable);
        }
    }

    public ContentPanel getCurrentContentPanel() {
        return this.currentContentPanel;
    }

    public void appendToNode(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector) {
        HostMgrTreeModel hostMgrTreeModel = (HostMgrTreeModel)this.getModel();
        defaultMutableTreeNode.getChildCount();
        int n = 0;
        while (n < vector.size()) {
            ImageIcon imageIcon;
            ContentPanel contentPanel;
            String string;
            NetworkData networkData = (NetworkData)vector.elementAt(n);
            if (networkData.getNetworkAddress().length() > 0) {
                if (networkData.isNetwork()) {
                    string = "main_tree_net";
                    contentPanel = new NetworkContentPanel();
                    contentPanel.addView(new NetworkIconView());
                    contentPanel.addView(new NetworkTableView());
                    imageIcon = networkData.isStaticNetwork() ? this.staticNetworkIcon : this.dynamicNetworkIcon;
                } else {
                    string = "main_tree_subnet";
                    contentPanel = new HostContentPanel();
                    contentPanel.addView(new HostIconView());
                    contentPanel.addView(new HostTableView());
                    imageIcon = networkData.isStaticNetwork() ? this.staticSubnetIcon : this.dynamicSubnetIcon;
                }
            } else {
                string = "main_tree_allhosts";
                contentPanel = new HostContentPanel();
                contentPanel.addView(new HostIconView());
                contentPanel.addView(new HostTableView());
                imageIcon = this.allHostsIcon;
            }
            String string2 = this.treeNodeName(networkData);
            TreeNodeData treeNodeData = new TreeNodeData(string2, contentPanel, networkData, imageIcon, string);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(treeNodeData);
            contentPanel.setTreeNode(defaultMutableTreeNode2);
            hostMgrTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, hostMgrTreeModel.getChildCount(defaultMutableTreeNode));
            ++n;
        }
    }

    private String treeNodeName(NetworkData networkData) {
        if (networkData.getNetworkAddress().length() > 0) {
            String string = networkData.getNetworkAddress();
            if (networkData.getNetworkName().length() > 0) {
                string = String.valueOf(string) + " (" + networkData.getNetworkName() + ")";
            }
            return string;
        }
        return networkData.getNetworkName();
    }

    public void addNetwork(DefaultMutableTreeNode defaultMutableTreeNode, NetworkData networkData) {
        Vector<NetworkData> vector = new Vector<NetworkData>();
        vector.addElement(networkData);
        this.appendToNode(defaultMutableTreeNode, vector);
    }

    public void removeNetwork(DefaultMutableTreeNode defaultMutableTreeNode, NetworkData networkData) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        int n = 0;
        while (n < defaultMutableTreeNode.getChildCount()) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            TreeNodeData treeNodeData = (TreeNodeData)defaultMutableTreeNode3.getUserObject();
            if (treeNodeData.getNetworkData() == networkData) {
                if (defaultMutableTreeNode3 == defaultMutableTreeNode2) {
                    return;
                }
                ContentPanel contentPanel = treeNodeData.getContentPanel();
                contentPanel.die();
                treeNodeData.setContentPanel(null);
                HostMgrTreeModel hostMgrTreeModel = (HostMgrTreeModel)this.getModel();
                hostMgrTreeModel.removeNodeFromParent(defaultMutableTreeNode3);
                TreeNodeData treeNodeData2 = (TreeNodeData)defaultMutableTreeNode.getUserObject();
                contentPanel = treeNodeData2.getContentPanel();
                contentPanel.getDataCache().removeElement(networkData);
                return;
            }
            ++n;
        }
    }

    public void selectNetwork(DefaultMutableTreeNode defaultMutableTreeNode, NetworkData networkData) {
        int n = 0;
        while (n < defaultMutableTreeNode.getChildCount()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            TreeNodeData treeNodeData = (TreeNodeData)defaultMutableTreeNode2.getUserObject();
            if (treeNodeData.getNetworkData() == networkData) {
                Object[] objectArray = defaultMutableTreeNode.getPath();
                TreePath treePath = new TreePath(objectArray);
                new TreePath(this.treeNodeName(networkData));
                TreePath treePath2 = treePath.pathByAddingChild(this.treeNodeName(networkData));
                this.setSelectionPath(treePath2);
                return;
            }
            ++n;
        }
    }

    public void removeAllNetworks(DefaultMutableTreeNode defaultMutableTreeNode) {
        HostMgrTreeModel hostMgrTreeModel = (HostMgrTreeModel)this.getModel();
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        int n = 0;
        while (n < defaultMutableTreeNode.getChildCount()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            vector.addElement(defaultMutableTreeNode2);
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)vector.elementAt(n2);
            TreeNodeData treeNodeData = (TreeNodeData)defaultMutableTreeNode3.getUserObject();
            ContentPanel contentPanel = treeNodeData.getContentPanel();
            contentPanel.die();
            treeNodeData.setContentPanel(null);
            hostMgrTreeModel.removeNodeFromParent(defaultMutableTreeNode3);
            ++n2;
        }
    }

    private void fireContentPanelChanged() {
        HostMgrTreeEvent hostMgrTreeEvent = new HostMgrTreeEvent(this.currentContentPanel);
        int n = 0;
        while (n < this.listeners.size()) {
            HostMgrTreeListener hostMgrTreeListener = (HostMgrTreeListener)this.listeners.elementAt(n);
            hostMgrTreeListener.contentPanelChanged(hostMgrTreeEvent);
            ++n;
        }
    }

    public synchronized void addHostMgrTreeListener(HostMgrTreeListener hostMgrTreeListener) {
        this.listeners.addElement(hostMgrTreeListener);
    }

    public synchronized void removeHostMgrTreeListener(HostMgrTreeListener hostMgrTreeListener) {
        this.listeners.removeElement(hostMgrTreeListener);
    }

    static /* synthetic */ void access$1(HostMgrTree hostMgrTree, TreeSelectionEvent treeSelectionEvent) {
        hostMgrTree.onTreeSelection(treeSelectionEvent);
    }

    private final class 1
    implements ListViewListener {
        public void itemPressed(ListViewEvent listViewEvent) {
            if (listViewEvent.getClickCount() < 2) {
                return;
            }
            ListView listView = listViewEvent.getSource();
            Vector vector = listView.getSelected();
            Object e = vector.elementAt(0);
            if (e instanceof HostData) {
                return;
            }
            NetworkData networkData = (NetworkData)vector.elementAt(0);
            String string = HostMgrTree.this.treeNodeName(networkData);
            TreePath treePath = HostMgrTree.this.getLeadSelectionPath();
            int n = HostMgrTree.this.getRowForPath(treePath);
            HostMgrTree.this.expandPath(treePath);
            Object[] objectArray = new Object[treePath.getPathCount() + 1];
            int n2 = 0;
            n2 = 0;
            while (n2 < treePath.getPathCount()) {
                objectArray[n2] = treePath.getPathComponent(n2);
                ++n2;
            }
            objectArray[n2] = string;
            TreePath treePath2 = new TreePath(objectArray);
            n2 = n;
            while (n2 < HostMgrTree.this.getRowCount()) {
                TreePath treePath3 = HostMgrTree.this.getPathForRow(n2);
                if (treePath2.getPathCount() == treePath3.getPathCount()) {
                    int n3 = treePath2.getPathCount();
                    boolean bl = true;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object object = treePath2.getPathComponent(n4);
                        Object object2 = treePath3.getPathComponent(n4);
                        if (object2.toString().compareTo(object.toString()) != 0) {
                            bl = false;
                            break;
                        }
                        ++n4;
                    }
                    if (bl) {
                        HostMgrTree.this.scrollPathToVisible(treePath3);
                        HostMgrTree.this.setSelectionPath(treePath3);
                        return;
                    }
                }
                ++n2;
            }
        }

        public void viewChanged(ListViewEvent listViewEvent) {
        }

        public void sortChanged(ListViewEvent listViewEvent) {
        }

        public void popupTriggered(ListViewEvent listViewEvent) {
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreeSelectionEvent treeSelectionEvent2 = treeSelectionEvent;
            3 var3_3 = new 3(HostMgrTree.this, treeSelectionEvent2);
            var3_3.start();
        }

        /* synthetic */ 2() {
        }
    }

    class HostMgrTreeCellRenderer
    implements TreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = HostMgrTree.this.oldRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            TreeNodeData treeNodeData = (TreeNodeData)defaultMutableTreeNode.getUserObject();
            JLabel jLabel = (JLabel)component;
            jLabel.setIcon(treeNodeData.getImageIcon());
            jLabel.setText(treeNodeData.getName());
            if (treeNodeData.getPreferredSize() == null) {
                Dimension dimension = jLabel.getMinimumSize();
                dimension.height += 4;
                treeNodeData.setPreferredSize(dimension);
            }
            jLabel.setPreferredSize(treeNodeData.getPreferredSize());
            jLabel.setMaximumSize(treeNodeData.getPreferredSize());
            return component;
        }

        HostMgrTreeCellRenderer() {
            HostMgrTree.this = HostMgrTree.this;
        }
    }

    class HostMgrTreeModel
    extends DefaultTreeModel {
        public HostMgrTreeModel(TreeNode treeNode) {
            super(treeNode);
            HostMgrTree.this = HostMgrTree.this;
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            TreeNodeData treeNodeData = (TreeNodeData)defaultMutableTreeNode.getUserObject();
            if (treeNodeData != null) {
                defaultMutableTreeNode.setUserObject(treeNodeData);
            } else {
                defaultMutableTreeNode.setUserObject((String)object);
            }
            this.nodeChanged(defaultMutableTreeNode);
        }
    }
}

