/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.mount;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.fsmgr.client.FsMgr;
import com.sun.admin.fsmgr.client.FsMgrClient;
import com.sun.admin.fsmgr.client.FsMgrResourceStrings;
import com.sun.admin.fsmgr.client.mount.FsMgrMountData;
import com.sun.admin.fsmgr.client.mount.Mount;
import com.sun.admin.fsmgr.client.mount.MountCacheEntry;
import com.sun.admin.fsmgr.common.FsMgrException;
import com.sun.admin.fsmgr.common.FsMgrMount;
import com.sun.admin.fsmgr.common.FsMgrMountDataException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UpdateAction {
    private MountCacheEntry cacheEntry;
    private String cacheStatus;
    private FsMgrMountData newMountData;
    private boolean canUpdate = false;

    public UpdateAction(MountCacheEntry mountCacheEntry, String string, FsMgrMountData fsMgrMountData) {
        String string2;
        this.cacheEntry = mountCacheEntry;
        this.cacheStatus = string;
        this.newMountData = fsMgrMountData;
        if (string.equals(MountCacheEntry.ATBOOT) || string.equals(MountCacheEntry.NOTMOUNTED)) {
            this.canUpdate = true;
            return;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        try {
            string2 = FsMgrResourceStrings.getString("ConfirmUpdateMountNumColumns");
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = 30;
        }
        string2 = FsMgrResourceStrings.getString("ConfirmUpdateMount");
        FlowArea flowArea = new FlowArea(string2, n, Constants.ERROR_DIALOG_FONT);
        Constraints.constrain(jPanel, flowArea, 0, 0, 2, 1, 20, 5, 0, 5);
        String string3 = FsMgrResourceStrings.getString("ConfirmUpdateMountWill");
        flowArea = new FlowArea(string3, n, Constants.ERROR_DIALOG_FONT);
        Constraints.constrain(jPanel, flowArea, 0, 1, 2, 1, 20, 5, 10, 5);
        String string4 = FsMgrResourceStrings.getString("DialogBulletGif");
        ImageIcon imageIcon = FsMgr.getFsMgr().loadImageIcon(string4, "DialogBulletGif");
        Constraints.constrain(jPanel, new JLabel(imageIcon), 0, 2, 1, 1, 0, 18, 0.0, 0.0, 0, 10, 10, 5);
        String string5 = FsMgrResourceStrings.getString("ConfirmUpdateMountBullet1");
        flowArea = new FlowArea(string5, n - 5, Constants.ERROR_DIALOG_FONT);
        Constraints.constrain(jPanel, flowArea, 1, 2, 1, 1, 0, 5, 10, 5);
        Constraints.constrain(jPanel, new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), 0, -1, 1, 0, 3, 18, 0.0, 1.0, 0, 0, 0, 0);
        new WarningDialog(FsMgr.getFsMgr().getFrame(), FsMgrResourceStrings.getString("ConfirmUpdateMountTitle"), jPanel, (ActionListener)new ConfirmUpdateListener(mountCacheEntry, string, fsMgrMountData), FsMgrResourceStrings.getString("UpdateMount"));
    }

    public void update() throws FsMgrException {
        if (!this.canUpdate) {
            return;
        }
        String string = FsMgrResourceStrings.getString("ModifyMountTitle");
        String string2 = FsMgrResourceStrings.getString("ModifyMountMessage");
        Object[] objectArray = new Object[]{this.newMountData.getResource()};
        String string3 = MessageFormat.format(string2, objectArray);
        ProgressPanel progressPanel = new ProgressPanel(FsMgr.getFsMgr().getFrame(), 1, 30, false, false);
        progressPanel.setTitle(string);
        progressPanel.setText(string3);
        ((Component)progressPanel).setVisible(true);
        progressPanel.show();
        FsMgrMount fsMgrMount = null;
        FsMgrMount fsMgrMount2 = null;
        try {
            FsMgrMountData fsMgrMountData;
            String string4;
            if (this.cacheStatus.equals(MountCacheEntry.BOTH) || this.cacheStatus.equals(MountCacheEntry.NOW)) {
                string4 = this.cacheEntry.getTable(MountCacheEntry.NOW);
                fsMgrMountData = (FsMgrMountData)this.newMountData.clone();
                if (fsMgrMountData.getFsType().equals(FsMgrMountData.NFS)) {
                    try {
                        fsMgrMountData.setOption(FsMgrMountData.RETRY, 0);
                        fsMgrMountData.setOption(FsMgrMountData.FG, true);
                    }
                    catch (FsMgrMountDataException fsMgrMountDataException) {
                        AdminCommonTools.CMN_HandleOutput("Invalid option!");
                    }
                }
                fsMgrMount2 = this.cacheEntry.getNowData().toFsMgrMount();
                fsMgrMount = fsMgrMountData.toFsMgrMount();
                FsMgrClient.instance().modifyMount(fsMgrMount2, fsMgrMount, string4);
            }
            if (this.cacheStatus.equals(MountCacheEntry.BOTH) || this.cacheStatus.equals(MountCacheEntry.ATBOOT)) {
                string4 = this.cacheEntry.getTable(MountCacheEntry.ATBOOT);
                fsMgrMountData = this.cacheEntry.getBootData();
                FsMgrMountData fsMgrMountData2 = (FsMgrMountData)this.newMountData.clone();
                fsMgrMountData2.setBootMount(fsMgrMountData.getBootMount());
                fsMgrMount2 = fsMgrMountData.toFsMgrMount();
                fsMgrMount = fsMgrMountData2.toFsMgrMount();
                FsMgrClient.instance().modifyMount(fsMgrMount2, fsMgrMount, string4);
            }
        }
        catch (FsMgrException fsMgrException) {
            ((Component)progressPanel).setVisible(false);
            progressPanel.dispose();
            throw fsMgrException;
        }
        if (fsMgrMount != null) {
            Mount.getInstance().refresh(fsMgrMount.getResource(), fsMgrMount.getMountPoint());
        }
        try {
            Thread.currentThread();
            Thread.sleep(1500L);
        }
        catch (Exception exception) {}
        ((Component)progressPanel).setVisible(false);
        progressPanel.dispose();
    }

    static /* synthetic */ boolean access$0(UpdateAction updateAction) {
        return updateAction.canUpdate;
    }

    private class ConfirmUpdateListener
    implements ActionListener {
        MountCacheEntry cacheEntry;
        String cacheStatus;
        FsMgrMountData newMountData;

        public ConfirmUpdateListener(MountCacheEntry mountCacheEntry, String string, FsMgrMountData fsMgrMountData) {
            UpdateAction.this = UpdateAction.this;
            this.cacheEntry = mountCacheEntry;
            this.cacheStatus = string;
            this.newMountData = fsMgrMountData;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UpdateAction.this.canUpdate = true;
        }
    }
}

