/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client;

import com.sun.admin.cis.client.AdminSession;
import com.sun.admin.cis.client.IClientComm;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.IConnection;
import com.sun.admin.cis.service.security.SecurityToken;
import com.sun.admin.fsmgr.common.FsMgrException;
import com.sun.admin.fsmgr.common.FsMgrMount;
import com.sun.admin.fsmgr.common.FsMgrNfsSecurityModeException;
import com.sun.admin.fsmgr.common.FsMgrRemoteFile;
import com.sun.admin.fsmgr.common.FsMgrShare;
import com.sun.admin.fsmgr.common.FsMgrUsage;
import com.sun.admin.fsmgr.server.FsMgrFactory;
import java.rmi.RemoteException;
import java.util.Vector;

public class FsMgrClient
implements IConnection {
    private static FsMgrClient fsMgrClient;
    static final String APP_NAME = "com.sun.admin.fsmgr.server.FsMgrFactoryImpl";
    private FsMgrFactory fsMgrServer;
    private AdminSession session;
    public final String[] shareNowArr = new String[]{"sharetab"};
    public final String[] shareAtBootArr = new String[]{"dfstab"};
    public final String[] shareBothArr = new String[]{"sharetab", "dfstab"};
    public final String[] mountNowArr = new String[]{"mounttab"};
    public final String[] mountAtBootArr = new String[]{"vfstab"};
    public final String[] mountBothArr = new String[]{"mounttab", "vfstab"};
    Vector fsMgrRights;

    public static FsMgrClient instance() {
        if (fsMgrClient == null) {
            fsMgrClient = new FsMgrClient();
        }
        return fsMgrClient;
    }

    public void setUpConnection(IClientComm iClientComm) throws Exception {
        this.session = iClientComm.getAdminSession();
        SecurityToken securityToken = this.session.getSecurityToken();
        this.fsMgrServer = (FsMgrFactory)this.session.getAppFactory(APP_NAME);
        this.fsMgrServer.initializeLogging(securityToken);
        this.fsMgrRights = this.fsMgrServer.getUserRights(securityToken);
    }

    public void terminateConnection() throws Exception {
        this.session.closeAppFactory(APP_NAME);
        return;
    }

    public boolean hasUpdateRights() {
        if (this.fsMgrRights == null) {
            return false;
        }
        return this.fsMgrRights.contains("solaris.admin.fsmgr.write");
    }

    public Vector getList(String string) throws FsMgrException {
        Vector vector = new Vector();
        try {
            SecurityToken securityToken = this.session.getSecurityToken();
            vector = this.fsMgrServer.getList(securityToken, string);
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
        return vector;
    }

    public FsMgrRemoteFile getFile(String string) throws FsMgrException {
        FsMgrRemoteFile fsMgrRemoteFile = null;
        try {
            SecurityToken securityToken = this.session.getSecurityToken();
            fsMgrRemoteFile = this.fsMgrServer.getFile(securityToken, string);
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
        return fsMgrRemoteFile;
    }

    public FsMgrRemoteFile makeDirectory(String string) throws FsMgrException {
        FsMgrRemoteFile fsMgrRemoteFile = null;
        try {
            SecurityToken securityToken = this.session.getSecurityToken();
            fsMgrRemoteFile = this.fsMgrServer.makeDirectory(securityToken, string);
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
        return fsMgrRemoteFile;
    }

    public Vector getShareList(String string) throws FsMgrException {
        Vector vector = new Vector();
        try {
            SecurityToken securityToken = this.session.getSecurityToken();
            vector = this.fsMgrServer.getShareList(securityToken, string);
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
        return vector;
    }

    public FsMgrShare getShareEntry(String string, String string2) throws FsMgrException {
        FsMgrShare fsMgrShare = null;
        try {
            SecurityToken securityToken = this.session.getSecurityToken();
            fsMgrShare = this.fsMgrServer.getShareEntry(securityToken, string, string2);
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
        return fsMgrShare;
    }

    public void addShare(FsMgrShare fsMgrShare, String[] stringArray) throws FsMgrException {
        try {
            Object[] objectArray = null;
            if (this.session.isVerify()) {
                objectArray = new Object[]{fsMgrShare, stringArray};
            }
            SecurityToken securityToken = this.session.getSecurityToken(objectArray);
            this.fsMgrServer.addShare(securityToken, fsMgrShare, stringArray);
            return;
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
    }

    public void addShare(FsMgrShare fsMgrShare, String string) throws FsMgrException {
        try {
            Object[] objectArray = null;
            if (this.session.isVerify()) {
                objectArray = new Object[]{fsMgrShare, string};
            }
            SecurityToken securityToken = this.session.getSecurityToken(objectArray);
            this.fsMgrServer.addShare(securityToken, fsMgrShare, string);
            return;
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
    }

    public void removeShare(FsMgrShare fsMgrShare, String[] stringArray) throws FsMgrException {
        try {
            Object[] objectArray = null;
            if (this.session.isVerify()) {
                objectArray = new Object[]{fsMgrShare, stringArray};
            }
            SecurityToken securityToken = this.session.getSecurityToken(objectArray);
            this.fsMgrServer.removeShare(securityToken, fsMgrShare, stringArray);
            return;
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
    }

    public void removeShare(FsMgrShare fsMgrShare, String string) throws FsMgrException {
        try {
            Object[] objectArray = null;
            if (this.session.isVerify()) {
                objectArray = new Object[]{fsMgrShare, string};
            }
            SecurityToken securityToken = this.session.getSecurityToken(objectArray);
            this.fsMgrServer.removeShare(securityToken, fsMgrShare, string);
            return;
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
    }

    public void modifyShare(FsMgrShare fsMgrShare, FsMgrShare fsMgrShare2, String string) throws FsMgrException {
        try {
            Object[] objectArray = null;
            if (this.session.isVerify()) {
                objectArray = new Object[]{fsMgrShare, fsMgrShare2, string};
            }
            SecurityToken securityToken = this.session.getSecurityToken(objectArray);
            this.fsMgrServer.modifyShare(securityToken, fsMgrShare, fsMgrShare2, string);
            return;
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
    }

    public Vector getMountList(String string) throws FsMgrException {
        Vector vector = new Vector();
        try {
            SecurityToken securityToken = this.session.getSecurityToken();
            vector = this.fsMgrServer.getMountList(securityToken, string);
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
        return vector;
    }

    public FsMgrMount getMountEntry(String string, String string2, String string3) throws FsMgrException {
        FsMgrMount fsMgrMount = null;
        try {
            SecurityToken securityToken = this.session.getSecurityToken();
            fsMgrMount = this.fsMgrServer.getMountEntry(securityToken, string, string2, string3);
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
        return fsMgrMount;
    }

    public void addMount(FsMgrMount fsMgrMount, String[] stringArray) throws FsMgrException {
        try {
            Object[] objectArray = null;
            if (this.session.isVerify()) {
                objectArray = new Object[]{fsMgrMount, stringArray};
            }
            SecurityToken securityToken = this.session.getSecurityToken(objectArray);
            this.fsMgrServer.addMount(securityToken, fsMgrMount, stringArray);
            return;
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
    }

    public void addMount(FsMgrMount fsMgrMount, String string) throws FsMgrException {
        try {
            Object[] objectArray = null;
            if (this.session.isVerify()) {
                objectArray = new Object[]{fsMgrMount, string};
            }
            SecurityToken securityToken = this.session.getSecurityToken(objectArray);
            this.fsMgrServer.addMount(securityToken, fsMgrMount, string);
            return;
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
    }

    public void removeMount(FsMgrMount fsMgrMount, String[] stringArray) throws FsMgrException {
        try {
            Object[] objectArray = null;
            if (this.session.isVerify()) {
                objectArray = new Object[]{fsMgrMount, stringArray};
            }
            SecurityToken securityToken = this.session.getSecurityToken(objectArray);
            this.fsMgrServer.removeMount(securityToken, fsMgrMount, stringArray);
            return;
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
    }

    public void removeMount(FsMgrMount fsMgrMount, String string) throws FsMgrException {
        try {
            Object[] objectArray = null;
            if (this.session.isVerify()) {
                objectArray = new Object[]{fsMgrMount, string};
            }
            SecurityToken securityToken = this.session.getSecurityToken(objectArray);
            this.fsMgrServer.removeMount(securityToken, fsMgrMount, string);
            return;
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
    }

    public void modifyMount(FsMgrMount fsMgrMount, FsMgrMount fsMgrMount2, String string) throws FsMgrException {
        try {
            Object[] objectArray = null;
            if (this.session.isVerify()) {
                objectArray = new Object[]{fsMgrMount, fsMgrMount2, string};
            }
            SecurityToken securityToken = this.session.getSecurityToken(objectArray);
            this.fsMgrServer.modifyMount(securityToken, fsMgrMount, fsMgrMount2, string);
            return;
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
    }

    public String[] showMounts(String string) throws FsMgrException {
        String[] stringArray = null;
        try {
            SecurityToken securityToken = this.session.getSecurityToken();
            stringArray = this.fsMgrServer.showMounts(securityToken, string);
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
        return stringArray;
    }

    public Vector getUsageList() throws FsMgrException {
        Vector vector = new Vector();
        try {
            SecurityToken securityToken = this.session.getSecurityToken();
            vector = this.fsMgrServer.getUsageList(securityToken);
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
        return vector;
    }

    public FsMgrUsage getUsageEntry(String string, String string2) throws FsMgrException {
        FsMgrUsage fsMgrUsage = null;
        try {
            SecurityToken securityToken = this.session.getSecurityToken();
            fsMgrUsage = this.fsMgrServer.getUsageEntry(securityToken, string2);
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
        return fsMgrUsage;
    }

    public Vector getNetCfgList() throws FsMgrException {
        Vector vector = new Vector();
        try {
            SecurityToken securityToken = this.session.getSecurityToken();
            vector = this.fsMgrServer.getNetCfgList(securityToken);
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
        return vector;
    }

    public Vector getNfsSecList() throws FsMgrException {
        Vector vector = new Vector();
        try {
            SecurityToken securityToken = this.session.getSecurityToken();
            vector = this.fsMgrServer.getNfsSecList(securityToken);
        }
        catch (FsMgrNfsSecurityModeException fsMgrNfsSecurityModeException) {
            throw fsMgrNfsSecurityModeException;
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
        return vector;
    }

    public String getDefaultNfsSecMode() throws FsMgrException {
        String string = null;
        try {
            SecurityToken securityToken = this.session.getSecurityToken();
            string = this.fsMgrServer.getDefaultNfsSecMode(securityToken);
        }
        catch (FsMgrNfsSecurityModeException fsMgrNfsSecurityModeException) {
            throw fsMgrNfsSecurityModeException;
        }
        catch (AdminException adminException) {
            throw new FsMgrException(adminException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new FsMgrException("EXM_REMOTE");
        }
        return string;
    }
}

