/*
 * Copyright (c) 1992-1999 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_INET_IP_IF_H
#define	_INET_IP_IF_H

#pragma ident	"@(#)ip_if.h	1.32	00/03/28 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

#define	PREFIX_INFINITY	0xffffffffUL
#define	IP_MAX_HW_LEN	40

#define	IP_LOOPBACK_MTU	(8*1024)

/* DLPI SAPs are in host byte order for all systems */
#define	IP_DL_SAP	0x0800
#define	IP6_DL_SAP	0x86dd

#ifdef	_KERNEL
/*
 * Interface flags actually represent the state/properties of 3 different
 * abstractions of interfaces in IP. Interface flags are set using
 * SIOCS[L]IFFLAGS ioctl. The three abstractions are :
 *
 * 1) Phyiscal interface (phyint) : There is one phyint allocated common
 *    to both IPv4 and IPv6 physical interface instance.
 *
 * 2) Phyiscal interface instance (ill) : This encompasses all the state
 *    that is common across all IP addresses assigned to a physical
 *    interface but different between the IPv4 and IPv6 instance.
 *
 * 3) Logical interface (ipif) : This has state about a single IP address.
 *
 * Values for the various states are derived from the same name space
 * as applications querying the state using SIOCGIFFLAGS/SIOCGLIFFLAGS
 * see only one state returned in lifr_flags which is a union of all
 * the above states/properties. Thus deriving the values from the common
 * name space makes implementaion easier. All these values are stored in
 * uint64_t and any other structure/code using these flags should use
 * uint64_ts.
 *
 * As we maintain the interface flags in 3 different flags namely
 * phyint_flags, ill_flags, ipif_flags we define the following flag values
 * to be used within the kernel to reduce potential errors. The ones
 * starting with PHYI_ are supposed to be used with phyint_flags, the ones
 * starting with ILLF_ are supposed to be used with ill_flags and the ones
 * starting with IPIF_ are supposed to be used with ipif_flags. If you see
 * any code with a mismatch i.e phyint_flags & IPIF_UP - it is wrong. Only
 * PHYI_XXX can be used with phyint_flags.
 *
 * NOTE : For EVERY FLAG in if.h, there should be a corresponding value
 * defined HERE and this is the one that should be USED within IP. We
 * use IFF_ flags within IP only when we examine lifr_flags.
 */
#define	IFF_PHYINT_FLAGS	(IFF_LOOPBACK|IFF_RUNNING|IFF_PROMISC| \
    IFF_ALLMULTI|IFF_INTELLIGENT|IFF_MULTI_BCAST|IFF_FAILED|IFF_STANDBY| \
    IFF_INACTIVE|IFF_LINKAGGR)

#define	IFF_PHYINTINST_FLAGS	(IFF_DEBUG|IFF_NOTRAILERS|IFF_NOARP| \
    IFF_MULTICAST|IFF_ROUTER|IFF_NONUD|IFF_NORTEXCH|IFF_IPV4|IFF_IPV6)

#define	IFF_LOGINT_FLAGS	(IFF_UP|IFF_BROADCAST|IFF_POINTOPOINT| \
    IFF_UNNUMBERED|IFF_DHCPRUNNING|IFF_PRIVATE|IFF_NOXMIT|IFF_NOLOCAL| \
    IFF_DEPRECATED|IFF_ADDRCONF|IFF_ANYCAST|IFF_MIPRUNNING|IFF_NOFAILOVER)

#define	PHYI_LOOPBACK		IFF_LOOPBACK	/* is a loopback net */
#define	PHYI_RUNNING		IFF_RUNNING	/* resources allocated */
#define	PHYI_PROMISC		IFF_PROMISC	/* receive all packets */
#define	PHYI_ALLMULTI		IFF_ALLMULTI	/* receive all multi packets */
#define	PHYI_INTELLIGENT	IFF_INTELLIGENT	/* protocol code on board */
#define	PHYI_MULTI_BCAST	IFF_MULTI_BCAST	/* multicast using broadcast */
#define	PHYI_FAILED		IFF_FAILED	/* NIC has failed */
#define	PHYI_STANDBY		IFF_STANDBY	/* Standby NIC  */
#define	PHYI_INACTIVE		IFF_INACTIVE	/* Standby active or not ? */
#define	PHYI_LINKAGGR		IFF_LINKAGGR	/* Link Aggregation supported */

#define	ILLF_DEBUG		IFF_DEBUG	/* turn on debugging */
#define	ILLF_NOTRAILERS		IFF_NOTRAILERS	/* avoid use of trailers */
#define	ILLF_NOARP		IFF_NOARP	/* no ARP for this interface */
#define	ILLF_MULTICAST		IFF_MULTICAST	/* supports multicast */
#define	ILLF_ROUTER		IFF_ROUTER	/* router on this interface */
#define	ILLF_NONUD		IFF_NONUD	/* No NUD on this interface */
#define	ILLF_NORTEXCH		IFF_NORTEXCH	/* No routing info exchange */
#define	ILLF_IPV4		IFF_IPV4	/* IPv4 interface */
#define	ILLF_IPV6		IFF_IPV6	/* IPv6 interface */

#define	IPIF_UP			IFF_UP		/* interface is up */
#define	IPIF_BROADCAST		IFF_BROADCAST	/* broadcast address valid */
#define	IPIF_POINTOPOINT	IFF_POINTOPOINT	/* point-to-point link */
#define	IPIF_UNNUMBERED		IFF_UNNUMBERED	/* non-unique address */
#define	IPIF_DHCPRUNNING	IFF_DHCPRUNNING	/* DHCP controlled interface */
#define	IPIF_PRIVATE		IFF_PRIVATE	/* do not advertise */
#define	IPIF_NOXMIT		IFF_NOXMIT	/* Do not transmit packets */
#define	IPIF_NOLOCAL		IFF_NOLOCAL	/* Just on-link subnet */
#define	IPIF_DEPRECATED		IFF_DEPRECATED	/* address deprecated */
#define	IPIF_ADDRCONF		IFF_ADDRCONF	/* stateless addrconf */
#define	IPIF_ANYCAST		IFF_ANYCAST	/* Anycast address */
#define	IPIF_MIPRUNNING		IFF_MIPRUNNING	/* Mobip Controlled interface */
#define	IPIF_NOFAILOVER		IFF_NOFAILOVER	/* No failover on NIC failure */

extern	void	illgrp_delete(ill_t *);
extern	ill_t	*illgrp_scheduler(ill_t *);
extern	ipif_t	*ifgrp_scheduler(ipif_t *);
extern	mblk_t	*ill_arp_alloc(ill_t *, uchar_t *, ipaddr_t);
extern	void	ill_dlpi_done(ill_t *);
extern	void	ill_dlpi_send(ill_t *, mblk_t *);
extern	mblk_t	*ill_dlur_gen(uchar_t *, uint_t, t_uscalar_t, t_scalar_t);
extern	ill_t	*ill_lookup_on_ifindex(uint_t, boolean_t);
extern	ill_t	*ill_lookup_on_name(char *, size_t, boolean_t, boolean_t);
extern	char	*ipif_get_name(ipif_t *, char *, int);
extern	void	ipif_init(void);
extern	void	ipif_init_v6(void);
extern	ipif_t	*ipif_lookup_addr(ipaddr_t, ill_t *);
extern	ipif_t	*ipif_lookup_addr_v6(const in6_addr_t *, ill_t *);
extern	ipif_t	*ipif_lookup_group(ipaddr_t);
extern	ipif_t	*ipif_lookup_group_v6(const in6_addr_t *);
extern	ipif_t	*ipif_lookup_interface(ipaddr_t, ipaddr_t);
extern	ipif_t	*ipif_lookup_interface_v6(const in6_addr_t *,
    const in6_addr_t *);
extern	ipif_t	*ipif_lookup_on_name(char *, size_t, boolean_t, boolean_t *,
    boolean_t);
extern	ipif_t	*ipif_lookup_remote(ill_t *, ipaddr_t);
extern	ipif_t	*ipif_lookup_remote_v6(ill_t *, const in6_addr_t *);
extern	ipif_t	*ipif_lookup_scope_v6(ill_t *, const in6_addr_t *,
		    int, int, int, int, int);
extern	ipif_t	*ipif_lookup_seqid(ill_t *, uint_t);
extern	ipif_t	*ipif_select_source(ill_t *, ipaddr_t);
extern	int	ifgrp_get(queue_t *, mblk_t *, void *);
extern	int	ifgrp_insert(ipif_t *);
extern	int	illgrp_insert(ill_group_t **, ill_t *, char *, ill_group_t *);
extern	int	ifgrp_report(queue_t *, mblk_t *, void *);
extern	int	ifgrp_set(queue_t *, mblk_t *, char *, void *);
extern	void	ill_ipif_cache_delete(ire_t *, char *);
extern	void	ill_delete(ill_t *);
extern	int	ill_dl_phys(ill_t *, ipif_t *, mblk_t *, queue_t *);
extern	int	ill_dls_info(struct sockaddr_dl *, ipif_t *);
extern	void	ill_down(ill_t *);
extern	void	ill_fastpath_ack(ill_t *, mblk_t *);
extern	void	ill_fastpath_probe(ill_t *, mblk_t *);
extern	void	ill_frag_prune(ill_t *, uint_t);
extern	boolean_t	ill_frag_timeout(ill_t *, time_t);
extern	int	ill_init(queue_t *, ill_t *);
extern	int	ill_nominate_mcast_rcv(ill_group_t *);
extern	boolean_t	ill_setdefaulttoken(ill_t *);
extern	int	ip_ill_report(queue_t *, mblk_t *, void *);
extern	int	ip_ipif_report(queue_t *, mblk_t *, void *);
extern	void	ip_ll_subnet_defaults(ill_t *, mblk_t *);
extern	int	ip_rt_add(ipaddr_t, ipaddr_t, ipaddr_t, int, ipif_t *,
    ire_t **, boolean_t);
extern	int	ip_rt_add_v6(const in6_addr_t *, const in6_addr_t *,
    const in6_addr_t *, int, ipif_t *, ire_t **);
extern	int	ip_rt_delete(ipaddr_t, ipaddr_t, ipaddr_t, uint_t, int,
    ipif_t *, boolean_t);
extern	int	ip_rt_delete_v6(const in6_addr_t *, const in6_addr_t *,
    const in6_addr_t *, uint_t, int, ipif_t *);
extern	int	ip_siocdelndp_v6(ipif_t *, struct lif_nd_req *, queue_t *);
extern	int	ip_siocqueryndp_v6(ipif_t *, struct lif_nd_req *, queue_t *,
    mblk_t  *);
extern	int	ip_siocsetndp_v6(ipif_t *, lif_nd_req_t *, queue_t *,
    mblk_t  *);

extern	int	ip_sioctl_addr(ipif_t *, sin_t *, queue_t *, mblk_t *);
extern	int	ip_sioctl_move(queue_t *, mblk_t *, boolean_t);
extern	void	ip_sioctl_copyin_done(queue_t *, mblk_t *);
extern	void	ip_sioctl_copyin_setup(queue_t *, mblk_t *);
extern	int	ip_sioctl_copyin_writer(mblk_t *);
extern	void	ip_sioctl_iocack(queue_t *, mblk_t *);
extern	boolean_t	ipif_arp_up(ipif_t *, ipaddr_t);
extern	int	ipif_arp_setup_multicast(ipif_t *, mblk_t **);
extern	void	ipif_down(ipif_t *);
extern	void	ipif_multicast_down(ipif_t *);
extern	void	ipif_multicast_up(ipif_t *);
extern	void	ipif_ndp_down(ipif_t *);
extern	int	ipif_ndp_up(ipif_t *, const in6_addr_t *);
extern	int	ipif_ndp_setup_multicast(ipif_t *, struct nce_s **);
extern	void	ipif_recover_ire(ipif_t *);
extern	void	ipif_recover_ire_v6(ipif_t *);
extern	int	ipif_up(ipif_t *, queue_t *, mblk_t *);
extern	int	ipif_up_done(ipif_t *);
extern	int	ipif_up_done_v6(ipif_t *);
extern	void	ipif_update_other_ipifs(ipif_t *, ill_group_t *);
extern	void	ipif_update_other_ipifs_v6(ipif_t *, ill_group_t *);
extern	void	ipif_recreate_interface_routes(ipif_t *, ipif_t *);
extern	void	ipif_recreate_interface_routes_v6(ipif_t *, ipif_t *);
extern	void	ill_update_source_selection(ill_t *);
extern	ipif_t	*ipif_select_source_v6(ill_t *, const in6_addr_t *);
extern	int	ipif_setlinklocal(ipif_t *);
extern	void	ipif_set_tun_llink(ill_t *, struct iftun_req *);

#endif /* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _INET_IP_IF_H */
