/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMSecurityException;
import com.sun.wbem.cimom.SecurityInterface;
import com.sun.wbem.client.CommonServerSecurityContext;
import com.sun.wbem.client.LogFile;
import com.sun.wbem.client.RemoteCIMListener;
import com.sun.wbem.security.SecurityMessage;
import com.sun.wbem.security.SecurityToken;
import com.sun.wbem.security.SecurityUtil;
import com.sun.wbem.security.WorkMod51;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;

public final class ServerSecurity
implements CommonServerSecurityContext {
    private static final long AUDIT_NO_SUCH_USER = -1L;
    private static final long AUDIT_BAD_PASSWD = -2L;
    private static final long AUDIT_SUCCESS = 1L;
    private static ThreadLocal requestSession = new ThreadLocal();
    protected static byte[] adminCred = null;
    private static boolean initialized = false;
    private static byte[] GUESTSHADOW = "abvyhtC1vX8PI".getBytes();
    private static KeyPairGenerator keygen;
    private static KeyPair keypair;
    private static Signature signer;
    private static PrivateKey sprivkey;
    private static PublicKey spubkey;
    private MessageDigest md = null;
    private PublicKey cpubkey;
    private String userName = null;
    private String roleName = null;
    private String clientHost = null;
    private String initialKey = "InitialKey";
    private byte[] schallenge1;
    private byte[] sessionId = null;
    private byte[] sessionKey = null;
    private byte[] decryptKey = null;
    private byte[] auditKey = null;
    private byte[] cf;
    private byte[] nameSpace;
    private byte[] sf;
    private String cp = null;
    private String cversion;
    private String cap = "none";
    private String capNameSpace = "__junk__";
    private static SecurityInterface si;
    private RemoteCIMListener rl = null;
    private static final int MAX_DATA_SIZE = 15;
    private static final char[] hex;

    static {
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    public ServerSecurity() throws Exception {
        if (!initialized) {
            signer = Signature.getInstance("DSA");
            keygen = KeyPairGenerator.getInstance("DSA");
            keygen.initialize(1024, SecurityUtil.secrand);
            keypair = ((KeyPairGeneratorSpi)keygen).generateKeyPair();
            sprivkey = keypair.getPrivate();
            spubkey = keypair.getPublic();
            initialized = true;
            si = ServerSecurity.securityIFFactory();
        }
        this.md = MessageDigest.getInstance("MD5");
    }

    ServerSecurity(String string, String string2, String string3, byte[] byArray) {
        this.userName = string;
        this.roleName = string2;
        this.setClientHostName(string3);
        ServerSecurity.setRequestSession(this);
        this.auditKey = byArray;
    }

    public void assumeRole(String string, String string2) throws CIMException {
        if (this.userName.equals("guest")) {
            throw new CIMSecurityException("CANNOT_ASSUME_ROLE", (Object)this.userName, (Object)string);
        }
        String string3 = si.getEncryptedPassword(string);
        if (string3 == null) {
            si.auditLogin(this.clientHost, this.userName, -1L);
            throw new CIMSecurityException("NO_SUCH_PRINCIPAL", (Object)string);
        }
        if (string3.trim().length() == 0) {
            si.auditLogin(this.clientHost, this.userName, -2L);
            throw new CIMSecurityException("INVALID_CREDENTIAL");
        }
        byte[] byArray = string3.getBytes();
        byte[] byArray2 = new byte[]{byArray[0], byArray[1]};
        boolean bl = false;
        String string4 = this.trans51Unformat(string2);
        if (string4 != null) {
            byte[] byArray3 = string4.getBytes();
            byte[] byArray4 = new WorkMod51().mod51Format(byArray3, byArray2);
            String string5 = new String(byArray4);
            bl = string5.equals(string3);
        }
        if (!bl) {
            si.auditLogin(this.clientHost, this.userName, -2L);
            throw new CIMSecurityException("INVALID_CREDENTIAL");
        }
        if (!si.canUserAssumeRole(this.userName, string)) {
            throw new CIMSecurityException("CANNOT_ASSUME_ROLE", (Object)this.userName, (Object)string);
        }
        this.roleName = string;
        si.auditLogin(this.clientHost, this.userName, 1L);
    }

    public void authenticateRequest(String[] stringArray, SecurityToken securityToken) throws CIMException {
        LogFile.methodEntry("authenticateRequest");
        ServerSecurity.setRequestSession(this);
        MessageDigest messageDigest = this.getMD();
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            string = String.valueOf(string) + stringArray[n];
            ++n;
        }
        byte[] byArray = string.getBytes();
        messageDigest.reset();
        messageDigest.update(this.getSessionKey());
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        if (!MessageDigest.isEqual(byArray2, securityToken.getChecksum())) {
            throw new CIMSecurityException("CHECKSUM_ERROR");
        }
        LogFile.methodReturn("authenticateRequest");
    }

    private byte[] fromHex(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length() / 2 * 2;
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byArray[n3] = 0;
            boolean bl = false;
            char c = string.charAt(n2);
            int n4 = 0;
            while (n4 < hex.length) {
                if (c == hex[n4]) {
                    byArray[n3] = (byte)(n4 << 4 & 0xF0);
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                return null;
            }
            bl = false;
            c = string.charAt(++n2);
            n4 = 0;
            while (n4 < hex.length) {
                if (c == hex[n4]) {
                    byArray[n3] = (byte)(byArray[n3] | (byte)(n4 & 0xF));
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                return null;
            }
            ++n3;
            ++n2;
        }
        return byArray;
    }

    public SecurityMessage generateChallenge(String string, SecurityMessage securityMessage, byte[] byArray) throws CIMException {
        Object object;
        if (!securityMessage.isHello()) {
            throw new CIMSecurityException("NOT_HELLO");
        }
        this.cversion = string;
        this.sessionId = byArray;
        this.md.reset();
        this.md.update(securityMessage.getChallenge());
        byte[] byArray2 = this.md.digest(this.initialKey.getBytes());
        this.md.reset();
        this.md.update(securityMessage.getChallenge());
        this.md.update(this.initialKey.getBytes());
        this.md.update(securityMessage.getUserDigest());
        this.md.update(securityMessage.getNameSpace());
        if (!MessageDigest.isEqual(this.md.digest(), securityMessage.getChecksum())) {
            throw new CIMSecurityException("CHECKSUM_ERROR");
        }
        byte[] byArray3 = SecurityUtil.extractHashedData((byte[])securityMessage.getUserDigest(), (byte[])byArray2);
        this.nameSpace = SecurityUtil.extractHashedData((byte[])securityMessage.getNameSpace(), (byte[])byArray2);
        this.userName = new String(byArray3);
        if (byArray3 == null) {
            si.auditLogin(this.clientHost, this.userName, -1L);
            throw new CIMSecurityException("NO_SUCH_PRINCIPAL", null);
        }
        if (this.userName.equals("guest")) {
            this.sf = GUESTSHADOW;
        } else {
            object = si.getEncryptedPassword(this.userName);
            if (object == null) {
                si.auditLogin(this.clientHost, this.userName, -1L);
                throw new CIMSecurityException("NO_SUCH_PRINCIPAL", (Object)this.userName);
            }
            this.sf = ((String)object).length() == 0 ? GUESTSHADOW : ((String)object).getBytes();
        }
        this.schallenge1 = new byte[16];
        SecurityUtil.secrand.nextBytes(this.schallenge1);
        object = new byte[]{this.sf[0], this.sf[1]};
        this.md.reset();
        this.md.update(this.schallenge1);
        this.md.update(this.initialKey.getBytes());
        byte[] byArray4 = this.md.digest();
        byte[] byArray5 = SecurityUtil.hashData((byte[])object, (byte[])byArray4);
        this.md.reset();
        this.md.update(this.schallenge1);
        this.md.update(this.initialKey.getBytes());
        this.md.update(byArray5);
        return SecurityMessage.challenge((byte[])this.schallenge1, (byte[])byArray5, (byte[])byArray, (byte[])this.md.digest(byArray));
    }

    public int getAuditId() {
        int n = 0;
        if (this.auditKey != null) {
            n = (this.auditKey[0] & 0xFF) << 24;
            n |= (this.auditKey[1] & 0xFF) << 16;
            n |= (this.auditKey[2] & 0xFF) << 8;
            n |= this.auditKey[3] & 0xFF;
        }
        return n;
    }

    public String getCapability() {
        return this.cap;
    }

    public String getCapabilityNS() {
        return this.capNameSpace;
    }

    public byte[] getChallenge() {
        return this.schallenge1;
    }

    public String getClientHostName() {
        return this.clientHost;
    }

    public PublicKey getClientPublicKey() {
        return this.cpubkey;
    }

    public String getClientVersion() {
        return this.cversion;
    }

    public RemoteCIMListener getListener() {
        return this.rl;
    }

    public MessageDigest getMD() {
        return this.md;
    }

    public byte[] getNameSpace() {
        return this.nameSpace;
    }

    public String getPasswd() {
        return this.cp;
    }

    public PrivateKey getPrivateKey() {
        return sprivkey;
    }

    public PublicKey getPublicKey() {
        return spubkey;
    }

    static CommonServerSecurityContext getRequestSession() {
        return (CommonServerSecurityContext)requestSession.get();
    }

    public String getRoleName() {
        return this.roleName;
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public byte[] getShadow() {
        return this.sf;
    }

    public Signature getSigner() {
        return signer;
    }

    public String getUserName() {
        return this.userName;
    }

    public void incSessionKey() {
        SecurityUtil.incByteArray((byte[])this.sessionKey);
    }

    static SecurityInterface securityIFFactory() throws Exception {
        Class<?> clazz;
        try {
            clazz = Class.forName(System.getProperty("com.sun.wbem.cimom.passwdlib"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogFile.add(0, "NO_SECURITY_INTERFACE", classNotFoundException.toString());
            throw classNotFoundException;
        }
        si = (SecurityInterface)clazz.newInstance();
        return si;
    }

    public void setCapability(String string) {
        this.cap = string;
    }

    public void setCapabilityNS(String string) {
        this.capNameSpace = string;
    }

    public void setClientHostName(String string) {
        this.clientHost = string;
    }

    public void setListener(RemoteCIMListener remoteCIMListener) {
        this.rl = remoteCIMListener;
    }

    public static void setRequestSession(CommonServerSecurityContext commonServerSecurityContext) {
        requestSession.set(commonServerSecurityContext);
    }

    private String toHex(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(hex[byArray[n] >> 4 & 0xF]);
            stringBuffer.append(hex[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String trans51Unformat(String string) {
        byte[] byArray = this.fromHex(string);
        if (byArray == null) {
            return null;
        }
        if (this.decryptKey == null) {
            return null;
        }
        int n = this.decryptKey.length;
        byte[] byArray2 = new byte[n];
        System.arraycopy(this.decryptKey, 0, byArray2, 0, n);
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        while (n2 < n4) {
            int n5 = n2;
            byArray2[n5] = (byte)(byArray2[n5] ^ byArray[n2]);
            if (bl && byArray2[n2] == 0) {
                bl = false;
                n3 = n2;
            }
            ++n2;
        }
        if (n3 < 1 || n3 > 15) {
            return null;
        }
        String string2 = new String(byArray2, 0, n3);
        return string2;
    }

    public SecurityMessage validateResponse(byte[] byArray, byte[] byArray2, PublicKey publicKey, byte[] byArray3, SecurityMessage securityMessage) throws CIMException {
        if (!securityMessage.isResponse()) {
            throw new CIMSecurityException("NOT_RESPONSE");
        }
        this.sessionKey = byArray3;
        this.cpubkey = securityMessage.getPublicKey();
        this.md.reset();
        this.md.update(byArray);
        this.md.update(this.initialKey.getBytes());
        byte[] byArray4 = this.md.digest(byArray2);
        this.md.reset();
        this.md.update(byArray);
        this.md.update(this.initialKey.getBytes());
        this.md.update(byArray2);
        this.md.update(securityMessage.getResponse());
        this.md.update(securityMessage.getPublicKey().getEncoded());
        this.md.update(securityMessage.getSessionId());
        if (!MessageDigest.isEqual(this.md.digest(), securityMessage.getChecksum())) {
            si.auditLogin(this.clientHost, this.userName, -2L);
            throw new CIMSecurityException("INVALID_CREDENTIAL");
        }
        byte[] byArray5 = SecurityUtil.extractHashedData((byte[])securityMessage.getResponse(), (byte[])byArray4);
        if (byArray5 == null) {
            si.auditLogin(this.clientHost, this.userName, -2L);
            throw new CIMSecurityException("INVALID_CREDENTIAL");
        }
        byte[] byArray6 = new byte[]{byArray2[0], byArray2[1]};
        byte[] byArray7 = new WorkMod51().mod51Format(byArray5, byArray6);
        String string = new String(byArray7);
        if (!string.equals(new String(byArray2))) {
            si.auditLogin(this.clientHost, this.userName, -2L);
            throw new CIMSecurityException("INVALID_CREDENTIAL");
        }
        this.decryptKey = new byte[byArray3.length];
        System.arraycopy(byArray3, 0, this.decryptKey, 0, this.decryptKey.length);
        this.auditKey = new byte[4];
        System.arraycopy(byArray3, 0, this.auditKey, 0, 4);
        this.md.reset();
        this.md.update(byArray);
        byArray4 = this.md.digest(byArray5);
        byte[] byArray8 = SecurityUtil.hashData((byte[])byArray3, (byte[])byArray4);
        this.md.reset();
        this.md.update(byArray);
        this.md.update(byArray5);
        this.md.update(securityMessage.getSessionId());
        this.md.update(publicKey.getEncoded());
        si.auditLogin(this.clientHost, this.userName, 1L);
        return SecurityMessage.result((byte[])securityMessage.getSessionId(), (PublicKey)publicKey, (byte[])byArray8, (byte[])this.md.digest(byArray8));
    }
}

