/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.osserver;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.osserver.BootparamsObject;
import com.sun.wbem.solarisprovider.osserver.BootparamsTable;
import com.sun.wbem.solarisprovider.osserver.DBTableException;
import com.sun.wbem.solarisprovider.osserver.DisklessClient;
import com.sun.wbem.solarisprovider.osserver.EtherObject;
import com.sun.wbem.solarisprovider.osserver.EtherTable;
import com.sun.wbem.solarisprovider.osserver.HostObject;
import com.sun.wbem.solarisprovider.osserver.HostTable;
import com.sun.wbem.solarisprovider.osserver.TimezoneObject;
import com.sun.wbem.solarisprovider.osserver.TimezoneTable;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import java.util.Vector;

public class DBTableWrapper {
    private static String BOOTTYPE = "boottype";
    private static String BOOTTYPE_DI = "di";
    private static String BOOTTYPE_OS = "os";
    private static String EQUALS = "=";
    private static String COLON = ":";
    private String scopeUrl = null;
    private ProviderUtility provUtil = null;

    public DBTableWrapper(ProviderUtility providerUtility, String string) {
        this.provUtil = providerUtility;
        this.scopeUrl = string;
    }

    public void addDisklessClient(DisklessClient disklessClient) throws DBTableException, DirectoryTableException {
        if (disklessClient == null) {
            throw new DBTableException("EXM_ADDDC_NULL");
        }
        BootparamsTable bootparamsTable = new BootparamsTable(this.scopeUrl);
        BootparamsObject bootparamsObject = new BootparamsObject(disklessClient.getHostName(), disklessClient.getFileServer(), disklessClient.getRoot(), disklessClient.getSwap(), Integer.toString(disklessClient.getSwapSize()), disklessClient.getDump(), Integer.toString(disklessClient.getDumpSize()), BOOTTYPE_DI, "");
        bootparamsTable.addBootparamsEntry(bootparamsObject);
        HostTable hostTable = new HostTable(this.scopeUrl);
        HostObject hostObject = new HostObject(disklessClient.getIpAddress(), disklessClient.getHostName(), "", "");
        hostTable.addHostEntry(hostObject);
        EtherTable etherTable = new EtherTable(this.scopeUrl);
        EtherObject etherObject = new EtherObject(disklessClient.getEthernetAddress(), disklessClient.getHostName(), "");
        etherTable.addEtherEntry(etherObject);
        if (disklessClient.getTimeZone() != null && disklessClient.getTimeZone().length() != 0) {
            TimezoneTable timezoneTable = new TimezoneTable(this.scopeUrl);
            TimezoneObject timezoneObject = new TimezoneObject(disklessClient.getTimeZone(), disklessClient.getHostName(), "");
            timezoneTable.addTimezoneEntry(timezoneObject);
        }
    }

    public void addOsService(String string) throws DBTableException, DirectoryTableException {
        if (string == null) {
            throw new DBTableException("EXM_ADDOS_INV");
        }
        String string2 = String.valueOf(BOOTTYPE) + EQUALS + COLON + BOOTTYPE_OS;
        BootparamsTable bootparamsTable = new BootparamsTable(this.scopeUrl);
        BootparamsObject bootparamsObject = new BootparamsObject(string, string2, "");
        bootparamsTable.addBootparamsEntry(bootparamsObject);
    }

    public void deleteDisklessClient(String string) throws DBTableException, DirectoryTableException {
        if (string == null) {
            throw new DBTableException("EXM_DELDC_INV");
        }
        HostTable hostTable = new HostTable(this.scopeUrl);
        hostTable.deleteHostEntry(string);
        EtherTable etherTable = new EtherTable(this.scopeUrl);
        etherTable.deleteEtherEntry(string);
        TimezoneTable timezoneTable = new TimezoneTable(this.scopeUrl);
        timezoneTable.deleteTimezoneEntry(string);
        BootparamsTable bootparamsTable = new BootparamsTable(this.scopeUrl);
        bootparamsTable.deleteBootparamsEntry(string);
    }

    public void deleteOsService(String string) throws DBTableException, DirectoryTableException {
        if (string == null) {
            throw new DBTableException("EXM_DELOS_INV");
        }
        BootparamsTable bootparamsTable = new BootparamsTable(this.scopeUrl);
        bootparamsTable.deleteBootparamsEntry(string);
    }

    public DisklessClient getDisklessClient(String string) throws DBTableException, DirectoryTableException {
        TimezoneTable timezoneTable;
        TimezoneObject timezoneObject;
        EtherTable etherTable;
        EtherObject etherObject;
        HostObject hostObject;
        Object object;
        if (string == null) {
            throw new DBTableException("EXM_GETDC_INV");
        }
        DisklessClient disklessClient = new DisklessClient();
        disklessClient.setHostName(string);
        BootparamsTable bootparamsTable = new BootparamsTable(this.scopeUrl);
        BootparamsObject bootparamsObject = bootparamsTable.getBootparamsEntry(string);
        if (bootparamsObject != null) {
            disklessClient.setRoot(bootparamsObject.getIDRoot());
            disklessClient.setSwap(bootparamsObject.getIDSwap());
            disklessClient.setDump(bootparamsObject.getIDDump());
            object = bootparamsObject.getIDSwapSize();
            if (object != null && ((String)object).trim().length() != 0) {
                disklessClient.setSwapSize(Integer.parseInt((String)object));
            } else {
                disklessClient.setSwapSize(0);
            }
            object = bootparamsObject.getIDDumpSize();
            if (object != null && ((String)object).trim().length() != 0) {
                disklessClient.setDumpSize(Integer.parseInt((String)object));
            } else {
                disklessClient.setDumpSize(0);
            }
        }
        if ((hostObject = ((HostTable)(object = new HostTable(this.scopeUrl))).getHostEntry(string)) != null) {
            disklessClient.setIpAddress(hostObject.getIPAddr());
        }
        if ((etherObject = (etherTable = new EtherTable(this.scopeUrl)).getEtherEntry(string)) != null) {
            disklessClient.setEthernetAddress(etherObject.getEthernetAddr());
        }
        if ((timezoneObject = (timezoneTable = new TimezoneTable(this.scopeUrl)).getTimezoneEntry(string)) != null) {
            disklessClient.setTimeZone(timezoneObject.getTimezone());
        }
        return disklessClient;
    }

    public Vector getDisklessClientKeys() throws DBTableException, DirectoryTableException {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = null;
        BootparamsTable bootparamsTable = new BootparamsTable(this.scopeUrl);
        vector2 = bootparamsTable.list();
        int n = 0;
        while (vector2 != null && n < vector2.size()) {
            BootparamsObject bootparamsObject = (BootparamsObject)vector2.elementAt(n);
            if (bootparamsObject != null && bootparamsObject.getIDBoottype().equalsIgnoreCase(BOOTTYPE_DI)) {
                String string = bootparamsObject.getClientName();
                vector.addElement(string);
            }
            ++n;
        }
        return vector;
    }

    public void getDisklessClientPaths(DisklessClient disklessClient) throws DBTableException, DirectoryTableException {
        if (disklessClient == null) {
            throw new DBTableException("EXM_GETPATH_NULL");
        }
        BootparamsTable bootparamsTable = new BootparamsTable(this.scopeUrl);
        BootparamsObject bootparamsObject = bootparamsTable.getBootparamsEntry(disklessClient.getHostName());
        if (bootparamsObject == null || !bootparamsObject.getIDBoottype().equalsIgnoreCase(BOOTTYPE_DI)) {
            throw new DBTableException("EXM_GETPATH_NODC", disklessClient.getHostName());
        }
        disklessClient.setRoot(bootparamsObject.getIDRoot());
        disklessClient.setSwap(bootparamsObject.getIDSwap());
        disklessClient.setDump(bootparamsObject.getIDDump());
    }

    public Vector listDisklessClients() throws DBTableException, DirectoryTableException {
        Vector<DisklessClient> vector = new Vector<DisklessClient>();
        Vector vector2 = null;
        BootparamsTable bootparamsTable = new BootparamsTable(this.scopeUrl);
        vector2 = bootparamsTable.list();
        int n = 0;
        while (vector2 != null && n < vector2.size()) {
            BootparamsObject bootparamsObject = (BootparamsObject)vector2.elementAt(n);
            if (bootparamsObject != null && bootparamsObject.getIDBoottype().equalsIgnoreCase(BOOTTYPE_DI)) {
                TimezoneTable timezoneTable;
                TimezoneObject timezoneObject;
                EtherTable etherTable;
                EtherObject etherObject;
                DisklessClient disklessClient = new DisklessClient();
                String string = bootparamsObject.getClientName();
                disklessClient.setHostName(string);
                disklessClient.setRoot(bootparamsObject.getIDRoot());
                disklessClient.setSwap(bootparamsObject.getIDSwap());
                disklessClient.setDump(bootparamsObject.getIDDump());
                String string2 = bootparamsObject.getIDSwapSize();
                if (string2 != null && string2.trim().length() != 0) {
                    disklessClient.setSwapSize(Integer.parseInt(string2));
                } else {
                    disklessClient.setSwapSize(0);
                }
                string2 = bootparamsObject.getIDDumpSize();
                if (string2 != null && string2.trim().length() != 0) {
                    disklessClient.setDumpSize(Integer.parseInt(string2));
                } else {
                    disklessClient.setDumpSize(0);
                }
                HostTable hostTable = new HostTable(this.scopeUrl);
                HostObject hostObject = hostTable.getHostEntry(string);
                if (hostObject != null) {
                    disklessClient.setIpAddress(hostObject.getIPAddr());
                }
                if ((etherObject = (etherTable = new EtherTable(this.scopeUrl)).getEtherEntry(string)) != null) {
                    disklessClient.setEthernetAddress(etherObject.getEthernetAddr());
                }
                if ((timezoneObject = (timezoneTable = new TimezoneTable(this.scopeUrl)).getTimezoneEntry(string)) != null) {
                    disklessClient.setTimeZone(timezoneObject.getTimezone());
                }
                vector.addElement(disklessClient);
            }
            ++n;
        }
        return vector;
    }

    public void modifyDisklessClient(DisklessClient disklessClient) throws DBTableException, DirectoryTableException {
        if (disklessClient == null || disklessClient.getEthernetAddress() == null || disklessClient.getHostName() == null) {
            throw new DBTableException("EXM_MODDC_NULL");
        }
        EtherTable etherTable = new EtherTable(this.scopeUrl);
        EtherObject etherObject = new EtherObject(disklessClient.getEthernetAddress(), disklessClient.getHostName(), "");
        etherTable.modifyEtherEntry(disklessClient.getHostName(), etherObject);
        if (disklessClient.getTimeZone() != null && disklessClient.getTimeZone().length() > 0) {
            TimezoneTable timezoneTable = new TimezoneTable(this.scopeUrl);
            TimezoneObject timezoneObject = new TimezoneObject(disklessClient.getTimeZone(), disklessClient.getHostName(), "");
            timezoneTable.modifyTimezoneEntry(disklessClient.getHostName(), timezoneObject);
        }
    }
}

