/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.diskdrive;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.solarisprovider.diskdrive.SliceData;
import java.io.Serializable;
import java.util.Vector;

public class DiskData
implements Serializable,
Cloneable {
    private static final int MAX_VOLUMELABEL = 8;
    private static final short MAX_SPARC_SLICE = 7;
    private static final short MAX_X86_SLICE = 9;
    private static final short BYTES_PER_SECTOR = 512;
    private String diskName = "";
    private String diskType = "";
    private String diskLabel = "";
    private int dataCylinders = 0;
    private int physicalCylinders = 0;
    private int alternateCylinders = 0;
    private int headsACylinder = 0;
    private int sectorsATrack = 0;
    private int bytesPerCylinder = 0;
    private int actualCylinders = 0;
    private boolean bX86 = false;
    private boolean fdiskPresent = false;
    private boolean fdiskRequired = false;
    private Vector vSlices;

    public DiskData() {
    }

    public DiskData(CIMInstance cIMInstance) {
        CIMValue cIMValue = cIMInstance.getProperty("DiskName").getValue();
        if (cIMValue != null) {
            this.diskName = (String)cIMValue.getValue();
        }
        if ((cIMValue = cIMInstance.getProperty("DiskType").getValue()) != null) {
            this.diskType = (String)cIMValue.getValue();
        }
        if ((cIMValue = cIMInstance.getProperty("DiskLabel").getValue()) != null) {
            this.diskLabel = (String)cIMValue.getValue();
        }
        if ((cIMValue = cIMInstance.getProperty("DataCylinders").getValue()) != null) {
            this.dataCylinders = ((UnsignedInt32)cIMValue.getValue()).intValue();
        }
        if ((cIMValue = cIMInstance.getProperty("HeadsACylinder").getValue()) != null) {
            this.headsACylinder = ((UnsignedInt32)cIMValue.getValue()).intValue();
        }
        if ((cIMValue = cIMInstance.getProperty("SectorsATrack").getValue()) != null) {
            this.sectorsATrack = ((UnsignedInt32)cIMValue.getValue()).intValue();
        }
        Vector vector = null;
        cIMValue = cIMInstance.getProperty("PartitionTags").getValue();
        if (cIMValue != null) {
            vector = (Vector)cIMValue.getValue();
        }
        Vector vector2 = null;
        cIMValue = cIMInstance.getProperty("PartitionFlags").getValue();
        if (cIMValue != null) {
            vector2 = (Vector)cIMValue.getValue();
        }
        Vector vector3 = null;
        cIMValue = cIMInstance.getProperty("PartitionStartCylinder").getValue();
        if (cIMValue != null) {
            vector3 = (Vector)cIMValue.getValue();
        }
        Vector vector4 = null;
        cIMValue = cIMInstance.getProperty("PartitionNumberOfSectors").getValue();
        if (cIMValue != null) {
            vector4 = (Vector)cIMValue.getValue();
        }
        int n = 0;
        if (vector != null) {
            n = vector.size();
        }
        this.vSlices = new Vector();
        int n2 = 0;
        while (n2 < n) {
            SliceData sliceData = new SliceData((short)n2);
            sliceData.setTag(((UnsignedInt16)vector.elementAt(n2)).shortValue());
            sliceData.setFlag(((UnsignedInt16)vector2.elementAt(n2)).shortValue());
            sliceData.setStartCylinder(((UnsignedInt32)vector3.elementAt(n2)).intValue());
            sliceData.setNumSectors(((UnsignedInt32)vector4.elementAt(n2)).intValue());
            this.vSlices.addElement(sliceData);
            ++n2;
        }
    }

    public DiskData(String string, String string2, String string3, int n, int n2, int n3, Vector vector) {
        this.diskName = string;
        this.diskType = string2;
        this.diskLabel = string3;
        this.dataCylinders = n;
        this.headsACylinder = n2;
        this.sectorsATrack = n3;
        this.vSlices = vector;
    }

    public DiskData(boolean bl) {
        short s = bl ? (short)9 : 7;
        this.vSlices = new Vector(s + 1);
        short s2 = 0;
        while (s2 <= s) {
            this.vSlices.add(new SliceData(s2));
            s2 = (short)(s2 + 1);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public long computeDiskCapacity() {
        long l = this.dataCylinders * this.headsACylinder * this.sectorsATrack * 512;
        return l;
    }

    public long computeDiskFree() {
        return this.computeDiskCapacity() - this.computeDiskUsed();
    }

    public float computeDiskPercentFree() {
        float f = this.computeDiskCapacity();
        float f2 = this.computeDiskFree();
        float f3 = 100.0f * (f2 / f);
        int n = (int)(f3 * 100.0f);
        f3 = n;
        return f3 /= 100.0f;
    }

    public long computeDiskUsed() {
        int n = 0;
        if (this.vSlices != null) {
            int n2 = 0;
            while (n2 < this.vSlices.size()) {
                SliceData sliceData = (SliceData)this.vSlices.elementAt(n2);
                if (sliceData.getTag() != 5) {
                    int n3 = sliceData.getStartCylinder();
                    int n4 = sliceData.getNumSectors();
                    n += n4 - this.cylinderToSector(n3);
                }
                ++n2;
            }
        }
        return n * 512;
    }

    private UnsignedInt32 convertIntToCIMUnsignedInt(int n) {
        try {
            return new UnsignedInt32(Integer.toString(n));
        }
        catch (Exception exception) {
            return new UnsignedInt32("0");
        }
    }

    private UnsignedInt16 convertShortToCIMUnsignedInt16(short s) {
        try {
            return new UnsignedInt16(Short.toString(s));
        }
        catch (Exception exception) {
            return new UnsignedInt16("0");
        }
    }

    public int cylinderToSector(int n) {
        return n * this.headsACylinder * this.sectorsATrack;
    }

    public boolean equals(DiskData diskData) {
        if (diskData == null) {
            return false;
        }
        return this.getDiskName().equals(diskData.getDiskName()) && this.getDiskType().equals(diskData.getDiskType()) && this.getDiskLabel().equals(diskData.getDiskLabel());
    }

    public int getActualCylinders() {
        return this.actualCylinders;
    }

    public int getAlternateCylinders() {
        return this.alternateCylinders;
    }

    public int getBytesPerCylinder() {
        return this.bytesPerCylinder;
    }

    public int getDataCylinders() {
        return this.dataCylinders;
    }

    public String getDiskCapacity() {
        Long l = new Long(this.computeDiskCapacity());
        return l.toString();
    }

    public String getDiskFree() {
        Long l = new Long(this.computeDiskFree());
        return l.toString();
    }

    public String getDiskLabel() {
        return this.diskLabel;
    }

    public String getDiskName() {
        return this.diskName;
    }

    public String getDiskPercentFree() {
        Float f = new Float(this.computeDiskPercentFree());
        return f.toString();
    }

    public String getDiskType() {
        return this.diskType;
    }

    public String getDiskUsed() {
        Long l = new Long(this.computeDiskUsed());
        return l.toString();
    }

    public int getHeadsACylinder() {
        return this.headsACylinder;
    }

    public String getNumCylinders() {
        return new String("1024");
    }

    public int getPhysicalCylinders() {
        return this.physicalCylinders;
    }

    public int getSectorsATrack() {
        return this.sectorsATrack;
    }

    public Vector getVSlices() {
        return this.vSlices;
    }

    public boolean isFdiskPresent() {
        return this.fdiskPresent;
    }

    public boolean isFdiskRequired() {
        return this.fdiskRequired;
    }

    public void print() {
        System.out.println("*************************************");
        System.out.println("Disk Name:            " + this.diskName);
        System.out.println("Disk Type:            " + this.diskType);
        System.out.println("Volume Label:        " + this.diskLabel);
        System.out.println("Disk Capacity:        " + this.getDiskCapacity());
        System.out.println("Disk Used:            " + this.getDiskUsed());
        System.out.println("Disk Free:            " + this.getDiskFree());
        System.out.println("Disk Percent Free:    " + this.getDiskPercentFree());
        System.out.println("Total Data Cylinders: " + this.dataCylinders);
        System.out.println("Heads Per Cylinder: " + this.headsACylinder);
        System.out.println("Sectors Per Track: " + this.sectorsATrack);
        System.out.println("*************************************");
        if (this.vSlices != null) {
            int n = 0;
            while (n < this.vSlices.size()) {
                SliceData sliceData = (SliceData)this.vSlices.elementAt(n);
                sliceData.print();
                ++n;
            }
        }
    }

    public int sectorToCylinder(int n) {
        return n / this.sectorsATrack / this.headsACylinder;
    }

    public void setDiskLabel(String string) {
        this.diskLabel = string;
    }

    public CIMInstance toCIMInstance(CIMClass cIMClass) throws CIMException {
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty("DiskName", new CIMValue((Object)this.diskName));
        cIMInstance.setProperty("DiskType", new CIMValue((Object)this.diskType));
        cIMInstance.setProperty("DiskLabel", new CIMValue((Object)this.diskLabel));
        UnsignedInt32 unsignedInt32 = this.convertIntToCIMUnsignedInt(this.dataCylinders);
        cIMInstance.setProperty("DataCylinders", new CIMValue((Object)unsignedInt32));
        UnsignedInt32 unsignedInt322 = this.convertIntToCIMUnsignedInt(this.headsACylinder);
        cIMInstance.setProperty("HeadsACylinder", new CIMValue((Object)unsignedInt322));
        UnsignedInt32 unsignedInt323 = this.convertIntToCIMUnsignedInt(this.sectorsATrack);
        cIMInstance.setProperty("SectorsATrack", new CIMValue((Object)unsignedInt323));
        if (this.vSlices != null) {
            Vector<UnsignedInt16> vector = new Vector<UnsignedInt16>();
            Vector<UnsignedInt16> vector2 = new Vector<UnsignedInt16>();
            Vector<UnsignedInt32> vector3 = new Vector<UnsignedInt32>();
            Vector<UnsignedInt32> vector4 = new Vector<UnsignedInt32>();
            int n = 0;
            while (n < this.vSlices.size()) {
                SliceData sliceData = (SliceData)this.vSlices.elementAt(n);
                UnsignedInt16 unsignedInt16 = this.convertShortToCIMUnsignedInt16(sliceData.getTag());
                vector.addElement(unsignedInt16);
                UnsignedInt16 unsignedInt162 = this.convertShortToCIMUnsignedInt16(sliceData.getFlag());
                vector2.addElement(unsignedInt162);
                UnsignedInt32 unsignedInt324 = this.convertIntToCIMUnsignedInt(sliceData.getStartCylinder());
                vector3.addElement(unsignedInt324);
                UnsignedInt32 unsignedInt325 = this.convertIntToCIMUnsignedInt(sliceData.getNumSectors());
                vector4.addElement(unsignedInt325);
                ++n;
            }
            cIMInstance.setProperty("PartitionTags", new CIMValue(vector));
            cIMInstance.setProperty("PartitionFlags", new CIMValue(vector2));
            cIMInstance.setProperty("PartitionStartCylinder", new CIMValue(vector3));
            cIMInstance.setProperty("PartitionNumberOfSectors", new CIMValue(vector4));
        }
        return cIMInstance;
    }
}

