/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.logviewer.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.logviewer.client.LogContextHelpListener;
import com.sun.admin.logviewer.client.LogSettingsPanel;
import com.sun.admin.logviewer.client.VLogViewer;
import com.sun.admin.logviewer.common.LogViewerException;
import com.sun.management.viper.console.gui.VFrame;
import com.sun.management.viper.console.gui.VOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class LogSettings
extends VOptionPane {
    public static final int HELP_CACHE_SIZE = 2;
    GenInfoPanel infoPanel;
    Vector helpCache;
    LogContextHelpListener helpListener;
    VLogViewer theApp;
    ResourceBundle bundle;
    LogSettingsPanel genPanel;
    JButton okBtn;
    JButton cancelBtn;
    GridBagConstraints gbc = new GridBagConstraints();

    public LogSettings(VLogViewer vLogViewer) {
        this.theApp = vLogViewer;
        this.bundle = vLogViewer.getResourceBundle();
        this.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"main_title"));
        this.infoPanel = new GenInfoPanel((VOptionPane)this);
        this.helpCache = new Vector(2);
        this.helpListener = new LogContextHelpListener(vLogViewer, this.helpCache, this.infoPanel, "lm_ctx_dlg_settings_overview");
        this.infoPanel.setFocusListener((FocusListener)((Object)this.helpListener), true);
        JPanel jPanel = this.buildBtnPanel();
        JComponent jComponent = this.getButtonPane();
        jComponent.setLayout(new GridBagLayout());
        Constraints.constrain((Container)jComponent, (Component)jPanel, (int)0, (int)0, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        this.genPanel = new LogSettingsPanel(vLogViewer, this);
        JComponent jComponent2 = this.getContentPane();
        jComponent2.setLayout(new GridBagLayout());
        Constraints.constrain((Container)jComponent2, (Component)this.genPanel, (int)0, (int)0, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
    }

    protected JPanel buildBtnPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        Constraints.constrain((Container)jPanel, (Component)jPanel2, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        BtnListener btnListener = new BtnListener();
        String string = new String(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"okBtn"));
        this.okBtn = new JButton(string);
        this.okBtn.addActionListener(btnListener);
        Constraints.constrain((Container)jPanel, (Component)this.okBtn, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        string = new String(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"cancelBtn"));
        this.cancelBtn = new JButton(string);
        this.cancelBtn.addActionListener(btnListener);
        Constraints.constrain((Container)jPanel, (Component)this.cancelBtn, (int)2, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)6, (int)0, (int)6, (int)6);
        return jPanel;
    }

    public void doCancel() {
        VFrame vFrame = (VFrame)this.getContainer();
        vFrame.dispose();
    }

    public void doOK() {
        this.theApp.waitOn();
        if (!this.genPanel.areFieldsOK()) {
            LogViewerException logViewerException = new LogViewerException("EXM_LV_GUI_BAD_SETTINGS");
            this.theApp.reportErrorException((Exception)((Object)logViewerException));
        } else {
            try {
                this.genPanel.updateSettings();
                this.doCancel();
            }
            catch (AdminException adminException) {
                this.theApp.reportErrorException((Exception)((Object)adminException));
            }
        }
        this.theApp.waitOff();
    }

    public JButton getOKBtn() {
        return this.okBtn;
    }

    public LogSettingsPanel getPanel() {
        return this.genPanel;
    }

    class BtnListener
    implements ActionListener {
        BtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == LogSettings.this.okBtn) {
                LogSettings.this.doOK();
            } else if (actionEvent.getSource() == LogSettings.this.cancelBtn) {
                LogSettings.this.doCancel();
            }
        }
    }
}

