/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client.WBEMClient;

import com.sun.admin.diskmgr.client.WBEMClient.ClientProxyException;
import com.sun.admin.diskmgr.common.DiskData;
import com.sun.admin.diskmgr.common.FdiskData;
import com.sun.admin.diskmgr.common.SliceData;
import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMSecurityException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt8;
import com.sun.wbem.client.CIMClient;
import com.sun.wbem.security.PasswordCredential;
import com.sun.wbem.security.UserPrincipal;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Vector;

public class DiskMgrClientWrapper {
    private static final String DISK_PATH = new String("CIM_DiskDrive");
    private static final String SOLARIS_DISK_PATH = new String("Solaris_DiskDrive");
    private static final String DEVICE_ID = new String("DeviceID");
    private static final String DISK_TYPE = new String("DiskType");
    private static final String DISK_LABEL = new String("DiskLabel");
    private static final String TOTAL_CYLINDERS = new String("DataCylinders");
    private static final String ACTUAL_CYLINDERS = new String("ActualCylinders");
    private static final String HEADS_PER_CYL = new String("HeadsPerCylinder");
    private static final String SECTORS_PER_TRACK = new String("SectorsPerTrack");
    private static final String PLATFORM = new String("FdiskRequired");
    private static final String SLICE_PATH = new String("CIM_DiskPartition");
    private static final String SOLARIS_SLICE_PATH = new String("Solaris_DiskPartition");
    private static final String DISK_NAME = new String("DiskName");
    private static final String SLICE_TAG = new String("Tag");
    private static final String SLICE_FLAG = new String("Flag");
    private static final String START_CYL = new String("StartCylinder");
    private static final String NUM_SECTORS = new String("Blocks");
    private static final String FS = new String("ValidFileSystem");
    private static final String CIM_ACCESS_DENIED = "CIM_ERR_ACCESS_DENIED";
    private static final String CIM_GEN_EXCEPTION = "GENERAL_EXCEPTION";
    private CIMClient cc = null;

    private void addFdiskData(DiskData diskData) throws CIMException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_DISK_PATH);
        cIMObjectPath.addKey(DEVICE_ID, new CIMValue((Object)diskData.getDiskName()));
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.cc.invokeMethod(cIMObjectPath, "GetFdiskPartitions", vector, vector2);
        Vector<FdiskData> vector3 = new Vector<FdiskData>();
        short s = 0;
        if (vector2.size() > 0) {
            int n = 0;
            while (n < vector2.size()) {
                CIMValue cIMValue = null;
                cIMValue = (CIMValue)vector2.elementAt(n);
                Number number = (Number)cIMValue.getValue();
                cIMValue = (CIMValue)vector2.elementAt(n + 1);
                Integer n2 = (Integer)cIMValue.getValue();
                boolean bl = false;
                if (n2 == 128) {
                    bl = true;
                }
                cIMValue = (CIMValue)vector2.elementAt(n + 2);
                Number number2 = (Number)cIMValue.getValue();
                int n3 = diskData.sectorToCylinder(number2.intValue());
                cIMValue = (CIMValue)vector2.elementAt(n + 3);
                Number number3 = (Number)cIMValue.getValue();
                FdiskData fdiskData = new FdiskData(diskData, s, number.shortValue(), n3, number3.intValue(), bl);
                vector3.addElement(fdiskData);
                s = (short)(s + 1);
                n += 4;
            }
            diskData.setVPartitions(vector3);
        }
    }

    private void addSliceData(DiskData diskData) throws CIMException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_SLICE_PATH);
        cIMObjectPath.addKey(DISK_NAME, new CIMValue((Object)diskData.getDiskName()));
        Vector<SliceData> vector = new Vector<SliceData>();
        CIMInstance cIMInstance = null;
        CIMValue cIMValue = null;
        String string = this.queryForPartitions(diskData);
        Enumeration enumeration = this.cc.execQuery(cIMObjectPath, string, 0);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                cIMInstance = (CIMInstance)enumeration.nextElement();
                String string2 = (String)cIMInstance.getProperty(DEVICE_ID).getValue().getValue();
                Short s = new Short(string2 = string2.substring(string2.indexOf(115) + 1));
                if (s.intValue() > 9) continue;
                Number number = (Number)cIMInstance.getProperty(SLICE_TAG).getValue().getValue();
                Number number2 = (Number)cIMInstance.getProperty(SLICE_FLAG).getValue().getValue();
                Number number3 = (Number)cIMInstance.getProperty(START_CYL).getValue().getValue();
                Number number4 = (Number)cIMInstance.getProperty(NUM_SECTORS).getValue().getValue();
                cIMValue = cIMInstance.getProperty(FS).getValue();
                Boolean bl = new Boolean(true);
                if (cIMValue != null) {
                    bl = (Boolean)cIMValue.getValue();
                }
                SliceData sliceData = new SliceData(diskData, s, number.shortValue(), number2.shortValue(), number3.intValue(), number4.intValue(), bl);
                vector.addElement(sliceData);
            }
            diskData.setVSlices(vector);
        }
    }

    private DiskData buildDiskData(CIMInstance cIMInstance) throws CIMException {
        String string = (String)cIMInstance.getProperty(DEVICE_ID).getValue().getValue();
        String string2 = (String)cIMInstance.getProperty(DISK_TYPE).getValue().getValue();
        CIMValue cIMValue = cIMInstance.getProperty(DISK_LABEL).getValue();
        String string3 = null;
        if (cIMValue != null) {
            string3 = (String)cIMValue.getValue();
        }
        Number number = (Number)cIMInstance.getProperty(TOTAL_CYLINDERS).getValue().getValue();
        Number number2 = (Number)cIMInstance.getProperty(ACTUAL_CYLINDERS).getValue().getValue();
        Number number3 = (Number)cIMInstance.getProperty(HEADS_PER_CYL).getValue().getValue();
        Number number4 = (Number)cIMInstance.getProperty(SECTORS_PER_TRACK).getValue().getValue();
        DiskData diskData = new DiskData(string, string2, string3, number.intValue(), number2.intValue(), number3.intValue(), number4.intValue());
        Boolean bl = (Boolean)cIMInstance.getProperty(PLATFORM).getValue().getValue();
        diskData.setX86(bl);
        this.addSliceData(diskData);
        if (bl.booleanValue()) {
            this.addFdiskData(diskData);
        }
        return diskData;
    }

    public void createDefaultFdiskPartition(DiskData diskData) throws ClientProxyException {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_DISK_PATH);
            cIMObjectPath.addKey(DEVICE_ID, new CIMValue((Object)diskData.getDiskName()));
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            this.cc.invokeMethod(cIMObjectPath, "CreateDefaultFdiskPartition", vector, vector2);
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals(CIM_GEN_EXCEPTION)) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string);
            }
            throw new ClientProxyException("EXM_CIM_DEFAULT_FDISK", diskData.getDiskName(), cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_GEN_DEFAULT_FDISK", diskData.getDiskName(), exception.getLocalizedMessage());
        }
    }

    public void createFS(SliceData sliceData) throws ClientProxyException {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_SLICE_PATH);
            cIMObjectPath.addKey(DEVICE_ID, new CIMValue((Object)sliceData.getSliceName()));
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            this.cc.invokeMethod(cIMObjectPath, "CreateFileSystem", vector, vector2);
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals(CIM_GEN_EXCEPTION)) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string);
            }
            throw new ClientProxyException("EXM_SLICE_CIM_NEWFS", sliceData.getSliceName(), cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_SLICE_GEN_NEWFS", sliceData.getSliceName(), exception.getLocalizedMessage());
        }
    }

    public void fdiskDisk(DiskData diskData) throws ClientProxyException {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_DISK_PATH);
            cIMObjectPath.addKey(DEVICE_ID, new CIMValue((Object)diskData.getDiskName()));
            Vector<String> vector = new Vector<String>();
            Vector vector2 = new Vector();
            Enumeration enumeration = diskData.getVPartitions().elements();
            FdiskData fdiskData = null;
            String string = "128";
            String string2 = "0";
            while (enumeration.hasMoreElements()) {
                fdiskData = (FdiskData)enumeration.nextElement();
                if (fdiskData.getEndCylinder() < 1) continue;
                String string3 = Short.toString(fdiskData.getUsedFor());
                vector.addElement(string3);
                String string4 = "0";
                if (fdiskData.getActive()) {
                    string4 = "128";
                }
                vector.addElement(string4);
                String string5 = Integer.toString(diskData.cylinderToSector(fdiskData.getStartCylinder()));
                vector.addElement(string5);
                String string6 = Integer.toString(fdiskData.getNumSectors());
                vector.addElement(string6);
            }
            this.cc.invokeMethod(cIMObjectPath, "CreateFdiskPartitions", vector, vector2);
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals(CIM_GEN_EXCEPTION)) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string);
            }
            throw new ClientProxyException("EXM_CIM_FDISK", diskData.getDiskName(), cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_GEN_FDISK", diskData.getDiskName(), exception.getLocalizedMessage());
        }
    }

    public void formatDisk(DiskData diskData) throws ClientProxyException {
        diskData.sortSlicesByPartition();
        Vector vector = diskData.getVSlices();
        SliceData sliceData = (SliceData)vector.elementAt(2);
        if (diskData.isX86() && sliceData.getTag() != 5 && sliceData.getEndCylinder() <= 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                SliceData sliceData2 = (SliceData)enumeration.nextElement();
                this.formatSlice(sliceData2);
            }
            return;
        }
        try {
            Vector<String> vector2 = new Vector<String>();
            Vector vector3 = new Vector();
            Enumeration enumeration = diskData.getVSlices().elements();
            SliceData sliceData3 = null;
            while (enumeration.hasMoreElements()) {
                sliceData3 = (SliceData)enumeration.nextElement();
                String string = Short.toString(sliceData3.getPartition());
                vector2.addElement(string);
                String string2 = Short.toString(sliceData3.getTag());
                vector2.addElement(string2);
                String string3 = Short.toString(sliceData3.getFlag());
                vector2.addElement(string3);
                String string4 = Integer.toString(diskData.cylinderToSector(sliceData3.getStartCylinder()));
                vector2.addElement(string4);
                String string5 = Integer.toString(sliceData3.getNumSectors());
                vector2.addElement(string5);
            }
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_SLICE_PATH);
            cIMObjectPath.addKey(DEVICE_ID, new CIMValue((Object)sliceData3.getSliceName()));
            CIMValue cIMValue = this.cc.invokeMethod(cIMObjectPath, "CreatePartitions", vector2, vector3);
            Boolean bl = (Boolean)cIMValue.getValue();
            if (!bl.booleanValue()) {
                throw new ClientProxyException("EXM_DISK_FMT", diskData.getDiskName());
            }
            enumeration = diskData.getVSlices().elements();
            while (enumeration.hasMoreElements()) {
                sliceData3 = (SliceData)enumeration.nextElement();
                if (!sliceData3.getFS()) continue;
                this.createFS(sliceData3);
            }
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals(CIM_GEN_EXCEPTION)) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string);
            }
            throw new ClientProxyException("EXM_DISK_CIM_FMT", diskData.getDiskName(), cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_DISK_GEN_FMT", diskData.getDiskName(), exception.getLocalizedMessage());
        }
    }

    public void formatSlice(SliceData sliceData) throws ClientProxyException {
        try {
            Vector<CIMProperty> vector = new Vector<CIMProperty>();
            CIMProperty cIMProperty = new CIMProperty(DEVICE_ID);
            cIMProperty.setValue(new CIMValue((Object)sliceData.getSliceName()));
            vector.addElement(cIMProperty);
            cIMProperty = new CIMProperty(START_CYL);
            cIMProperty.setValue(new CIMValue((Object)new UnsignedInt32((long)sliceData.getStartCylinder())));
            vector.addElement(cIMProperty);
            cIMProperty = new CIMProperty(NUM_SECTORS);
            cIMProperty.setValue(new CIMValue((Object)new UnsignedInt32((long)sliceData.getNumSectors())));
            vector.addElement(cIMProperty);
            cIMProperty = new CIMProperty(SLICE_TAG);
            cIMProperty.setValue(new CIMValue((Object)new UnsignedInt8(sliceData.getTag())));
            vector.addElement(cIMProperty);
            cIMProperty = new CIMProperty(SLICE_FLAG);
            cIMProperty.setValue(new CIMValue((Object)new UnsignedInt8(sliceData.getFlag())));
            vector.addElement(cIMProperty);
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_SLICE_PATH);
            CIMClass cIMClass = this.cc.getClass(cIMObjectPath, false);
            CIMInstance cIMInstance = cIMClass.newInstance();
            cIMInstance.setProperties(vector);
            this.cc.setInstance(cIMObjectPath, cIMInstance);
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals(CIM_GEN_EXCEPTION)) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string);
            }
            throw new ClientProxyException("EXM_SLICE_CIM_FMT", sliceData.getSliceName(), cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_SLICE_GEN_FMT", sliceData.getSliceName(), exception.getLocalizedMessage());
        }
    }

    public DiskData getDisk(String string) throws ClientProxyException {
        DiskData diskData = null;
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_DISK_PATH);
            cIMObjectPath.addKey(DEVICE_ID, new CIMValue((Object)string));
            CIMInstance cIMInstance = this.cc.getInstance(cIMObjectPath, false);
            if (cIMInstance != null) {
                diskData = this.buildDiskData(cIMInstance);
            }
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals(CIM_ACCESS_DENIED)) {
                throw new ClientProxyException("EXM_DISK_SCTY_READALL");
            }
            throw new ClientProxyException("EXM_GEN_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals(CIM_GEN_EXCEPTION)) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            throw new ClientProxyException("EXM_DISK_CIM_READ", string, cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_DISK_GEN_READ", string, exception.getLocalizedMessage());
        }
        return diskData;
    }

    private String getKeyBoard(String string) {
        System.out.print(string);
        try {
            byte[] byArray = new byte[100];
            char c = (char)System.in.read(byArray);
            if ((char)byArray[c - '\u0001'] == '\n') {
                byArray[c - '\u0001'] = 0;
            }
            String string2 = new String(byArray);
            return string2.trim();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            exception.printStackTrace();
            return new String("");
        }
    }

    public void init(CIMClient cIMClient) throws CIMException {
        this.cc = cIMClient;
    }

    public void labelDisk(DiskData diskData) throws ClientProxyException {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_DISK_PATH);
            cIMObjectPath.addKey(DEVICE_ID, new CIMValue((Object)diskData.getDiskName()));
            Vector<String> vector = new Vector<String>();
            vector.addElement(diskData.getDiskLabel());
            Vector vector2 = new Vector();
            this.cc.invokeMethod(cIMObjectPath, "LabelDisk", vector, vector2);
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals(CIM_GEN_EXCEPTION)) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string);
            }
            throw new ClientProxyException("EXM_CIM_LABEL", diskData.getDiskName(), cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_GEN_LABEL", diskData.getDiskName(), exception.getLocalizedMessage());
        }
    }

    public Vector listDisks() throws ClientProxyException {
        Vector<DiskData> vector = new Vector<DiskData>();
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_DISK_PATH);
            Enumeration enumeration = this.cc.enumInstances(cIMObjectPath, true, false);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                    DiskData diskData = this.buildDiskData(cIMInstance);
                    vector.addElement(diskData);
                }
            }
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals(CIM_ACCESS_DENIED)) {
                throw new ClientProxyException("EXM_DISK_SCTY_READALL");
            }
            throw new ClientProxyException("EXM_GEN_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals(CIM_GEN_EXCEPTION)) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string);
            }
            throw new ClientProxyException("EXM_DISK_CIM_READALL", cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_DISK_GEN_READALL", exception.getLocalizedMessage());
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        block5: {
            String string = "Usage: DiskMgrClientWrapper host username password";
            if (stringArray.length != 3) {
                System.out.println(string);
                System.exit(1);
            }
            CIMClient cIMClient = null;
            try {
                CIMNameSpace cIMNameSpace = new CIMNameSpace(stringArray[0]);
                UserPrincipal userPrincipal = new UserPrincipal(stringArray[1]);
                PasswordCredential passwordCredential = new PasswordCredential(stringArray[2]);
                cIMClient = new CIMClient(cIMNameSpace, (Principal)userPrincipal, (Object)passwordCredential);
                DiskMgrClientWrapper diskMgrClientWrapper = new DiskMgrClientWrapper();
                diskMgrClientWrapper.init(cIMClient);
                diskMgrClientWrapper.test();
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception);
                exception.printStackTrace();
            }
            if (cIMClient == null) break block5;
            try {
                cIMClient.close();
            }
            catch (Exception exception) {}
        }
    }

    private String queryForPartitions(DiskData diskData) {
        String string = "select * from Solaris_DiskPartition where ";
        string = String.valueOf(string) + "( DiskID = '" + diskData.getDiskName() + "' )";
        return string;
    }

    /*
     * Exception decompiling
     */
    private void test() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void testChangeLabel() throws CIMException {
        System.out.println("------ Change Volume Name Begin -------\n");
        String string = this.getKeyBoard("Disk name(c#t#d#): ");
        try {
            DiskData diskData = this.getDisk(string);
            if (diskData == null) {
                System.out.println("Disk not found on server");
            } else {
                String string2 = this.getKeyBoard("Volume Name[" + diskData.getDiskLabel() + "]: ");
                if (string2.length() == 0) {
                    return;
                }
                diskData.setDiskLabel(string2);
                this.formatDisk(diskData);
            }
        }
        catch (ClientProxyException clientProxyException) {
            clientProxyException.printStackTrace();
        }
        System.out.println("\n------ Change Volume Name End -------\n");
    }

    private void testChangeSlice() throws CIMException {
        block9: {
            System.out.println("------ Change Slice Begin -------\n");
            String string = this.getKeyBoard("Disk name(c#t#d#): ");
            try {
                DiskData diskData = this.getDisk(string);
                if (diskData == null) {
                    System.out.println("Disk not found on server");
                    break block9;
                }
                try {
                    String string2;
                    String string3;
                    String string4;
                    String string5 = this.getKeyBoard("Partition Number: ");
                    short s = new Short(string5);
                    Vector vector = diskData.getVSlices();
                    SliceData sliceData = (SliceData)vector.elementAt(s);
                    String string6 = this.getKeyBoard("Tag[" + sliceData.getTag() + "]: ");
                    if (string6.length() == 0) {
                        string6 = new Short(sliceData.getTag()).toString();
                    }
                    if ((string4 = this.getKeyBoard("Flag[" + sliceData.getFlag() + "]: ")).length() == 0) {
                        string4 = new Short(sliceData.getFlag()).toString();
                    }
                    if ((string3 = this.getKeyBoard("Start Cylinder[" + sliceData.getStartCylinder() + "]: ")).length() == 0) {
                        string3 = new Integer(sliceData.getStartCylinder()).toString();
                    }
                    if ((string2 = this.getKeyBoard("Number of sectors[" + sliceData.getNumSectors() + "]: ")).length() == 0) {
                        string2 = new Integer(sliceData.getNumSectors()).toString();
                    }
                    sliceData = new SliceData(diskData, s, new Short(string6), new Short(string4), new Integer(string3), new Integer(string2), true);
                    vector.setElementAt(sliceData, s);
                    this.formatDisk(diskData);
                }
                catch (Exception exception) {
                    System.out.println("Exception: " + exception);
                    exception.printStackTrace();
                    return;
                }
            }
            catch (ClientProxyException clientProxyException) {
                clientProxyException.printStackTrace();
            }
        }
        System.out.println("\n------ Change Slice End -------\n");
    }

    /*
     * Exception decompiling
     */
    private void testFormatDisk() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void testGetDisk() throws CIMException {
        System.out.println("------ Get Disk Begin -------\n");
        String string = this.getKeyBoard("Disk name(c#t#d#): ");
        try {
            DiskData diskData = this.getDisk(string);
            if (diskData == null) {
                System.out.println("Entry not found");
            } else {
                diskData.print();
            }
            System.out.println("\n------ Get Disk End -------\n");
        }
        catch (ClientProxyException clientProxyException) {
            clientProxyException.printStackTrace();
        }
    }

    private void testListDisks() throws CIMException {
        System.out.println("------ List Disks Begin -------\n");
        Vector vector = new Vector();
        try {
            vector = this.listDisks();
        }
        catch (ClientProxyException clientProxyException) {}
        int n = 0;
        while (n < vector.size()) {
            DiskData diskData = (DiskData)vector.elementAt(n);
            diskData.print();
            ++n;
        }
        System.out.println("\n------ List Disks End -------\n");
    }
}

