/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.diskmgr.client.Content;
import com.sun.admin.diskmgr.client.DiskMgrContextHelpListener;
import com.sun.admin.diskmgr.client.SliceReviewStep;
import com.sun.admin.diskmgr.client.SliceWizard;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.admin.diskmgr.common.DiskData;
import com.sun.admin.diskmgr.common.SliceData;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SliceFsStep
extends VWizardCard {
    public static final String NAME = "SliceFsStep";
    public static final int HELP_CACHE_SIZE = 2;
    GenInfoPanel infoPanel;
    Vector helpCache;
    DiskMgrContextHelpListener helpListener;
    DiskData diskData;
    ResourceBundle bundle;
    SliceWizard wizard;
    VDiskMgr theApp;
    SliceReviewStep reviewStep = null;
    Vector slices;
    Vector vChecks;
    int numToCreate;

    public SliceFsStep(VDiskMgr vDiskMgr, SliceWizard sliceWizard) {
        this.theApp = vDiskMgr;
        this.wizard = sliceWizard;
        this.diskData = sliceWizard.getDiskData();
        this.bundle = vDiskMgr.getResourceBundle();
        this.infoPanel = new GenInfoPanel((VOptionPane)sliceWizard);
        this.helpCache = new Vector(2);
        this.helpListener = new DiskMgrContextHelpListener(vDiskMgr, this.helpCache, this.infoPanel, "disk_wiz_custom_fs");
        this.infoPanel.setFocusListener((FocusListener)((Object)this.helpListener), true);
        this.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"SliceWizFsStep"));
        this.constructStep();
    }

    private void constructStep() {
        ((Container)((Object)this)).removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"SliceWizPartition"));
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"SliceWizSize"));
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)1, (int)0, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"SliceWizUsedFor"));
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)2, (int)0, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"SliceWizFileSystem"));
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)3, (int)0, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        JPanel jPanel2 = new JPanel();
        Constraints.constrain((Container)jPanel, (Component)jPanel2, (int)4, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        int n = 1;
        this.slices = this.wizard.getSlices();
        SliceData sliceData = null;
        this.numToCreate = this.wizard.getNumSlices();
        if (this.wizard.hasBackup()) {
            ++this.numToCreate;
        }
        this.vChecks = new Vector(this.numToCreate);
        int n2 = 0;
        while (n2 < this.numToCreate) {
            int n3 = n2;
            if (this.wizard.hasBackup() && this.numToCreate < 3 && n2 == 1) {
                n3 = 2;
            }
            sliceData = (SliceData)this.slices.elementAt(n3);
            JLabel jLabel2 = new JLabel(Integer.toString(n3));
            Constraints.constrain((Container)jPanel, (Component)jLabel2, (int)0, (int)n, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)3, (int)6, (int)6, (int)6);
            JLabel jLabel3 = new JLabel(Content.formatSuffix(sliceData.getSize(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"Megabytes")));
            Constraints.constrain((Container)jPanel, (Component)jLabel3, (int)1, (int)n, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)3, (int)6, (int)6, (int)6);
            JLabel jLabel4 = new JLabel(sliceData.getTagAsString());
            Constraints.constrain((Container)jPanel, (Component)jLabel4, (int)2, (int)n, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)3, (int)6, (int)6, (int)6);
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setSelected(sliceData.getFS());
            JComponent jComponent = jCheckBox;
            if (sliceData.getTag() == 5) {
                jLabel2.setFont(Constants.ITALIC_DIALOG_FONT);
                jLabel3.setFont(Constants.ITALIC_DIALOG_FONT);
                jLabel4.setText(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"SliceWizBackup"));
                jLabel4.setFont(Constants.ITALIC_DIALOG_FONT);
                jComponent = new JLabel();
            }
            this.vChecks.addElement(jComponent);
            this.helpListener = new DiskMgrContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "disk_wiz_custom_fs_create");
            this.theApp.addHelpListener(this.helpListener, jComponent);
            Constraints.constrain((Container)jPanel, (Component)jComponent, (int)3, (int)n, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)3, (int)6, (int)6, (int)6);
            jPanel2 = new JPanel();
            Constraints.constrain((Container)jPanel, (Component)jPanel2, (int)4, (int)n, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            ++n;
            ++n2;
        }
        Constraints.constrain((Container)((Object)this), (Component)jPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        jPanel2 = new JPanel();
        Constraints.constrain((Container)((Object)this), (Component)jPanel2, (int)0, (int)1, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
    }

    public boolean isSubStep() {
        return true;
    }

    public void reset() {
    }

    public void start() {
        super.start();
        this.constructStep();
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.canmoveforward", "vwp.true");
    }

    public boolean stop(boolean bl) {
        if (this.wizard.isCustom()) {
            int n = this.wizard.getNumSlices() - 1;
            if (this.wizard.hasBackup() && this.wizard.getNumSlices() > 2) {
                ++n;
            }
            this.getManager().setPrevious(NAME, "SliceCustomStep".concat(Integer.toString(n)));
        } else {
            this.getManager().setPrevious(NAME, "SliceUseStep");
        }
        if (bl) {
            if (this.reviewStep == null) {
                this.reviewStep = new SliceReviewStep(this.theApp, this.wizard);
                this.wizard.addCard("SliceReviewStep", this.reviewStep);
            }
            this.getManager().setNext(NAME, "SliceReviewStep");
            int n = 0;
            while (n < this.vChecks.size()) {
                SliceData sliceData;
                int n2 = n;
                if (this.wizard.hasBackup() && this.numToCreate < 3 && n == 1) {
                    n2 = 2;
                }
                if ((sliceData = (SliceData)this.slices.elementAt(n2)).getTag() != 5) {
                    JCheckBox jCheckBox = (JCheckBox)this.vChecks.elementAt(n);
                    sliceData.setFS(jCheckBox.isSelected());
                }
                ++n;
            }
        }
        return true;
    }
}

