/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.diskmgr.client.ChangeFdiskDialog;
import com.sun.admin.diskmgr.client.Content;
import com.sun.admin.diskmgr.client.CopyLayoutDialog;
import com.sun.admin.diskmgr.client.DiskContent;
import com.sun.admin.diskmgr.client.DiskPropDialog;
import com.sun.admin.diskmgr.client.FdiskWizard;
import com.sun.admin.diskmgr.client.SliceWizard;
import com.sun.admin.diskmgr.client.TreeNodeData;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.admin.diskmgr.common.DiskData;
import com.sun.admin.diskmgr.common.DiskMgrException;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VBusyPanel;
import com.sun.management.viper.console.gui.VFrame;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;

public class AppContent
extends Content {
    public static final String DISK_COLUMN = "diskListDisk";
    public static final String TYPE_COLUMN = "diskListType";
    public static final String LABEL_COLUMN = "diskListLabel";
    public static final String CAPACITY_COLUMN = "diskListCapacity";
    public static final String USED_COLUMN = "diskListUsed";
    public static final String FREE_COLUMN = "diskListFree";
    public static final String PERCENTFREE_COLUMN = "diskListPercentFree";
    private ResourceBundle bundle;
    private String fetchMessage;
    private String fetchDoneMessage;
    private final Object[][] columnHeaderConfig = new Object[][]{{"diskListType", new Integer(16)}, {"diskListCapacity", new Integer(20016)}, {"diskListUsed", new Integer(20016)}, {"diskListFree", new Integer(20016)}, {"diskListPercentFree", new Integer(20016)}};
    private static String[][] columnHeaders = null;

    public AppContent(VDiskMgr vDiskMgr) {
        super(vDiskMgr);
        this.bundle = vDiskMgr.getResourceBundle();
        this.fetchMessage = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"FetchDisksTitle");
        this.fetchDoneMessage = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"FetchDisksDone");
        this.sortPreferenceKey = String.valueOf(this.getClass().getName()) + ".sortPreference";
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setToolBar((JToolBar)vDiskMgr.getDiskToolBar());
        this.rootNode.setMenuBar((JMenuBar)vDiskMgr.getDiskMenuBar());
    }

    public void changeActiveFdisk() {
        VScopeNode vScopeNode = this.getSelectedNode();
        if (vScopeNode == null) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                AppContent.this.theApp.waitOn();
                VScopeNode vScopeNode = AppContent.this.getSelectedNode();
                TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
                DiskData diskData = treeNodeData.getDiskData();
                VFrame vFrame = new VFrame();
                ChangeFdiskDialog changeFdiskDialog = new ChangeFdiskDialog(AppContent.this.theApp, diskData);
                changeFdiskDialog.setContainer((Component)vFrame);
                vFrame.showCenter((Component)AppContent.this.theApp.getProperties().getPropertyObject("vconsole.frame"));
                changeFdiskDialog.setVisible(true);
                AppContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public void clear() {
        this.theApp.setInfoBar(" ");
        this.clearSelection();
        this.getDataCache().removeAllElements();
        System.gc();
        this.theApp.getTree().removeAllDisks();
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setToolBar((JToolBar)this.theApp.getDiskToolBar());
        this.rootNode.setMenuBar((JMenuBar)this.theApp.getDiskMenuBar());
        this.bRefresh = true;
    }

    public void cloneSelected() {
        VScopeNode vScopeNode = this.getSelectedNode();
        if (vScopeNode == null) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                AppContent.this.theApp.waitOn();
                VScopeNode vScopeNode = AppContent.this.getSelectedNode();
                TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
                DiskData diskData = treeNodeData.getDiskData();
                VFrame vFrame = new VFrame();
                CopyLayoutDialog copyLayoutDialog = new CopyLayoutDialog(AppContent.this.theApp, diskData);
                copyLayoutDialog.setContainer((Component)vFrame);
                vFrame.showCenter((Component)AppContent.this.theApp.getProperties().getPropertyObject("vconsole.frame"));
                copyLayoutDialog.setVisible(true);
                AppContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public void fdiskSelected() {
        VScopeNode vScopeNode = this.getSelectedNode();
        if (vScopeNode == null) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                AppContent.this.theApp.waitOn();
                VScopeNode vScopeNode = AppContent.this.getSelectedNode();
                TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
                DiskData diskData = treeNodeData.getDiskData();
                VFrame vFrame = new VFrame();
                FdiskWizard fdiskWizard = new FdiskWizard(AppContent.this.theApp, (DiskData)diskData.clone());
                fdiskWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)AppContent.this.theApp.getProperties().getPropertyObject("vconsole.frame"));
                fdiskWizard.start();
                AppContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public void formatSelected() {
        VScopeNode vScopeNode = this.getSelectedNode();
        if (vScopeNode == null) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                AppContent.this.theApp.waitOn();
                VScopeNode vScopeNode = AppContent.this.getSelectedNode();
                TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
                DiskData diskData = treeNodeData.getDiskData();
                VFrame vFrame = new VFrame();
                SliceWizard sliceWizard = new SliceWizard(AppContent.this.theApp, (DiskData)diskData.clone());
                sliceWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)AppContent.this.theApp.getProperties().getPropertyObject("vconsole.frame"));
                sliceWizard.start();
                AppContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public String[][] getColumnHeaders() {
        if (columnHeaders == null) {
            columnHeaders = this.constructColumnHeaders(this.columnHeaderConfig);
        }
        return columnHeaders;
    }

    public static Hashtable getColumnValues(ResourceBundle resourceBundle, DiskData diskData) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = columnHeaders[0][0];
        hashtable.put(string, diskData.getDiskType());
        string = columnHeaders[1][0];
        String string2 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"Megabytes");
        String string3 = Content.formatSuffix(diskData.getDiskCapacity(), string2);
        hashtable.put(string, string3);
        string = columnHeaders[2][0];
        string3 = Content.formatSuffix(diskData.getDiskUsed(), string2);
        hashtable.put(string, string3);
        string = columnHeaders[3][0];
        string3 = Content.formatSuffix(diskData.getDiskFree(), string2);
        hashtable.put(string, string3);
        string = columnHeaders[4][0];
        string2 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"Percentage");
        string3 = Content.formatSuffix(diskData.getDiskPercentFree(), string2);
        hashtable.put(string, string3);
        return hashtable;
    }

    public String getSortAttribute() {
        return null;
    }

    public void openSelected() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.scopeselected", (Object)vScopeNode);
        this.theApp.fireConsoleAction(vConsoleEvent);
    }

    public void refresh() {
        this.vDataCache.removeAllElements();
        System.gc();
        this.clear();
        if (this.treeNode.getResultPane() == null) {
            this.treeNode.setResultPane((Component)new VBusyPanel(this.fetchMessage));
            this.theApp.fireConsoleAction(new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode));
        }
        this.theApp.setStatusBar(this.fetchMessage);
        try {
            Vector vector = this.theApp.getDiskMgr().listDisks();
            if (vector != null && vector.size() > 0) {
                DiskData diskData = (DiskData)vector.firstElement();
                this.theApp.setX86(diskData.isX86());
            }
            this.theApp.getTree().appendToNode(vector);
        }
        catch (DiskMgrException diskMgrException) {
            this.theApp.reportErrorException((Exception)((Object)diskMgrException));
        }
        this.treeNode.setResultPane(null);
        this.theApp.fireConsoleAction(new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode));
        this.theApp.setStatusBar(this.fetchDoneMessage);
        this.bRefresh = true;
    }

    public void refresh(DiskData diskData) {
        Enumeration enumeration = this.vDataCache.elements();
        while (enumeration.hasMoreElements()) {
            VScopeNode vScopeNode = (VScopeNode)enumeration.nextElement();
            TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
            DiskData diskData2 = treeNodeData.getDiskData();
            if (!diskData2.getDiskName().equals(diskData.getDiskName())) continue;
            try {
                DiskData diskData3 = this.theApp.getDiskMgr().getDisk(null, diskData);
                DiskContent diskContent = new DiskContent(this.theApp);
                diskContent.setTreeNode(vScopeNode);
                treeNodeData.setContent(diskContent);
                treeNodeData.setDiskData(diskData3);
                vScopeNode.setPayload((Object)treeNodeData);
            }
            catch (DiskMgrException diskMgrException) {
                this.theApp.reportErrorException((Exception)((Object)diskMgrException));
            }
            return;
        }
    }

    public void setDefaultColumnHeader() {
        this.properties.setProperty("vconsole.defaultcolumnheader", ResourceStrings.getString((ResourceBundle)this.theApp.getResourceBundle(), (String)DISK_COLUMN));
    }

    public void updateInfoBar() {
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"DiskListContents");
        Object[] objectArray = new Object[]{new Integer(this.getDataCache().size())};
        String string2 = MessageFormat.format(string, objectArray);
        this.theApp.setInfoBar(string2);
    }

    public void viewProperties() {
        VScopeNode vScopeNode = this.getSelectedNode();
        if (vScopeNode == null) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                AppContent.this.theApp.waitOn();
                VScopeNode vScopeNode = AppContent.this.getSelectedNode();
                TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
                DiskData diskData = treeNodeData.getDiskData();
                VFrame vFrame = new VFrame();
                DiskPropDialog diskPropDialog = new DiskPropDialog(AppContent.this.theApp, diskData);
                diskPropDialog.setContainer((Component)vFrame);
                vFrame.showCenter((Component)AppContent.this.theApp.getProperties().getPropertyObject("vconsole.frame"));
                diskPropDialog.start();
                AppContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public String whatAmI() {
        return "app";
    }
}

