/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.process;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt64;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.provider.MethodProvider;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.solarisprovider.process.ProcessData;
import com.sun.wbem.solarisprovider.process.ProcessManager;
import com.sun.wbem.solarisprovider.process.ProcessManagerWrapper;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class Solaris_Process
implements InstanceProvider,
MethodProvider {
    private CIMOMHandle cimomhandle = null;

    static {
        System.loadLibrary("solprov");
    }

    native String GetOSName();

    native long GetParentPID(String var1);

    native String GetProcessArgs(String var1);

    native String GetProcessName(String var1);

    native int GetProcessPriority(String var1);

    native int GetProcessSize(String var1);

    native long GetProcessStart(String var1);

    native int GetProcessState(String var1);

    native long GetUsrSysTime(String var1);

    native int KillProcess(String var1);

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        ProcessManager processManager = new ProcessManager();
        try {
            String string = null;
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                if (!cIMProperty.getName().equalsIgnoreCase("Handle")) continue;
                string = (String)cIMProperty.getValue().getValue();
            }
            int n = Integer.parseInt(string);
            int n2 = processManager.killProcess(n);
            if (n2 != 0) {
                throw new CIMException("CIM_ERR_FAILED");
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            throw new CIMException("CIM_ERR_FAILED", (Object)cIMException);
        }
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        Vector vector2 = null;
        String string = null;
        ProcessManager processManager = new ProcessManager();
        try {
            vector2 = processManager.getAllProcesses();
            if (vector2 == null) {
                return null;
            }
            string = processManager.getOSName();
            if (string == null) {
                string = "SunOS";
            }
            int n = 0;
            while (n < vector2.size()) {
                CIMObjectPath cIMObjectPath2 = null;
                cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                cIMObjectPath2.addKey("CSCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                try {
                    cIMObjectPath2.addKey("CSName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (UnknownHostException unknownHostException) {
                    unknownHostException.printStackTrace();
                    throw new CIMException("CIM_ERR_FAILED", (Object)unknownHostException);
                }
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_Process"));
                cIMObjectPath2.addKey("OSCreationClassName", new CIMValue((Object)"Solaris_OperatingSystem"));
                cIMObjectPath2.addKey("Handle", new CIMValue((Object)((ProcessData)vector2.elementAt(n)).getPID()));
                cIMObjectPath2.addKey("OSName", new CIMValue((Object)string));
                vector.addElement(cIMObjectPath2);
                ++n;
            }
            return vector;
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            throw new CIMException("CIM_ERR_FAILED", (Object)cIMException);
        }
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        Vector vector2 = null;
        String string = null;
        ProcessManager processManager = new ProcessManager();
        try {
            vector2 = processManager.getAllProcesses();
            if (vector2 == null) {
                return null;
            }
            string = processManager.getOSName();
            if (string == null) {
                string = "SunOS";
            }
            int n = 0;
            while (n < vector2.size()) {
                CIMInstance cIMInstance = cIMClass.newInstance();
                String string2 = null;
                ProcessData processData = null;
                string2 = ((ProcessData)vector2.elementAt(n)).getPID();
                processData = processManager.getProcessData(string2);
                if (processData != null) {
                    cIMInstance.setProperty("CSCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                    cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_Process"));
                    cIMInstance.setProperty("OSCreationClassName", new CIMValue((Object)"Solaris_OperatingSystem"));
                    try {
                        cIMInstance.setProperty("CSName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                    }
                    catch (UnknownHostException unknownHostException) {
                        unknownHostException.printStackTrace();
                        throw new CIMException("CIM_ERR_FAILED", (Object)unknownHostException);
                    }
                    cIMInstance.setProperty("OSName", new CIMValue((Object)string));
                    cIMInstance.setProperty("Handle", new CIMValue((Object)string2));
                    cIMInstance.setProperty("ProcessOwner", new CIMValue((Object)processData.getPUSER()));
                    cIMInstance.setProperty("ProcessExecutable", new CIMValue((Object)processData.getPNAME()));
                    cIMInstance.setProperty("ProcessMemoryAddr", new CIMValue((Object)processData.getPADDR()));
                    cIMInstance.setProperty("ParentHandle", new CIMValue((Object)processData.getPPID()));
                    cIMInstance.setProperty("GroupHandle", new CIMValue((Object)processData.getPGID()));
                    cIMInstance.setProperty("ProcessUserPriority", new CIMValue((Object)processData.getPPRI()));
                    cIMInstance.setProperty("PercentCPUTime", new CIMValue((Object)processData.getPCPU()));
                    cIMInstance.setProperty("PercentMemorySize", new CIMValue((Object)processData.getPMEM()));
                    cIMInstance.setProperty("ProcessVMSize", new CIMValue((Object)new UnsignedInt64(new BigInteger(processData.getPVSZ()))));
                    cIMInstance.setProperty("ProcessResidentSetSize", new CIMValue((Object)new UnsignedInt64(new BigInteger(processData.getPRSS()))));
                    cIMInstance.setProperty("ProcessControllingTerminal", new CIMValue((Object)processData.getPTTY()));
                    cIMInstance.setProperty("SystemSchedulingPriority", new CIMValue((Object)processData.getPNICE()));
                    cIMInstance.setProperty("ProcessSchedulingClass", new CIMValue((Object)processData.getPCLASS()));
                    cIMInstance.setProperty("ProcessStartTime", new CIMValue((Object)processData.getPSTIME()));
                    cIMInstance.setProperty("CumulativeExecutionTime", new CIMValue((Object)processData.getPTIME()));
                    cIMInstance.setProperty("ProcessStateString", new CIMValue((Object)processData.getPSTATE()));
                    cIMInstance.setProperty("BoundProcessorNumber", new CIMValue((Object)processData.getPPSR()));
                    cIMInstance.setProperty("ProcessWaitingAddr", new CIMValue((Object)processData.getPWCHAN()));
                    cIMInstance.setProperty("ExecutingCommand", new CIMValue((Object)processData.getPCMD()));
                    cIMInstance.setProperty("Priority", new CIMValue((Object)new UnsignedInt32((long)this.GetProcessPriority(string2))));
                    cIMInstance.setProperty("WorkingSetSize", new CIMValue((Object)new UnsignedInt64(new BigInteger(Integer.toString(this.GetProcessSize(string2))))));
                    cIMInstance.setProperty("Name", new CIMValue((Object)this.GetProcessName(string2)));
                    cIMInstance.setProperty("Description", new CIMValue((Object)this.GetProcessArgs(string2)));
                    cIMInstance.setProperty("Caption", new CIMValue((Object)this.GetProcessArgs(string2)));
                    cIMInstance.setProperty("ExecutionState", new CIMValue((Object)new UnsignedInt16(this.GetProcessState(string2))));
                    cIMInstance.setProperty("Status", new CIMValue((Object)this.getStatus(string2)));
                    cIMInstance.setProperty("ParentHandle", new CIMValue((Object)Integer.toString((int)this.GetParentPID(string2))));
                    cIMInstance.setProperty("UserKernelModeTime", new CIMValue((Object)new UnsignedInt64(new BigInteger(Integer.toString((int)this.GetUsrSysTime(string2))))));
                    cIMInstance.setProperty("UserModeTime", new CIMValue((Object)new UnsignedInt64(new BigInteger("0"))));
                    cIMInstance.setProperty("KernelModeTime", new CIMValue((Object)new UnsignedInt64(new BigInteger("0"))));
                    Date date = new Date(1000L * this.GetProcessStart(string2));
                    cIMInstance.setProperty("CreationDate", new CIMValue((Object)new CIMDateTime(date)));
                    cIMInstance.setProperty("InstallDate", new CIMValue((Object)new CIMDateTime(date)));
                    vector.addElement(cIMInstance);
                }
                ++n;
            }
            return vector;
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            throw new CIMException("CIM_ERR_FAILED", (Object)cIMException);
        }
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) {
        return null;
    }

    private Date getDate(String string) {
        Date date = null;
        DateFormat dateFormat = DateFormat.getTimeInstance(3);
        try {
            date = dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return date;
    }

    public Integer getExtendedProperty(String string, String string2, Vector vector) throws CIMException {
        Integer n;
        try {
            ProcessManagerWrapper processManagerWrapper = new ProcessManagerWrapper();
            n = processManagerWrapper.getExtendedProperty(string, string2, vector);
        }
        catch (CIMException cIMException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)cIMException);
        }
        return n;
    }

    private String getHandle(CIMObjectPath cIMObjectPath) {
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.getName().equalsIgnoreCase("Handle")) continue;
            String string = (String)cIMProperty.getValue().getValue();
            return string;
        }
        return "-1";
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        ProcessData processData = null;
        String string = null;
        ProcessManager processManager = new ProcessManager();
        try {
            CIMProperty cIMProperty;
            String string2 = null;
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                cIMProperty = (CIMProperty)enumeration.nextElement();
                if (!cIMProperty.getName().equalsIgnoreCase("Handle")) continue;
                string2 = (String)cIMProperty.getValue().getValue();
            }
            processData = processManager.getProcessData(string2);
            if (processData == null) {
                return null;
            }
            string = processManager.getOSName();
            if (string == null) {
                string = "SunOS";
            }
            cIMProperty = cIMClass.newInstance();
            cIMProperty.setProperty("CSCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            cIMProperty.setProperty("CreationClassName", new CIMValue((Object)"Solaris_Process"));
            cIMProperty.setProperty("OSCreationClassName", new CIMValue((Object)"Solaris_OperatingSystem"));
            try {
                cIMProperty.setProperty("CSName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (UnknownHostException unknownHostException) {
                throw new CIMException("CIM_ERR_FAILED", (Object)unknownHostException);
            }
            cIMProperty.setProperty("OSName", new CIMValue((Object)string));
            cIMProperty.setProperty("Handle", new CIMValue((Object)string2));
            cIMProperty.setProperty("ProcessOwner", new CIMValue((Object)processData.getPUSER()));
            cIMProperty.setProperty("ProcessExecutable", new CIMValue((Object)processData.getPNAME()));
            cIMProperty.setProperty("ProcessMemoryAddr", new CIMValue((Object)processData.getPADDR()));
            cIMProperty.setProperty("ParentHandle", new CIMValue((Object)processData.getPPID()));
            cIMProperty.setProperty("GroupHandle", new CIMValue((Object)processData.getPGID()));
            cIMProperty.setProperty("ProcessUserPriority", new CIMValue((Object)processData.getPPRI()));
            cIMProperty.setProperty("PercentCPUTime", new CIMValue((Object)processData.getPCPU()));
            cIMProperty.setProperty("PercentMemorySize", new CIMValue((Object)processData.getPMEM()));
            cIMProperty.setProperty("ProcessVMSize", new CIMValue((Object)new UnsignedInt64(new BigInteger(processData.getPVSZ()))));
            cIMProperty.setProperty("ProcessResidentSetSize", new CIMValue((Object)new UnsignedInt64(new BigInteger(processData.getPRSS()))));
            cIMProperty.setProperty("ProcessControllingTerminal", new CIMValue((Object)processData.getPTTY()));
            cIMProperty.setProperty("SystemSchedulingPriority", new CIMValue((Object)processData.getPNICE()));
            cIMProperty.setProperty("ProcessSchedulingClass", new CIMValue((Object)processData.getPCLASS()));
            cIMProperty.setProperty("ProcessStartTime", new CIMValue((Object)processData.getPSTIME()));
            cIMProperty.setProperty("CumulativeExecutionTime", new CIMValue((Object)processData.getPTIME()));
            cIMProperty.setProperty("ProcessStateString", new CIMValue((Object)processData.getPSTATE()));
            cIMProperty.setProperty("BoundProcessorNumber", new CIMValue((Object)processData.getPPSR()));
            cIMProperty.setProperty("ProcessWaitingAddr", new CIMValue((Object)processData.getPWCHAN()));
            cIMProperty.setProperty("ExecutingCommand", new CIMValue((Object)processData.getPCMD()));
            cIMProperty.setProperty("Priority", new CIMValue((Object)new UnsignedInt32((long)this.GetProcessPriority(string2))));
            cIMProperty.setProperty("WorkingSetSize", new CIMValue((Object)new UnsignedInt64(new BigInteger(Integer.toString(this.GetProcessSize(string2))))));
            cIMProperty.setProperty("Name", new CIMValue((Object)this.GetProcessName(string2)));
            cIMProperty.setProperty("Description", new CIMValue((Object)this.GetProcessArgs(string2)));
            cIMProperty.setProperty("Caption", new CIMValue((Object)this.GetProcessArgs(string2)));
            cIMProperty.setProperty("ExecutionState", new CIMValue((Object)new UnsignedInt16(this.GetProcessState(string2))));
            cIMProperty.setProperty("Status", new CIMValue((Object)this.getStatus(string2)));
            cIMProperty.setProperty("ParentHandle", new CIMValue((Object)Integer.toString((int)this.GetParentPID(string2))));
            cIMProperty.setProperty("UserKernelModeTime", new CIMValue((Object)new UnsignedInt64(new BigInteger(Integer.toString((int)this.GetUsrSysTime(string2))))));
            cIMProperty.setProperty("UserModeTime", new CIMValue((Object)new UnsignedInt64(new BigInteger("0"))));
            cIMProperty.setProperty("KernelModeTime", new CIMValue((Object)new UnsignedInt64(new BigInteger("0"))));
            Date date = new Date(1000L * this.GetProcessStart(string2));
            cIMProperty.setProperty("CreationDate", new CIMValue((Object)new CIMDateTime(date)));
            cIMProperty.setProperty("InstallDate", new CIMValue((Object)new CIMDateTime(date)));
            return cIMProperty;
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            throw new CIMException("CIM_ERR_FAILED", (Object)cIMException);
        }
    }

    private String getStatus(String string) {
        int n = this.GetProcessState(string);
        switch (n) {
            case 3: {
                return "Unknown";
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                return "OK";
            }
        }
        return "Unknown";
    }

    public void initialize(CIMOMHandle cIMOMHandle) {
        this.cimomhandle = cIMOMHandle;
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        if (string.equalsIgnoreCase("suspendProcess")) {
            return new CIMValue((Object)this.suspendProcess((Integer)((CIMValue)vector.elementAt(0)).getValue()));
        }
        if (string.equalsIgnoreCase("resumeprocess")) {
            return new CIMValue((Object)this.resumeProcess((Integer)((CIMValue)vector.elementAt(0)).getValue()));
        }
        if (string.equalsIgnoreCase("getExtendedProperty")) {
            return new CIMValue((Object)this.getExtendedProperty((String)((CIMValue)vector.elementAt(0)).getValue(), (String)((CIMValue)vector.elementAt(1)).getValue(), vector2));
        }
        return null;
    }

    public Integer resumeProcess(int n) throws CIMException {
        Integer n2;
        ProcessManagerWrapper processManagerWrapper = new ProcessManagerWrapper();
        try {
            n2 = processManagerWrapper.resumeProcess(n);
        }
        catch (CIMException cIMException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)cIMException);
        }
        return n2;
    }

    public synchronized void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        String string = null;
        String string2 = null;
        ProcessData processData = null;
        String string3 = null;
        ProcessManager processManager = new ProcessManager();
        try {
            int n;
            string = (String)cIMInstance.getProperty("Handle").getValue().getValue();
            processData = processManager.getProcessData(string);
            string2 = (String)cIMInstance.getProperty("ProcessUserPriority").getValue().getValue();
            string3 = (String)cIMInstance.getProperty("ProcessSchedulingClass").getValue().getValue();
            int n2 = Integer.parseInt(string2);
            int n3 = Integer.parseInt(string);
            if (!string2.equals(processData.getPPRI()) && (n = processManager.setProcessUserPriority(n3, n2)) != 0) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            if (!string3.equals(processData.getPCLASS()) && (n = processManager.setProcessSchedClass(n3, string3)) != 0) {
                throw new CIMException("CIM_ERR_FAILED");
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Integer suspendProcess(int n) throws CIMException {
        Integer n2;
        ProcessManagerWrapper processManagerWrapper = new ProcessManagerWrapper();
        try {
            n2 = processManagerWrapper.suspendProcess(n);
        }
        catch (CIMException cIMException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)cIMException);
        }
        return n2;
    }
}

