/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.process;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.solarisprovider.process.ProcessData;
import com.sun.wbem.solarisprovider.process.ProcessManagerRunCmd;
import com.sun.wbem.solarisprovider.process.PsCmdData;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Vector;

public class ProcessManager {
    private static final String[] GET_ACTIVE_PROCESSES = new String[]{"/usr/bin/ps", "-eflo user,fname,addr,pid,ppid,pgid,pri,pcpu,pmem,vsz,rss,tty,nice,class,stime,time,s,psr,wchan,args"};
    private static final String[] ENV_ARGS = new String[]{"LC_ALL=C", "LC_MESSAGES=C", "LANG=C"};
    private static final String PSTOP = "/usr/proc/bin/pstop";
    private static final String PRESUME = "/usr/proc/bin/prun";
    private static final String PKILL = "/usr/bin/kill";
    private static final String KILLBYNAME = "/usr/bin/pkill";
    private static final String PLIMIT = "/usr/bin/plimit";
    private static final String PSTACK = "/usr/proc/bin/pstack";
    private static final String PTREE = "/usr/proc/bin/ptree";
    private static final String PFLAGS = "/usr/proc/bin/pflags";
    private static final String PCRED = "/usr/proc/bin/pcred";
    private static final String PMAP = "/usr/proc/bin/pmap";
    private static final String PLDD = "/usr/proc/bin/pldd";
    private static final String PFILE = "/usr/proc/bin/pfiles";
    private static final String PWDX = "/usr/proc/bin/pwdx";
    private static final String PTIME = "/usr/proc/bin/ptime";
    private static final String PSIG = "/usr/proc/bin/psig";
    private static final String NFSSTATS = "/usr/bin/nfsstat";
    private static final String VMSTATS = "/usr/bin/vmstat";
    private static final String OSNAME = "/usr/bin/uname";
    private static final String VOLUME_MANAGER = "/etc/init.d/volmgt";
    private static final String AUTOMOUNT_DAEMON = "/etc/init.d/autofs";
    private static final String CRON_DAEMON = "/etc/init.d/cron";
    private static final String NFS_DAEMON = "/etc/init.d/nfs.server";
    private static final String SENDMAIL_DAEMON = "/etc/init.d/sendmail";
    private static final String MOUNT_DAEMON = "/etc/init.d/nfs.server";
    private static final String USRLIBNFSD = "/usr/lib/nfs/nfsd";
    private static final String SYSTEM_SCHED_INTERFACE = "/usr/bin/priocntl";
    public static final int NFSD = 0;
    public static final int MOUNTD = 1;
    public static final int AUTOMOUNTD = 2;
    public static final int VOLD = 3;
    public static final int CRON = 4;
    public static final int SENDMAIL = 5;

    public synchronized Vector displayActiveProcesses() throws CIMException {
        Vector vector = null;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(GET_ACTIVE_PROCESSES);
            if (processManagerRunCmd.getResult() != 0) {
                processManagerRunCmd.dispose();
            } else {
                vector = processManagerRunCmd.getOutput();
                processManagerRunCmd.dispose();
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return vector;
    }

    public Vector displayAndReinitializeClientRPCStats() throws CIMException {
        String string = "-zrc";
        String[] stringArray = new String[]{NFSSTATS, string};
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                return processManagerRunCmd.getErrors();
            }
            return processManagerRunCmd.getOutput();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector displayAndReinitializeMountedFSStats() throws CIMException {
        String string = "-zm";
        String[] stringArray = new String[]{NFSSTATS, string};
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                return processManagerRunCmd.getErrors();
            }
            return processManagerRunCmd.getOutput();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector displayAndReinitializeNFSClientStats() throws CIMException {
        String string = "-znc";
        String[] stringArray = new String[]{NFSSTATS, string};
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                return processManagerRunCmd.getErrors();
            }
            return processManagerRunCmd.getOutput();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector displayAndReinitializeNFSServerStats() throws CIMException {
        String string = "-zns";
        String[] stringArray = new String[]{NFSSTATS, string};
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                return processManagerRunCmd.getErrors();
            }
            return processManagerRunCmd.getOutput();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector displayAndReinitializeServerRPCStats() throws CIMException {
        String string = "-zrs";
        String[] stringArray = new String[]{NFSSTATS, string};
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                return processManagerRunCmd.getErrors();
            }
            return processManagerRunCmd.getOutput();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector displayAndReinitializeStats() throws CIMException {
        String string = "-z";
        String[] stringArray = new String[]{NFSSTATS, string};
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                return processManagerRunCmd.getErrors();
            }
            return processManagerRunCmd.getOutput();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector displayNfsClientInfo() throws CIMException {
        try {
            String string = "-nc";
            String[] stringArray = new String[]{NFSSTATS, string};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                return processManagerRunCmd.getErrors();
            }
            return processManagerRunCmd.getOutput();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector displayNfsClientRPCInfo() throws CIMException {
        String string = "-rc";
        String[] stringArray = new String[]{NFSSTATS, string};
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                return processManagerRunCmd.getErrors();
            }
            return processManagerRunCmd.getOutput();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector displayNfsMountedFSstats() throws CIMException {
        try {
            String string = "-m";
            String[] stringArray = new String[]{NFSSTATS, string};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                return processManagerRunCmd.getErrors();
            }
            return processManagerRunCmd.getOutput();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector displayNfsServerInfo() throws CIMException {
        String string = "-ns";
        String[] stringArray = new String[]{NFSSTATS, string};
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                return processManagerRunCmd.getErrors();
            }
            return processManagerRunCmd.getOutput();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector displayNfsServerRPCInfo() throws CIMException {
        try {
            String string = "-rs";
            String[] stringArray = new String[]{NFSSTATS, string};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                return processManagerRunCmd.getErrors();
            }
            return processManagerRunCmd.getOutput();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized Vector displayProcessAddrMap(int n) throws CIMException {
        Vector vector = null;
        String string = String.valueOf(n);
        String[] stringArray = new String[]{PMAP, string};
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                processManagerRunCmd.dispose();
            } else {
                vector = processManagerRunCmd.getOutput();
                processManagerRunCmd.dispose();
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return vector;
    }

    public synchronized Vector displayProcessAncestry(int n) throws CIMException {
        Vector vector = null;
        try {
            String string = String.valueOf(n);
            String[] stringArray = new String[]{PTREE, string};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                processManagerRunCmd.dispose();
            } else {
                vector = processManagerRunCmd.getOutput();
                processManagerRunCmd.dispose();
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return vector;
    }

    public synchronized Vector displayProcessCWD(int n) throws CIMException {
        String string = String.valueOf(n);
        String[] stringArray = new String[]{PWDX, string};
        Vector vector = null;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                processManagerRunCmd.dispose();
            } else {
                vector = processManagerRunCmd.getOutput();
                processManagerRunCmd.dispose();
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return vector;
    }

    public synchronized Vector displayProcessCredentials(int n) throws CIMException {
        Vector vector = null;
        String string = String.valueOf(n);
        String[] stringArray = new String[]{PCRED, string};
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                processManagerRunCmd.dispose();
            } else {
                vector = processManagerRunCmd.getOutput();
                processManagerRunCmd.dispose();
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return vector;
    }

    public synchronized Vector displayProcessDynamicLibs(int n) throws CIMException {
        String string = String.valueOf(n);
        String[] stringArray = new String[]{PLDD, string};
        Vector vector = null;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                processManagerRunCmd.dispose();
            } else {
                vector = processManagerRunCmd.getOutput();
                processManagerRunCmd.dispose();
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return vector;
    }

    public synchronized Vector displayProcessFlags(int n) throws CIMException {
        Vector vector = null;
        String string = String.valueOf(n);
        String[] stringArray = new String[]{PFLAGS, string};
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                processManagerRunCmd.dispose();
            } else {
                vector = processManagerRunCmd.getOutput();
                processManagerRunCmd.dispose();
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return vector;
    }

    public synchronized Vector displayProcessOpenFilesInfo(int n) throws CIMException {
        String string = String.valueOf(n);
        String[] stringArray = new String[]{PFILE, string};
        Vector vector = null;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                processManagerRunCmd.dispose();
            } else {
                vector = processManagerRunCmd.getOutput();
                processManagerRunCmd.dispose();
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return vector;
    }

    public synchronized Vector displayProcessPriorityParams(int n) throws CIMException {
        Vector vector = null;
        try {
            String string = String.valueOf(n);
            String string2 = "-d " + string;
            String[] stringArray = new String[]{SYSTEM_SCHED_INTERFACE, string2};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                processManagerRunCmd.dispose();
            } else {
                vector = processManagerRunCmd.getOutput();
                processManagerRunCmd.dispose();
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return vector;
    }

    public synchronized Vector displayProcessResourceLimits(int n) throws CIMException {
        Vector vector = null;
        try {
            String string = String.valueOf(n);
            String string2 = "-km";
            String[] stringArray = new String[]{PLIMIT, string2, string};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray, ENV_ARGS);
            if (processManagerRunCmd.getResult() != 0) {
                processManagerRunCmd.dispose();
            } else {
                vector = processManagerRunCmd.getOutput();
                processManagerRunCmd.dispose();
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return vector;
    }

    public synchronized Vector displayProcessSignalActions(int n) throws CIMException {
        String string = String.valueOf(n);
        String[] stringArray = new String[]{PSIG, string};
        Vector vector = null;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                processManagerRunCmd.dispose();
            } else {
                vector = processManagerRunCmd.getOutput();
                processManagerRunCmd.dispose();
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return vector;
    }

    public synchronized Vector displayProcessStack(int n) throws CIMException {
        Vector vector = null;
        try {
            String string = String.valueOf(n);
            String[] stringArray = new String[]{PSTACK, string};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                processManagerRunCmd.dispose();
            } else {
                vector = processManagerRunCmd.getOutput();
                processManagerRunCmd.dispose();
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return vector;
    }

    public synchronized Vector displaySystemSchedConfig() throws CIMException {
        String string = "-l ";
        String[] stringArray = new String[]{SYSTEM_SCHED_INTERFACE, string};
        Vector vector = null;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                processManagerRunCmd.dispose();
            } else {
                vector = processManagerRunCmd.getOutput();
                processManagerRunCmd.dispose();
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return vector;
    }

    public synchronized Vector displayTimedProcessInfo(int n) throws CIMException {
        String string = String.valueOf(n);
        String[] stringArray = new String[]{PTIME, string};
        Vector vector = null;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                processManagerRunCmd.dispose();
            } else {
                vector = processManagerRunCmd.getOutput();
                processManagerRunCmd.dispose();
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return vector;
    }

    public Vector displayVMStats() throws CIMException {
        Object var1_1 = null;
        String[] stringArray = new String[]{VMSTATS, var1_1};
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                return processManagerRunCmd.getErrors();
            }
            return processManagerRunCmd.getOutput();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized int getActiveProcessesCount() throws CIMException {
        int n = 0;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(GET_ACTIVE_PROCESSES, ENV_ARGS);
            PsCmdData psCmdData = new PsCmdData(processManagerRunCmd.getOutput());
            processManagerRunCmd.dispose();
            n = psCmdData.getActiveProcessesCount();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return n;
    }

    public synchronized Vector getAllProcesses() throws CIMException {
        Vector vector = null;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(GET_ACTIVE_PROCESSES, ENV_ARGS);
            PsCmdData psCmdData = new PsCmdData(processManagerRunCmd.getOutput());
            processManagerRunCmd.dispose();
            vector = psCmdData.getProcessDataVector();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return vector;
    }

    public synchronized Vector getExtendedProperty(String string, String string2) throws CIMException {
        Vector vector = null;
        int n = Integer.parseInt(string2);
        try {
            if (string.equalsIgnoreCase("PROCESS_FLAGS")) {
                vector = this.displayProcessFlags(n);
            } else if (string.equalsIgnoreCase("PROCESS_CRED")) {
                vector = this.displayProcessCredentials(n);
            } else if (string.equalsIgnoreCase("PROCESS_ADDRMAP")) {
                vector = this.displayProcessAddrMap(n);
            } else if (string.equalsIgnoreCase("PROCESS_LDD")) {
                vector = this.displayProcessDynamicLibs(n);
            } else if (string.equalsIgnoreCase("PROCESS_SIG")) {
                vector = this.displayProcessSignalActions(n);
            } else if (string.equalsIgnoreCase("PROCESS_FILES")) {
                vector = this.displayProcessOpenFilesInfo(n);
            } else if (string.equalsIgnoreCase("PROCESS_CWD")) {
                vector = this.displayProcessCWD(n);
            } else if (string.equalsIgnoreCase("PROCESS_TREE")) {
                vector = this.displayProcessAncestry(n);
            } else if (string.equalsIgnoreCase("PROCESS_STACK")) {
                vector = this.displayProcessStack(n);
            }
        }
        catch (CIMException cIMException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)cIMException);
        }
        return vector;
    }

    public String getLocalHostname() throws CIMException {
        String string = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostName();
        }
        catch (Exception exception) {}
        return string;
    }

    public String getOSName() throws CIMException {
        String string = null;
        String string2 = "-s";
        String[] stringArray = new String[]{OSNAME, string2};
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            if (processManagerRunCmd.getResult() != 0) {
                string = "SunOS";
                processManagerRunCmd.dispose();
            } else {
                string = (String)processManagerRunCmd.getOutput().elementAt(0);
                processManagerRunCmd.dispose();
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return string;
    }

    public synchronized String getParentGID(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPGID();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized String getParentPID(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPPID();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized String getProcessAddr(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPADDR();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized String getProcessCMD(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPCMD();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized String getProcessCPU(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPCPU();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized String getProcessCumulativeTime(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPTIME();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized ProcessData getProcessData(String string) throws CIMException {
        ProcessData processData = null;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(GET_ACTIVE_PROCESSES, ENV_ARGS);
            PsCmdData psCmdData = new PsCmdData(processManagerRunCmd.getOutput());
            processManagerRunCmd.dispose();
            Hashtable hashtable = psCmdData.getProcessDataTable();
            processData = (ProcessData)hashtable.get(string);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return processData;
    }

    public synchronized String getProcessMemory(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPMEM();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized String getProcessName(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPNAME();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized String getProcessNiceVal(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPNICE();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized String getProcessOwner(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPUSER();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized String getProcessPSR(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPPSR();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized String getProcessPriority(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPPRI();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized String getProcessRSS(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPRSS();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized String getProcessSchedClass(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPCLASS();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized String getProcessSize(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPVSZ();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized String getProcessStartTime(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPSTIME();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized String getProcessState(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPSTATE();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized String getProcessTTY(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPTTY();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized String getProcessWCHAN(int n) throws CIMException {
        try {
            String string = String.valueOf(n);
            ProcessData processData = this.getProcessData(string);
            return processData.getPWCHAN();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized int killProcess(int n) throws CIMException {
        int n2;
        try {
            String string = String.valueOf(n);
            String[] stringArray = new String[]{PKILL, string};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return n2;
    }

    private synchronized int killProcessByName(String string) throws CIMException {
        int n;
        try {
            String[] stringArray = new String[]{KILLBYNAME, string};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return n;
    }

    public synchronized int modifyProcessArgs(int n, String string, String string2) throws CIMException {
        int n2;
        try {
            int n3 = this.killProcess(n);
            if (n3 != 0) {
                return n3;
            }
            String[] stringArray = new String[]{string, string2};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return n2;
    }

    public synchronized int resumeProcess(int n) throws CIMException {
        String string = String.valueOf(n);
        String[] stringArray = new String[]{PRESUME, string};
        int n2 = -1;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return n2;
    }

    public synchronized Vector runCommandLine(String string, String string2) throws CIMException {
        String[] stringArray = new String[]{string, string2};
        Vector vector = null;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            int n = processManagerRunCmd.getResult();
            if (n != 0) {
                processManagerRunCmd.dispose();
            } else {
                vector = processManagerRunCmd.getOutput();
                processManagerRunCmd.dispose();
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return vector;
    }

    public synchronized int setNServers(int n) throws CIMException {
        String string = "nfsd";
        try {
            int n2 = this.killProcessByName(string);
            if (n2 != 0) {
                return n2;
            }
            String string2 = String.valueOf(n);
            String string3 = "-a " + string2 + " &";
            String[] stringArray = new String[]{USRLIBNFSD, string3};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            return processManagerRunCmd.getResult();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized int setProcessCPUTIMELimits(int n, String string, String string2) throws CIMException {
        int n2;
        try {
            String string3 = String.valueOf(n);
            if (string.equals("unlimited")) {
                string2 = "unlimited";
            }
            String string4 = "-t";
            String[] stringArray = new String[]{PLIMIT, string4, string, ",", string2, string3};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return n2;
    }

    public synchronized int setProcessCoreFileSizeLimits(int n, String string, String string2) throws CIMException {
        int n2;
        try {
            String string3 = String.valueOf(n);
            if (string.equals("unlimited")) {
                string2 = "unlimited";
            } else {
                string = String.valueOf(string) + "k";
            }
            if (!string2.equals("unlimited")) {
                string2 = String.valueOf(string2) + "k";
            }
            String string4 = "-c";
            String[] stringArray = new String[]{PLIMIT, string4, string, ",", string2, string3};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return n2;
    }

    public synchronized int setProcessFileDescriptorLimits(int n, String string, String string2) throws CIMException {
        int n2;
        try {
            String string3 = String.valueOf(n);
            if (string.equals("unlimited")) {
                string2 = "unlimited";
            }
            String string4 = "-n";
            String[] stringArray = new String[]{PLIMIT, string4, string, ",", string2, string3};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return n2;
    }

    public synchronized int setProcessFileSizeLimits(int n, String string, String string2) throws CIMException {
        int n2;
        try {
            String string3 = String.valueOf(n);
            if (string.equals("unlimited")) {
                string2 = "unlimited";
            } else {
                string = String.valueOf(string) + "k";
            }
            if (!string2.equals("unlimited")) {
                string2 = String.valueOf(string2) + "k";
            }
            String string4 = "-f";
            String[] stringArray = new String[]{PLIMIT, string4, string, ",", string2, string3};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return n2;
    }

    public synchronized int setProcessHeapSizeLimits(int n, String string, String string2) throws CIMException {
        int n2;
        try {
            String string3 = String.valueOf(n);
            if (string.equals("unlimited")) {
                string2 = "unlimited";
            }
            String string4 = "-d";
            String[] stringArray = new String[]{PLIMIT, string4, string, ",", string2, string3};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return n2;
    }

    public synchronized int setProcessSchedClass(int n, String string) throws CIMException {
        int n2;
        try {
            String string2 = String.valueOf(n);
            String string3 = "-sc " + string + " " + string2;
            String[] stringArray = new String[]{SYSTEM_SCHED_INTERFACE, string3};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return n2;
    }

    public synchronized int setProcessStackSizeLimits(int n, String string, String string2) throws CIMException {
        int n2;
        try {
            String string3 = String.valueOf(n);
            if (string.equals("unlimited")) {
                string2 = "unlimited";
            }
            String string4 = "-s";
            String[] stringArray = new String[]{PLIMIT, string4, string, ",", string2, string3};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return n2;
    }

    public synchronized int setProcessTimeQuantum(int n, int n2, int n3) throws CIMException {
        int n4;
        String string = null;
        try {
            String string2 = String.valueOf(n);
            String string3 = String.valueOf(n2);
            String string4 = String.valueOf(n3);
            string = "-st " + string3 + " " + "-r " + string4 + " " + string2;
            String[] stringArray = new String[]{SYSTEM_SCHED_INTERFACE, string};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n4 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return n4;
    }

    public synchronized int setProcessUserPriority(int n, int n2) throws CIMException {
        int n3;
        try {
            String string = String.valueOf(n);
            String string2 = String.valueOf(n2);
            String string3 = "-ms " + string2 + " " + "-p " + string2 + " " + string;
            String[] stringArray = new String[]{SYSTEM_SCHED_INTERFACE, string3};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n3 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return n3;
    }

    public synchronized int setVirtualMemorySizeLimits(int n, String string, String string2) throws CIMException {
        int n2;
        try {
            String string3 = String.valueOf(n);
            if (string.equals("unlimited")) {
                string2 = "unlimited";
            }
            String string4 = "-v";
            String[] stringArray = new String[]{PLIMIT, string4, string, ",", string2, string3};
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return n2;
    }

    public synchronized int startDaemon(int n) throws CIMException {
        String string = "start";
        try {
            switch (n) {
                case 1: {
                    String[] stringArray = new String[]{"/etc/init.d/nfs.server", string};
                    ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
                    if (processManagerRunCmd.getResult() != 0) {
                        return processManagerRunCmd.getResult();
                    }
                    return processManagerRunCmd.getResult();
                }
                case 0: {
                    String[] stringArray = new String[]{"/etc/init.d/nfs.server", string};
                    ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
                    if (processManagerRunCmd.getResult() != 0) {
                        return processManagerRunCmd.getResult();
                    }
                    return processManagerRunCmd.getResult();
                }
                case 2: {
                    String[] stringArray = new String[]{AUTOMOUNT_DAEMON, string};
                    ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
                    if (processManagerRunCmd.getResult() != 0) {
                        return processManagerRunCmd.getResult();
                    }
                    return processManagerRunCmd.getResult();
                }
                case 3: {
                    String[] stringArray = new String[]{VOLUME_MANAGER, string};
                    ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
                    if (processManagerRunCmd.getResult() != 0) {
                        return processManagerRunCmd.getResult();
                    }
                    return processManagerRunCmd.getResult();
                }
                case 4: {
                    String[] stringArray = new String[]{CRON_DAEMON, string};
                    ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
                    if (processManagerRunCmd.getResult() != 0) {
                        return processManagerRunCmd.getResult();
                    }
                    return processManagerRunCmd.getResult();
                }
                case 5: {
                    String[] stringArray = new String[]{SENDMAIL_DAEMON, string};
                    ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
                    if (processManagerRunCmd.getResult() != 0) {
                        return processManagerRunCmd.getResult();
                    }
                    return processManagerRunCmd.getResult();
                }
            }
            return 1;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized int stopDaemon(int n) throws CIMException {
        String string = "stop";
        try {
            switch (n) {
                case 1: {
                    String[] stringArray = new String[]{"/etc/init.d/nfs.server", string};
                    ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
                    if (processManagerRunCmd.getResult() != 0) {
                        return processManagerRunCmd.getResult();
                    }
                    return processManagerRunCmd.getResult();
                }
                case 0: {
                    String[] stringArray = new String[]{"/etc/init.d/nfs.server", string};
                    ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
                    if (processManagerRunCmd.getResult() != 0) {
                        return processManagerRunCmd.getResult();
                    }
                    return processManagerRunCmd.getResult();
                }
                case 2: {
                    String[] stringArray = new String[]{AUTOMOUNT_DAEMON, string};
                    ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
                    if (processManagerRunCmd.getResult() != 0) {
                        return processManagerRunCmd.getResult();
                    }
                    return processManagerRunCmd.getResult();
                }
                case 3: {
                    String[] stringArray = new String[]{VOLUME_MANAGER, string};
                    ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
                    if (processManagerRunCmd.getResult() != 0) {
                        return processManagerRunCmd.getResult();
                    }
                    return processManagerRunCmd.getResult();
                }
                case 4: {
                    String[] stringArray = new String[]{CRON_DAEMON, string};
                    ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
                    if (processManagerRunCmd.getResult() != 0) {
                        return processManagerRunCmd.getResult();
                    }
                    return processManagerRunCmd.getResult();
                }
                case 5: {
                    String[] stringArray = new String[]{SENDMAIL_DAEMON, string};
                    ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
                    if (processManagerRunCmd.getResult() != 0) {
                        return processManagerRunCmd.getResult();
                    }
                    return processManagerRunCmd.getResult();
                }
            }
            return 1;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public synchronized int suspendProcess(int n) throws CIMException {
        String string = String.valueOf(n);
        String[] stringArray = new String[]{PSTOP, string};
        int n2 = -1;
        try {
            ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray);
            n2 = processManagerRunCmd.getResult();
            processManagerRunCmd.dispose();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return n2;
    }
}

