/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.process;

import com.sun.wbem.solarisprovider.process.ProcessManagerRunCmd;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class ProcessData
implements Serializable {
    private static final String[] ENV_ARGS = new String[]{"LC_ALL=C", "LC_MESSAGES=C", "LANG=C"};
    private static final String PLIMIT = "/usr/bin/plimit";
    private static final String delimiter = " \t\n\r\f";
    private String PUSER = null;
    private String PNAME = null;
    private String PADDR = null;
    private String PID = null;
    private String PPID = null;
    private String PGID = null;
    private String PPRI = null;
    private String PCPU = null;
    private String PMEM = null;
    private String PVSZ = null;
    private String PRSS = null;
    private String PTTY = null;
    private String PNICE = null;
    private String PCLASS = null;
    private String PSTIME = null;
    private String PTIME = null;
    private String PSTATE = null;
    private String PPSR = null;
    private String PWCHAN = null;
    private String PCMD = null;
    private String MaxFileSizeLimit = null;
    private String CurrentFileSizeLimit = null;
    private String MaxHeapSizeLimit = null;
    private String CurrHeapSizeLimit = null;
    private String MaxStackSizeLimit = null;
    private String CurrStackSizeLimit = null;
    private String MaxCPUTIMELimit = null;
    private String CurrentCPUTIMELimit = null;
    private String MaxFileDescriptorLimit = null;
    private String CurrFileDescriptorLimit = null;
    private String MaxCoreFileSizeLimit = null;
    private String CurrCoreFileSizeLimit = null;
    private String MaxVirtualMemorySizeLimit = null;
    private String CurrVirtualMemorySizeLimit = null;

    public ProcessData(String string) {
        int n = 0;
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        try {
            while (stringTokenizer.hasMoreTokens()) {
                if (n < 20) {
                    ++n;
                }
                switch (n) {
                    case 1: {
                        this.PUSER = stringTokenizer.nextToken();
                        break;
                    }
                    case 2: {
                        this.PNAME = stringTokenizer.nextToken();
                        break;
                    }
                    case 3: {
                        this.PADDR = stringTokenizer.nextToken();
                        break;
                    }
                    case 4: {
                        this.PID = stringTokenizer.nextToken();
                        break;
                    }
                    case 5: {
                        this.PPID = stringTokenizer.nextToken();
                        break;
                    }
                    case 6: {
                        this.PGID = stringTokenizer.nextToken();
                        break;
                    }
                    case 7: {
                        this.PPRI = stringTokenizer.nextToken();
                        break;
                    }
                    case 8: {
                        this.PCPU = stringTokenizer.nextToken();
                        break;
                    }
                    case 9: {
                        this.PMEM = stringTokenizer.nextToken();
                        break;
                    }
                    case 10: {
                        this.PVSZ = stringTokenizer.nextToken();
                        if (!this.PVSZ.equals("?")) break;
                        this.PVSZ = "0";
                        break;
                    }
                    case 11: {
                        this.PRSS = stringTokenizer.nextToken();
                        if (!this.PRSS.equals("?")) break;
                        this.PRSS = "0";
                        break;
                    }
                    case 12: {
                        this.PTTY = stringTokenizer.nextToken();
                        break;
                    }
                    case 13: {
                        this.PNICE = stringTokenizer.nextToken();
                        break;
                    }
                    case 14: {
                        this.PCLASS = stringTokenizer.nextToken();
                        break;
                    }
                    case 15: {
                        this.PSTIME = stringTokenizer.nextToken();
                        break;
                    }
                    case 16: {
                        this.PTIME = stringTokenizer.nextToken();
                        break;
                    }
                    case 17: {
                        this.PSTATE = stringTokenizer.nextToken();
                        break;
                    }
                    case 18: {
                        this.PPSR = stringTokenizer.nextToken();
                        break;
                    }
                    case 19: {
                        this.PWCHAN = stringTokenizer.nextToken();
                        break;
                    }
                    case 20: {
                        if (this.PCMD == null) {
                            this.PCMD = stringTokenizer.nextToken();
                            break;
                        }
                        this.PCMD = String.valueOf(this.PCMD) + " " + stringTokenizer.nextToken();
                        break;
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
    }

    public String getCurrCoreFileSizeLimit() {
        return this.CurrCoreFileSizeLimit;
    }

    public String getCurrFileDescriptorLimit() {
        return this.CurrFileDescriptorLimit;
    }

    public String getCurrHeapSizeLimit() {
        return this.CurrHeapSizeLimit;
    }

    public String getCurrStackSizeLimit() {
        return this.CurrStackSizeLimit;
    }

    public String getCurrVirtualMemorySizeLimit() {
        return this.CurrVirtualMemorySizeLimit;
    }

    public String getCurrentCPUTIMELimit() {
        return this.CurrentCPUTIMELimit;
    }

    public String getCurrentFileSizeLimit() {
        return this.CurrentFileSizeLimit;
    }

    public String getMaxCPUTIMELimit() {
        return this.MaxCPUTIMELimit;
    }

    public String getMaxCoreFileSizeLimit() {
        return this.MaxCoreFileSizeLimit;
    }

    public String getMaxFileDescriptorLimit() {
        return this.MaxFileDescriptorLimit;
    }

    public String getMaxFileSizeLimit() {
        return this.MaxFileSizeLimit;
    }

    public String getMaxHeapSizeLimit() {
        return this.MaxHeapSizeLimit;
    }

    public String getMaxStackSizeLimit() {
        return this.MaxStackSizeLimit;
    }

    public String getMaxVirtualMemorySizeLimit() {
        return this.MaxVirtualMemorySizeLimit;
    }

    public String getPADDR() {
        return this.PADDR;
    }

    public String getPCLASS() {
        return this.PCLASS;
    }

    public String getPCMD() {
        return this.PCMD;
    }

    public String getPCPU() {
        return this.PCPU;
    }

    public String getPGID() {
        return this.PGID;
    }

    public String getPID() {
        return this.PID;
    }

    public String getPMEM() {
        return this.PMEM;
    }

    public String getPNAME() {
        return this.PNAME;
    }

    public String getPNICE() {
        return this.PNICE;
    }

    public String getPPID() {
        return this.PPID;
    }

    public String getPPRI() {
        return this.PPRI;
    }

    public String getPPSR() {
        return this.PPSR;
    }

    public String getPRSS() {
        return this.PRSS;
    }

    public String getPSTATE() {
        return this.PSTATE;
    }

    public String getPSTIME() {
        return this.PSTIME;
    }

    public String getPTIME() {
        return this.PTIME;
    }

    public String getPTTY() {
        return this.PTTY;
    }

    public String getPUSER() {
        return this.PUSER;
    }

    public String getPVSZ() {
        return this.PVSZ;
    }

    public String getPWCHAN() {
        return this.PWCHAN;
    }

    private Vector getProcessResourceLimits(String string) {
        String string2 = "-km";
        Vector vector = null;
        String[] stringArray = new String[]{PLIMIT, string2, string};
        ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray, ENV_ARGS);
        if (processManagerRunCmd.getResult() != 0) {
            processManagerRunCmd.dispose();
        } else {
            vector = processManagerRunCmd.getOutput();
            processManagerRunCmd.dispose();
        }
        return vector;
    }

    private void initProcessData() {
        this.PUSER = null;
        this.PNAME = null;
        this.PADDR = null;
        this.PID = null;
        this.PPID = null;
        this.PGID = null;
        this.PPRI = null;
        this.PCPU = null;
        this.PMEM = null;
        this.PVSZ = null;
        this.PRSS = null;
        this.PTTY = null;
        this.PNICE = null;
        this.PCLASS = null;
        this.PSTIME = null;
        this.PTIME = null;
        this.PSTATE = null;
        this.PPSR = null;
        this.PWCHAN = null;
        this.PCMD = null;
        this.MaxFileSizeLimit = null;
        this.CurrentFileSizeLimit = null;
        this.MaxHeapSizeLimit = null;
        this.CurrHeapSizeLimit = null;
        this.MaxStackSizeLimit = null;
        this.CurrStackSizeLimit = null;
        this.MaxCPUTIMELimit = null;
        this.CurrentCPUTIMELimit = null;
        this.MaxFileDescriptorLimit = null;
        this.CurrFileDescriptorLimit = null;
        this.MaxCoreFileSizeLimit = null;
        this.CurrCoreFileSizeLimit = null;
        this.MaxVirtualMemorySizeLimit = null;
        this.CurrVirtualMemorySizeLimit = null;
    }

    public void printData() {
        System.out.print(String.valueOf(this.PUSER) + "\t");
        System.out.print(String.valueOf(this.PNAME) + "\t");
        System.out.print(String.valueOf(this.PADDR) + "\t");
        System.out.print(String.valueOf(this.PID) + "\t");
        System.out.print(String.valueOf(this.PPID) + "\t");
        System.out.print(String.valueOf(this.PGID) + "\t");
        System.out.print(String.valueOf(this.PPRI) + "\t");
        System.out.print(String.valueOf(this.PCPU) + "\t");
        System.out.print(String.valueOf(this.PMEM) + "\t");
        System.out.print(String.valueOf(this.PVSZ) + "\t");
        System.out.print(String.valueOf(this.PRSS) + "\t");
        System.out.print(String.valueOf(this.PTTY) + "\t");
        System.out.print(String.valueOf(this.PNICE) + "\t");
        System.out.print(String.valueOf(this.PCLASS) + "\t");
        System.out.print(String.valueOf(this.PSTIME) + "\t");
        System.out.print(String.valueOf(this.PSTATE) + "\t");
        System.out.print(String.valueOf(this.PPSR) + "\t");
        System.out.print(String.valueOf(this.PWCHAN) + "\t");
        System.out.println(String.valueOf(this.PCMD) + "\t");
        System.out.println(String.valueOf(this.MaxFileSizeLimit) + "\t");
        System.out.println(String.valueOf(this.CurrentFileSizeLimit) + "\t");
        System.out.println(String.valueOf(this.MaxHeapSizeLimit) + "\t");
        System.out.println(String.valueOf(this.CurrHeapSizeLimit) + "\t");
        System.out.println(String.valueOf(this.MaxStackSizeLimit) + "\t");
        System.out.println(String.valueOf(this.CurrStackSizeLimit) + "\t");
        System.out.println(String.valueOf(this.MaxCPUTIMELimit) + "\t");
        System.out.println(String.valueOf(this.CurrentCPUTIMELimit) + "\t");
        System.out.println(String.valueOf(this.MaxFileDescriptorLimit) + "\t");
        System.out.println(String.valueOf(this.CurrFileDescriptorLimit) + "\t");
        System.out.println(String.valueOf(this.MaxCoreFileSizeLimit) + "\t");
        System.out.println(String.valueOf(this.CurrCoreFileSizeLimit) + "\t");
        System.out.println(String.valueOf(this.MaxVirtualMemorySizeLimit) + "\t");
        System.out.println(String.valueOf(this.CurrVirtualMemorySizeLimit) + "\n");
    }

    private void setCPUTIMELimits(String string) {
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, delimiter);
        int n = stringTokenizer.countTokens();
        try {
            if (n >= 3) {
                stringTokenizer.nextToken();
                this.setCurrCPUTIMELimit(stringTokenizer.nextToken());
                this.setMaxCPUTIMELimit(stringTokenizer.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
    }

    private void setCoreFileSizeLimits(String string) {
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, delimiter);
        int n = stringTokenizer.countTokens();
        try {
            if (n >= 3) {
                stringTokenizer.nextToken();
                this.setCurrCoreFileSizeLimit(stringTokenizer.nextToken());
                this.setMaxCoreFileSizeLimit(stringTokenizer.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
    }

    private void setCurrCPUTIMELimit(String string) {
        this.CurrentCPUTIMELimit = string;
    }

    private void setCurrCoreFileSizeLimit(String string) {
        this.CurrCoreFileSizeLimit = string;
    }

    private void setCurrFileDescriptorLimit(String string) {
        this.CurrFileDescriptorLimit = string;
    }

    private void setCurrFileSizeLimit(String string) {
        this.CurrentFileSizeLimit = string;
    }

    private void setCurrHeapSizeLimit(String string) {
        this.CurrHeapSizeLimit = string;
    }

    private void setCurrStackSizeLimit(String string) {
        this.CurrStackSizeLimit = string;
    }

    private void setCurrVirtualMemorySizeLimit(String string) {
        this.CurrVirtualMemorySizeLimit = string;
    }

    private void setFileDescriptorLimits(String string) {
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, delimiter);
        int n = stringTokenizer.countTokens();
        try {
            if (n >= 3) {
                stringTokenizer.nextToken();
                this.setCurrFileDescriptorLimit(stringTokenizer.nextToken());
                this.setMaxFileDescriptorLimit(stringTokenizer.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
    }

    private void setFileSizeLimits(String string) {
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, delimiter);
        int n = stringTokenizer.countTokens();
        try {
            if (n >= 3) {
                stringTokenizer.nextToken();
                this.setCurrFileSizeLimit(stringTokenizer.nextToken());
                this.setMaxFileSizeLimit(stringTokenizer.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
    }

    private void setHeapSizeLimits(String string) {
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, delimiter);
        int n = stringTokenizer.countTokens();
        try {
            if (n >= 3) {
                stringTokenizer.nextToken();
                this.setCurrHeapSizeLimit(stringTokenizer.nextToken());
                this.setMaxHeapSizeLimit(stringTokenizer.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
    }

    private void setMaxCPUTIMELimit(String string) {
        this.MaxCPUTIMELimit = string;
    }

    private void setMaxCoreFileSizeLimit(String string) {
        this.MaxCoreFileSizeLimit = string;
    }

    private void setMaxFileDescriptorLimit(String string) {
        this.MaxFileDescriptorLimit = string;
    }

    private void setMaxFileSizeLimit(String string) {
        this.MaxFileSizeLimit = string;
    }

    private void setMaxHeapSizeLimit(String string) {
        this.MaxHeapSizeLimit = string;
    }

    private void setMaxStackSizeLimit(String string) {
        this.MaxStackSizeLimit = string;
    }

    private void setMaxVirtualMemorySizeLimit(String string) {
        this.MaxVirtualMemorySizeLimit = string;
    }

    private void setStackSizeLimits(String string) {
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, delimiter);
        int n = stringTokenizer.countTokens();
        try {
            if (n >= 3) {
                stringTokenizer.nextToken();
                this.setCurrStackSizeLimit(stringTokenizer.nextToken());
                this.setMaxStackSizeLimit(stringTokenizer.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
    }

    private void setVirtualMemorySizeLimits(String string) {
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, delimiter);
        int n = stringTokenizer.countTokens();
        try {
            if (n >= 3) {
                stringTokenizer.nextToken();
                this.setCurrVirtualMemorySizeLimit(stringTokenizer.nextToken());
                this.setMaxVirtualMemorySizeLimit(stringTokenizer.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
    }
}

