/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.cim.CIMException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ServiceProps {
    public static final String ADMIN_SERVER_PROP_PATH = "/usr/sadm/lib/wbem";
    public static final String ADMIN_SERVER_PROP_FILE = "WbemServices.properties";
    public static final String ADMIN_PROP_SERVER_HDR = "Wbem Services properties file";
    public static final int ADMIN_PROP_MODE_READ = 0;
    public static final int ADMIN_PROP_MODE_WRITE = 1;
    public static final int ADMIN_PROP_MODE_CREATE = 2;
    public static final String ADMIN_PROP_ON_VALUE = "on";
    public static final String ADMIN_PROP_OFF_VALUE = "off";
    public static final String LOG_SERVICE_FILE_DIR = "wbem.logging.file.dir";
    public static final String LOG_SERVICE_FILE_NAME = "wbem.logging.file.name";
    public static final String LOG_SERVICE_FILE_SIZE = "wbem.logging.file.size";
    public static final String LOG_SERVICE_FILE_NUM = "wbem.logging.file.num";
    public static final String LOG_SERVICE_SYSLOG = "wbem.logging.syslog";
    private String propfile;
    private int propmode;
    private Properties props = null;

    public ServiceProps(String string, int n) throws CIMException {
        this.propfile = string;
        this.propmode = n;
    }

    public ServiceProps(String string, String string2, int n) throws CIMException {
        String string3 = null;
        if (string == null || string.trim().length() == 0) {
            throw new CIMException("CIM_ERR_FAILED", (Object)"Logging Properties file path");
        }
        try {
            string3 = System.getProperty(string);
        }
        catch (Exception exception) {
            string3 = null;
        }
        if (string3 == null) {
            throw new CIMException("CIM_ERR_FAILED", (Object)"Logging Properties file path");
        }
        if (string2 == null || string2.trim().length() == 0) {
            throw new CIMException("CIM_ERR_FAILED", (Object)"Logging Properties file path");
        }
        this.propmode = n;
        string3 = string3.concat(File.separator);
        this.propfile = string3.concat(string2);
    }

    public void delServiceProp(String string) throws CIMException {
        if (this.props == null) {
            this.loadProperties();
        }
        try {
            String string2 = (String)((Hashtable)this.props).remove(string);
        }
        catch (Exception exception) {}
    }

    public String getServiceProp(String string) throws CIMException {
        String string2;
        if (this.props == null) {
            this.loadProperties();
        }
        try {
            string2 = this.props.getProperty(string);
        }
        catch (Exception exception) {
            throw new CIMException(string);
        }
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public Vector getServicePropList(String string) throws CIMException {
        Vector<String> vector = new Vector<String>();
        boolean bl = true;
        if (this.props == null) {
            this.loadProperties();
        }
        int n = 1;
        String string2 = string.concat(".");
        while (bl) {
            string2 = String.valueOf(string) + "." + n;
            try {
                String string3 = this.props.getProperty(string2);
                if (string3 == null) {
                    bl = false;
                } else {
                    vector.addElement(string3);
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            ++n;
        }
        return vector;
    }

    public Vector getServicePropNames() throws CIMException {
        Vector<String> vector = new Vector<String>();
        if (this.props == null) {
            this.loadProperties();
        }
        Enumeration<?> enumeration = this.props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = new String((String)enumeration.nextElement());
            vector.addElement(string);
        }
        return vector;
    }

    private void loadProperties() throws CIMException {
        boolean bl = false;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.propfile);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = true;
        }
        if (bl && (this.propmode ^ 2) == 0) {
            throw new CIMException("EXM_BPF", (Object)this.propfile);
        }
        this.props = new Properties();
        if (!bl) {
            try {
                this.props.load(bufferedInputStream);
            }
            catch (IOException iOException) {
                throw new CIMException("EXM_LPF", (Object)this.propfile, (Object)iOException);
            }
        }
        try {
            fileInputStream.close();
        }
        catch (Exception exception) {}
    }

    public void putServiceProp(String string, String string2) throws CIMException {
        if (this.props == null) {
            this.loadProperties();
        }
        String string3 = string2 == null ? "" : string2.trim();
        try {
            ((Hashtable)this.props).put(string, string3);
        }
        catch (Exception exception) {
            throw new CIMException("EXM_PNS", (Object)string);
        }
    }

    private void saveProperties(String string, String string2) throws CIMException {
        BufferedOutputStream bufferedOutputStream;
        FileOutputStream fileOutputStream;
        try {
            fileOutputStream = new FileOutputStream(string);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        }
        catch (SecurityException securityException) {
            throw new CIMException("EXM_NAP", (Object)string);
        }
        catch (IOException iOException) {
            throw new CIMException("EXM_NWP", (Object)string);
        }
        try {
            this.props.store(bufferedOutputStream, string2);
        }
        catch (Exception exception) {
            throw new CIMException("EXM_NWP", (Object)string, (Object)exception);
        }
        try {
            bufferedOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new CIMException("EXM_NWP", (Object)string, (Object)exception);
        }
    }

    public void saveServiceProps(String string) throws CIMException {
        this.saveServiceProps(this.propfile, string);
    }

    public void saveServiceProps(String string, String string2) throws CIMException {
        if (this.props != null) {
            if (string2 == null) {
                this.saveProperties(string, "*** DO NOT EDIT THIS FILE ***");
            } else {
                this.saveProperties(string, string2);
            }
        }
    }
}

